/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.support.conv;

import com.cloudera.support.conv.ConversionResult;
import com.cloudera.support.conv.ExactNumConverter;
import java.math.BigDecimal;

public class ApproxNumConverter {
    private ApproxNumConverter() {
        throw new UnsupportedOperationException();
    }

    public static BigDecimal toBigDecimal(double d, short s, short s2, ConversionResult conversionResult) {
        if (Double.isNaN(d)) {
            conversionResult.setState(ConversionResult.TypeConversionState.INVALID_DATA);
            return null;
        }
        if (Double.POSITIVE_INFINITY == d) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
            return null;
        }
        if (Double.NEGATIVE_INFINITY == d) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
            return null;
        }
        return ExactNumConverter.setPrecScale(new BigDecimal(d), s, s2, conversionResult);
    }

    public static String toChar(double d, long l, ConversionResult conversionResult) {
        String string = Double.POSITIVE_INFINITY == d ? "INFINITY" : (Double.NEGATIVE_INFINITY == d ? "-INFINITY" : Double.toString(d));
        if ((long)string.length() <= l) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.STRING_RIGHT_TRUNCATION);
            string = string.substring(0, (int)l);
        }
        return string;
    }
}

