/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.executor.etree.statement;

import com.cloudera.dsi.dataengine.utilities.CursorType;
import com.cloudera.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.cloudera.sqlengine.executor.etree.ETBoolean;
import com.cloudera.sqlengine.executor.etree.IETNode;
import com.cloudera.sqlengine.executor.etree.IETNodeVisitor;
import com.cloudera.sqlengine.executor.etree.IETUnaryNode;
import com.cloudera.sqlengine.executor.etree.bool.ETBooleanExpr;
import com.cloudera.sqlengine.executor.etree.relation.ETTable;
import com.cloudera.sqlengine.executor.etree.statement.IETRowCountStatement;
import com.cloudera.support.exceptions.ErrorException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETSearchedDelete
implements IETRowCountStatement,
IETUnaryNode<ETTable> {
    private ETTable m_operand;
    private ETBooleanExpr m_condition;
    private long m_rowCount = -1L;

    public ETSearchedDelete(ETTable eTTable, ETBooleanExpr eTBooleanExpr) {
        this.m_operand = eTTable;
        this.m_condition = eTBooleanExpr;
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public Iterator<? extends IETNode> getChildItr() {
        return this.asList().iterator();
    }

    @Override
    public String getLogString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public int getNumChildren() {
        return 2;
    }

    @Override
    public ETTable getOperand() {
        return this.m_operand;
    }

    @Override
    public long getRowCount() throws ErrorException {
        return this.m_rowCount;
    }

    public ETBooleanExpr getSearchCondition() {
        return this.m_condition;
    }

    @Override
    public void execute() throws ErrorException {
        this.m_operand.open(CursorType.FORWARD_ONLY);
        this.m_condition.open();
        this.m_operand.onStartDMLBatch(DSIExtJResultSet.DMLType.DELETE, -1L);
        this.m_rowCount = 0L;
        while (this.m_operand.move()) {
            if (ETBoolean.SQL_BOOLEAN_TRUE != this.m_condition.evaluate()) continue;
            this.m_operand.deleteRow();
            ++this.m_rowCount;
        }
        this.m_operand.onFinishDMLBatch();
        this.m_operand.close();
        this.m_condition.close();
    }

    @Override
    public boolean isResultSet() {
        return false;
    }

    private List<? extends IETNode> asList() {
        return new AbstractList<IETNode>(){

            @Override
            public IETNode get(int n) {
                if (0 == n) {
                    return ETSearchedDelete.this.m_operand;
                }
                if (1 == n) {
                    return ETSearchedDelete.this.m_condition;
                }
                throw new IndexOutOfBoundsException();
            }

            @Override
            public int size() {
                return 2;
            }
        };
    }
}

