/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.executor.datawrapper;

import com.cloudera.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.dsi.exceptions.IncorrectTypeException;
import com.cloudera.sqlengine.exceptions.SQLEngineException;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.cloudera.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.support.exceptions.ErrorException;
import java.math.BigInteger;

public final class SqlBooleanDataWrapper
extends DefaultSqlDataWrapper {
    private boolean m_data;
    private boolean m_isSet = false;
    private boolean m_isNull = false;
    private final int m_type;

    public SqlBooleanDataWrapper(int n) {
        assert (n == -7 || n == 16);
        this.m_type = n;
    }

    public BigInteger getBigInt() throws ErrorException, NullPointerException {
        this.checkValidRetrieval();
        if (this.m_data) {
            return BigInteger.ONE;
        }
        return BigInteger.ZERO;
    }

    public boolean getBoolean() throws ErrorException, NullPointerException {
        this.checkValidRetrieval();
        return this.m_data;
    }

    public double getDouble() throws ErrorException, NullPointerException {
        this.checkValidRetrieval();
        if (this.m_data) {
            return 1.0;
        }
        return 0.0;
    }

    public long getInteger() throws ErrorException, NullPointerException {
        this.checkValidRetrieval();
        if (this.m_data) {
            return 1L;
        }
        return 0L;
    }

    public int getSmallInt() throws ErrorException, NullPointerException {
        this.checkValidRetrieval();
        if (this.m_data) {
            return 1;
        }
        return 0;
    }

    public short getTinyInt() throws ErrorException, NullPointerException {
        this.checkValidRetrieval();
        if (this.m_data) {
            return 1;
        }
        return 0;
    }

    public int getType() {
        return this.m_type;
    }

    public boolean isNull() {
        return this.m_isNull;
    }

    public boolean isSet() {
        return this.m_isSet;
    }

    public void setBoolean(boolean bl) {
        this.m_isSet = true;
        this.m_data = bl;
        this.m_isNull = false;
    }

    public void setNull() {
        this.m_isSet = true;
        this.m_isNull = true;
    }

    public void setValue(DataWrapper dataWrapper) throws ErrorException {
        if (dataWrapper.isNull()) {
            this.setNull();
        } else {
            try {
                switch (dataWrapper.getType()) {
                    case 16: {
                        this.setBoolean(dataWrapper.getBoolean());
                        break;
                    }
                    case -7: {
                        this.setBoolean(dataWrapper.getBit());
                        break;
                    }
                    default: {
                        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(dataWrapper.getType());
                    }
                }
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), incorrectTypeException);
            }
        }
    }

    public void retrieveData(DataWrapper dataWrapper) throws ErrorException {
        if (!this.m_isSet) {
            throw new IllegalStateException("ISqlDataWrapper is not set with data for retrieval");
        }
        if (this.m_isNull) {
            dataWrapper.setNull(this.m_type);
            return;
        }
        switch (this.m_type) {
            case 16: {
                dataWrapper.setBoolean(this.m_data);
                break;
            }
            case -7: {
                dataWrapper.setBit(this.m_data);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void checkValidRetrieval() throws ErrorException {
        if (!this.m_isSet) {
            throw SQLEngineExceptionFactory.requestedDataNotSet();
        }
        if (this.m_isNull) {
            throw new NullPointerException("Data requested, but the data is null.");
        }
    }
}

