/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.executor.conversions;

import com.cloudera.dsi.dataengine.interfaces.IColumn;
import com.cloudera.dsi.dataengine.utilities.TypeUtilities;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.sqlengine.executor.conversions.ISqlConverter;
import com.cloudera.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.cloudera.support.conv.ApproxNumConverter;
import com.cloudera.support.conv.ConversionResult;
import com.cloudera.support.exceptions.ErrorException;
import java.math.BigDecimal;

public class SqlApproxNumConverter
implements ISqlConverter {
    private IColumn m_targetMeta;

    public SqlApproxNumConverter(IColumn iColumn, IColumn iColumn2) {
        assert (iColumn.getTypeMetadata().isApproximateNumericType());
        this.m_targetMeta = iColumn2;
    }

    public ConversionResult convert(ISqlDataWrapper iSqlDataWrapper, ISqlDataWrapper iSqlDataWrapper2) throws ErrorException {
        ConversionResult conversionResult = new ConversionResult();
        if (iSqlDataWrapper.isNull()) {
            iSqlDataWrapper2.setNull();
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
            return conversionResult;
        }
        double d = iSqlDataWrapper.getDouble();
        switch (iSqlDataWrapper2.getType()) {
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                String string = ApproxNumConverter.toChar(d, this.m_targetMeta.getColumnLength(), conversionResult);
                iSqlDataWrapper2.setChar(string);
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = ApproxNumConverter.toBigDecimal(d, this.m_targetMeta.getTypeMetadata().getPrecision(), this.m_targetMeta.getTypeMetadata().getScale(), conversionResult);
                iSqlDataWrapper2.setExactNumber(bigDecimal);
                break;
            }
            default: {
                throw SQLEngineExceptionFactory.conversionNotSupported(TypeUtilities.sqlTypeToString((short)iSqlDataWrapper.getType()), TypeUtilities.sqlTypeToString((short)iSqlDataWrapper2.getType()));
            }
        }
        return conversionResult;
    }
}

