/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.aeprocessor.aetree.relation;

import com.cloudera.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.sqlengine.aeprocessor.aetree.IAENodeVisitor;
import com.cloudera.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AEBinaryRelationalExpr;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.cloudera.support.exceptions.ErrorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AEJoin
extends AEBinaryRelationalExpr {
    private AEJoinType m_joinType;
    private AEBooleanExpr m_joinCondition;

    public AEJoin(AEJoinType aEJoinType, AERelationalExpr aERelationalExpr, AERelationalExpr aERelationalExpr2) {
        this(aEJoinType, aERelationalExpr, aERelationalExpr2, null);
    }

    public AEJoin(AEJoinType aEJoinType, AERelationalExpr aERelationalExpr, AERelationalExpr aERelationalExpr2, AEBooleanExpr aEBooleanExpr) {
        super(aERelationalExpr, aERelationalExpr2);
        if (null == aEJoinType) {
            throw new IllegalArgumentException("Arguments to AEJoin may not be null.");
        }
        this.m_joinType = aEJoinType;
        this.m_joinCondition = aEBooleanExpr;
        if (null != aEBooleanExpr) {
            this.m_joinCondition.setParent(this);
        }
    }

    public AEBooleanExpr getJoinCondition() {
        return this.m_joinCondition;
    }

    public void setJoinCondition(AEBooleanExpr aEBooleanExpr) {
        aEBooleanExpr.setParent(this);
        this.m_joinCondition = aEBooleanExpr;
    }

    public AEJoinType getJoinType() {
        return this.m_joinType;
    }

    public boolean isOuterJoin() {
        return this.m_joinType != AEJoinType.INNER_JOIN;
    }

    @Override
    public <T> T acceptVisitor(IAENodeVisitor<T> iAENodeVisitor) throws ErrorException {
        return iAENodeVisitor.visit(this);
    }

    @Override
    public int getNumChildren() {
        return 3;
    }

    @Override
    public boolean isEquivalent(IAENode iAENode) {
        if (this == iAENode) {
            return true;
        }
        if (!(iAENode instanceof AEJoin)) {
            return false;
        }
        AEJoin aEJoin = (AEJoin)iAENode;
        return aEJoin.m_joinType == this.m_joinType && aEJoin.m_joinCondition.isEquivalent(this.m_joinCondition) && aEJoin.getLeftOperand().isEquivalent(this.getLeftOperand()) && aEJoin.getRightOperand().isEquivalent(this.getRightOperand());
    }

    @Override
    public AEJoin copy() {
        return new AEJoin(this.m_joinType, this.getLeftOperand().copy(), this.getRightOperand().copy(), null == this.m_joinCondition ? null : this.m_joinCondition.copy());
    }

    @Override
    public String getLogString() {
        return super.getLogString() + ": " + this.m_joinType.name();
    }

    @Override
    protected IAENode getChild(int n) {
        switch (n) {
            case 0: {
                return this.getLeftOperand();
            }
            case 1: {
                return this.getRightOperand();
            }
            case 2: {
                return this.m_joinCondition;
            }
        }
        throw new IndexOutOfBoundsException("" + n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AEJoinType {
        INNER_JOIN("INNER JOIN"),
        LEFT_OUTER_JOIN("LEFT JOIN"),
        RIGHT_OUTER_JOIN("RIGHT JOIN"),
        FULL_OUTER_JOIN("FULL JOIN");

        private String m_stringVal;

        private AEJoinType(String string2) {
            this.m_stringVal = string2;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }
}

