/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.aeprocessor.aetree;

import com.cloudera.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.support.exceptions.ErrorException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AETreeWalker
implements Iterator<IAENode> {
    protected IAENode m_nextNode;
    protected Stack<Iterator<? extends IAENode>> m_parentIters;

    public AETreeWalker(IAENode iAENode) {
        this.m_nextNode = iAENode;
        this.m_parentIters = new Stack();
    }

    @Override
    public boolean hasNext() {
        return null != this.m_nextNode;
    }

    public IAENode peekNext() {
        return this.m_nextNode;
    }

    @Override
    public IAENode next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        IAENode iAENode = this.m_nextNode;
        this.m_parentIters.push(iAENode.getChildItr());
        this.findNext();
        return iAENode;
    }

    protected void findNext() {
        this.m_nextNode = null;
        while (!this.m_parentIters.empty()) {
            if (this.m_parentIters.peek().hasNext()) {
                this.m_nextNode = this.m_parentIters.peek().next();
                break;
            }
            this.m_parentIters.pop();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is not supported.");
    }

    public static <T> T walk(IAENode iAENode, Action<T> action) throws ErrorException {
        ((Action)action).walk(new AETreeWalker(iAENode));
        return action.getResult();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Action<T> {
        private IAENode m_currentNode;
        private AETreeWalker m_walker;

        public abstract void act(IAENode var1) throws ErrorException;

        public T getResult() {
            return null;
        }

        protected void skipChildren() {
            if (this.m_currentNode.getNumChildren() != 0) {
                this.m_walker.m_parentIters.pop();
                this.m_walker.findNext();
            }
        }

        protected void skipAll() {
            this.m_walker.m_parentIters.clear();
            this.m_walker.m_nextNode = null;
        }

        private void walk(AETreeWalker aETreeWalker) throws ErrorException {
            this.m_walker = aETreeWalker;
            while (this.m_walker.hasNext()) {
                this.m_currentNode = this.m_walker.next();
                this.act(this.m_currentNode);
            }
        }
    }
}

