/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.aeprocessor.aebuilder.bool;

import com.cloudera.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.cloudera.sqlengine.aeprocessor.aebuilder.value.AEValueExprComposer;
import com.cloudera.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.cloudera.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.sqlengine.aeprocessor.aetree.bool.AEAnd;
import com.cloudera.sqlengine.aeprocessor.aetree.bool.AEBinaryBooleanExpr;
import com.cloudera.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.cloudera.sqlengine.aeprocessor.aetree.bool.AEBooleanTrue;
import com.cloudera.sqlengine.aeprocessor.aetree.bool.AEComparison;
import com.cloudera.sqlengine.aeprocessor.aetree.bool.AEExistsPredicate;
import com.cloudera.sqlengine.aeprocessor.aetree.bool.AEInPredicate;
import com.cloudera.sqlengine.aeprocessor.aetree.bool.AELikePredicate;
import com.cloudera.sqlengine.aeprocessor.aetree.bool.AENot;
import com.cloudera.sqlengine.aeprocessor.aetree.bool.AENullPredicate;
import com.cloudera.sqlengine.aeprocessor.aetree.bool.AEOr;
import com.cloudera.sqlengine.aeprocessor.aetree.bool.AEQuantifiedComparison;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.support.exceptions.ErrorException;

public class AEBooleanExprProcessor {
    public static void process(AEBooleanExpr aEBooleanExpr, AEQueryScope aEQueryScope) throws ErrorException {
        aEBooleanExpr.acceptVisitor(new AEBoolExprProcessorVisitor(aEQueryScope));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AEBoolExprProcessorVisitor
    extends AEDefaultVisitor<Void> {
        private AEQueryScope m_queryScope = null;

        public AEBoolExprProcessorVisitor(AEQueryScope aEQueryScope) {
            this.m_queryScope = aEQueryScope;
        }

        @Override
        public Void visit(AEAnd aEAnd) throws ErrorException {
            this.processBinary(aEAnd);
            return null;
        }

        @Override
        public Void visit(AEOr aEOr) throws ErrorException {
            this.processBinary(aEOr);
            return null;
        }

        @Override
        public Void visit(AENot aENot) throws ErrorException {
            return aENot.getOperand().acceptVisitor(this);
        }

        @Override
        public Void visit(AEComparison aEComparison) throws ErrorException {
            AEValueExprComposer.compose(aEComparison.getLeftOperand(), this.m_queryScope);
            AEValueExprComposer.compose(aEComparison.getRightOperand(), this.m_queryScope);
            return null;
        }

        @Override
        public Void visit(AEInPredicate aEInPredicate) throws ErrorException {
            AEValueExprComposer.compose(aEInPredicate.getLeftOperand(), this.m_queryScope);
            IAENode iAENode = aEInPredicate.getRightOperand();
            if (iAENode instanceof AEValueExprList) {
                AEValueExprComposer.compose((AEValueExprList)iAENode, this.m_queryScope);
            }
            return null;
        }

        @Override
        public Void visit(AENullPredicate aENullPredicate) throws ErrorException {
            AEValueExprComposer.compose(aENullPredicate.getOperand(), this.m_queryScope);
            return null;
        }

        @Override
        public Void visit(AEBooleanTrue aEBooleanTrue) throws ErrorException {
            return null;
        }

        @Override
        public Void visit(AEExistsPredicate aEExistsPredicate) throws ErrorException {
            return null;
        }

        @Override
        public Void visit(AEQuantifiedComparison aEQuantifiedComparison) throws ErrorException {
            AEValueExprComposer.compose(aEQuantifiedComparison.getLeftOperand(), this.m_queryScope);
            return null;
        }

        @Override
        public Void visit(AELikePredicate aELikePredicate) throws ErrorException {
            aELikePredicate.setLeftOperand(AEValueExprComposer.composeExpr(aELikePredicate.getLeftOperand(), this.m_queryScope));
            aELikePredicate.setRightOperand(AEValueExprComposer.composeExpr(aELikePredicate.getRightOperand(), this.m_queryScope));
            if (aELikePredicate.hasEscapeChar()) {
                aELikePredicate.setEscape(AEValueExprComposer.composeExpr(aELikePredicate.getEscapeChar(), this.m_queryScope));
            }
            return null;
        }

        @Override
        protected Void defaultVisit(IAENode iAENode) throws ErrorException {
            throw SQLEngineExceptionFactory.invalidOperationException("Unexpected node visited" + iAENode.getLogString());
        }

        private void processBinary(AEBinaryBooleanExpr aEBinaryBooleanExpr) throws ErrorException {
            aEBinaryBooleanExpr.getLeftOperand().acceptVisitor(this);
            aEBinaryBooleanExpr.getRightOperand().acceptVisitor(this);
        }
    }
}

