/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hivecommon.querytranslation.hql;

import com.cloudera.dsi.dataengine.interfaces.IColumn;
import com.cloudera.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.hivecommon.querytranslation.ScalarFunctionTranslator;
import com.cloudera.hivecommon.querytranslation.hql.SelectNode;
import com.cloudera.hivecommon.querytranslation.hql.SelectType;
import com.cloudera.sqlengine.aeprocessor.AEQTableName;
import com.cloudera.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.cloudera.sqlengine.aeprocessor.aetree.AENodeList;
import com.cloudera.sqlengine.aeprocessor.aetree.AESortSpec;
import com.cloudera.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AEAggregate;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AEProject;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AESelect;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AESort;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AETable;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AETop;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEAdd;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEConcat;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AECountStarAggrFn;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEDivide;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AELiteral;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEMultiply;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AENegate;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AERename;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEScalarFn;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AESearchedCase;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AESearchedWhenClause;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AESubtract;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.cloudera.support.exceptions.ErrorException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;

public class OrderBySubqueryAnalyzer
extends AEDefaultVisitor<String> {
    private int m_currentColumnNumber = 0;
    private boolean m_launchExtraWhereClause = false;
    private boolean m_orderBYprocessingSelectList = false;
    private boolean m_processingOrderByList = false;
    private boolean m_processingOrderNode = false;
    private boolean m_canReplaceListWithStar = false;
    private boolean m_isBuildOrderBySubqueryFromAETop = false;
    private boolean m_isBuildOrderBySubqueryFromAESort = false;
    private HashMap<Integer, String> m_selectColumnRef = new HashMap();
    private HashMap<Integer, String> m_orderByColumnRef = new HashMap();
    private HashMap<Integer, SelectNode> m_columnFullNameRef = new HashMap();
    private HashMap<AENamedRelationalExpr, String> m_generatedTableAlias = new HashMap();

    public OrderBySubqueryAnalyzer(AESort aESort) throws ErrorException {
        aESort.acceptVisitor(this);
    }

    public OrderBySubqueryAnalyzer(AETop aETop) throws ErrorException {
        aETop.acceptVisitor(this);
    }

    @Override
    public String visit(AEValueExprList aEValueExprList) throws ErrorException {
        Iterator iterator = aEValueExprList.getChildItr();
        while (iterator.hasNext()) {
            ((AEValueExpr)iterator.next()).acceptVisitor(this);
        }
        return null;
    }

    @Override
    public String visit(AEColumnReference aEColumnReference) throws ErrorException {
        String string = null;
        AENamedRelationalExpr aENamedRelationalExpr = aEColumnReference.getNamedRelationalExpr();
        string = this.m_generatedTableAlias.containsKey(aENamedRelationalExpr) ? this.m_generatedTableAlias.get(aENamedRelationalExpr) : aENamedRelationalExpr.getCorrelationName();
        String string2 = aEColumnReference.getNamedRelationalExpr().getQTableName().getTableName();
        IColumn iColumn = aEColumnReference.getNamedRelationalExpr().getBaseColumn(aEColumnReference.getColumnNum());
        if (string.length() > 0) {
            this.saveColumnRef("`" + aEColumnReference.getName() + "`");
            this.saveFullColumnRef(new SelectNode(SelectType.NORMAL, "`" + iColumn.getName() + "`"));
            return null;
        }
        if (string2.length() > 0) {
            this.saveColumnRef("`" + iColumn.getName() + "`");
            this.saveFullColumnRef(new SelectNode(SelectType.NORMAL, "`" + iColumn.getName() + "`"));
            return null;
        }
        this.saveColumnRef("`" + aEColumnReference.getName() + "`");
        return null;
    }

    @Override
    public String visit(AERename aERename) throws ErrorException {
        if (null != this.m_columnFullNameRef.get(this.m_currentColumnNumber) && !this.m_columnFullNameRef.get(this.m_currentColumnNumber).getSubqueryColumnName().contains("`" + aERename.getLabel() + "`")) {
            this.saveFullColumnRef(new SelectNode(SelectType.RENAME, "`" + aERename.getLabel() + "`"));
        }
        return null;
    }

    @Override
    public String visit(AETable aETable) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        AEQTableName aEQTableName = aETable.getBaseQTableName();
        if (aEQTableName.hasSchemaName()) {
            stringBuilder.append('`').append(aEQTableName.getSchemaName()).append("`.");
        }
        stringBuilder.append('`').append(aEQTableName.getTableName()).append('`');
        if (aETable.hasCorrelationName()) {
            stringBuilder.append(' ').append('`').append(aETable.getCorrelationName()).append('`');
        } else {
            String string = aEQTableName.getSchemaName() + "_" + aEQTableName.getTableName();
            this.m_generatedTableAlias.put(aETable, string);
            stringBuilder.append(' ').append('`').append(string).append('`');
        }
        return stringBuilder.toString();
    }

    @Override
    public String visit(AEScalarFn aEScalarFn) throws ErrorException {
        String string = new ScalarFunctionTranslator(this, ScalarFunctionTranslator.SERVER_TYPE.HIVE).translateScalarFunction(aEScalarFn);
        this.saveFullColumnRef(new SelectNode(SelectType.RENAME, string));
        return string;
    }

    @Override
    public String visit(AESelect aESelect) throws ErrorException {
        Iterator<IAENode> iterator = aESelect.getChildItr();
        iterator.next().acceptVisitor(this);
        if (this.m_launchExtraWhereClause) {
            if (aESelect.getOperand() instanceof AEAggregate) {
                iterator.next().acceptVisitor(this);
            } else {
                iterator.next().acceptVisitor(this);
            }
            this.m_launchExtraWhereClause = false;
        } else {
            iterator.next().acceptVisitor(this);
        }
        return null;
    }

    @Override
    public String visit(AENegate aENegate) throws ErrorException {
        this.saveFullColumnRef(new SelectNode(SelectType.GNEGATE, "GNEGATE TEMP RESULT"));
        this.defaultVisit(aENegate);
        return null;
    }

    @Override
    public String visit(AETop aETop) throws ErrorException {
        if (aETop.isPercent()) {
            // empty if block
        }
        Iterator<IAENode> iterator = aETop.getChildItr();
        iterator.next().acceptVisitor(this);
        iterator.next().acceptVisitor(this);
        if (this.m_isBuildOrderBySubqueryFromAESort) {
            this.m_isBuildOrderBySubqueryFromAESort = false;
        } else {
            this.m_isBuildOrderBySubqueryFromAETop = this.subqueryBuildtrigger() && this.m_processingOrderNode && !this.m_canReplaceListWithStar;
        }
        return null;
    }

    @Override
    public String visit(AESort aESort) throws ErrorException {
        this.m_processingOrderNode = true;
        AEProject aEProject = (AEProject)aESort.getOperand();
        this.m_processingOrderByList = true;
        for (AESortSpec aESortSpec : aESort.getSortSpecs()) {
            IColumn iColumn = aEProject.getColumn(aESortSpec.getColumnNumber());
            this.saveColumnRef("`" + iColumn.getName() + "`");
        }
        this.m_processingOrderByList = false;
        this.m_isBuildOrderBySubqueryFromAESort = this.subqueryBuildtrigger() && this.m_processingOrderNode && !this.m_canReplaceListWithStar;
        return null;
    }

    @Override
    public String visit(AENodeList<? extends IAENode> aENodeList) throws ErrorException {
        Iterator iterator = aENodeList.getChildItr();
        if (iterator.hasNext()) {
            ((IAENode)iterator.next()).acceptVisitor(this);
            while (iterator.hasNext()) {
                ((IAENode)iterator.next()).acceptVisitor(this);
            }
        }
        return null;
    }

    private boolean subqueryBuildtrigger() {
        for (int i = 0; i <= this.m_currentColumnNumber; ++i) {
            if (!this.m_orderByColumnRef.containsValue(this.m_selectColumnRef.get(i))) continue;
            return this.m_columnFullNameRef.get(i).getType() == SelectType.RENAME;
        }
        return true;
    }

    private void saveColumnRef(String string) {
        if (this.m_orderBYprocessingSelectList) {
            this.m_selectColumnRef.put(this.m_currentColumnNumber, string);
        }
        if (this.m_processingOrderByList) {
            this.m_orderByColumnRef.put(this.m_currentColumnNumber, string);
        }
    }

    private void saveFullColumnRef(SelectNode selectNode) {
        if (this.m_orderBYprocessingSelectList && !this.m_processingOrderByList) {
            this.m_columnFullNameRef.put(this.m_currentColumnNumber, selectNode);
        }
    }

    @Override
    public String defaultVisit(IAENode iAENode) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<? extends IAENode> iterator = iAENode.getChildItr();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().acceptVisitor(this));
        }
        return stringBuilder.toString();
    }

    public boolean isBuildOrderBySubqueryFromAETop() {
        return this.m_isBuildOrderBySubqueryFromAETop;
    }

    public boolean isBuildOrderBySubqueryFromAESort() {
        return this.m_isBuildOrderBySubqueryFromAESort;
    }

    private static String escapeStringLiteral(String string, boolean bl) {
        if (bl) {
            return string.replace("\\", "\\\\").replace("'", "\\'").replace("\"", "\\\"");
        }
        return string.replace("'", "\\'").replace("\"", "\\\"");
    }

    @Override
    public String visit(AELiteral aELiteral) throws ErrorException {
        String string = "";
        switch (aELiteral.getLiteralType()) {
            case CHARSTR: {
                string = "'" + OrderBySubqueryAnalyzer.escapeStringLiteral(aELiteral.getStringValue(), true) + "'";
                this.saveFullColumnRef(new SelectNode(SelectType.LITERAL, string));
                return null;
            }
            case DECIMAL: 
            case APPROXNUM: 
            case USINT: {
                string = aELiteral.getStringValue();
                this.saveFullColumnRef(new SelectNode(SelectType.LITERAL, string));
                return null;
            }
            case NULL: {
                string = "NULL";
                this.saveFullColumnRef(new SelectNode(SelectType.LITERAL, string));
                return null;
            }
            case DATE: {
                string = "CAST('" + aELiteral.getStringValue() + "' AS DATE)";
                this.saveFullColumnRef(new SelectNode(SelectType.LITERAL, string));
                return null;
            }
            case TIMESTAMP: {
                string = "CAST('" + aELiteral.getStringValue() + "' AS TIMESTAMP)";
                this.saveFullColumnRef(new SelectNode(SelectType.LITERAL, string));
                return null;
            }
        }
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_TRANSLATION_ERR.name(), new String[]{"42000", "Syntax error or access violation", "Literal type not supported: " + aELiteral.getLiteralType().name()});
        return null;
    }

    @Override
    public String visit(AEAdd aEAdd) throws ErrorException {
        if (aEAdd.getTypeMetadata().isCharacterType()) {
            this.visit(new AEConcat(null, aEAdd.getLeftOperand(), aEAdd.getRightOperand()));
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(aEAdd.getLeftOperand().acceptVisitor(this));
        stringBuilder.append(" + ");
        stringBuilder.append(aEAdd.getRightOperand().acceptVisitor(this));
        stringBuilder.append(")");
        this.saveFullColumnRef(new SelectNode(SelectType.CALCULATE, stringBuilder.toString()));
        return null;
    }

    @Override
    public String visit(AEConcat aEConcat) throws ErrorException {
        Stack<AEValueExpr> stack;
        AEConcat aEConcat2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CONCAT(");
        if (aEConcat.getLeftOperand() instanceof AEConcat) {
            aEConcat2 = (AEConcat)aEConcat.getLeftOperand();
            stack = new Stack<AEValueExpr>();
            stack.push(aEConcat2.getRightOperand());
            stack.push(aEConcat2.getLeftOperand());
            boolean bl = true;
            while (!stack.isEmpty()) {
                AEValueExpr aEValueExpr = (AEValueExpr)stack.pop();
                if (aEValueExpr instanceof AEConcat) {
                    aEConcat2 = (AEConcat)aEValueExpr;
                    stack.push(aEConcat2.getRightOperand());
                    stack.push(aEConcat2.getLeftOperand());
                    continue;
                }
                if (!bl) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(aEValueExpr.acceptVisitor(this));
                bl = false;
            }
        } else {
            stringBuilder.append(aEConcat.getLeftOperand().acceptVisitor(this));
        }
        if (aEConcat.getRightOperand() instanceof AEConcat) {
            aEConcat2 = (AEConcat)aEConcat.getRightOperand();
            stack = new Stack();
            stack.push(aEConcat2.getRightOperand());
            stack.push(aEConcat2.getLeftOperand());
            while (!stack.isEmpty()) {
                AEValueExpr aEValueExpr = (AEValueExpr)stack.pop();
                if (aEValueExpr instanceof AEConcat) {
                    aEConcat2 = (AEConcat)aEValueExpr;
                    stack.push(aEConcat2.getRightOperand());
                    stack.push(aEConcat2.getLeftOperand());
                    continue;
                }
                stringBuilder.append(", ").append(aEValueExpr.acceptVisitor(this));
            }
        } else {
            stringBuilder.append(", ").append(aEConcat.getRightOperand().acceptVisitor(this));
        }
        stringBuilder.append(")");
        this.saveFullColumnRef(new SelectNode(SelectType.CONCAT, stringBuilder.toString()));
        return null;
    }

    @Override
    public String visit(AESubtract aESubtract) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(aESubtract.getLeftOperand().acceptVisitor(this));
        stringBuilder.append(" - ");
        stringBuilder.append(aESubtract.getRightOperand().acceptVisitor(this));
        stringBuilder.append(")");
        this.saveFullColumnRef(new SelectNode(SelectType.CALCULATE, stringBuilder.toString()));
        return null;
    }

    @Override
    public String visit(AEDivide aEDivide) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(aEDivide.getLeftOperand().acceptVisitor(this));
        stringBuilder.append(" / ");
        stringBuilder.append(aEDivide.getRightOperand().acceptVisitor(this));
        stringBuilder.append(")");
        this.saveFullColumnRef(new SelectNode(SelectType.CALCULATE, stringBuilder.toString()));
        return null;
    }

    @Override
    public String visit(AEMultiply aEMultiply) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(aEMultiply.getLeftOperand().acceptVisitor(this));
        stringBuilder.append(" * ");
        stringBuilder.append(aEMultiply.getRightOperand().acceptVisitor(this));
        stringBuilder.append(")");
        this.saveFullColumnRef(new SelectNode(SelectType.CALCULATE, stringBuilder.toString()));
        return null;
    }

    @Override
    public String visit(AECountStarAggrFn aECountStarAggrFn) throws ErrorException {
        this.saveFullColumnRef(new SelectNode(SelectType.COUNTSTAR, "COUNT(*)"));
        return null;
    }

    @Override
    public String visit(AESearchedCase aESearchedCase) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder("(CASE ");
        stringBuilder.append((String)this.visit(aESearchedCase.getWhenClauseList()));
        AEValueExpr aEValueExpr = aESearchedCase.getElseClause();
        if (null != aEValueExpr) {
            stringBuilder.append(" ELSE ").append(aEValueExpr.acceptVisitor(this));
        }
        stringBuilder.append(" END)");
        this.saveFullColumnRef(new SelectNode(SelectType.SEARCH, stringBuilder.toString()));
        return null;
    }

    @Override
    public String visit(AESearchedWhenClause aESearchedWhenClause) throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("WHEN ").append(aESearchedWhenClause.getWhenCondition().acceptVisitor(this));
        stringBuilder.append(" THEN ").append(aESearchedWhenClause.getThenExpression().acceptVisitor(this));
        this.saveFullColumnRef(new SelectNode(SelectType.SEARCH, stringBuilder.toString()));
        return stringBuilder.toString();
    }
}

