/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hivecommon.jdbc41;

import com.cloudera.dsi.dataengine.utilities.ExecutionResult;
import com.cloudera.hivecommon.HiveJDBCSettings;
import com.cloudera.hivecommon.core.CoreUtils;
import com.cloudera.hivecommon.core.HiveJDBCCommonConnection;
import com.cloudera.hivecommon.core.HiveJDBCStatement;
import com.cloudera.hivecommon.dataengine.HiveJDBCResultSet;
import com.cloudera.hivecommon.jdbc41.Hive41ForwardResultSet;
import com.cloudera.jdbc.common.SConnection;
import com.cloudera.jdbc.common.SStatement;
import com.cloudera.jdbc.jdbc41.S41PreparedStatement;
import com.cloudera.support.LogUtilities;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class Hive41PreparedStatement
extends S41PreparedStatement {
    public Hive41PreparedStatement(String string, HiveJDBCStatement hiveJDBCStatement, SConnection sConnection, int n) throws SQLException {
        super(string, hiveJDBCStatement, sConnection, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        super.cancel();
        Object object = this.m_cancelLock;
        synchronized (object) {
            if (this.m_statement instanceof HiveJDBCStatement && this.m_isInCancelableFunction) {
                ((HiveJDBCStatement)this.m_statement).cancel();
            }
        }
    }

    public boolean getAsyncExecution() {
        return ((HiveJDBCStatement)this.m_statement).getAsyncExecution();
    }

    public HiveJDBCSettings getSettings() throws SQLException {
        Connection connection = this.getConnection();
        if (connection instanceof HiveJDBCCommonConnection) {
            return ((HiveJDBCCommonConnection)((Object)connection)).getSettings();
        }
        return null;
    }

    @Override
    public synchronized void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        super.setBigDecimal(n, bigDecimal);
        CoreUtils.alterBigDecimalMetadata(n, bigDecimal, this.m_setMetadata, this.getSettings());
    }

    @Override
    public synchronized void setObject(int n, Object object) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, object);
        if (!CoreUtils.setBigDecimalObject(this, n, object, this.getSettings())) {
            super.setObject(n, object);
        }
    }

    @Override
    public synchronized void setObject(int n, Object object, int n2) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, object, n2);
        if (!CoreUtils.setBigDecimalObject(this, n, object, this.getSettings())) {
            super.setObject(n, object, n2);
        }
    }

    @Override
    protected ResultSet createResultSet(ExecutionResult executionResult) throws SQLException {
        ResultSet resultSet = null;
        if (this.getAsyncExecution() && executionResult.getResult() instanceof HiveJDBCResultSet) {
            resultSet = new Hive41ForwardResultSet((SStatement)this, (HiveJDBCResultSet)executionResult.getResult(), this.m_logger);
            resultSet.setFetchSize(this.getFetchSize());
        } else {
            resultSet = super.createResultSet(executionResult);
        }
        return resultSet;
    }
}

