/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober.distributionanalysis;

public abstract class CharDistributionAnalysis {
    public static final float SURE_NO = 0.01f;
    public static final float SURE_YES = 0.99f;
    public static final int ENOUGH_DATA_THRESHOLD = 1024;
    public static final int MINIMUM_DATA_THRESHOLD = 4;
    private int freqChars;
    private int totalChars;
    protected int[] charToFreqOrder;
    protected float typicalDistributionRatio;

    public CharDistributionAnalysis() {
        CharDistributionAnalysis charDistributionAnalysis = this;
        charDistributionAnalysis.reset();
    }

    public void handleData(byte[] byArray, int n2, int n3) {
    }

    public void handleOneChar(byte[] objectArray, int n2, int n3) {
        int n4 = n3;
        n3 = -1;
        if (n4 == 2) {
            n3 = this.getOrder((byte[])objectArray, n2);
        }
        if (n3 >= 0) {
            CharDistributionAnalysis charDistributionAnalysis = this;
            ++charDistributionAnalysis.totalChars;
            objectArray = charDistributionAnalysis.charToFreqOrder;
            if (n3 < charDistributionAnalysis.charToFreqOrder.length && 512 > objectArray[n3]) {
                ++this.freqChars;
            }
        }
    }

    public float getConfidence() {
        int n2;
        int n3 = this.totalChars;
        if (n3 > 0 && (n2 = this.freqChars) > 4) {
            if (n3 != n2) {
                float f2;
                float f3 = (float)n2 / ((float)(n3 - n2) * this.typicalDistributionRatio);
                if (f2 < 0.99f) {
                    return f3;
                }
            }
            return 0.99f;
        }
        return 0.01f;
    }

    public void reset() {
        CharDistributionAnalysis charDistributionAnalysis = this;
        charDistributionAnalysis.totalChars = 0;
        charDistributionAnalysis.freqChars = 0;
    }

    public void setOption() {
    }

    public boolean gotEnoughData() {
        return this.totalChars > 1024;
    }

    protected abstract int getOrder(byte[] var1, int var2);
}

