/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;

public class HebrewProber
extends CharsetProber {
    public static final int FINAL_KAF = 234;
    public static final int NORMAL_KAF = 235;
    public static final int FINAL_MEM = 237;
    public static final int NORMAL_MEM = 238;
    public static final int FINAL_NUN = 239;
    public static final int NORMAL_NUN = 240;
    public static final int FINAL_PE = 243;
    public static final int NORMAL_PE = 244;
    public static final int FINAL_TSADI = 245;
    public static final int NORMAL_TSADI = 246;
    public static final byte SPACE = 32;
    public static final int MIN_FINAL_CHAR_DISTANCE = 5;
    public static final float MIN_MODEL_DISTANCE = 0.01f;
    private int finalCharLogicalScore;
    private int finalCharVisualScore;
    private byte prev;
    private byte beforePrev;
    private CharsetProber logicalProber;
    private CharsetProber visualProber;

    public HebrewProber() {
        HebrewProber hebrewProber = this;
        hebrewProber.logicalProber = null;
        hebrewProber.visualProber = null;
        hebrewProber.reset();
    }

    protected static boolean isFinal(byte by) {
        int n2 = by & 0xFF;
        by = (byte)n2;
        return n2 == 234 || by == 237 || by == 239 || by == 243 || by == 245;
    }

    protected static boolean isNonFinal(byte by) {
        int n2 = by & 0xFF;
        by = (byte)n2;
        return n2 == 235 || by == 238 || by == 240 || by == 244;
    }

    public void setModalProbers(CharsetProber charsetProber, CharsetProber charsetProber2) {
        HebrewProber hebrewProber = this;
        hebrewProber.logicalProber = charsetProber;
        hebrewProber.visualProber = charsetProber2;
    }

    @Override
    public String getCharSetName() {
        float f2;
        int n2 = this.finalCharLogicalScore - this.finalCharVisualScore;
        if (n2 >= 5) {
            return Constants.CHARSET_WINDOWS_1255;
        }
        if (n2 <= -5) {
            return Constants.CHARSET_ISO_8859_8;
        }
        float f3 = this.logicalProber.getConfidence() - this.visualProber.getConfidence();
        if (f2 > 0.01f) {
            return Constants.CHARSET_WINDOWS_1255;
        }
        if (f3 < -0.01f) {
            return Constants.CHARSET_ISO_8859_8;
        }
        if (n2 < 0) {
            return Constants.CHARSET_ISO_8859_8;
        }
        return Constants.CHARSET_WINDOWS_1255;
    }

    @Override
    public float getConfidence() {
        return 0.0f;
    }

    @Override
    public CharsetProber.ProbingState getState() {
        CharsetProber.ProbingState probingState = CharsetProber.ProbingState.NOT_ME;
        if (this.logicalProber.getState() == probingState && this.visualProber.getState() == probingState) {
            return probingState;
        }
        return CharsetProber.ProbingState.DETECTING;
    }

    @Override
    public CharsetProber.ProbingState handleData(byte[] byArray, int n2, int n3) {
        CharsetProber.ProbingState probingState = CharsetProber.ProbingState.NOT_ME;
        if (this.getState() == probingState) {
            return probingState;
        }
        n3 = n2 + n3;
        while (n2 < n3) {
            byte by = byArray[n2];
            if (by == 32) {
                if (this.beforePrev != 32) {
                    if (HebrewProber.isFinal(this.prev)) {
                        ++this.finalCharLogicalScore;
                    } else if (HebrewProber.isNonFinal(this.prev)) {
                        ++this.finalCharVisualScore;
                    }
                }
            } else if (this.beforePrev == 32 && HebrewProber.isFinal(this.prev) && by != 32) {
                ++this.finalCharVisualScore;
            }
            this.beforePrev = this.prev;
            this.prev = by;
            ++n2;
        }
        return CharsetProber.ProbingState.DETECTING;
    }

    @Override
    public void reset() {
        HebrewProber hebrewProber = this;
        hebrewProber.finalCharLogicalScore = 0;
        hebrewProber.finalCharVisualScore = 0;
        hebrewProber.prev = (byte)32;
        hebrewProber.beforePrev = (byte)32;
    }

    @Override
    public void setOption() {
    }
}

