/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import java.util.Arrays;
import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.distributionanalysis.EUCKRDistributionAnalysis;
import org.mozilla.universalchardet.prober.statemachine.CodingStateMachine;
import org.mozilla.universalchardet.prober.statemachine.EUCKRSMModel;
import org.mozilla.universalchardet.prober.statemachine.SMModel;

public class EUCKRProber
extends CharsetProber {
    private static final SMModel smModel = new EUCKRSMModel();
    private CodingStateMachine codingSM;
    private CharsetProber.ProbingState state;
    private EUCKRDistributionAnalysis distributionAnalyzer;
    private byte[] lastChar;

    public EUCKRProber() {
        EUCKRProber eUCKRProber = this;
        eUCKRProber.codingSM = new CodingStateMachine(smModel);
        eUCKRProber.distributionAnalyzer = new EUCKRDistributionAnalysis();
        eUCKRProber.lastChar = new byte[2];
        eUCKRProber.reset();
    }

    @Override
    public String getCharSetName() {
        return Constants.CHARSET_EUC_KR;
    }

    @Override
    public float getConfidence() {
        return this.distributionAnalyzer.getConfidence();
    }

    @Override
    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    @Override
    public CharsetProber.ProbingState handleData(byte[] byArray, int n2, int n3) {
        n3 = n2 + n3;
        for (int i2 = n2; i2 < n3; ++i2) {
            int n4 = this.codingSM.nextState(byArray[i2]);
            if (n4 == 1) {
                this.state = CharsetProber.ProbingState.NOT_ME;
                break;
            }
            if (n4 == 2) {
                this.state = CharsetProber.ProbingState.FOUND_IT;
                break;
            }
            if (n4 != 0) continue;
            n4 = this.codingSM.getCurrentCharLen();
            if (i2 == n2) {
                EUCKRProber eUCKRProber = this;
                byte[] byArray2 = eUCKRProber.lastChar;
                eUCKRProber.lastChar[1] = byArray[n2];
                eUCKRProber.distributionAnalyzer.handleOneChar(byArray2, 0, n4);
                continue;
            }
            this.distributionAnalyzer.handleOneChar(byArray, i2 - 1, n4);
        }
        EUCKRProber eUCKRProber = this;
        eUCKRProber.lastChar[0] = byArray[n3 - 1];
        if (eUCKRProber.state == CharsetProber.ProbingState.DETECTING && this.distributionAnalyzer.gotEnoughData() && this.getConfidence() > 0.95f) {
            this.state = CharsetProber.ProbingState.FOUND_IT;
        }
        return this.state;
    }

    @Override
    public void reset() {
        EUCKRProber eUCKRProber = this;
        eUCKRProber.codingSM.reset();
        eUCKRProber.state = CharsetProber.ProbingState.DETECTING;
        eUCKRProber.distributionAnalyzer.reset();
        Arrays.fill(eUCKRProber.lastChar, (byte)0);
    }

    @Override
    public void setOption() {
    }
}

