/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import java.util.Arrays;
import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.distributionanalysis.Big5DistributionAnalysis;
import org.mozilla.universalchardet.prober.statemachine.Big5SMModel;
import org.mozilla.universalchardet.prober.statemachine.CodingStateMachine;
import org.mozilla.universalchardet.prober.statemachine.SMModel;

public class Big5Prober
extends CharsetProber {
    private static final SMModel smModel = new Big5SMModel();
    private CodingStateMachine codingSM;
    private CharsetProber.ProbingState state;
    private Big5DistributionAnalysis distributionAnalyzer;
    private byte[] lastChar;

    public Big5Prober() {
        Big5Prober big5Prober = this;
        big5Prober.codingSM = new CodingStateMachine(smModel);
        big5Prober.distributionAnalyzer = new Big5DistributionAnalysis();
        big5Prober.lastChar = new byte[2];
        big5Prober.reset();
    }

    @Override
    public String getCharSetName() {
        return Constants.CHARSET_BIG5;
    }

    @Override
    public float getConfidence() {
        return this.distributionAnalyzer.getConfidence();
    }

    @Override
    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    @Override
    public CharsetProber.ProbingState handleData(byte[] byArray, int n2, int n3) {
        n3 = n2 + n3;
        for (int i2 = n2; i2 < n3; ++i2) {
            int n4 = this.codingSM.nextState(byArray[i2]);
            if (n4 == 1) {
                this.state = CharsetProber.ProbingState.NOT_ME;
                break;
            }
            if (n4 == 2) {
                this.state = CharsetProber.ProbingState.FOUND_IT;
                break;
            }
            if (n4 != 0) continue;
            n4 = this.codingSM.getCurrentCharLen();
            if (i2 == n2) {
                Big5Prober big5Prober = this;
                byte[] byArray2 = big5Prober.lastChar;
                big5Prober.lastChar[1] = byArray[n2];
                big5Prober.distributionAnalyzer.handleOneChar(byArray2, 0, n4);
                continue;
            }
            this.distributionAnalyzer.handleOneChar(byArray, i2 - 1, n4);
        }
        Big5Prober big5Prober = this;
        big5Prober.lastChar[0] = byArray[n3 - 1];
        if (big5Prober.state == CharsetProber.ProbingState.DETECTING && this.distributionAnalyzer.gotEnoughData() && this.getConfidence() > 0.95f) {
            this.state = CharsetProber.ProbingState.FOUND_IT;
        }
        return this.state;
    }

    @Override
    public void reset() {
        Big5Prober big5Prober = this;
        big5Prober.codingSM.reset();
        big5Prober.state = CharsetProber.ProbingState.DETECTING;
        big5Prober.distributionAnalyzer.reset();
        Arrays.fill(big5Prober.lastChar, (byte)0);
    }

    @Override
    public void setOption() {
    }
}

