/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.mozilla.universalchardet.CharsetListener;
import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.EscCharsetProber;
import org.mozilla.universalchardet.prober.MBCSGroupProber;

public class UniversalDetector {
    public static final float SHORTCUT_THRESHOLD = 0.95f;
    public static final float MINIMUM_THRESHOLD = 0.2f;
    private InputState inputState;
    private boolean done;
    private boolean start;
    private boolean gotData;
    private byte lastChar;
    private String detectedCharset;
    private CharsetProber[] probers;
    private CharsetProber escCharsetProber;
    private CharsetListener listener;

    public UniversalDetector() {
        this(null);
    }

    public UniversalDetector(CharsetListener charsetListener) {
        this.listener = charsetListener;
        this.escCharsetProber = null;
        this.probers = new CharsetProber[1];
        this.reset();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String detectCharset(File object) throws IOException {
        String string2;
        UniversalDetector universalDetector;
        FileInputStream fileInputStream;
        FileInputStream fileInputStream2 = fileInputStream;
        fileInputStream = new FileInputStream((File)object);
        try {
            object = new byte[4096];
        }
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                try {
                    fileInputStream2.close();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        UniversalDetector universalDetector2 = universalDetector;
        {
            universalDetector = new UniversalDetector(null);
        }
        {
            int n2;
            while ((n2 = fileInputStream2.read((byte[])object)) > 0 && !universalDetector2.isDone()) {
                universalDetector2.handleData((byte[])object, 0, n2);
            }
            UniversalDetector universalDetector3 = universalDetector2;
            universalDetector3.dataEnd();
            string2 = universalDetector3.getDetectedCharset();
            universalDetector2.reset();
            fileInputStream2.close();
        }
        return string2;
    }

    public boolean isDone() {
        return this.done;
    }

    public String getDetectedCharset() {
        return this.detectedCharset;
    }

    public void setListener(CharsetListener charsetListener) {
        this.listener = charsetListener;
    }

    public CharsetListener getListener() {
        return this.listener;
    }

    public void handleData(byte[] byArray) {
        int n2 = byArray.length;
        this.handleData(byArray, 0, n2);
    }

    public void handleData(byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        if (this.done) {
            return;
        }
        if (n3 > 0) {
            this.gotData = true;
        }
        if (this.start) {
            this.start = false;
            if (n3 > 3) {
                n6 = byArray[n2] & 0xFF;
                n5 = byArray[n2 + 1] & 0xFF;
                n4 = byArray[n2 + 2] & 0xFF;
                int n7 = byArray[n2 + 3] & 0xFF;
                if (n6 != 0) {
                    if (n6 != 239) {
                        if (n6 != 254) {
                            if (n6 == 255) {
                                if (n5 == 254 && n4 == 0 && n7 == 0) {
                                    this.detectedCharset = Constants.CHARSET_UTF_32LE;
                                } else if (n5 == 254) {
                                    this.detectedCharset = Constants.CHARSET_UTF_16LE;
                                }
                            }
                        } else if (n5 == 255 && n4 == 0 && n7 == 0) {
                            this.detectedCharset = Constants.CHARSET_X_ISO_10646_UCS_4_3412;
                        } else if (n5 == 255) {
                            this.detectedCharset = Constants.CHARSET_UTF_16BE;
                        }
                    } else if (n5 == 187 && n4 == 191) {
                        this.detectedCharset = Constants.CHARSET_UTF_8;
                    }
                } else if (n5 == 0 && n4 == 254 && n7 == 255) {
                    this.detectedCharset = Constants.CHARSET_UTF_32BE;
                } else if (n5 == 0 && n4 == 255 && n7 == 254) {
                    this.detectedCharset = Constants.CHARSET_X_ISO_10646_UCS_4_2143;
                }
                if (this.detectedCharset != null) {
                    this.done = true;
                    return;
                }
            }
        }
        n6 = n2 + n3;
        for (n5 = n2; n5 < n6; ++n5) {
            n4 = byArray[n5] & 0xFF;
            if ((n4 & 0x80) != 0 && n4 != 160) {
                MBCSGroupProber mBCSGroupProber;
                Object object = InputState.HIGHBYTE;
                if (this.inputState == InputState.HIGHBYTE) continue;
                this.inputState = object;
                if (this.escCharsetProber != null) {
                    this.escCharsetProber = null;
                }
                object = this.probers;
                if (this.probers[0] != null) continue;
                CharsetProber[] charsetProberArray = object;
                object = mBCSGroupProber;
                mBCSGroupProber = new MBCSGroupProber();
                charsetProberArray[0] = object;
                continue;
            }
            if (this.inputState == InputState.PURE_ASCII && (n4 == 27 || n4 == 123 && this.lastChar == 126)) {
                this.inputState = InputState.ESC_ASCII;
            }
            this.lastChar = byArray[n5];
        }
        Object object = this.inputState;
        if (object == InputState.ESC_ASCII) {
            if (this.escCharsetProber == null) {
                EscCharsetProber escCharsetProber;
                object = escCharsetProber;
                escCharsetProber = new EscCharsetProber();
                this.escCharsetProber = object;
            }
            if (this.escCharsetProber.handleData(byArray, n2, n3) == CharsetProber.ProbingState.FOUND_IT) {
                this.done = true;
                this.detectedCharset = this.escCharsetProber.getCharSetName();
            }
        } else if (object == InputState.HIGHBYTE) {
            int n8 = 0;
            while (true) {
                CharsetProber[] charsetProberArray = this.probers;
                if (n8 >= this.probers.length) break;
                if (charsetProberArray[n8].handleData(byArray, n2, n3) == CharsetProber.ProbingState.FOUND_IT) {
                    this.done = true;
                    this.detectedCharset = this.probers[n8].getCharSetName();
                    return;
                }
                ++n8;
            }
        }
    }

    public void dataEnd() {
        block8: {
            CharsetProber[] charsetProberArray;
            Object object;
            if (!((UniversalDetector)object).gotData) {
                return;
            }
            String string2 = ((UniversalDetector)object).detectedCharset;
            if (string2 != null) {
                ((UniversalDetector)object).done = true;
                object = ((UniversalDetector)object).listener;
                if (object != null) {
                    object.report(string2);
                }
                return;
            }
            if (((UniversalDetector)object).inputState != InputState.HIGHBYTE) break block8;
            float f2 = 0.0f;
            int n2 = 0;
            int n3 = 0;
            while (true) {
                float f3;
                charsetProberArray = ((UniversalDetector)object).probers;
                if (n3 >= ((UniversalDetector)object).probers.length) break;
                float f4 = charsetProberArray[n3].getConfidence();
                if (f3 > f2) {
                    n2 = n3;
                } else {
                    f4 = f2;
                }
                ++n3;
                f2 = f4;
            }
            if (f2 > 0.2f) {
                Object object2 = object;
                object = charsetProberArray[n2].getCharSetName();
                ((UniversalDetector)object2).detectedCharset = object;
                CharsetListener charsetListener = ((UniversalDetector)object2).listener;
                if (charsetListener != null) {
                    charsetListener.report((String)object);
                }
            }
        }
    }

    public void reset() {
        this.done = false;
        this.start = true;
        this.detectedCharset = null;
        this.gotData = false;
        this.inputState = InputState.PURE_ASCII;
        this.lastChar = 0;
        CharsetProber charsetProber = this.escCharsetProber;
        if (charsetProber != null) {
            charsetProber.reset();
        }
        int n2 = 0;
        while (true) {
            CharsetProber[] charsetProberArray = this.probers;
            if (n2 >= this.probers.length) break;
            if (charsetProberArray[n2] != null) {
                charsetProberArray[n2].reset();
            }
            ++n2;
        }
    }

    public static final class InputState
    extends Enum<InputState> {
        public static final /* enum */ InputState PURE_ASCII;
        public static final /* enum */ InputState ESC_ASCII;
        public static final /* enum */ InputState HIGHBYTE;
        private static final /* synthetic */ InputState[] $VALUES;

        public static InputState[] values() {
            return (InputState[])$VALUES.clone();
        }

        public static InputState valueOf(String string2) {
            return Enum.valueOf(InputState.class, string2);
        }

        static {
            InputState inputState;
            InputState inputState2;
            InputState inputState3;
            InputState inputState4 = inputState3;
            PURE_ASCII = new InputState();
            InputState inputState5 = inputState2;
            ESC_ASCII = new InputState();
            InputState inputState6 = inputState;
            HIGHBYTE = new InputState();
            $VALUES = new InputState[]{inputState4, inputState5, inputState6};
        }
    }
}

