/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.nineoldandroids.view.animation;

import android.graphics.Camera;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.os.Build;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

public final class AnimatorProxy
extends Animation {
    public static final boolean NEEDS_PROXY = Integer.valueOf(Build.VERSION.SDK) < 11;
    private static final WeakHashMap<View, AnimatorProxy> PROXIES = new WeakHashMap();
    private final WeakReference<View> mView;
    private final Camera mCamera;
    private boolean mHasPivot;
    private float mAlpha;
    private float mPivotX;
    private float mPivotY;
    private float mRotationX;
    private float mRotationY;
    private float mRotationZ;
    private float mScaleX;
    private float mScaleY;
    private float mTranslationX;
    private float mTranslationY;
    private final RectF mBefore;
    private final RectF mAfter;
    private final Matrix mTempMatrix;

    public static AnimatorProxy wrap(View view) {
        WeakHashMap<View, AnimatorProxy> weakHashMap = PROXIES;
        AnimatorProxy animatorProxy = weakHashMap.get(view);
        if (animatorProxy == null || animatorProxy != view.getAnimation()) {
            AnimatorProxy animatorProxy2;
            animatorProxy = animatorProxy2;
            animatorProxy2 = new AnimatorProxy(view);
            weakHashMap.put(view, animatorProxy);
        }
        return animatorProxy;
    }

    private AnimatorProxy(View view) {
        WeakReference<View> weakReference;
        Matrix matrix;
        RectF rectF;
        RectF rectF2;
        Camera camera;
        AnimatorProxy animatorProxy = object;
        AnimatorProxy animatorProxy2 = object;
        Camera camera2 = camera;
        camera = new Camera();
        animatorProxy2.mCamera = camera2;
        animatorProxy2.mAlpha = 1.0f;
        animatorProxy2.mScaleX = 1.0f;
        animatorProxy2.mScaleY = 1.0f;
        camera2 = rectF2;
        rectF2 = new RectF();
        animatorProxy2.mBefore = camera2;
        camera2 = rectF;
        rectF = new RectF();
        animatorProxy2.mAfter = camera2;
        camera2 = matrix;
        matrix = new Matrix();
        animatorProxy2.mTempMatrix = camera2;
        animatorProxy2.setDuration(0L);
        animatorProxy2.setFillAfter(true);
        view.setAnimation((Animation)object);
        Object object = weakReference;
        weakReference = new WeakReference<View>(view);
        animatorProxy.mView = object;
    }

    private void prepareForUpdate() {
        View view = (View)this.mView.get();
        if (view != null) {
            AnimatorProxy animatorProxy = this;
            animatorProxy.computeRect(animatorProxy.mBefore, view);
        }
    }

    private void invalidateAfterUpdate() {
        View view = (View)this.mView.get();
        if (view != null && view.getParent() != null) {
            RectF rectF = this.mAfter;
            AnimatorProxy animatorProxy = this;
            animatorProxy.computeRect(rectF, view);
            rectF.union(animatorProxy.mBefore);
            RectF rectF2 = rectF;
            int n2 = (int)Math.floor(rectF2.top);
            int n3 = (int)Math.ceil(rectF2.right);
            int n4 = (int)Math.ceil(rectF2.bottom);
            ((View)view.getParent()).invalidate((int)Math.floor(rectF.left), n2, n3, n4);
            return;
        }
    }

    private void computeRect(RectF rectF, View view) {
        float f2;
        float f3;
        float f4;
        float f5;
        RectF rectF2 = rectF;
        AnimatorProxy animatorProxy = this;
        View view2 = view;
        float f6 = view2.getWidth();
        float f7 = view2.getHeight();
        rectF.set(0.0f, 0.0f, f6, f7);
        Matrix matrix = animatorProxy.mTempMatrix;
        matrix.reset();
        animatorProxy.transformMatrix(matrix, view);
        animatorProxy.mTempMatrix.mapRect(rectF);
        rectF2.offset((float)view.getLeft(), (float)view.getTop());
        f6 = rectF2.right;
        float f8 = rectF.left;
        if (f5 < f4) {
            RectF rectF3 = rectF;
            rectF3.right = f8;
            rectF3.left = f6;
        }
        f6 = rectF.bottom;
        f8 = rectF.top;
        if (f3 < f2) {
            RectF rectF4 = rectF;
            rectF4.top = f6;
            rectF4.bottom = f8;
        }
    }

    private void transformMatrix(Matrix matrix, View view) {
        View view2 = view;
        float f2 = view2.getWidth();
        float f3 = view2.getHeight();
        boolean bl = this.mHasPivot;
        float f4 = bl ? this.mPivotX : f2 / 2.0f;
        float f5 = bl ? this.mPivotY : f3 / 2.0f;
        float f6 = this.mRotationX;
        AnimatorProxy animatorProxy = this;
        float f7 = animatorProxy.mRotationY;
        float f8 = animatorProxy.mRotationZ;
        if (f6 != 0.0f || f7 != 0.0f || f8 != 0.0f) {
            Camera camera = this.mCamera;
            camera.save();
            camera.rotateX(f6);
            camera.rotateY(f7);
            camera.rotateZ(-f8);
            camera.getMatrix(matrix);
            camera.restore();
            f6 = -f4;
            matrix.preTranslate(f6, -f5);
            matrix.postTranslate(f4, f5);
        }
        f6 = this.mScaleX;
        f7 = this.mScaleY;
        if (f6 != 1.0f || f7 != 1.0f) {
            matrix.postScale(f6, f7);
            f2 = -(f4 / f2) * (f6 * f2 - f2);
            matrix.postTranslate(f2, -(f5 / f3) * (f7 * f3 - f3));
        }
        AnimatorProxy animatorProxy2 = this;
        float f9 = animatorProxy2.mTranslationX;
        matrix.postTranslate(f9, animatorProxy2.mTranslationY);
    }

    public float getAlpha() {
        return this.mAlpha;
    }

    public void setAlpha(float f2) {
        if (animatorProxy.mAlpha != f2) {
            animatorProxy.mAlpha = f2;
            AnimatorProxy animatorProxy = (View)animatorProxy.mView.get();
            if (animatorProxy != null) {
                animatorProxy.invalidate();
            }
        }
    }

    public float getPivotX() {
        return this.mPivotX;
    }

    public void setPivotX(float f2) {
        if (!this.mHasPivot || this.mPivotX != f2) {
            AnimatorProxy animatorProxy = this;
            animatorProxy.prepareForUpdate();
            animatorProxy.mHasPivot = true;
            animatorProxy.mPivotX = f2;
            animatorProxy.invalidateAfterUpdate();
        }
    }

    public float getPivotY() {
        return this.mPivotY;
    }

    public void setPivotY(float f2) {
        if (!this.mHasPivot || this.mPivotY != f2) {
            AnimatorProxy animatorProxy = this;
            animatorProxy.prepareForUpdate();
            animatorProxy.mHasPivot = true;
            animatorProxy.mPivotY = f2;
            animatorProxy.invalidateAfterUpdate();
        }
    }

    public float getRotation() {
        return this.mRotationZ;
    }

    public void setRotation(float f2) {
        if (this.mRotationZ != f2) {
            AnimatorProxy animatorProxy = this;
            animatorProxy.prepareForUpdate();
            animatorProxy.mRotationZ = f2;
            animatorProxy.invalidateAfterUpdate();
        }
    }

    public float getRotationX() {
        return this.mRotationX;
    }

    public void setRotationX(float f2) {
        if (this.mRotationX != f2) {
            AnimatorProxy animatorProxy = this;
            animatorProxy.prepareForUpdate();
            animatorProxy.mRotationX = f2;
            animatorProxy.invalidateAfterUpdate();
        }
    }

    public float getRotationY() {
        return this.mRotationY;
    }

    public void setRotationY(float f2) {
        if (this.mRotationY != f2) {
            AnimatorProxy animatorProxy = this;
            animatorProxy.prepareForUpdate();
            animatorProxy.mRotationY = f2;
            animatorProxy.invalidateAfterUpdate();
        }
    }

    public float getScaleX() {
        return this.mScaleX;
    }

    public void setScaleX(float f2) {
        if (this.mScaleX != f2) {
            AnimatorProxy animatorProxy = this;
            animatorProxy.prepareForUpdate();
            animatorProxy.mScaleX = f2;
            animatorProxy.invalidateAfterUpdate();
        }
    }

    public float getScaleY() {
        return this.mScaleY;
    }

    public void setScaleY(float f2) {
        if (this.mScaleY != f2) {
            AnimatorProxy animatorProxy = this;
            animatorProxy.prepareForUpdate();
            animatorProxy.mScaleY = f2;
            animatorProxy.invalidateAfterUpdate();
        }
    }

    public int getScrollX() {
        AnimatorProxy animatorProxy = (View)animatorProxy.mView.get();
        if (animatorProxy == null) {
            return 0;
        }
        return animatorProxy.getScrollX();
    }

    public void setScrollX(int n2) {
        AnimatorProxy animatorProxy = (View)animatorProxy.mView.get();
        if (animatorProxy != null) {
            AnimatorProxy animatorProxy2 = animatorProxy;
            animatorProxy2.scrollTo(n2, animatorProxy2.getScrollY());
        }
    }

    public int getScrollY() {
        AnimatorProxy animatorProxy = (View)animatorProxy.mView.get();
        if (animatorProxy == null) {
            return 0;
        }
        return animatorProxy.getScrollY();
    }

    public void setScrollY(int n2) {
        AnimatorProxy animatorProxy = (View)animatorProxy.mView.get();
        if (animatorProxy != null) {
            AnimatorProxy animatorProxy2 = animatorProxy;
            animatorProxy2.scrollTo(animatorProxy2.getScrollX(), n2);
        }
    }

    public float getTranslationX() {
        return this.mTranslationX;
    }

    public void setTranslationX(float f2) {
        if (this.mTranslationX != f2) {
            AnimatorProxy animatorProxy = this;
            animatorProxy.prepareForUpdate();
            animatorProxy.mTranslationX = f2;
            animatorProxy.invalidateAfterUpdate();
        }
    }

    public float getTranslationY() {
        return this.mTranslationY;
    }

    public void setTranslationY(float f2) {
        if (this.mTranslationY != f2) {
            AnimatorProxy animatorProxy = this;
            animatorProxy.prepareForUpdate();
            animatorProxy.mTranslationY = f2;
            animatorProxy.invalidateAfterUpdate();
        }
    }

    public float getX() {
        View view = (View)this.mView.get();
        if (view == null) {
            return 0.0f;
        }
        return (float)view.getLeft() + this.mTranslationX;
    }

    public void setX(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            this.setTranslationX(f2 - (float)view.getLeft());
        }
    }

    public float getY() {
        View view = (View)this.mView.get();
        if (view == null) {
            return 0.0f;
        }
        return (float)view.getTop() + this.mTranslationY;
    }

    public void setY(float f2) {
        View view = (View)this.mView.get();
        if (view != null) {
            this.setTranslationY(f2 - (float)view.getTop());
        }
    }

    protected void applyTransformation(float f2, Transformation transformation) {
        View view = (View)this.mView.get();
        if (view != null) {
            Transformation transformation2 = transformation;
            transformation2.setAlpha(this.mAlpha);
            this.transformMatrix(transformation2.getMatrix(), view);
        }
    }
}

