/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.nineoldandroids.animation;

import android.view.animation.Interpolator;

public abstract class Keyframe
implements Cloneable {
    float mFraction;
    Class mValueType;
    private Interpolator mInterpolator = null;
    boolean mHasValue = false;

    public static Keyframe ofInt(float f2, int n2) {
        return new IntKeyframe(f2, n2);
    }

    public static Keyframe ofInt(float f2) {
        return new IntKeyframe(f2);
    }

    public static Keyframe ofFloat(float f2, float f3) {
        return new FloatKeyframe(f2, f3);
    }

    public static Keyframe ofFloat(float f2) {
        return new FloatKeyframe(f2);
    }

    public static Keyframe ofObject(float f2, Object object) {
        return new ObjectKeyframe(f2, object);
    }

    public static Keyframe ofObject(float f2) {
        return new ObjectKeyframe(f2, null);
    }

    public boolean hasValue() {
        return this.mHasValue;
    }

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public float getFraction() {
        return this.mFraction;
    }

    public void setFraction(float f2) {
        this.mFraction = f2;
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    public Class getType() {
        return this.mValueType;
    }

    public abstract Keyframe clone();

    static class FloatKeyframe
    extends Keyframe {
        float mValue;

        FloatKeyframe(float f2, float f3) {
            FloatKeyframe floatKeyframe = this;
            this.mFraction = f2;
            floatKeyframe.mValue = f3;
            floatKeyframe.mValueType = Float.TYPE;
            floatKeyframe.mHasValue = true;
        }

        FloatKeyframe(float f2) {
            FloatKeyframe floatKeyframe = this;
            floatKeyframe.mFraction = f2;
            floatKeyframe.mValueType = Float.TYPE;
        }

        public float getFloatValue() {
            return this.mValue;
        }

        @Override
        public Object getValue() {
            return Float.valueOf(this.mValue);
        }

        @Override
        public void setValue(Object object) {
            if (object != null && object.getClass() == Float.class) {
                FloatKeyframe floatKeyframe = this;
                floatKeyframe.mValue = ((Float)object).floatValue();
                floatKeyframe.mHasValue = true;
            }
        }

        @Override
        public FloatKeyframe clone() {
            FloatKeyframe floatKeyframe = this;
            float f2 = floatKeyframe.getFraction();
            FloatKeyframe floatKeyframe2 = new FloatKeyframe(f2, floatKeyframe.mValue);
            floatKeyframe2.setInterpolator(this.getInterpolator());
            return floatKeyframe2;
        }
    }

    static class IntKeyframe
    extends Keyframe {
        int mValue;

        IntKeyframe(float f2, int n2) {
            IntKeyframe intKeyframe = this;
            this.mFraction = f2;
            intKeyframe.mValue = n2;
            intKeyframe.mValueType = Integer.TYPE;
            intKeyframe.mHasValue = true;
        }

        IntKeyframe(float f2) {
            IntKeyframe intKeyframe = this;
            intKeyframe.mFraction = f2;
            intKeyframe.mValueType = Integer.TYPE;
        }

        public int getIntValue() {
            return this.mValue;
        }

        @Override
        public Object getValue() {
            return this.mValue;
        }

        @Override
        public void setValue(Object object) {
            if (object != null && object.getClass() == Integer.class) {
                IntKeyframe intKeyframe = this;
                intKeyframe.mValue = (Integer)object;
                intKeyframe.mHasValue = true;
            }
        }

        @Override
        public IntKeyframe clone() {
            IntKeyframe intKeyframe = this;
            float f2 = intKeyframe.getFraction();
            IntKeyframe intKeyframe2 = new IntKeyframe(f2, intKeyframe.mValue);
            intKeyframe2.setInterpolator(this.getInterpolator());
            return intKeyframe2;
        }
    }

    static class ObjectKeyframe
    extends Keyframe {
        Object mValue;

        ObjectKeyframe(float f2, Object object) {
            this.mFraction = f2;
            this.mValue = object;
            boolean bl = object != null;
            this.mHasValue = bl;
            Class clazz = bl ? object.getClass() : Object.class;
            this.mValueType = clazz;
        }

        @Override
        public Object getValue() {
            return this.mValue;
        }

        @Override
        public void setValue(Object object) {
            this.mValue = object;
            boolean bl = object != null;
            this.mHasValue = bl;
        }

        @Override
        public ObjectKeyframe clone() {
            ObjectKeyframe objectKeyframe = this;
            float f2 = objectKeyframe.getFraction();
            ObjectKeyframe objectKeyframe2 = new ObjectKeyframe(f2, objectKeyframe.mValue);
            objectKeyframe2.setInterpolator(this.getInterpolator());
            return objectKeyframe2;
        }
    }
}

