/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.oauth;

import io.dcloud.common.DHInterface.BaseFeature;
import io.dcloud.common.DHInterface.IReflectAble;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.util.SP;
import io.dcloud.common.constant.DOMException;
import io.dcloud.common.util.Base64;
import io.dcloud.common.util.JSUtil;
import io.dcloud.common.util.NetTool;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.StringUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseOAuthService
extends BaseFeature.BaseModule
implements IReflectAble {
    protected static final String NULL = "null";
    protected static final String KEY_AUTHRESULT = "authResult";
    protected static final String KEY_USERINFO = "userInfo";
    protected static final String KEY_UNIVERIFYINFO = "univerifyInfo";
    protected static final String KEY_SCOPE = "scope";
    protected static final String KEY_STATE = "state";
    protected static final String KEY_APPID = "appid";
    protected static final String KEY_APPKEY = "appkey";
    protected static final String KEY_APSECRET = "appsecret";
    protected static final String KEY_REDIRECT_URI = "redirect_uri";
    protected static final String KEY_OPENID = "openid";
    protected static final String KEY_ACCESS_TOKEN = "access_token";
    protected static final String KEY_EXPIRES_IN = "expires_in";
    protected static final String KEY_REFRESH_TOKEN = "refresh_token";
    protected static final String KEY_HEADIMGURL = "headimgurl";
    protected static final String KEY_NICKNAME = "nickname";
    protected static final String KEY_UNIONID = "unionid";
    protected JSONObject authResult;
    protected JSONObject userInfo;
    protected JSONObject univerifyInfo;
    protected IWebview mLoginWebViewImpl = null;
    protected String mLoginCallbackId = null;
    protected JSONObject mLoginOptions = null;
    protected IWebview mAuthWebview = null;
    protected String mAuthCallbackId = null;
    protected JSONObject mAuthOptions = null;
    protected IWebview mLogoutWebViewImpl = null;
    protected String mLogoutCallbackId = null;
    protected IWebview mPreLoginWebViewImpl = null;
    protected String mPreLoginCallbackId = null;
    protected IWebview mOtherClickWebViewImpl = null;
    protected String mOtherClickCallbackId = null;
    protected IWebview mGetUserInfoWebViewImpl = null;
    protected String mGetUserInfoCallbackId = null;
    protected IWebview mAddPhoneNumberWebViewImpl = null;
    protected String mAddPhoneNumberCallbackId = null;

    public void login(IWebview iWebview, JSONArray jSONArray) {
        BaseOAuthService baseOAuthService = baseOAuthService2;
        baseOAuthService2.initMetaData();
        baseOAuthService2.mLoginWebViewImpl = iWebview;
        baseOAuthService2.mLoginCallbackId = jSONArray.getString(1);
        BaseOAuthService baseOAuthService2 = jSONArray.optJSONObject(2);
        try {
            baseOAuthService.mLoginOptions = baseOAuthService2;
            baseOAuthService.initAuthOptions((JSONObject)baseOAuthService2);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public void authorize(IWebview iWebview, JSONArray jSONArray) {
        BaseOAuthService baseOAuthService = baseOAuthService2;
        baseOAuthService2.initMetaData();
        baseOAuthService2.mAuthWebview = iWebview;
        baseOAuthService2.mAuthCallbackId = jSONArray.optString(1, "");
        BaseOAuthService baseOAuthService2 = jSONArray.optJSONObject(2);
        baseOAuthService.mAuthOptions = baseOAuthService2;
        baseOAuthService.initAuthOptions((JSONObject)baseOAuthService2);
    }

    public void initMetaData() {
    }

    public void initAuthOptions(JSONObject jSONObject) {
    }

    public boolean hasGeneralError(IWebview iWebview, String string2) {
        if (!objectArray2.hasFullConfigData()) {
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = -7;
            objectArray[1] = DOMException.toString(DOMException.MSG_BUSINESS_PARAMETER_HAS_NOT);
            JSUtil.execCallback(iWebview, string2, StringUtil.format("{code:%d,message:'%s'}", objectArray2), JSUtil.ERROR, true, false);
            return true;
        }
        return false;
    }

    public boolean hasFullConfigData() {
        return false;
    }

    protected void onLoginFinished(JSONObject jSONObject, boolean bl) {
        BaseOAuthService baseOAuthService = this;
        IWebview iWebview = baseOAuthService.mLoginWebViewImpl;
        String string2 = baseOAuthService.mLoginCallbackId;
        int n2 = bl ? JSUtil.OK : JSUtil.ERROR;
        BaseOAuthService baseOAuthService2 = this;
        JSUtil.execCallback(iWebview, string2, jSONObject, n2, false);
        baseOAuthService2.mLoginWebViewImpl = null;
        baseOAuthService2.mLoginCallbackId = null;
    }

    public void logout(IWebview iWebview, JSONArray jSONArray) {
        this.mLogoutWebViewImpl = iWebview;
        try {
            this.mLogoutCallbackId = jSONArray.getString(1);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    protected void onLogoutFinished(JSONObject jSONObject, boolean bl) {
        BaseOAuthService baseOAuthService = iWebview;
        IWebview iWebview = baseOAuthService.mLogoutWebViewImpl;
        String string2 = baseOAuthService.mLogoutCallbackId;
        int n2 = bl ? JSUtil.OK : JSUtil.ERROR;
        JSUtil.execCallback(iWebview, string2, jSONObject, n2, false);
    }

    public void preLogin(IWebview iWebview, JSONArray jSONArray) {
        this.initMetaData();
        this.mPreLoginWebViewImpl = iWebview;
        try {
            this.mPreLoginCallbackId = jSONArray.getString(1);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public void closeAuthView(IWebview iWebview, JSONArray jSONArray) {
    }

    public void otherLoginButtonClick(IWebview iWebview, JSONArray jSONArray) {
        this.mOtherClickWebViewImpl = iWebview;
        try {
            this.mOtherClickCallbackId = jSONArray.getString(1);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    protected void onPreLoginFinished(JSONObject jSONObject, boolean bl) {
        BaseOAuthService baseOAuthService = iWebview;
        IWebview iWebview = baseOAuthService.mPreLoginWebViewImpl;
        String string2 = baseOAuthService.mPreLoginCallbackId;
        int n2 = bl ? JSUtil.OK : JSUtil.ERROR;
        JSUtil.execCallback(iWebview, string2, jSONObject, n2, false);
    }

    public void getUserInfo(IWebview iWebview, JSONArray jSONArray) {
        this.mGetUserInfoWebViewImpl = iWebview;
        try {
            this.mGetUserInfoCallbackId = jSONArray.getString(1);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    protected void onGetUserInfoFinished(JSONObject jSONObject, boolean bl) {
        BaseOAuthService baseOAuthService = iWebview;
        IWebview iWebview = baseOAuthService.mGetUserInfoWebViewImpl;
        String string2 = baseOAuthService.mGetUserInfoCallbackId;
        int n2 = bl ? JSUtil.OK : JSUtil.ERROR;
        JSUtil.execCallback(iWebview, string2, jSONObject, n2, false);
    }

    public void addPhoneNumber(IWebview iWebview, JSONArray jSONArray) {
        this.mAddPhoneNumberWebViewImpl = iWebview;
        try {
            this.mAddPhoneNumberCallbackId = jSONArray.getString(1);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    protected void onAddPhoneNumberFinished(JSONObject jSONObject, boolean bl) {
        BaseOAuthService baseOAuthService = iWebview;
        IWebview iWebview = baseOAuthService.mAddPhoneNumberWebViewImpl;
        String string2 = baseOAuthService.mAddPhoneNumberCallbackId;
        int n2 = bl ? JSUtil.OK : JSUtil.ERROR;
        JSUtil.execCallback(iWebview, string2, jSONObject, n2, false);
    }

    @Override
    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject;
        String string2 = "{id:'%s',description:'%s',authResult:%s,userInfo:%s}";
        Object[] objectArray = new Object[4];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.id;
        objectArray[1] = this.description;
        int n2 = 2;
        Object object = this.authResult;
        if (object == null) {
            object = NULL;
        }
        objectArray2[n2] = object;
        int n3 = 3;
        Object object2 = this.userInfo;
        if (object2 == null) {
            object2 = NULL;
        }
        JSONObject jSONObject2 = jSONObject;
        objectArray2[n3] = object2;
        jSONObject2(String.format(string2, objectArray2));
        return jSONObject2;
    }

    protected String getUserInfo(String string2) {
        byte[] byArray = NetTool.httpGet(string2);
        Object object = byArray;
        if (!PdrUtil.isEmpty(byArray)) {
            return new String((byte[])object);
        }
        return null;
    }

    protected String checkToken(String string2) {
        return new String(NetTool.httpGet(string2));
    }

    protected void removeToken() {
        SP.clearBundle(this.mApplicationContext, "oauth_" + this.id);
    }

    protected void saveValue(String string2, String string3) {
        BaseOAuthService baseOAuthService = this;
        BaseOAuthService baseOAuthService2 = baseOAuthService;
        BaseOAuthService baseOAuthService3 = baseOAuthService;
        String string4 = string3;
        string2 = this.encrypt(string2);
        string3 = baseOAuthService2.encrypt(string4);
        try {
            SP.setBundleData(baseOAuthService3.mApplicationContext, "oauth_" + this.id, string2, string3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void removeValue(String string2) {
        BaseOAuthService baseOAuthService = this;
        BaseOAuthService baseOAuthService2 = baseOAuthService;
        string2 = baseOAuthService.encrypt(string2);
        try {
            SP.removeBundleData(baseOAuthService2.mApplicationContext, "oauth_" + this.id, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected String getValue(String string2) {
        block4: {
            BaseOAuthService baseOAuthService;
            try {
                BaseOAuthService baseOAuthService2 = this;
                baseOAuthService = baseOAuthService2;
                string2 = baseOAuthService2.encrypt(string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return "{}";
            }
            string2 = SP.getBundleData(baseOAuthService.mApplicationContext, "oauth_" + this.id, string2);
            if (string2 != null) break block4;
            return "{}";
        }
        return this.decrypt(string2);
    }

    protected String getToken(String string2) {
        byte[] byArray = NetTool.httpGet(string2);
        Object object = byArray;
        if (byArray != null) {
            return new String((byte[])object);
        }
        return null;
    }

    protected String refreshToken(String string2) {
        byte[] byArray = NetTool.httpGet(string2);
        Object object = byArray;
        if (byArray != null) {
            return new String((byte[])object);
        }
        return null;
    }

    public String encrypt(String string2) throws Exception {
        return Base64.encodeString(string2, true, 5);
    }

    public String decrypt(String string2) throws Exception {
        return Base64.decodeString(string2, true, 5);
    }

    public JSONObject makeResultJson() {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        BaseOAuthService baseOAuthService = object;
        BaseOAuthService baseOAuthService2 = object;
        BaseOAuthService baseOAuthService3 = object;
        jSONObject2();
        Object object = KEY_AUTHRESULT;
        jSONObject2.put((String)object, (Object)baseOAuthService3.authResult);
        object = KEY_USERINFO;
        jSONObject2.put((String)object, (Object)baseOAuthService2.userInfo);
        object = KEY_UNIVERIFYINFO;
        try {
            jSONObject.put((String)object, (Object)baseOAuthService.univerifyInfo);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject2;
    }

    public JSONObject getErrorJsonbject(int n2, String string2) {
        String string3 = DOMException.toJSON(n2, string2);
        try {
            return new JSONObject(string3);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return new JSONObject();
        }
    }

    public JSONObject getErrorJsonbject(String string2, String string3) {
        String string4 = DOMException.toJSON(string2, string3);
        try {
            return new JSONObject(string4);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return new JSONObject();
        }
    }

    public JSONObject getErrorJsonbject(int n2, String string2, int n3) {
        String string3 = DOMException.toJSON(n2, n2 + ":" + string2, n3);
        try {
            return new JSONObject(string3);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return new JSONObject();
        }
    }

    public JSONObject makeResultJSONObject() {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        BaseOAuthService baseOAuthService = object;
        BaseOAuthService baseOAuthService2 = object;
        BaseOAuthService baseOAuthService3 = object;
        jSONObject2();
        Object object = KEY_AUTHRESULT;
        jSONObject2.put((String)object, (Object)baseOAuthService3.authResult);
        object = KEY_USERINFO;
        jSONObject2.put((String)object, (Object)baseOAuthService2.userInfo);
        object = KEY_UNIVERIFYINFO;
        try {
            jSONObject.put((String)object, (Object)baseOAuthService.univerifyInfo);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject2;
    }
}

