/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.nativeObj.richtext.dom;

import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.widget.TextView;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.feature.nativeObj.richtext.IAssets;
import io.dcloud.feature.nativeObj.richtext.dom.DomElement;
import io.dcloud.feature.nativeObj.richtext.span.AHrefSpan;
import io.dcloud.feature.nativeObj.richtext.span.FontSpan;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;

public class TextDomElement
extends DomElement {
    public String text;
    public String color;
    public String href;

    private int getFontWeightInt() {
        return "bold".equalsIgnoreCase(this.getFontWeight()) ? 1 : 0;
    }

    private int getFontStyleInt() {
        return "italic".equalsIgnoreCase(this.getFontStyle()) ? 1 : 0;
    }

    @Override
    public void parseDomElement(XmlPullParser xmlPullParser) {
        XmlPullParser xmlPullParser2 = xmlPullParser;
        XmlPullParser xmlPullParser3 = xmlPullParser;
        super.parseDomElement(xmlPullParser);
        this.color = xmlPullParser3.getAttributeValue(xmlPullParser3.getNamespace(), "color");
        this.href = xmlPullParser2.getAttributeValue(xmlPullParser2.getNamespace(), "href");
    }

    @Override
    public void makeSpan(IAssets object, TextView textView, SpannableStringBuilder spannableStringBuilder) {
        if (!TextUtils.isEmpty((CharSequence)this.text)) {
            TextDomElement textDomElement = this;
            int n2 = "a".equalsIgnoreCase(textDomElement.tagName);
            boolean bl = "p".equalsIgnoreCase(textDomElement.tagName);
            if (bl) {
                spannableStringBuilder.append((CharSequence)"\n");
            }
            TextDomElement textDomElement2 = this;
            spannableStringBuilder.append((CharSequence)this.text);
            float f2 = PdrUtil.parseFloat(this.getFontSize(), 100.0f, FontSpan.DEF_FONT_SIZE, 1.0f);
            int n3 = object.getDefaultColor(n2 != 0);
            int n4 = textDomElement2.getFontWeightInt();
            int n5 = textDomElement2.getFontStyleInt();
            int n6 = textDomElement2.getTextDecorationInt();
            String string2 = textDomElement2.getColor();
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                n3 = object.stringToColor(string2);
            }
            if (n2 != 0) {
                AHrefSpan aHrefSpan;
                SpannableStringBuilder spannableStringBuilder2 = spannableStringBuilder;
                object = aHrefSpan;
                TextDomElement textDomElement3 = this;
                String string3 = textDomElement3.onClickEvent;
                String string4 = textDomElement3.href;
                aHrefSpan = new AHrefSpan(f2, n3, n4, n5, n6, string3, string4);
                int n7 = spannableStringBuilder2.length() - this.text.length();
                int n8 = spannableStringBuilder2.length();
                spannableStringBuilder2.setSpan(object, n7, n8, 17);
            } else {
                FontSpan fontSpan;
                SpannableStringBuilder spannableStringBuilder3 = spannableStringBuilder;
                object = fontSpan;
                fontSpan = new FontSpan(f2, n3, n4, n5, n6);
                int n9 = spannableStringBuilder3.length() - this.text.length();
                n2 = spannableStringBuilder3.length();
                spannableStringBuilder3.setSpan(object, n9, n2, 17);
            }
            if (bl) {
                spannableStringBuilder.append((CharSequence)"\n");
            }
        }
    }

    String getFontSize() {
        HashMap<String, String> hashMap = domElement.style;
        if (hashMap != null && hashMap.containsKey("font-size")) {
            return domElement.style.get("font-size");
        }
        DomElement domElement = domElement.parentDomElement;
        if (domElement != null && domElement instanceof TextDomElement) {
            return ((TextDomElement)domElement).getFontSize();
        }
        return null;
    }

    String getFontWeight() {
        HashMap<String, String> hashMap = domElement.style;
        if (hashMap != null && hashMap.containsKey("font-weight")) {
            return domElement.style.get("font-weight");
        }
        DomElement domElement = domElement.parentDomElement;
        if (domElement != null && domElement instanceof TextDomElement) {
            return ((TextDomElement)domElement).getFontWeight();
        }
        return null;
    }

    String getFontStyle() {
        HashMap<String, String> hashMap = domElement.style;
        if (hashMap != null && hashMap.containsKey("font-style")) {
            return domElement.style.get("font-style");
        }
        DomElement domElement = domElement.parentDomElement;
        if (domElement != null && domElement instanceof TextDomElement) {
            return ((TextDomElement)domElement).getFontStyle();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int getTextDecorationInt() {
        String string2 = this.getTextDecoration();
        if ("underline".equalsIgnoreCase(string2)) {
            return 1;
        }
        if ("line-through".equalsIgnoreCase(string2)) {
            return 2;
        }
        if (!"a".equalsIgnoreCase(this.tagName)) return 0;
        return 1;
    }

    String getTextDecoration() {
        HashMap<String, String> hashMap = domElement.style;
        if (hashMap != null && hashMap.containsKey("text-decoration")) {
            return domElement.style.get("text-decoration");
        }
        DomElement domElement = domElement.parentDomElement;
        if (domElement != null && domElement instanceof TextDomElement) {
            return ((TextDomElement)domElement).getTextDecoration();
        }
        return null;
    }

    String getColor() {
        HashMap<String, String> hashMap = domElement.style;
        if (hashMap != null && hashMap.containsKey("color")) {
            return domElement.style.get("color");
        }
        if (!TextUtils.isEmpty((CharSequence)((TextDomElement)domElement).color) && !"a".equalsIgnoreCase(domElement.tagName)) {
            return ((TextDomElement)domElement).color;
        }
        DomElement domElement = domElement.parentDomElement;
        if (domElement != null && domElement instanceof TextDomElement) {
            return ((TextDomElement)domElement).getColor();
        }
        return null;
    }
}

