/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.nativeObj.photoview.subscaleview.decoder;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Point;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import io.dcloud.feature.nativeObj.photoview.subscaleview.SubsamplingScaleImageView;
import io.dcloud.feature.nativeObj.photoview.subscaleview.decoder.ImageRegionDecoder;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;

public class SkiaPooledImageRegionDecoder
implements ImageRegionDecoder {
    private static final String TAG = "SkiaPooledImageRegionDecoder";
    private static boolean debug = false;
    private static final String FILE_PREFIX = "file://";
    private static final String ASSET_PREFIX = "file:///android_asset/";
    private static final String RESOURCE_PREFIX = "android.resource://";
    private DecoderPool decoderPool;
    private final ReadWriteLock decoderLock;
    private final Bitmap.Config bitmapConfig;
    private Context context;
    private Uri uri;
    private long fileLength;
    private final Point imageDimensions;
    private final AtomicBoolean lazyInited;

    @Keep
    public SkiaPooledImageRegionDecoder() {
        this(null);
    }

    public SkiaPooledImageRegionDecoder(@Nullable Bitmap.Config config) {
        AtomicBoolean atomicBoolean;
        Point point;
        ReentrantReadWriteLock reentrantReadWriteLock;
        DecoderPool decoderPool;
        Object object = decoderPool;
        decoderPool = new DecoderPool();
        this.decoderPool = object;
        object = reentrantReadWriteLock;
        reentrantReadWriteLock = new ReentrantReadWriteLock(true);
        this.decoderLock = object;
        this.fileLength = Long.MAX_VALUE;
        object = point;
        point = new Point(0, 0);
        this.imageDimensions = object;
        object = atomicBoolean;
        atomicBoolean = new AtomicBoolean(false);
        this.lazyInited = object;
        object = SubsamplingScaleImageView.getPreferredBitmapConfig();
        this.bitmapConfig = config != null ? config : (object != null ? object : Bitmap.Config.RGB_565);
    }

    @Keep
    public static void setDebug(boolean bl) {
        debug = bl;
    }

    private void lazyInit() {
        if (this.lazyInited.compareAndSet(false, true) && this.fileLength < Long.MAX_VALUE) {
            this.debug("Starting lazy init of additional decoders");
            new Thread(){

                @Override
                public void run() {
                    while (SkiaPooledImageRegionDecoder.this.decoderPool != null) {
                        SkiaPooledImageRegionDecoder skiaPooledImageRegionDecoder = SkiaPooledImageRegionDecoder.this;
                        if (!skiaPooledImageRegionDecoder.allowAdditionalDecoder(skiaPooledImageRegionDecoder.decoderPool.size(), SkiaPooledImageRegionDecoder.this.fileLength)) break;
                        if (SkiaPooledImageRegionDecoder.this.decoderPool == null) continue;
                        1 v1 = this;
                        1 v2 = v1;
                        1 v3 = v1;
                        1 v4 = v1;
                        long l2 = System.currentTimeMillis();
                        v3.SkiaPooledImageRegionDecoder.this.debug("Starting decoder");
                        v4.SkiaPooledImageRegionDecoder.this.initialiseDecoder();
                        long l3 = System.currentTimeMillis();
                        SkiaPooledImageRegionDecoder skiaPooledImageRegionDecoder2 = v2.SkiaPooledImageRegionDecoder.this;
                        StringBuilder stringBuilder = new StringBuilder().append("Started decoder, took ");
                        try {
                            skiaPooledImageRegionDecoder2.debug(stringBuilder.append(l3 - l2).append("ms").toString());
                        }
                        catch (Exception exception) {
                            SkiaPooledImageRegionDecoder.this.debug("Failed to start decoder: " + exception.getMessage());
                        }
                    }
                }
            }.start();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initialiseDecoder() throws Exception {
        Object object;
        long l2;
        Object object2;
        block32: {
            object2 = this.uri.toString();
            l2 = Long.MAX_VALUE;
            if (((String)object2).startsWith(RESOURCE_PREFIX)) {
                SkiaPooledImageRegionDecoder skiaPooledImageRegionDecoder = this;
                object2 = skiaPooledImageRegionDecoder.uri.getAuthority();
                object = skiaPooledImageRegionDecoder.context.getPackageName().equals(object2) ? this.context.getResources() : this.context.getPackageManager().getResourcesForApplication((String)object2);
                int n2 = 0;
                List list = this.uri.getPathSegments();
                int n3 = list.size();
                if (n3 == 2 && ((String)list.get(0)).equals("drawable")) {
                    n2 = object.getIdentifier((String)list.get(1), "drawable", (String)object2);
                } else if (n3 == 1 && TextUtils.isDigitsOnly((CharSequence)((CharSequence)list.get(0)))) {
                    try {
                        n2 = Integer.parseInt((String)list.get(0));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                try {
                    l2 = this.context.getResources().openRawResourceFd(n2).getLength();
                }
                catch (Exception exception) {}
                object2 = BitmapRegionDecoder.newInstance((InputStream)this.context.getResources().openRawResource(n2), (boolean)false);
                object = object2;
            } else if (((String)object2).startsWith(ASSET_PREFIX)) {
                object2 = ((String)object2).substring(22);
                try {
                    l2 = this.context.getAssets().openFd((String)object2).getLength();
                }
                catch (Exception exception) {}
                object2 = BitmapRegionDecoder.newInstance((InputStream)this.context.getAssets().open((String)object2, 1), (boolean)false);
                object = object2;
            } else {
                block33: {
                    AssetFileDescriptor assetFileDescriptor;
                    if (((String)object2).startsWith(FILE_PREFIX)) {
                        File file;
                        object = BitmapRegionDecoder.newInstance((String)((String)object2).substring(7), (boolean)false);
                        File file2 = file;
                        if (new File((String)object2).exists()) {
                            l2 = file2.length();
                        }
                        break block32;
                    }
                    object2 = null;
                    ContentResolver contentResolver = this.context.getContentResolver();
                    object2 = contentResolver.openInputStream(this.uri);
                    object = BitmapRegionDecoder.newInstance((InputStream)object2, (boolean)false);
                    try {
                        assetFileDescriptor = contentResolver.openAssetFileDescriptor(this.uri, "r");
                        if (assetFileDescriptor == null) break block33;
                    }
                    catch (Exception exception) {}
                    l2 = assetFileDescriptor.getLength();
                }
                if (object2 == null) break block32;
                try {
                    ((InputStream)object2).close();
                }
                catch (Exception exception) {}
            }
        }
        SkiaPooledImageRegionDecoder skiaPooledImageRegionDecoder = this;
        skiaPooledImageRegionDecoder.fileLength = l2;
        Object object3 = object;
        int n4 = object3.getWidth();
        skiaPooledImageRegionDecoder.imageDimensions.set(n4, object3.getHeight());
        skiaPooledImageRegionDecoder.decoderLock.writeLock().lock();
        try {
            DecoderPool decoderPool = skiaPooledImageRegionDecoder.decoderPool;
            if (decoderPool != null) {
                decoderPool.add((BitmapRegionDecoder)object);
            }
            this.decoderLock.writeLock().unlock();
            return;
        }
        catch (Throwable throwable) {
            this.decoderLock.writeLock().unlock();
            throw throwable;
        }
        catch (Throwable throwable) {
            if (object2 == null) throw throwable;
            try {
                ((InputStream)object2).close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
    }

    private int getNumberOfCores() {
        if (Build.VERSION.SDK_INT >= 17) {
            return Runtime.getRuntime().availableProcessors();
        }
        return this.getNumCoresOldPhones();
    }

    private int getNumCoresOldPhones() {
        try {
            class CpuFilter
            implements FileFilter {
                CpuFilter() {
                }

                @Override
                public boolean accept(File file) {
                    return Pattern.matches("cpu[0-9]+", file.getName());
                }
            }
            return new File("/sys/devices/system/cpu/").listFiles(new CpuFilter()).length;
        }
        catch (Exception exception) {
            return 1;
        }
    }

    private boolean isLowMemory() {
        SkiaPooledImageRegionDecoder skiaPooledImageRegionDecoder = (ActivityManager)skiaPooledImageRegionDecoder.context.getSystemService("activity");
        if (skiaPooledImageRegionDecoder != null) {
            ActivityManager.MemoryInfo memoryInfo;
            SkiaPooledImageRegionDecoder skiaPooledImageRegionDecoder2 = skiaPooledImageRegionDecoder;
            skiaPooledImageRegionDecoder = memoryInfo;
            skiaPooledImageRegionDecoder2.getMemoryInfo(new ActivityManager.MemoryInfo());
            return ((ActivityManager.MemoryInfo)skiaPooledImageRegionDecoder).lowMemory;
        }
        return true;
    }

    private void debug(String string2) {
        if (debug) {
            Log.d((String)TAG, (String)string2);
        }
    }

    @Override
    @NonNull
    public Point init(Context context, @NonNull Uri uri) throws Exception {
        SkiaPooledImageRegionDecoder skiaPooledImageRegionDecoder = this;
        this.context = context;
        skiaPooledImageRegionDecoder.uri = uri;
        skiaPooledImageRegionDecoder.initialiseDecoder();
        return skiaPooledImageRegionDecoder.imageDimensions;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NonNull
    public Bitmap decodeRegion(@NonNull Rect rect, int n2) {
        DecoderPool decoderPool;
        block12: {
            block13: {
                block14: {
                    BitmapFactory.Options options;
                    this.debug("Decode region " + rect + " on thread " + Thread.currentThread().getName());
                    if (rect.width() < this.imageDimensions.x || rect.height() < this.imageDimensions.y) {
                        this.lazyInit();
                    }
                    SkiaPooledImageRegionDecoder skiaPooledImageRegionDecoder = this;
                    skiaPooledImageRegionDecoder.decoderLock.readLock().lock();
                    decoderPool = skiaPooledImageRegionDecoder.decoderPool;
                    if (decoderPool == null) throw new IllegalStateException("Cannot decode region after decoder has been recycled");
                    {
                        catch (Throwable throwable) {
                            this.decoderLock.readLock().unlock();
                            throw throwable;
                        }
                    }
                    decoderPool = decoderPool.acquire();
                    if (decoderPool == null) break block12;
                    if (decoderPool.isRecycled()) break block12;
                    DecoderPool decoderPool2 = decoderPool;
                    Rect rect2 = rect;
                    rect = options;
                    rect();
                    rect.inSampleSize = n2;
                    options.inPreferredConfig = this.bitmapConfig;
                    rect = decoderPool2.decodeRegion(rect2, options);
                    if (rect == null) break block13;
                    if (decoderPool == null) break block14;
                    this.decoderPool.release((BitmapRegionDecoder)decoderPool);
                }
                this.decoderLock.readLock().unlock();
                return rect;
            }
            try {
                throw new RuntimeException("Skia image decoder returned null bitmap - image format may not be supported");
            }
            catch (Throwable throwable) {
                if (decoderPool == null) throw throwable;
                this.decoderPool.release((BitmapRegionDecoder)decoderPool);
                throw throwable;
            }
        }
        if (decoderPool == null) throw new IllegalStateException("Cannot decode region after decoder has been recycled");
        this.decoderPool.release((BitmapRegionDecoder)decoderPool);
        throw new IllegalStateException("Cannot decode region after decoder has been recycled");
    }

    @Override
    public synchronized boolean isReady() {
        DecoderPool decoderPool = ((SkiaPooledImageRegionDecoder)((Object)decoderPool)).decoderPool;
        return decoderPool != null && !decoderPool.isEmpty();
    }

    @Override
    public synchronized void recycle() {
        block3: {
            DecoderPool decoderPool;
            SkiaPooledImageRegionDecoder skiaPooledImageRegionDecoder = this;
            skiaPooledImageRegionDecoder.decoderLock.writeLock().lock();
            try {
                decoderPool = skiaPooledImageRegionDecoder.decoderPool;
                if (decoderPool == null) break block3;
            }
            catch (Throwable throwable) {
                this.decoderLock.writeLock().unlock();
                throw throwable;
            }
            SkiaPooledImageRegionDecoder skiaPooledImageRegionDecoder2 = this;
            decoderPool.recycle();
            skiaPooledImageRegionDecoder2.decoderPool = null;
            skiaPooledImageRegionDecoder2.context = null;
            skiaPooledImageRegionDecoder2.uri = null;
        }
        this.decoderLock.writeLock().unlock();
    }

    protected boolean allowAdditionalDecoder(int n2, long l2) {
        if (n2 >= 4) {
            this.debug("No additional decoders allowed, reached hard limit (4)");
            return false;
        }
        if ((l2 = (long)n2 * l2) > 0x1400000L) {
            this.debug("No additional encoders allowed, reached hard memory limit (20Mb)");
            return false;
        }
        if (n2 >= this.getNumberOfCores()) {
            this.debug("No additional encoders allowed, limited by CPU cores (" + this.getNumberOfCores() + ")");
            return false;
        }
        if (this.isLowMemory()) {
            this.debug("No additional encoders allowed, memory is low");
            return false;
        }
        this.debug("Additional decoder allowed, current count is " + n2 + ", estimated native memory " + l2 / 0x100000L + "Mb");
        return true;
    }

    private static class DecoderPool {
        private final Semaphore available;
        private final Map<BitmapRegionDecoder, Boolean> decoders;

        private DecoderPool() {
            ConcurrentHashMap concurrentHashMap;
            Semaphore semaphore;
            Object object = semaphore;
            semaphore = new Semaphore(0, true);
            v1.available = object;
            object = concurrentHashMap;
            concurrentHashMap = new ConcurrentHashMap();
            v1.decoders = object;
        }

        private synchronized boolean isEmpty() {
            return this.decoders.isEmpty();
        }

        private synchronized int size() {
            return this.decoders.size();
        }

        private BitmapRegionDecoder acquire() {
            DecoderPool decoderPool = this;
            decoderPool.available.acquireUninterruptibly();
            return decoderPool.getNextAvailable();
        }

        private void release(BitmapRegionDecoder bitmapRegionDecoder) {
            if (this.markAsUnused(bitmapRegionDecoder)) {
                this.available.release();
            }
        }

        private synchronized void add(BitmapRegionDecoder bitmapRegionDecoder) {
            DecoderPool decoderPool = this;
            decoderPool.decoders.put(bitmapRegionDecoder, Boolean.FALSE);
            decoderPool.available.release();
        }

        private synchronized void recycle() {
            while (!this.decoders.isEmpty()) {
                DecoderPool decoderPool = this;
                BitmapRegionDecoder bitmapRegionDecoder = decoderPool.acquire();
                bitmapRegionDecoder.recycle();
                decoderPool.decoders.remove(bitmapRegionDecoder);
            }
        }

        private synchronized BitmapRegionDecoder getNextAvailable() {
            for (Map.Entry entry : ((DecoderPool)this).decoders.entrySet()) {
                if (((Boolean)entry.getValue()).booleanValue()) continue;
                Map.Entry entry2 = entry;
                entry2.setValue(Boolean.TRUE);
                return (BitmapRegionDecoder)entry2.getKey();
            }
            return null;
        }

        private synchronized boolean markAsUnused(BitmapRegionDecoder bitmapRegionDecoder) {
            for (Map.Entry entry : ((DecoderPool)this).decoders.entrySet()) {
                if (bitmapRegionDecoder != entry.getKey()) continue;
                if (((Boolean)entry.getValue()).booleanValue()) {
                    entry.setValue(Boolean.FALSE);
                    return true;
                }
                return false;
            }
            return false;
        }
    }
}

