/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.barcode2.camera;

import android.graphics.Point;
import android.hardware.Camera;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import io.dcloud.feature.barcode2.camera.CameraConfigurationManager;
import io.dcloud.feature.barcode2.decoding.IBarHandler;

final class PreviewCallback
implements Camera.PreviewCallback {
    private static final String TAG = PreviewCallback.class.getSimpleName();
    private static boolean mIsVerticalScreen = true;
    private final CameraConfigurationManager configManager;
    private final boolean useOneShotPreviewCallback;
    private Handler previewHandler;
    private IBarHandler mBarHandler;
    private int previewMessage;
    private byte[] lastBitmapData = null;

    PreviewCallback(CameraConfigurationManager cameraConfigurationManager, boolean bl) {
        this.configManager = cameraConfigurationManager;
        this.useOneShotPreviewCallback = bl;
    }

    void setHandler(IBarHandler iBarHandler, Handler handler, int n2, boolean bl) {
        PreviewCallback previewCallback = this;
        previewCallback.mBarHandler = iBarHandler;
        previewCallback.previewHandler = handler;
        previewCallback.previewMessage = n2;
        mIsVerticalScreen = bl;
    }

    public void onPreviewFrame(byte[] byArray, Camera camera) {
        IBarHandler iBarHandler = this.mBarHandler;
        if (iBarHandler != null && iBarHandler.isRunning()) {
            PreviewCallback previewCallback = this;
            iBarHandler = previewCallback.configManager.getCameraResolution();
            if (!previewCallback.useOneShotPreviewCallback) {
                camera.setPreviewCallback(null);
            }
            if ((camera = this.previewHandler) != null) {
                Message message;
                int n2 = this.previewMessage;
                if (n2 == 1004) {
                    if (mIsVerticalScreen) {
                        IBarHandler iBarHandler2 = iBarHandler;
                        int n3 = ((Point)iBarHandler2).x;
                        int n4 = ((Point)iBarHandler2).y;
                        message = camera.obtainMessage(1005, n3, n4, (Object)byArray);
                    } else {
                        IBarHandler iBarHandler3 = iBarHandler;
                        int n5 = ((Point)iBarHandler3).x;
                        int n6 = ((Point)iBarHandler3).y;
                        message = camera.obtainMessage(1006, n5, n6, (Object)byArray);
                    }
                } else {
                    IBarHandler iBarHandler4 = iBarHandler;
                    int n7 = ((Point)iBarHandler4).x;
                    int n8 = ((Point)iBarHandler4).y;
                    message = camera.obtainMessage(n2, n7, n8, (Object)byArray);
                }
                message.sendToTarget();
                this.previewHandler = null;
            } else {
                Log.d((String)TAG, (String)"Got preview callback, but no handler for it");
            }
            this.lastBitmapData = byArray;
        }
    }

    public byte[] getLastBitmapData() {
        return this.lastBitmapData;
    }

    public void setLastBitmapData(byte[] byArray) {
        this.lastBitmapData = byArray;
    }
}

