/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.barcode2.camera;

import android.graphics.Bitmap;
import com.dcloud.zxing2.LuminanceSource;

public final class PlanarYUVLuminanceSource
extends LuminanceSource {
    private final byte[] yuvData;
    private final int dataWidth;
    private final int dataHeight;
    private final int left;
    private final int top;
    private LuminanceSource rotateLuminanceSource = null;

    public PlanarYUVLuminanceSource(byte[] byArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n6, n7);
        if (n6 <= n2 && n7 <= n3) {
            PlanarYUVLuminanceSource planarYUVLuminanceSource = this;
            planarYUVLuminanceSource.yuvData = byArray;
            planarYUVLuminanceSource.dataWidth = n2;
            planarYUVLuminanceSource.dataHeight = n3;
            planarYUVLuminanceSource.left = n4;
            planarYUVLuminanceSource.top = n5;
            return;
        }
        throw new IllegalArgumentException("Crop rectangle does not fit within image data.width=" + n6 + ";dataWidth=" + n2 + ";height=" + n7 + ";dataHeight=" + n3);
    }

    @Override
    public byte[] getRow(int n2, byte[] byArray) {
        if (n2 >= 0 && n2 < this.getHeight()) {
            int n3 = this.getWidth();
            if (byArray == null || byArray.length < n3) {
                byArray = new byte[n3];
            }
            int n4 = (n2 + this.top) * this.dataWidth + this.left;
            System.arraycopy(this.yuvData, n4, byArray, 0, n3);
            return byArray;
        }
        throw new IllegalArgumentException("Requested row is outside the image: " + n2);
    }

    @Override
    public byte[] getMatrix() {
        int n2 = this.getWidth();
        PlanarYUVLuminanceSource planarYUVLuminanceSource = this;
        int n3 = planarYUVLuminanceSource.getHeight();
        int n4 = planarYUVLuminanceSource.dataWidth;
        if (n2 == n4 && n3 == this.dataHeight) {
            return this.yuvData;
        }
        int n5 = n4;
        int n6 = n2 * n3;
        byte[] byArray = new byte[n6];
        n4 = this.top * n4 + this.left;
        if (n2 == n5) {
            System.arraycopy(this.yuvData, n4, byArray, 0, n6);
            return byArray;
        }
        byte[] byArray2 = this.yuvData;
        for (int i2 = 0; i2 < n3; ++i2) {
            System.arraycopy(byArray2, n4, byArray, i2 * n2, n2);
            n4 += this.dataWidth;
        }
        return byArray;
    }

    @Override
    public boolean isCropSupported() {
        return true;
    }

    @Override
    public boolean isRotateSupported() {
        return true;
    }

    @Override
    public LuminanceSource rotateCounterClockwise() {
        if (this.rotateLuminanceSource == null) {
            PlanarYUVLuminanceSource planarYUVLuminanceSource;
            PlanarYUVLuminanceSource planarYUVLuminanceSource2 = this;
            Object object = planarYUVLuminanceSource2.getMatrix();
            int n2 = planarYUVLuminanceSource2.getHeight();
            int n3 = this.getWidth();
            byte[] byArray = new byte[((byte[])object).length];
            int n4 = (n2 - 1) * n3;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n5 = i2 * n3;
                for (int i3 = 0; i3 < n3; ++i3) {
                    int n6 = n5 + i3;
                    byArray[n6] = object[n4 - i3 * n3];
                }
                ++n4;
            }
            object = planarYUVLuminanceSource;
            planarYUVLuminanceSource = new PlanarYUVLuminanceSource(byArray, n3, n2, 0, 0, n3, n2);
            this.rotateLuminanceSource = object;
        }
        return this.rotateLuminanceSource;
    }

    public int getDataWidth() {
        return this.dataWidth;
    }

    public int getDataHeight() {
        return this.dataHeight;
    }

    public Bitmap renderCroppedGreyscaleBitmap() {
        return this.renderCroppedGreyscaleBitmap(false);
    }

    public Bitmap renderCroppedGreyscaleBitmap(boolean n2) {
        int n3 = n2;
        PlanarYUVLuminanceSource planarYUVLuminanceSource = this;
        n2 = planarYUVLuminanceSource.getWidth();
        int n4 = this.getHeight();
        int[] nArray = new int[n2 * n4];
        byte[] byArray = planarYUVLuminanceSource.yuvData;
        if (n3) {
            int n5 = (this.top + n4) * this.dataWidth + this.left;
            for (int i2 = 0; i2 < n4; ++i2) {
                int n6 = i2 * n2;
                for (int i3 = 0; i3 < n2; ++i3) {
                    int n7 = n6 + i3;
                    nArray[n7] = (byArray[n5 - i3 * this.dataWidth] & 0xFF) * 65793 | 0xFF000000;
                }
                ++n5;
            }
        } else {
            int n8 = this.top * this.dataWidth + this.left;
            for (int i4 = 0; i4 < n4; ++i4) {
                int n9 = i4 * n2;
                for (int i5 = 0; i5 < n2; ++i5) {
                    int n10 = n9 + i5;
                    nArray[n10] = (byArray[n8 + i5] & 0xFF) * 65793 | 0xFF000000;
                }
                n8 += this.dataWidth;
            }
        }
        Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n4, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setPixels(nArray, 0, n2, 0, 0, n2, n4);
        return bitmap;
    }
}

