/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.barcode2;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.graphics.YuvImage;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.hardware.Camera;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Handler;
import android.os.Vibrator;
import android.text.TextUtils;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsoluteLayout;
import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.Result;
import io.dcloud.application.DCLoudApplicationImpl;
import io.dcloud.base.R;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.IEventCallback;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.ui.AdaFrameItem;
import io.dcloud.common.adapter.ui.AdaFrameView;
import io.dcloud.common.adapter.util.CanvasHelper;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.MessageHandler;
import io.dcloud.common.adapter.util.PermissionUtil;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.JSUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.StringUtil;
import io.dcloud.feature.barcode2.BarcodeProxy;
import io.dcloud.feature.barcode2.BarcodeProxyMgr;
import io.dcloud.feature.barcode2.camera.CameraManager;
import io.dcloud.feature.barcode2.decoding.CaptureActivityHandler;
import io.dcloud.feature.barcode2.decoding.IBarHandler;
import io.dcloud.feature.barcode2.decoding.InactivityTimer;
import io.dcloud.feature.barcode2.view.DetectorViewConfig;
import io.dcloud.feature.barcode2.view.ViewfinderView;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class BarcodeFrameItem
extends AdaFrameItem
implements TextureView.SurfaceTextureListener,
IBarHandler {
    public static final String TAG = BarcodeFrameItem.class.getSimpleName();
    private static final float BEEP_VOLUME = 0.8f;
    static BarcodeFrameItem sBarcodeFrameItem = null;
    private static final long VIBRATE_DURATION = 200L;
    static final int UNKOWN = -1000;
    static final int QR = 0;
    static final int EAN13 = 1;
    static final int EAN8 = 2;
    static final int AZTEC = 3;
    static final int DATAMATRIX = 4;
    static final int UPCA = 5;
    static final int UPCE = 6;
    static final int CODABAR = 7;
    static final int CODE39 = 8;
    static final int CODE93 = 9;
    static final int CODE128 = 10;
    static final int ITF = 11;
    static final int MAXICODE = 12;
    static final int PDF417 = 13;
    static final int RSS14 = 14;
    static final int RSSEXPANDED = 15;
    private CaptureActivityHandler handler;
    private ViewfinderView viewfinderView;
    private boolean hasSurface;
    private Vector<BarcodeFormat> decodeFormats;
    private String characterSet;
    private InactivityTimer inactivityTimer;
    private MediaPlayer mediaPlayer;
    boolean playBeep;
    boolean vibrate;
    TextureView surfaceView;
    Map<String, String> mCallbackIds;
    private Context mAct;
    private IWebview mWebViewImpl;
    private IWebview mContainerWebview;
    private IApp mAppHandler;
    private boolean mRunning;
    public String errorMsg;
    boolean mConserve;
    String mFilename;
    BarcodeProxy mProxy;
    boolean noPermission;
    JSONArray mDivRectJson;
    JSONObject mStyles;
    JSONArray mFilters;
    private String mPosition;
    public String mUuid;
    public boolean autoDecodeCharset;
    boolean isVerticalScreen;
    int mOrientationState;
    private boolean isCancelScan;
    private Bitmap lastBitmap;
    private final MediaPlayer.OnCompletionListener beepListener;

    protected BarcodeFrameItem(BarcodeProxy barcodeProxy, IWebview iWebview, String string2, JSONArray jSONArray, JSONArray jSONArray2, JSONObject jSONObject) {
        AbsoluteLayout absoluteLayout;
        BarcodeFrameItem barcodeFrameItem = this;
        BarcodeFrameItem barcodeFrameItem2 = this;
        BarcodeFrameItem barcodeFrameItem3 = this;
        super(iWebview.getContext());
        barcodeFrameItem3.playBeep = true;
        barcodeFrameItem3.vibrate = true;
        barcodeFrameItem3.mCallbackIds = null;
        barcodeFrameItem3.mRunning = false;
        barcodeFrameItem3.errorMsg = null;
        barcodeFrameItem3.mConserve = false;
        barcodeFrameItem3.mFilename = null;
        barcodeFrameItem3.noPermission = false;
        barcodeFrameItem3.mPosition = "static";
        barcodeFrameItem3.autoDecodeCharset = false;
        barcodeFrameItem3.isVerticalScreen = true;
        barcodeFrameItem3.isCancelScan = false;
        barcodeFrameItem3.lastBitmap = null;
        barcodeFrameItem3.beepListener = new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mediaPlayer) {
                mediaPlayer.seekTo(0);
            }
        };
        sBarcodeFrameItem = barcodeFrameItem3;
        this.mProxy = barcodeProxy;
        barcodeFrameItem2.mUuid = string2;
        barcodeFrameItem2.mCallbackIds = new HashMap<String, String>();
        this.mAct = iWebview.getContext();
        this.mWebViewImpl = iWebview;
        this.mContainerWebview = iWebview;
        this.mAppHandler = iWebview.obtainApp();
        this.mDivRectJson = jSONArray;
        this.mStyles = jSONObject;
        this.mFilters = jSONArray2;
        barcodeProxy = barcodeFrameItem.getFrameLayoutParam(jSONArray, jSONObject);
        iWebview = absoluteLayout;
        BarcodeFrameItem barcodeFrameItem4 = this;
        barcodeFrameItem.setMainView((View)new AbsoluteLayout(barcodeFrameItem4.mAct, (AbsoluteLayout.LayoutParams)barcodeProxy){
            Paint paint;
            final /* synthetic */ AbsoluteLayout.LayoutParams val$lp;
            {
                Paint paint;
                this_.val$lp = layoutParams;
                super(context);
                1 this_ = paint;
                paint = new Paint();
                v1.paint = this_;
            }

            protected void onDraw(Canvas canvas) {
                1 v0 = this;
                super.onDraw(canvas);
                if (v0.BarcodeFrameItem.this.noPermission) {
                    1 v1 = this;
                    v1.paint.setColor(-1);
                    v1.paint.setTextSize((float)CanvasHelper.dip2px(BarcodeFrameItem.this.mAct, 18.0f));
                    v1.paint.setTextAlign(Paint.Align.CENTER);
                    Paint.FontMetrics fontMetrics = v1.paint.getFontMetrics();
                    float f2 = fontMetrics.top;
                    float f3 = fontMetrics.bottom;
                    AbsoluteLayout.LayoutParams layoutParams = v1.val$lp;
                    int n2 = (int)((float)(layoutParams.height / 2) - f2 / 2.0f - f3 / 2.0f);
                    String string2 = DCLoudApplicationImpl.self().getContext().getString(R.string.dcloud_feature_barcode2_no_camera_permission);
                    f3 = layoutParams.width / 2;
                    float f4 = n2;
                    Paint paint = v1.paint;
                    canvas.drawText(string2, f3, f4, paint);
                }
            }
        });
        if (jSONObject != null) {
            this.initStyles(jSONObject, (View)iWebview);
        }
        this.initDecodeFormats(jSONArray2);
    }

    private AbsoluteLayout.LayoutParams getFrameLayoutParam(JSONArray object, JSONObject jSONObject) {
        AdaFrameItem adaFrameItem;
        float f2 = ((BarcodeFrameItem)adaFrameItem).mContainerWebview.getScale();
        AbsoluteLayout.LayoutParams layoutParams = null;
        if (object.length() > 3) {
            int n2;
            adaFrameItem = DetectorViewConfig.getInstance().gatherRect;
            ((Rect)adaFrameItem).left = PdrUtil.parseInt(JSONUtil.getString(object, 0), 0);
            ((Rect)adaFrameItem).top = PdrUtil.parseInt(JSONUtil.getString(object, 1), 0);
            ((Rect)adaFrameItem).right = ((Rect)adaFrameItem).left + PdrUtil.parseInt(JSONUtil.getString(object, 2), 0);
            ((Rect)adaFrameItem).bottom = n2 = ((Rect)adaFrameItem).top + PdrUtil.parseInt(JSONUtil.getString(object, 3), 0);
            ((Rect)adaFrameItem).left = (int)((float)((Rect)adaFrameItem).left * f2);
            ((Rect)adaFrameItem).top = (int)((float)((Rect)adaFrameItem).top * f2);
            ((Rect)adaFrameItem).right = (int)((float)((Rect)adaFrameItem).right * f2);
            ((Rect)adaFrameItem).bottom = (int)((float)n2 * f2);
            if (adaFrameItem.width() != 0 && adaFrameItem.height() != 0) {
                AdaFrameItem adaFrameItem2 = adaFrameItem;
                int n3 = ((Rect)adaFrameItem2).top;
                n2 = adaFrameItem2.width();
                int n4 = adaFrameItem2.height();
                layoutParams = (AbsoluteLayout.LayoutParams)AdaFrameItem.LayoutParamsUtil.createLayoutParams(((Rect)adaFrameItem).left, n3, n2, n4);
            }
        } else {
            int n5;
            if (jSONObject == null) {
                return layoutParams;
            }
            BarcodeFrameItem barcodeFrameItem = adaFrameItem;
            adaFrameItem = (AdaFrameView)barcodeFrameItem.mContainerWebview.obtainFrameView();
            object = adaFrameItem.obtainFrameOptions();
            if (barcodeFrameItem.mPosition.equals("absolute")) {
                n5 = object.height;
            } else {
                n5 = ((ViewGroup)adaFrameItem.obtainWebviewParent().obtainMainView()).getHeight();
                if (n5 == 0) {
                    n5 = object.height;
                }
            }
            JSONObject jSONObject2 = jSONObject;
            int n6 = PdrUtil.convertToScreenInt(JSONUtil.getString(jSONObject2, "left"), object.width, 0, f2);
            int n7 = PdrUtil.convertToScreenInt(JSONUtil.getString(jSONObject2, "top"), n5, 0, f2);
            int n8 = object.width;
            int n9 = PdrUtil.convertToScreenInt(JSONUtil.getString(jSONObject2, "width"), n8, n8, f2);
            int n10 = n5;
            n5 = PdrUtil.convertToScreenInt(JSONUtil.getString(jSONObject2, "height"), n10, n10, f2);
            Rect rect = DetectorViewConfig.getInstance().gatherRect;
            rect.left = n6;
            rect.top = n7;
            rect.right = n6 + n9;
            rect.bottom = n7 + n5;
            if (rect.width() != 0 && rect.height() != 0) {
                Rect rect2 = rect;
                n5 = rect2.top;
                n9 = rect2.width();
                n6 = rect2.height();
                layoutParams = (AbsoluteLayout.LayoutParams)AdaFrameItem.LayoutParamsUtil.createLayoutParams(rect.left, n5, n9, n6);
            }
        }
        return layoutParams;
    }

    private void initCameraView(AbsoluteLayout.LayoutParams layoutParams, AbsoluteLayout absoluteLayout) {
        BarcodeFrameItem barcodeFrameItem = this;
        CameraManager.init((Context)barcodeFrameItem.getActivity().getApplication(), this.mAppHandler.isVerticalScreen());
        CameraManager.sScreenWidth = barcodeFrameItem.mAppHandler.getInt(0);
        CameraManager.sScreenAllHeight = barcodeFrameItem.mAppHandler.getInt(2);
        if (barcodeFrameItem.getActivity().getResources().getConfiguration().orientation == 1) {
            this.initPortraitCameraView(layoutParams, absoluteLayout);
        } else {
            this.initLandScapeCameraView(layoutParams, absoluteLayout);
        }
    }

    private void initPortraitCameraView(AbsoluteLayout.LayoutParams layoutParams, final AbsoluteLayout absoluteLayout) {
        Rect rect = DetectorViewConfig.getInstance().gatherRect;
        if ((rect = CameraManager.getCR(rect.height(), rect.width())) == null) {
            this.noPermission = true;
            MessageHandler.sendMessage(new MessageHandler.IMessages(){

                @Override
                public void execute(Object object) {
                    3 v0 = this;
                    v0.absoluteLayout.setBackgroundColor(-16777216);
                    v0.absoluteLayout.invalidate();
                }
            }, null);
            return;
        }
        int n2 = layoutParams.width;
        int n3 = rect.x;
        int n4 = rect.y;
        int n5 = 0;
        int n6 = 0;
        int n7 = layoutParams.height;
        if (n2 * n3 / n4 < n7) {
            int n8 = n2;
            n2 = n7 * n4 / n3;
            DetectorViewConfig.detectorRectOffestLeft = n5 = (n8 - n2) / 2;
            DetectorViewConfig.detectorRectOffestTop = 0;
        } else {
            int n9 = n7;
            n7 = n2 * n3 / n4;
            DetectorViewConfig.detectorRectOffestTop = n6 = (n9 - n7) / 2;
            DetectorViewConfig.detectorRectOffestLeft = 0;
        }
        BarcodeFrameItem barcodeFrameItem = this;
        barcodeFrameItem.surfaceView.setClickable(false);
        absoluteLayout.addView((View)barcodeFrameItem.surfaceView, (ViewGroup.LayoutParams)new AbsoluteLayout.LayoutParams(n2, n7, n5, n6));
        DetectorViewConfig.getInstance().initSurfaceViewRect(n5, n6, n2, n7);
        absoluteLayout.addView((View)this.viewfinderView);
    }

    private void initLandScapeCameraView(AbsoluteLayout.LayoutParams layoutParams, final AbsoluteLayout absoluteLayout) {
        Rect rect = DetectorViewConfig.getInstance().gatherRect;
        if ((rect = CameraManager.getCR(rect.width(), rect.height())) == null) {
            this.noPermission = true;
            MessageHandler.sendMessage(new MessageHandler.IMessages(){

                @Override
                public void execute(Object object) {
                    4 v0 = this;
                    v0.absoluteLayout.setBackgroundColor(-16777216);
                    v0.absoluteLayout.invalidate();
                }
            }, null);
            return;
        }
        int n2 = layoutParams.height;
        int n3 = rect.x;
        int n4 = rect.y;
        int n5 = 0;
        int n6 = 0;
        int n7 = layoutParams.width;
        if (n2 * n3 / n4 < n7) {
            int n8 = n2;
            n2 = n7 * n4 / n3;
            DetectorViewConfig.detectorRectOffestTop = n6 = (n8 - n2) / 2;
            DetectorViewConfig.detectorRectOffestLeft = 0;
        } else {
            int n9 = n7;
            n7 = n2 * n3 / n4;
            DetectorViewConfig.detectorRectOffestLeft = n5 = (n9 - n7) / 2;
            DetectorViewConfig.detectorRectOffestTop = 0;
        }
        BarcodeFrameItem barcodeFrameItem = this;
        barcodeFrameItem.surfaceView.setClickable(false);
        absoluteLayout.addView((View)barcodeFrameItem.surfaceView, (ViewGroup.LayoutParams)new AbsoluteLayout.LayoutParams(n7, n2, n5, n6));
        DetectorViewConfig.getInstance().initSurfaceViewRect(n5, n6, n7, n2);
        absoluteLayout.addView((View)this.viewfinderView);
    }

    private void initStyles(JSONObject jSONObject, View view) {
        this.mStyles = jSONObject;
        DetectorViewConfig.laserColor = -65536;
        DetectorViewConfig.cornerColor = -65536;
        if (jSONObject.has("position")) {
            this.mPosition = jSONObject.optString("position");
        }
        if (!TextUtils.isEmpty((CharSequence)jSONObject.optString("scanbarColor"))) {
            int n2 = PdrUtil.stringToColor(jSONObject.optString("scanbarColor"));
            if (n2 == -1) {
                n2 = DetectorViewConfig.laserColor;
            }
            DetectorViewConfig.laserColor = n2;
        }
        if (!TextUtils.isEmpty((CharSequence)jSONObject.optString("frameColor"))) {
            int n3 = PdrUtil.stringToColor(jSONObject.optString("frameColor"));
            if (n3 == -1) {
                n3 = DetectorViewConfig.laserColor;
            }
            DetectorViewConfig.cornerColor = n3;
        }
        if (!TextUtils.isEmpty((CharSequence)jSONObject.optString("background"))) {
            int n4 = PdrUtil.stringToColor(jSONObject.optString("background"));
            if (n4 == -1) {
                n4 = DetectorViewConfig.laserColor;
            }
            view.setBackgroundColor(n4);
        }
    }

    private void listenHideAndShow(IWebview iWebview) {
        iWebview.obtainFrameView().addFrameViewListener(new IEventCallback(){

            @Override
            public Object onCallBack(String string2, Object object) {
                if (!PdrUtil.isEquals(string2, "hide") && !PdrUtil.isEquals(string2, "window_close")) {
                    if (PdrUtil.isEquals(string2, "show_animation_end")) {
                        BarcodeFrameItem.this.onResume(true);
                    }
                } else {
                    BarcodeFrameItem.this.onPause();
                }
                return null;
            }
        });
    }

    private void saveOrientationState() {
        this.mOrientationState = this.mAppHandler.getRequestedOrientation();
    }

    private void resumeOrientationState() {
        this.mAppHandler.setRequestedOrientation(this.mOrientationState);
    }

    private void initCamera(SurfaceTexture object) {
        block5: {
            block4: {
                CaptureActivityHandler captureActivityHandler;
                BarcodeFrameItem barcodeFrameItem;
                try {
                    CameraManager.get().openDriver((SurfaceTexture)object);
                    object = ((BarcodeFrameItem)((Object)vector)).handler;
                    if (object != null) break block4;
                    barcodeFrameItem = vector;
                }
                catch (RuntimeException runtimeException) {
                    ((BarcodeFrameItem)((Object)vector)).errorMsg = runtimeException.getMessage();
                    return;
                }
                catch (IOException iOException) {
                    ((BarcodeFrameItem)((Object)vector)).errorMsg = iOException.getMessage();
                    return;
                }
                object = captureActivityHandler;
                BarcodeFrameItem barcodeFrameItem2 = vector;
                Vector<BarcodeFormat> vector = barcodeFrameItem2.decodeFormats;
                String string2 = barcodeFrameItem2.characterSet;
                boolean bl = barcodeFrameItem2.autoDecodeCharset;
                barcodeFrameItem.handler = new CaptureActivityHandler(barcodeFrameItem2, vector, string2, bl);
                if (barcodeFrameItem.mRunning && object != null) {
                    ((CaptureActivityHandler)((Object)object)).restartPreviewAndDecode();
                }
                break block5;
            }
            ((CaptureActivityHandler)((Object)object)).resume();
        }
        return;
    }

    private void initBeepSound() {
        if (this.mediaPlayer == null) {
            BarcodeFrameItem barcodeFrameItem = this;
            barcodeFrameItem.getActivity().setVolumeControlStream(3);
            this.mediaPlayer = new MediaPlayer();
            this.mediaPlayer.setAudioStreamType(3);
            barcodeFrameItem.mediaPlayer.setOnCompletionListener(this.beepListener);
            AssetFileDescriptor assetFileDescriptor = barcodeFrameItem.mAct.getResources().getAssets().openFd("res/dcloud_beep.ogg");
            MediaPlayer mediaPlayer = this.mediaPlayer;
            AssetFileDescriptor assetFileDescriptor2 = assetFileDescriptor;
            AssetFileDescriptor assetFileDescriptor3 = assetFileDescriptor;
            FileDescriptor fileDescriptor = assetFileDescriptor.getFileDescriptor();
            long l2 = assetFileDescriptor3.getStartOffset();
            long l3 = assetFileDescriptor2.getLength();
            try {
                mediaPlayer.setDataSource(fileDescriptor, l2, l3);
                assetFileDescriptor.close();
                barcodeFrameItem.mediaPlayer.setVolume(0.8f, 0.8f);
                barcodeFrameItem.mediaPlayer.prepare();
            }
            catch (IOException iOException) {
                this.mediaPlayer = null;
            }
        }
    }

    private void playBeepSoundAndVibrate() {
        MediaPlayer mediaPlayer;
        if (this.playBeep && (mediaPlayer = this.mediaPlayer) != null) {
            mediaPlayer.start();
        }
        if (this.vibrate) {
            try {
                ((Vibrator)this.mAct.getSystemService("vibrator")).vibrate(200L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static int convertTypestrToNum(BarcodeFormat barcodeFormat) {
        if (barcodeFormat == BarcodeFormat.QR_CODE) {
            return 0;
        }
        if (barcodeFormat == BarcodeFormat.EAN_13) {
            return 1;
        }
        if (barcodeFormat == BarcodeFormat.EAN_8) {
            return 2;
        }
        if (barcodeFormat == BarcodeFormat.AZTEC) {
            return 3;
        }
        if (barcodeFormat == BarcodeFormat.DATA_MATRIX) {
            return 4;
        }
        if (barcodeFormat == BarcodeFormat.UPC_A) {
            return 5;
        }
        if (barcodeFormat == BarcodeFormat.UPC_E) {
            return 6;
        }
        if (barcodeFormat == BarcodeFormat.CODABAR) {
            return 7;
        }
        if (barcodeFormat == BarcodeFormat.CODE_39) {
            return 8;
        }
        if (barcodeFormat == BarcodeFormat.CODE_93) {
            return 9;
        }
        if (barcodeFormat == BarcodeFormat.CODE_128) {
            return 10;
        }
        if (barcodeFormat == BarcodeFormat.ITF) {
            return 11;
        }
        if (barcodeFormat == BarcodeFormat.MAXICODE) {
            return 12;
        }
        if (barcodeFormat == BarcodeFormat.PDF_417) {
            return 13;
        }
        if (barcodeFormat == BarcodeFormat.RSS_14) {
            return 14;
        }
        if (barcodeFormat == BarcodeFormat.RSS_EXPANDED) {
            return 15;
        }
        return -1000;
    }

    private void initDecodeFormats(JSONArray jSONArray) {
        Vector vector;
        Vector vector2 = vector;
        vector = new Vector();
        this.decodeFormats = vector2;
        if (jSONArray != null && jSONArray.length() != 0) {
            int n2 = jSONArray.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = -1;
                try {
                    n3 = jSONArray.getInt(i2);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                if (n3 == -1) continue;
                this.decodeFormats.add(this.convertNumToBarcodeFormat(n3));
            }
        } else {
            BarcodeFrameItem barcodeFrameItem = this;
            barcodeFrameItem.decodeFormats.add(BarcodeFormat.EAN_13);
            barcodeFrameItem.decodeFormats.add(BarcodeFormat.EAN_8);
            barcodeFrameItem.decodeFormats.add(BarcodeFormat.QR_CODE);
        }
    }

    private BarcodeFormat convertNumToBarcodeFormat(int n2) {
        Object object = null;
        switch (n2) {
            default: {
                break;
            }
            case 15: {
                object = BarcodeFormat.RSS_EXPANDED;
                break;
            }
            case 14: {
                object = BarcodeFormat.RSS_14;
                break;
            }
            case 13: {
                object = BarcodeFormat.PDF_417;
                break;
            }
            case 12: {
                object = BarcodeFormat.MAXICODE;
                break;
            }
            case 11: {
                object = BarcodeFormat.ITF;
                break;
            }
            case 10: {
                object = BarcodeFormat.CODE_128;
                break;
            }
            case 9: {
                object = BarcodeFormat.CODE_93;
                break;
            }
            case 8: {
                object = BarcodeFormat.CODE_39;
                break;
            }
            case 7: {
                object = BarcodeFormat.CODABAR;
                break;
            }
            case 6: {
                object = BarcodeFormat.UPC_E;
                break;
            }
            case 5: {
                object = BarcodeFormat.UPC_A;
                break;
            }
            case 4: {
                object = BarcodeFormat.DATA_MATRIX;
                break;
            }
            case 3: {
                object = BarcodeFormat.AZTEC;
                break;
            }
            case 2: {
                object = BarcodeFormat.EAN_8;
                break;
            }
            case 1: {
                object = BarcodeFormat.EAN_13;
                break;
            }
            case 0: {
                object = BarcodeFormat.QR_CODE;
            }
        }
        return object;
    }

    private Bitmap byte2bitmap(byte[] byArray, Camera camera) {
        Matrix matrix;
        ByteArrayOutputStream byteArrayOutputStream;
        BarcodeFrameItem barcodeFrameItem = null;
        Camera camera2 = camera = camera.getParameters().getPreviewSize();
        int n2 = 17;
        int n3 = camera2.width;
        int n4 = camera2.height;
        YuvImage yuvImage = new YuvImage(byArray, n2, n3, n4, null);
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        Camera camera3 = camera;
        int n5 = 0;
        n3 = 0;
        n4 = camera3.width;
        int n6 = camera3.height;
        yuvImage.compressToJpeg(new Rect(n5, n3, n4, n6), 80, (OutputStream)byteArrayOutputStream2);
        byte[] byArray2 = byteArrayOutputStream2.toByteArray();
        n5 = 0;
        barcodeFrameItem = BitmapFactory.decodeByteArray((byte[])byArray2, (int)n5, (int)byteArrayOutputStream2.size());
        byteArrayOutputStream2.close();
        byteArrayOutputStream2 = matrix;
        new Matrix().postRotate(90.0f);
        n5 = 0;
        n3 = 0;
        n4 = barcodeFrameItem.getWidth();
        n6 = barcodeFrameItem.getHeight();
        try {
            barcodeFrameItem = Bitmap.createBitmap((Bitmap)barcodeFrameItem, (int)n5, (int)n3, (int)n4, (int)n6, (Matrix)byteArrayOutputStream2, (boolean)true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return barcodeFrameItem;
    }

    public void appendToFrameView(AdaFrameView adaFrameView) {
        if (this.obtainMainView() != null && this.obtainMainView().getParent() != null) {
            BarcodeFrameItem barcodeFrameItem = this;
            barcodeFrameItem.removeMapFrameItem(barcodeFrameItem.mContainerWebview);
        }
        this.mContainerWebview = adaFrameView.obtainWebView();
        this.toFrameView();
    }

    public void removeMapFrameItem(IWebview iWebview) {
        if (this.mPosition.equals("absolute")) {
            iWebview.obtainFrameView().removeFrameItem(this);
        } else {
            iWebview.removeFrameItem(this);
        }
    }

    public void addCallBackId(String string2, String string3) {
        if (!this.mCallbackIds.containsKey(string2)) {
            this.mCallbackIds.put(string2, string3);
        }
    }

    public void toFrameView() {
        PermissionUtil.StreamPermissionRequest streamPermissionRequest;
        BarcodeFrameItem barcodeFrameItem = this;
        AbsoluteLayout absoluteLayout = (AbsoluteLayout)barcodeFrameItem.obtainMainView();
        JSONArray jSONArray = barcodeFrameItem.mDivRectJson;
        jSONArray = barcodeFrameItem.getFrameLayoutParam(jSONArray, barcodeFrameItem.mStyles);
        barcodeFrameItem.surfaceView = new TextureView(this.mAct);
        barcodeFrameItem.viewfinderView = new ViewfinderView(this.mAct, this);
        barcodeFrameItem.hasSurface = false;
        barcodeFrameItem.inactivityTimer = new InactivityTimer(this.getActivity());
        PermissionUtil.StreamPermissionRequest streamPermissionRequest2 = streamPermissionRequest;
        BarcodeFrameItem barcodeFrameItem2 = this;
        streamPermissionRequest = new PermissionUtil.StreamPermissionRequest(barcodeFrameItem2.mContainerWebview.obtainApp(), (AbsoluteLayout.LayoutParams)jSONArray, absoluteLayout){
            final /* synthetic */ AbsoluteLayout.LayoutParams val$lp;
            final /* synthetic */ AbsoluteLayout val$mainView;
            {
                this.val$lp = layoutParams;
                this.val$mainView = absoluteLayout;
                super(iApp);
            }

            @Override
            public void onGranted(String string2) {
                2 v0 = this_;
                2 this_ = v0.val$lp;
                this_.BarcodeFrameItem.this.initCameraView((AbsoluteLayout.LayoutParams)this_, v0.val$mainView);
            }

            @Override
            public void onDenied(String string2) {
                BarcodeFrameItem.this.noPermission = true;
                MessageHandler.sendMessage(new MessageHandler.IMessages(){

                    @Override
                    public void execute(Object object) {
                        1 v0 = this;
                        val$mainView.setBackgroundColor(-16777216);
                        val$mainView.invalidate();
                    }
                }, null);
            }
        };
        PermissionUtil.usePermission(barcodeFrameItem.mContainerWebview.getActivity(), "CAMERA", streamPermissionRequest2);
        barcodeFrameItem.onResume(false);
        barcodeFrameItem.saveOrientationState();
        this.isVerticalScreen = barcodeFrameItem.mAppHandler.isVerticalScreen();
        if (this.isVerticalScreen) {
            this.mAppHandler.setRequestedOrientation("portrait");
        } else {
            this.mAppHandler.setRequestedOrientation("landscape");
        }
        BarcodeFrameItem barcodeFrameItem3 = this;
        barcodeFrameItem3.listenHideAndShow(barcodeFrameItem3.mContainerWebview);
        if (barcodeFrameItem3.mPosition.equals("absolute")) {
            this.mContainerWebview.obtainFrameView().addFrameItem(this, (ViewGroup.LayoutParams)jSONArray);
        } else {
            this.mContainerWebview.addFrameItem(this, (ViewGroup.LayoutParams)jSONArray);
        }
    }

    public void upateStyles(JSONObject object) {
        JSONUtil.combinJSONObject(this.mStyles, object);
        if (object.has("top") || object.has("left") || object.has("width") || object.has("height") || object.has("position")) {
            BarcodeFrameItem barcodeFrameItem = this;
            JSONArray jSONArray = barcodeFrameItem.mDivRectJson;
            jSONArray = barcodeFrameItem.getFrameLayoutParam(jSONArray, barcodeFrameItem.mStyles);
            if (object.has("position")) {
                if (!(object = object.optString("position")).equals(this.mPosition)) {
                    if (this.mPosition.equals("absolute")) {
                        BarcodeFrameItem barcodeFrameItem2 = this;
                        barcodeFrameItem2.mContainerWebview.obtainFrameView().removeFrameItem(this);
                        barcodeFrameItem2.mContainerWebview.addFrameItem(this, (ViewGroup.LayoutParams)jSONArray);
                    } else {
                        BarcodeFrameItem barcodeFrameItem3 = this;
                        barcodeFrameItem3.mContainerWebview.removeFrameItem(this);
                        barcodeFrameItem3.mContainerWebview.obtainFrameView().addFrameItem(this, (ViewGroup.LayoutParams)jSONArray);
                    }
                    this.mPosition = object;
                }
            } else {
                this.obtainMainView().setLayoutParams((ViewGroup.LayoutParams)jSONArray);
            }
        }
    }

    @Override
    public void autoFocus() {
        this.handler.autoFocus();
    }

    @Override
    public void dispose() {
        BarcodeFrameItem barcodeFrameItem = this;
        super.dispose();
        Logger.d("Barcode", "dispose");
        barcodeFrameItem.onPause();
        DetectorViewConfig.clearData();
        barcodeFrameItem.mProxy.mBarcodeView = null;
        barcodeFrameItem.surfaceView = null;
        Bitmap bitmap = barcodeFrameItem.lastBitmap;
        if (bitmap != null && !bitmap.isRecycled()) {
            this.lastBitmap.recycle();
            this.lastBitmap = null;
        }
        CameraManager.get().clearLastBitmapData();
        this.resumeOrientationState();
        BarcodeProxyMgr.getBarcodeProxyMgr().removeBarcodeProxy(this.mUuid);
    }

    protected void onResume(boolean bl) {
        BarcodeFrameItem barcodeFrameItem = this;
        SurfaceTexture surfaceTexture = barcodeFrameItem.surfaceView.getSurfaceTexture();
        if (barcodeFrameItem.lastBitmap != null && this.isCancelScan && bl) {
            BarcodeFrameItem barcodeFrameItem2 = this;
            Resources resources = barcodeFrameItem2.mAct.getResources();
            this.surfaceView.setBackground((Drawable)new BitmapDrawable(resources, barcodeFrameItem2.lastBitmap));
        }
        if (this.hasSurface) {
            this.initCamera(surfaceTexture);
        } else {
            this.surfaceView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
        }
        if (((AudioManager)this.mAct.getSystemService("audio")).getRingerMode() != 2) {
            this.playBeep = false;
        }
        this.initBeepSound();
        if (bl && this.mRunning) {
            this.mRunning = false;
            this.start();
        }
    }

    @Override
    public void onPopFromStack(boolean bl) {
        super.onPopFromStack(bl);
        if (bl) {
            this.onPause();
        }
    }

    @Override
    public void onPushToStack(boolean bl) {
        super.onPushToStack(bl);
        if (bl) {
            this.onResume(false);
        }
    }

    protected void onPause() {
        CaptureActivityHandler captureActivityHandler = this.handler;
        if (captureActivityHandler != null) {
            captureActivityHandler.quitSynchronously();
            this.handler = null;
        }
        if (!this.noPermission) {
            CameraManager.get().closeDriver();
        }
        BarcodeFrameItem barcodeFrameItem = this;
        boolean bl = barcodeFrameItem.mRunning;
        barcodeFrameItem.cancel();
        barcodeFrameItem.mRunning = bl;
    }

    protected void start() {
        if (!this.mRunning) {
            BarcodeFrameItem barcodeFrameItem = this;
            barcodeFrameItem.getViewfinderView().startUpdateScreenTimer();
            CaptureActivityHandler captureActivityHandler = barcodeFrameItem.handler;
            if (captureActivityHandler != null) {
                captureActivityHandler.restartPreviewAndDecode();
            } else {
                this.onResume(false);
            }
            if (this.isCancelScan) {
                BarcodeFrameItem barcodeFrameItem2 = this;
                barcodeFrameItem2.surfaceView.setBackground(null);
                captureActivityHandler = barcodeFrameItem2.lastBitmap;
                if (captureActivityHandler != null && !captureActivityHandler.isRecycled()) {
                    this.lastBitmap.recycle();
                    this.lastBitmap = null;
                }
                BarcodeFrameItem barcodeFrameItem3 = this;
                CameraManager.get().clearLastBitmapData();
                barcodeFrameItem3.surfaceView.postInvalidate();
                barcodeFrameItem3.initCamera(barcodeFrameItem3.surfaceView.getSurfaceTexture());
            }
            BarcodeFrameItem barcodeFrameItem4 = this;
            barcodeFrameItem4.mRunning = true;
            barcodeFrameItem4.isCancelScan = false;
        }
    }

    public void setFlash(boolean bl) {
        CameraManager.get().setFlashlight(bl);
    }

    protected void cancel() {
        if (this.mRunning) {
            CaptureActivityHandler captureActivityHandler = this.handler;
            if (captureActivityHandler != null) {
                captureActivityHandler.stopDecode();
            }
            this.getViewfinderView().stopUpdateScreenTimer();
            this.mRunning = false;
        }
    }

    protected void cancel_scan() {
        if (this.mRunning) {
            Object object = this.handler;
            if (object != null) {
                object.quitSynchronously();
                this.handler = null;
            }
            this.getViewfinderView().stopUpdateScreenTimer();
            CameraManager.get().removeAutoFocus();
            CameraManager.get().stopPreview();
            byte[] byArray = CameraManager.get().getLastBitmapData();
            object = byArray;
            Camera camera = CameraManager.get().getCameraHandler();
            if (byArray != null && camera != null) {
                this.lastBitmap = this.byte2bitmap((byte[])object, camera);
            }
            BarcodeFrameItem barcodeFrameItem = this;
            CameraManager.get().closeDriver();
            barcodeFrameItem.mRunning = false;
            barcodeFrameItem.isCancelScan = true;
        }
    }

    protected void close_scan() {
        BarcodeFrameItem barcodeFrameItem = this;
        barcodeFrameItem.dispose();
        barcodeFrameItem.setMainView(null);
        System.gc();
    }

    protected void onDestroy() {
        BarcodeFrameItem barcodeFrameItem = this;
        barcodeFrameItem.inactivityTimer.shutdown();
        barcodeFrameItem.hasSurface = false;
        barcodeFrameItem.decodeFormats = null;
        barcodeFrameItem.characterSet = null;
        barcodeFrameItem.mCallbackIds.clear();
    }

    @Override
    public ViewfinderView getViewfinderView() {
        return this.viewfinderView;
    }

    @Override
    public Handler getHandler() {
        return this.handler;
    }

    @Override
    public boolean isRunning() {
        return this.mRunning;
    }

    @Override
    public void drawViewfinder() {
        this.viewfinderView.drawViewfinder();
    }

    @Override
    public void handleDecode(Result object, Bitmap bitmap) {
        BarcodeFrameItem barcodeFrameItem = this;
        barcodeFrameItem.inactivityTimer.onActivity();
        barcodeFrameItem.playBeepSoundAndVibrate();
        boolean bl = false;
        if (barcodeFrameItem.mConserve) {
            bl = PdrUtil.saveBitmapToFile(bitmap, this.mFilename);
        }
        int n2 = BarcodeFrameItem.convertTypestrToNum(((Result)object).getBarcodeFormat());
        if (bl) {
            BarcodeFrameItem barcodeFrameItem2 = this;
            String string2 = "{type:%d,message:%s,file:'%s',charSet:'%s'}";
            Object[] objectArray = barcodeFrameItem2.mWebViewImpl.obtainFrameView().obtainApp().obtainAppDocPath();
            Logger.d("doc:" + (String)objectArray);
            if (barcodeFrameItem2.mFilename.startsWith((String)objectArray)) {
                this.mFilename = "_doc" + this.mFilename.substring(objectArray.length() - 1);
            }
            String string3 = string2;
            string2 = this.mWebViewImpl.obtainFrameView().obtainApp().convert2RelPath(this.mFilename);
            Logger.d("Filename:" + this.mFilename + ";relPath:" + string2);
            Object[] objectArray2 = new Object[4];
            objectArray = objectArray2;
            objectArray[0] = n2;
            objectArray[1] = JSONUtil.toJSONableString(((Result)object).getText());
            objectArray[2] = string2;
            objectArray2[3] = ((Result)object).textCharset;
            object = StringUtil.format(string3, objectArray2);
        } else {
            Object[] objectArray = new Object[3];
            Object[] objectArray3 = objectArray;
            objectArray3[0] = n2;
            objectArray3[1] = JSONUtil.toJSONableString(((Result)object).getText());
            objectArray[2] = ((Result)object).textCharset;
            object = StringUtil.format("{type:%d,message:%s,charSet:'%s'}", objectArray3);
        }
        BarcodeFrameItem barcodeFrameItem3 = this;
        barcodeFrameItem3.runJsCallBack((String)object, JSUtil.OK, true, true);
        barcodeFrameItem3.cancel();
    }

    public JSONObject getJsBarcode() {
        JSONObject jSONObject = null;
        if (((AdaFrameItem)object).obtainMainView() != null) {
            JSONObject jSONObject2;
            jSONObject = jSONObject2;
            BarcodeFrameItem barcodeFrameItem = object;
            BarcodeFrameItem barcodeFrameItem2 = object;
            BarcodeFrameItem barcodeFrameItem3 = object;
            BarcodeFrameItem barcodeFrameItem4 = object;
            jSONObject();
            Object object = "uuid";
            jSONObject.put((String)object, (Object)barcodeFrameItem4.mUuid);
            object = "filters";
            jSONObject.put((String)object, (Object)barcodeFrameItem3.mFilters);
            object = "options";
            jSONObject.put((String)object, (Object)barcodeFrameItem2.mStyles);
            object = "autoDecodeCharset";
            try {
                jSONObject2.put((String)object, barcodeFrameItem.autoDecodeCharset);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return jSONObject;
    }

    public void runJsCallBack(String string2, int n2, boolean bl, boolean bl2) {
        for (String string3 : this.mCallbackIds.keySet()) {
            Object object = this.mCallbackIds.get(string3);
            object = BarcodeProxyMgr.getBarcodeProxyMgr().findWebviewByUuid(this.mWebViewImpl, (String)object);
            if (object == null) continue;
            JSUtil.execCallback((IWebview)object, string3, string2, n2, bl, bl2);
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n2, int n3) {
        if (!this.hasSurface) {
            this.hasSurface = true;
            if (!this.isCancelScan) {
                try {
                    this.initCamera(surfaceTexture);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n2, int n3) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        this.hasSurface = false;
        return false;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }
}

