/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.audio.recorder;

import android.media.AudioRecord;
import android.os.Handler;
import android.os.Message;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.feature.audio.aac.AacEncode;
import io.dcloud.feature.audio.mp3.SimpleLame;
import io.dcloud.feature.audio.recorder.DataEncodeThread;
import io.dcloud.feature.audio.recorder.HighGradeRecorder;
import io.dcloud.feature.audio.recorder.RecordOption;
import io.dcloud.feature.audio.recorder.RecorderUtil;
import java.io.File;
import java.io.FileNotFoundException;

public class RecorderTask
extends Thread {
    private static final String TAG = "RecorderTask";
    private static final int DEFAULT_LAME_MP3_QUALITY = 7;
    public static final int DEFAULT_LAME_MP3_BIT_RATE = 128;
    private static final int FRAME_COUNT = 220;
    private int[] sampleRates;
    private final int[] configs;
    private final int[] formats;
    private AudioRecord audioRecord;
    int bufsize;
    private boolean mShouldRun;
    private boolean mShouldRecord;
    private long startTime;
    private long duration;
    private int maxDuration;
    private short[] mPCMBuffer;
    private byte[] mAacBuffer;
    private DataEncodeThread mEncodeThread;
    private File outputFile;
    private double mDuration;
    private HighGradeRecorder.Callback mDurationListener;
    HighGradeRecorder mRecorder;
    boolean reallyStart;
    Handler handler;
    int waitingTime;
    private String mFormat;

    public RecorderTask(File object, HighGradeRecorder highGradeRecorder, RecordOption recordOption) {
        RecorderTask recorderTask = this;
        this.sampleRates = new int[]{44100, 22050, 11025, 8000};
        this.configs = new int[]{16, 12};
        this.formats = new int[]{2, 3};
        this.audioRecord = null;
        this.bufsize = -2;
        this.mShouldRun = false;
        this.mShouldRecord = false;
        this.startTime = 0L;
        this.duration = 0L;
        this.outputFile = object;
        recorderTask.mRecorder = highGradeRecorder;
        recorderTask.handler = new Handler();
        this.mFormat = recordOption.mFormat;
        if (!recordOption.isRateDeft) {
            int[] nArray = new int[5];
            object = nArray;
            nArray[0] = recordOption.mSamplingRate;
            nArray[1] = 44100;
            nArray[2] = 22050;
            nArray[3] = 11025;
            nArray[4] = 8000;
            this.sampleRates = (int[])object;
        }
        this.waitingTime = highGradeRecorder.getRecorderState() == 1 ? 1000 : 10000;
    }

    private int mapFormat(int n2) {
        if (n2 != 2) {
            if (n2 != 3) {
                return 0;
            }
            return 8;
        }
        return 16;
    }

    private void cancel() {
        this.stopRecord();
    }

    private double calVolume(short[] sArray, double d2) {
        long l2 = 0L;
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            l2 += (long)(sArray[i2] * sArray[i2]);
        }
        return Math.log10((double)l2 / d2) * 10.0;
    }

    private void init() {
        DataEncodeThread dataEncodeThread;
        int n2;
        block15: {
            block16: {
                int n3 = this.audioRecord.getAudioFormat() == 2 ? 2 : 1;
                n2 = this.bufsize / n3;
                int n4 = n2 % 220;
                if (n4 != 0) {
                    this.bufsize = (n2 + (220 - n4)) * n3;
                }
                RecorderTask recorderTask = this;
                n3 = recorderTask.bufsize;
                recorderTask.mPCMBuffer = new short[n3];
                recorderTask.mAacBuffer = new byte[n3];
                if (recorderTask.mFormat.equalsIgnoreCase("aac")) {
                    AacEncode.getAacEncode(this.audioRecord.getSampleRate(), this.audioRecord.getChannelCount());
                } else {
                    SimpleLame.init(this.audioRecord.getSampleRate(), this.audioRecord.getChannelCount(), this.audioRecord.getSampleRate(), 128, 7);
                }
                if (this.outputFile.exists()) break block15;
                File file = this.outputFile.getParentFile();
                if (file.exists()) break block16;
                file.mkdirs();
            }
            this.outputFile.createNewFile();
        }
        RecorderTask recorderTask = this;
        RecorderTask recorderTask2 = recorderTask;
        RecorderTask recorderTask3 = recorderTask;
        RecorderTask recorderTask4 = this;
        DataEncodeThread dataEncodeThread2 = dataEncodeThread;
        DataEncodeThread dataEncodeThread3 = dataEncodeThread;
        RecorderTask recorderTask5 = this;
        RecorderTask recorderTask6 = recorderTask5;
        RecorderTask recorderTask7 = recorderTask5;
        File file = recorderTask5.outputFile;
        n2 = recorderTask7.bufsize;
        String string2 = recorderTask6.mFormat;
        try {
            dataEncodeThread2(file, n2, string2);
            recorderTask4.mEncodeThread = dataEncodeThread3;
            dataEncodeThread.start();
            DataEncodeThread dataEncodeThread4 = this.mEncodeThread;
            recorderTask2.audioRecord.setRecordPositionUpdateListener((AudioRecord.OnRecordPositionUpdateListener)dataEncodeThread4, dataEncodeThread4.getHandler());
            recorderTask3.audioRecord.setPositionNotificationPeriod(220);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    private boolean isFound() {
        boolean bl = false;
        int n2 = 0;
        while (!bl) {
            int[] nArray = this.formats;
            if (n2 >= this.formats.length) break;
            int n3 = nArray[n2];
            int n4 = 0;
            while (!bl) {
                int[] nArray2 = this.sampleRates;
                if (n4 >= this.sampleRates.length) break;
                int n5 = nArray2[n4];
                int n6 = 0;
                while (!bl) {
                    int[] nArray3 = this.configs;
                    if (n6 >= this.configs.length) break;
                    int n7 = nArray3[n6];
                    Logger.e(TAG, "Trying to create AudioRecord use: " + n3 + "/" + n7 + "/" + n5);
                    this.bufsize = AudioRecord.getMinBufferSize((int)n5, (int)n7, (int)n3);
                    Logger.e(TAG, "Bufsize: " + this.bufsize);
                    int n8 = this.bufsize;
                    if (-2 == n8) {
                        Logger.i(TAG, "invaild params!");
                    } else if (-1 == n8) {
                        Logger.i(TAG, "Unable to query hardware!");
                    } else {
                        try {
                            RecorderTask recorderTask = this;
                            recorderTask.createRecord(n5, n7, n3);
                            if (recorderTask.audioRecord.getState() == 1) {
                                bl = true;
                                break;
                            }
                        }
                        catch (IllegalStateException illegalStateException) {
                            Logger.i(TAG, "Failed to set up recorder!");
                            this.audioRecord = null;
                        }
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return bl;
    }

    private void createRecord(int n2, int n3, int n4) {
        AudioRecord audioRecord;
        AudioRecord audioRecord2 = audioRecord;
        int n5 = this.bufsize;
        audioRecord = new AudioRecord(1, n2, n3, n4, n5);
        this.audioRecord = audioRecord2;
    }

    public void setMaxDuration(int n2) {
        this.maxDuration = n2;
    }

    public void setCallback(HighGradeRecorder.Callback callback) {
        this.mDurationListener = callback;
    }

    public void startRecording() {
        this.mShouldRecord = true;
    }

    public void resumeRecord() {
        this.mShouldRecord = true;
    }

    public void pauseRecord() {
        this.mShouldRecord = false;
    }

    public void stopRecord() {
        this.mShouldRecord = false;
        this.mShouldRun = false;
        AudioRecord audioRecord = this.audioRecord;
        if (audioRecord != null) {
            audioRecord.stop();
            this.audioRecord.release();
            this.audioRecord = null;
        }
        Message.obtain((Handler)this.mEncodeThread.getHandler(), (int)1).sendToTarget();
    }

    public int getDuration() {
        return (int)this.mDuration;
    }

    @Override
    public void run() {
        RecorderTask recorderTask = this;
        super.run();
        if (!recorderTask.isFound()) {
            Logger.e(TAG, "Sample rate, channel config or format not supported!");
            return;
        }
        RecorderTask recorderTask2 = this;
        recorderTask2.init();
        recorderTask2.mShouldRun = true;
        int n2 = 0;
        RecorderTask recorderTask3 = this;
        int n3 = recorderTask2.audioRecord.getSampleRate() * recorderTask3.mapFormat(recorderTask3.audioRecord.getAudioFormat()) / 8 * this.audioRecord.getChannelCount();
        recorderTask2.mDuration = 0.0;
        while (this.mShouldRun) {
            AudioRecord audioRecord;
            int n4 = this.mShouldRecord;
            if (n4 != n2) {
                block14: {
                    if (n4 != 0) {
                        RecorderTask recorderTask4 = this;
                        recorderTask4.startTime = System.currentTimeMillis();
                        recorderTask4.audioRecord.startRecording();
                        if (recorderTask4.mDuration != 0.0) break block14;
                        try {
                            this.reallyStart = true;
                            RecorderUtil.postTaskSafely(new Runnable(){

                                @Override
                                public void run() {
                                    RecorderTask.this.mRecorder.onstart();
                                }
                            });
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else {
                        this.audioRecord.stop();
                    }
                }
                n2 = this.mShouldRecord;
            }
            if (!this.mShouldRecord) continue;
            if (this.mFormat.equalsIgnoreCase("aac")) {
                RecorderTask recorderTask5 = this;
                byte[] byArray = recorderTask5.mAacBuffer;
                int n5 = recorderTask5.bufsize;
                n4 = this.audioRecord.read(byArray, 0, n5);
                if (n4 <= 0) continue;
                this.mEncodeThread.addTask(this.mAacBuffer, n4);
                continue;
            }
            RecorderTask recorderTask6 = this;
            short[] sArray = recorderTask6.mPCMBuffer;
            int n6 = recorderTask6.bufsize;
            n4 = this.audioRecord.read(sArray, 0, n6);
            if (n4 <= 0) continue;
            RecorderTask recorderTask7 = this;
            final double d2 = n4;
            double d3 = d2 * 1000.0 * 2.0 / (double)n3;
            d2 = recorderTask7.calVolume(recorderTask7.mPCMBuffer, d2);
            recorderTask7.mDuration += d3;
            if (recorderTask7.mDurationListener != null) {
                RecorderUtil.postTaskSafely(new Runnable(){

                    @Override
                    public void run() {
                        2 v0 = this;
                        2 v1 = this;
                        double d22 = v1.RecorderTask.this.mDuration;
                        double d3 = v1.d2;
                        v0.RecorderTask.this.mDurationListener.onRecording(d22, d3);
                        if (v0.RecorderTask.this.maxDuration > 0 && RecorderTask.this.mDuration >= (double)RecorderTask.this.maxDuration) {
                            2 v2 = this;
                            v2.RecorderTask.this.mRecorder.stop(2);
                            v2.RecorderTask.this.mDurationListener.onMaxDurationReached();
                        }
                    }
                });
            }
            if ((audioRecord = this.audioRecord) != null && audioRecord.getChannelCount() == 1) {
                this.mEncodeThread.addTask(this.mPCMBuffer, n4);
                continue;
            }
            audioRecord = this.audioRecord;
            if (audioRecord == null || audioRecord.getChannelCount() != 2) continue;
            int n7 = n4 / 2;
            short[] sArray2 = new short[n7];
            short[] sArray3 = new short[n7];
            for (int i2 = 0; i2 < n7; i2 += 2) {
                short[] sArray4 = this.mPCMBuffer;
                int n8 = i2 * 2;
                sArray2[i2] = this.mPCMBuffer[n8];
                int n9 = n8 + 1;
                if (n9 < n4) {
                    int n10 = i2 + 1;
                    sArray2[n10] = sArray4[n9];
                }
                if ((n9 = n8 + 2) < n4) {
                    sArray3[i2] = sArray4[n9];
                }
                if ((n8 += 3) >= n4) continue;
                int n11 = i2 + 1;
                sArray3[n11] = sArray4[n8];
            }
            this.mEncodeThread.addTask(sArray2, sArray3, n7);
        }
    }

    public boolean isRecording() {
        return this.mShouldRecord;
    }
}

