/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import io.dcloud.common.DHInterface.IActivityDelegate;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.adapter.util.AndroidResources;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.MobilePhoneModel;
import io.dcloud.common.adapter.util.PlatformUtil;
import io.dcloud.common.core.ui.DCKeyboardManager;
import io.dcloud.common.util.Base64;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.f.a.f;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.json.JSONObject;

public class AppStatusBarManager {
    private int mStatusBarDefaultColor = 0;
    public boolean isImmersive = false;
    public boolean isFullScreen = false;
    public boolean isHandledWhiteScreen = false;
    public boolean isTemporaryFullScreen = true;
    private f mWebAppInfo;
    private IApp mIApp;

    public AppStatusBarManager(Activity activity, f f2) {
        this.initStatusBarDefaultColor(activity);
        this.mWebAppInfo = f2;
        this.mIApp = (IApp)((Object)f2);
        this.initDirectImmersive();
    }

    private void initDirectImmersive() {
        if (this.mWebAppInfo.getActivity().getIntent().hasExtra("direct_page") && BaseInfo.isWap2AppAppid(this.mWebAppInfo.m) && Build.VERSION.SDK_INT > 19) {
            AppStatusBarManager appStatusBarManager = this;
            JSONObject jSONObject = appStatusBarManager.getDirectStatusJson(appStatusBarManager.mIApp);
            this.isImmersive = jSONObject != null && jSONObject.has("immersed") ? jSONObject.optBoolean("immersed") : true;
            BaseInfo.isImmersive = this.isImmersive;
        }
    }

    private void initStatusBarDefaultColor(Activity activity) {
        if (activity != null && Build.VERSION.SDK_INT >= 21) {
            activity = activity.getWindow();
            int n2 = this.getStatusbarColorIndex();
            if (n2 > 0) {
                this.mStatusBarDefaultColor = activity.getWindowStyle().getColor(n2, 0);
            }
            if (this.mStatusBarDefaultColor == 0) {
                this.mStatusBarDefaultColor = Color.parseColor((String)"#D4D4D4");
            }
        }
    }

    private void diyContentFullScreenBug(Activity activity) {
        FrameLayout frameLayout = null;
        if (activity instanceof IActivityDelegate) {
            frameLayout = ((IActivityDelegate)activity).obtainActivityContentView();
        }
        if (frameLayout == null) {
            return;
        }
        if (!((AppStatusBarManager)((Object)string2)).isFullScreen && !((AppStatusBarManager)((Object)string2)).isImmersive) {
            ((AppStatusBarManager)((Object)string2)).isTemporaryFullScreen = false;
            DCKeyboardManager.getInstance().setAdjust(false);
        } else {
            String string2 = AndroidResources.getMetaValue("DCLOUD_INPUT_MODE");
            if (TextUtils.isEmpty((CharSequence)string2) || !string2.contains("adjustPan")) {
                DCKeyboardManager.getInstance().setAdjust(true);
            }
        }
    }

    @TargetApi(value=19)
    private void setTranslucentStatus(final Activity activity, boolean bl) {
        Window window = activity.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        layoutParams.flags = bl ? (layoutParams.flags |= 0x4000000) : (layoutParams.flags &= 0xFBFFFFFF);
        Window window2 = window;
        window2.setAttributes(layoutParams);
        window2.getDecorView().post(new Runnable(){

            @Override
            public void run() {
                2 this_ = this_.AppStatusBarManager.this.getRootView(this_.activity);
                if (this_.getParent() instanceof LinearLayout) {
                    LinearLayout.LayoutParams layoutParams;
                    2 v0 = this_;
                    this_ = layoutParams;
                    layoutParams = new LinearLayout.LayoutParams(-1, -1);
                    v0.setLayoutParams((ViewGroup.LayoutParams)this_);
                } else if (this_.getParent() instanceof FrameLayout) {
                    FrameLayout.LayoutParams layoutParams;
                    2 v2 = this_;
                    this_ = layoutParams;
                    layoutParams = new FrameLayout.LayoutParams(-1, -1);
                    v2.setLayoutParams((ViewGroup.LayoutParams)this_);
                }
            }
        });
    }

    private View getRootView(Activity activity) {
        return activity.findViewById(0x1020002);
    }

    private void setMeizuStatusBarDarkIcon(Activity activity, boolean bl) {
        if (activity != null) {
            boolean bl2;
            try {
                bl2 = bl;
                AppStatusBarManager appStatusBarManager = activity.getWindow().getAttributes();
            }
            catch (Exception exception) {}
            Field field = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
            Field field2 = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
            AppStatusBarManager appStatusBarManager = appStatusBarManager;
            field.setAccessible(true);
            field2.setAccessible(true);
            int n2 = field.getInt(null);
            int n3 = field2.getInt(appStatusBarManager);
            n2 = bl2 ? n3 | n2 : n3 & ~n2;
            field2.setInt(appStatusBarManager, n2);
            activity.getWindow().setAttributes((WindowManager.LayoutParams)appStatusBarManager);
        }
    }

    private void setMiuiStatusBarDarkMode(Activity object, boolean bl) {
        Activity activity = object;
        try {
            Class<?> clazz = Class.forName("android.view.MiuiWindowManager$LayoutParams");
        }
        catch (Exception exception) {}
        int n2 = clazz.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE").getInt(clazz);
        Class[] classArray = new Class[2];
        object = Integer.TYPE;
        classArray[0] = object;
        classArray[1] = object;
        object = activity.getWindow().getClass().getMethod("setExtraFlags", classArray);
        Window window = activity.getWindow();
        Object[] objectArray = new Object[2];
        int n3 = 0;
        int n4 = bl ? n2 : 0;
        Object object2 = object;
        Window window2 = window;
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = objectArray;
        int n5 = n2;
        objectArray[n3] = n4;
        n2 = 1;
        objectArray2[n2] = n5;
        ((Method)object2).invoke((Object)window2, objectArray3);
    }

    public int getStatusBarDefaultColor() {
        return this.mStatusBarDefaultColor;
    }

    public int getStatusbarColorIndex() {
        int n2;
        Object object = PlatformUtil.newInstance(Base64.decode2String("Y29tLmFuZHJvaWQuaW50ZXJuYWwuUiRzdHlsZWFibGU="), null, null);
        try {
            n2 = Integer.parseInt(PlatformUtil.invokeFieldValue(null, "Window_statusBarColor", object).toString());
        }
        catch (Exception exception) {
            n2 = -1;
        }
        return n2;
    }

    public void setImmersive(final Activity activity, boolean bl) {
        if (activity != null) {
            int n2 = Build.VERSION.SDK_INT;
            if (!(n2 == 19 || DeviceInfo.sBrand.equalsIgnoreCase(MobilePhoneModel.SONY) && n2 >= 21 || DeviceInfo.sBrand.equalsIgnoreCase(MobilePhoneModel.QiKU) && n2 >= 21)) {
                if (n2 >= 21) {
                    this.isImmersive = bl;
                    Window window = activity.getWindow();
                    n2 = window.getDecorView().getSystemUiVisibility();
                    if (bl) {
                        Window window2 = window;
                        Window window3 = window;
                        window3.clearFlags(0x4000000);
                        window3.addFlags(Integer.MIN_VALUE);
                        window2.getDecorView().setSystemUiVisibility(n2 |= 0x500);
                        window2.setStatusBarColor(0);
                    } else {
                        window.getDecorView().setSystemUiVisibility(n2 &= 0xFFFFFAFF);
                        window.setStatusBarColor(this.mStatusBarDefaultColor);
                    }
                    window.getDecorView().post(new Runnable(){

                        @Override
                        public void run() {
                            1 this_ = this_.AppStatusBarManager.this.getRootView(this_.activity);
                            if (this_.getParent() instanceof LinearLayout) {
                                LinearLayout.LayoutParams layoutParams;
                                1 v0 = this_;
                                this_ = layoutParams;
                                layoutParams = new LinearLayout.LayoutParams(-1, -1);
                                v0.setLayoutParams((ViewGroup.LayoutParams)this_);
                            } else if (this_.getParent() instanceof FrameLayout) {
                                FrameLayout.LayoutParams layoutParams;
                                1 v2 = this_;
                                this_ = layoutParams;
                                layoutParams = new FrameLayout.LayoutParams(-1, -1);
                                v2.setLayoutParams((ViewGroup.LayoutParams)this_);
                            }
                        }
                    });
                    this.diyContentFullScreenBug(activity);
                }
            } else {
                AppStatusBarManager appStatusBarManager = this;
                appStatusBarManager.isImmersive = bl;
                appStatusBarManager.setTranslucentStatus(activity, bl);
                appStatusBarManager.diyContentFullScreenBug(activity);
            }
        }
    }

    public void setStatusBarMode(Activity activity, String string2) {
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 21 && activity != null) {
            if (PdrUtil.isEmpty(string2)) {
                string2 = "nono";
            }
            boolean bl = string2.equalsIgnoreCase("dark");
            Window window = activity.getWindow();
            String string3 = Build.BRAND;
            if (string3.equalsIgnoreCase(MobilePhoneModel.GOOGLE)) {
                string3 = Build.MANUFACTURER;
            }
            if (string3.equals(MobilePhoneModel.XIAOMI)) {
                this.setMiuiStatusBarDarkMode(activity, bl);
            } else if (string3.equals(MobilePhoneModel.MEIZU)) {
                this.setMeizuStatusBarDarkIcon(activity, bl);
            }
            if (n2 >= 23) {
                int n3 = window.getDecorView().getSystemUiVisibility();
                int n4 = 8192;
                Class<?> clazz = Class.forName("android.view.View");
                try {
                    n4 = clazz.getField("SYSTEM_UI_FLAG_LIGHT_STATUS_BAR").getInt(clazz);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                n3 = bl ? (n3 |= n4) : (n3 &= ~n4);
                window.getDecorView().setSystemUiVisibility(n3);
            }
        }
    }

    public void setStatusBarColor(Activity activity, int n2) {
        if (!PdrUtil.checkStatusbarColor(n2)) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 21 && activity != null && !this.isImmersive) {
            Window window = activity.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(n2);
        }
    }

    public boolean isFullScreenOrImmersive() {
        return this.isImmersive || this.isFullScreen;
    }

    public void setFullScreen(Activity activity, boolean bl) {
        Window window = activity.getWindow();
        this.isFullScreen = bl;
        if (bl) {
            WindowManager.LayoutParams layoutParams = window.getAttributes();
            layoutParams.flags |= 0x400;
            if (Build.VERSION.SDK_INT >= 28) {
                layoutParams.layoutInDisplayCutoutMode = 1;
            }
            window.setAttributes(layoutParams);
        } else {
            WindowManager.LayoutParams layoutParams = window.getAttributes();
            layoutParams.flags &= 0xFFFFFBFF;
            if (Build.VERSION.SDK_INT >= 28) {
                layoutParams.layoutInDisplayCutoutMode = 0;
            }
            window.setAttributes(layoutParams);
        }
        this.diyContentFullScreenBug(activity);
    }

    public boolean checkImmersedStatusBar(Context context, boolean bl) {
        int n2;
        boolean bl2;
        block8: {
            bl2 = false;
            n2 = Build.VERSION.SDK_INT;
            if (n2 < 19) {
                return bl2;
            }
            context = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (context == null) break block8;
            context = context.metaData;
            if (context == null) break block8;
            try {
                bl2 = context.getBoolean("immersed.status.bar", false);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
            }
        }
        if (!bl2) {
            bl2 = bl;
        }
        if (this.mWebAppInfo.l.equals("suggestedDevice") && bl2) {
            bl2 = (DeviceInfo.sBrand.equalsIgnoreCase(MobilePhoneModel.XIAOMI) || DeviceInfo.sBrand.contentEquals(MobilePhoneModel.MEIZU)) && n2 >= 21 || n2 >= 23;
        }
        this.isImmersive = bl2;
        if (!bl2 && this.mWebAppInfo.getActivity().getIntent().hasExtra("direct_page") && BaseInfo.isWap2AppAppid(this.mWebAppInfo.m) && !this.mIApp.manifestBeParsed()) {
            AppStatusBarManager appStatusBarManager = this;
            context = appStatusBarManager.getDirectStatusJson(appStatusBarManager.mIApp);
            this.isImmersive = context != null && context.has("immersed") ? context.optBoolean("immersed") : true;
            bl2 = this.isImmersive;
        }
        BaseInfo.isImmersive = this.isImmersive;
        return bl2;
    }

    public JSONObject getDirectStatusJson(IApp iApp) {
        AppStatusBarManager appStatusBarManager = iApp.obtainThridInfo(IApp.ConfigProperty.ThridInfo.DirectPageJsonData);
        if (appStatusBarManager != null && appStatusBarManager.has("statusbar")) {
            if ((appStatusBarManager = appStatusBarManager.optJSONObject("statusbar")) != null) {
                return appStatusBarManager;
            }
        } else {
            appStatusBarManager = iApp.obtainThridInfo(IApp.ConfigProperty.ThridInfo.SitemapJsonData);
            if (appStatusBarManager != null && appStatusBarManager.has("statusbar")) {
                return appStatusBarManager.optJSONObject("statusbar");
            }
        }
        return null;
    }
}

