/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.adapter.util;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import io.dcloud.common.adapter.io.DHFile;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.ThreadPool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

public class Logger {
    public static final String Capture_TAG = "Capture_Tag";
    public static final String Event_TAG = "Event_Tag";
    public static final String AppMgr_TAG = "appmgr";
    public static final String StreamApp_TAG = "stream_manager";
    public static final String AutoGC_TAG = "AutoGC_Path";
    public static final String Android_System_TAG = "Android_System_Path";
    public static final String LAYOUT_TAG = "Layout_Path";
    public static final String MAIN_TAG = "Main_Path";
    public static final String AUTO_POP_PUSH_TAG = "Auto_Pop_Push_Path";
    public static final String ANIMATION_TAG = "Animation_Path";
    public static final String MAP_TAG = "Map_Path";
    public static final String VIEW_VISIBLE_TAG = "View_Visible_Path";
    private static final String MSC_TAG = "DCloud_";
    private static final String LOGTAG = "DCloud_LOG";
    private static final String STREAMSDKLOGTAG = "DCLOUD_STREAMSDK_LOG";
    private static final String EXCEPTION_TAG = "DCloud_Exception";
    private static File mLogFile;
    private static String LogPath = "";
    private static boolean isStoreLog = false;
    private static long TIMES = 432000000L;
    private static boolean isOpen = true;
    private static boolean isHasDevFile = false;
    protected static String I = "I";
    protected static String D = "D";
    protected static String E = "E";
    protected static String W = "W";
    static String pkg = "";
    private static HandlerThread mWriteLogToSdCardThread;
    private static WriteLogToSdCardThreadHandler mWriteLogToSdCardThreadHandler;
    private static HashMap<String, SimpleDateFormat> mSimpleDateFormatCache;
    private static int MAX_CRASH_FILE_COUNT = 3;
    public static final String TIMESTAMP_HH_MM_SS_SSS = "HH:mm:ss.SSS";
    public static final String TIMESTAMP_YYYY_MM_DD = "yyyyMMdd";
    public static final String TIMESTAMP_YYYY_MM_DD_HH_MM_SS_SSS = "yyyyMMdd HH:mm:ss.SSS";

    public static void initLogger(Context context) {
        Context context2 = context;
        pkg = context2.getPackageName();
        isHasDevFile = DHFile.hasFile();
        isOpen = BaseInfo.isBase(context2) || isHasDevFile;
        isOpen = isOpen | BaseInfo.ISDEBUG;
        if ("mounted".equalsIgnoreCase(Environment.getExternalStorageState())) {
            LogPath = BaseInfo.getCrashLogsPath(context);
        }
        Logger.init(LogPath, "crash");
        Logger.init(LogPath + "crash/", null);
        Logger.setOpen(isOpen);
    }

    private static void init(final String string2, final String string3) {
        try {
            ThreadPool.self().addThreadTask(new Runnable(){

                @Override
                public void run() {
                    block4: {
                        File[] fileArray = new File(string2).listFiles();
                        if (fileArray == null || fileArray.length <= MAX_CRASH_FILE_COUNT) break block4;
                        if (fileArray[0].getName().compareTo(fileArray[1].getName()) < 0) {
                            for (int i2 = 0; i2 < fileArray.length - MAX_CRASH_FILE_COUNT; ++i2) {
                                if (TextUtils.equals((CharSequence)string3, (CharSequence)fileArray[i2].getName())) continue;
                                fileArray[i2].delete();
                            }
                        } else {
                            for (int i3 = fileArray.length - 1; i3 >= MAX_CRASH_FILE_COUNT; --i3) {
                                if (TextUtils.equals((CharSequence)string3, (CharSequence)fileArray[i3].getName())) continue;
                                fileArray[i3].delete();
                            }
                        }
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void setOpen(boolean bl) {
        isOpen = bl;
        if (isOpen) {
            Logger.canStoreLogToSDcard();
            Logger.storeLogToSDcard();
        }
    }

    public static boolean isOpen() {
        return isOpen;
    }

    public static void d(String string2, String string3) {
        if (isOpen) {
            if (!BaseInfo.ISDEBUG) {
                Log.i((String)string2, (String)string3);
            } else {
                Log.d((String)string2, (String)string3);
            }
            Logger.WriteLogToSDcard(D, string2, string3);
        }
    }

    public static void d(String string2, Object ... objectArray) {
        if (isOpen) {
            StringBuffer stringBuffer;
            StringBuffer stringBuffer2 = stringBuffer;
            stringBuffer = new StringBuffer();
            if (objectArray != null) {
                int n2 = objectArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    stringBuffer2.append(objectArray[i2]).append(";");
                }
            }
            if (!BaseInfo.ISDEBUG) {
                Log.i((String)string2, (String)stringBuffer2.toString());
            } else {
                Log.d((String)string2, (String)stringBuffer2.toString());
            }
            Logger.WriteLogToSDcard(D, string2, stringBuffer2.toString());
        }
    }

    public static void d(String string2) {
        Logger.d(LOGTAG, string2);
    }

    public static void i(String string2, String string3) {
        if (isOpen && string3 != null) {
            Log.i((String)string2, (String)string3);
            Logger.WriteLogToSDcard(I, string2, string3);
        }
    }

    public static void i(String string2) {
        Logger.i(LOGTAG, string2);
    }

    public static void w(String string2, Throwable throwable) {
        if (isOpen) {
            if (throwable != null) {
                throwable.printStackTrace();
            }
            Log.w((String)EXCEPTION_TAG, (String)string2, (Throwable)throwable);
            Logger.WriteExceptionToSDcard(W, EXCEPTION_TAG, string2, throwable);
        }
    }

    public static void w(Throwable throwable) {
        Logger.w("", throwable);
    }

    public static void e(String string2, String string3) {
        if (isOpen) {
            Log.e((String)string2, (String)string3);
            Logger.WriteLogToSDcard(E, string2, string3);
        }
    }

    public static void e(String string2) {
        Logger.e(LOGTAG, string2);
    }

    public static void es(String string2, String string3) {
        if (isOpen) {
            Log.e((String)string2, (String)string3);
            Logger.WriteLogToSDcard(E, string2, string3);
        }
    }

    public static void es(String string2) {
        if (isOpen) {
            Logger.es(STREAMSDKLOGTAG, string2);
        }
    }

    public static void p(String string2, String string3) {
        Logger.privacyLog(string2, string3);
    }

    public static void p(String string2) {
        Logger.privacyLog(LOGTAG, string2);
    }

    private static void privacyLog(String string2, String string3) {
        if (isHasDevFile) {
            Log.e((String)string2, (String)string3);
        }
    }

    public static boolean isTurnOn() {
        return isStoreLog;
    }

    public static void turnOff() {
        isStoreLog = false;
    }

    protected static boolean isSDcardExists() {
        return "mounted".equals(Environment.getExternalStorageState());
    }

    private static String concatString(String string2, String string3) {
        String string4 = null;
        if (string2 != null && string3 != null) {
            int n2 = string2.length() + string3.length();
            StringBuffer stringBuffer = new StringBuffer(n2);
            stringBuffer.append(string2).append(string3);
            string4 = stringBuffer.toString();
        }
        return string4;
    }

    public static boolean canStoreLogToSDcard() {
        if (Logger.isSDcardExists() && isOpen) {
            File file;
            File file2 = file;
            if (new File(LogPath).exists()) {
                Logger.deleteOldLog(file2);
            }
            if (file2.exists() && file2.canWrite()) {
                isStoreLog = true;
            }
        }
        return isStoreLog;
    }

    protected static String generateLog(String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Logger.generateTimeStamp(Boolean.TRUE)).append(" ").append(string2).append(" ").append("-").append(" ").append(string3).append(" ").append(string4).append("\n");
        return stringBuffer.toString();
    }

    private static void WriteExceptionToSDcard(String string2, String string3, String string4, Throwable stackTraceElementArray) {
        if (stackTraceElementArray != null) {
            Logger.WriteLogToSDcard(string2, string3, Logger.generateLog(string2, EXCEPTION_TAG, stackTraceElementArray.getClass().getName()));
            stackTraceElementArray = stackTraceElementArray.getStackTrace();
            if (stackTraceElementArray != null) {
                Logger.WriteLogToSDcard(string2, string3, string4);
                int n2 = stackTraceElementArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Logger.WriteLogToSDcard(string2, string3, Logger.generateLog(string2, EXCEPTION_TAG, "    at " + stackTraceElementArray[i2].toString()));
                }
            }
        }
    }

    private static void WriteLogToSDcard(String string2, String string3, String string4) {
        if (!isOpen) {
            return;
        }
        File file = mLogFile;
        if (file != null && file.exists()) {
            Logger.initWriteLogToSdCardThread();
            file = Message.obtain();
            Message.obtain().obj = new String[]{string2, string3, string4};
            if (!PdrUtil.isEmpty((Object)mWriteLogToSdCardThreadHandler)) {
                mWriteLogToSdCardThreadHandler.sendMessage((Message)file);
            }
            return;
        }
    }

    public static String generateTimeStamp(Boolean bl) {
        return Logger.generateTimeStamp(bl != false ? TIMESTAMP_HH_MM_SS_SSS : TIMESTAMP_YYYY_MM_DD, new Date());
    }

    public static String generateTimeStamp(String string2, Date date) {
        SimpleDateFormat simpleDateFormat = Logger.getDateFormatFromCache(string2);
        simpleDateFormat.applyPattern(string2);
        return simpleDateFormat.format(date);
    }

    private static SimpleDateFormat getDateFormatFromCache(String string2) {
        SimpleDateFormat simpleDateFormat;
        if (mSimpleDateFormatCache == null) {
            mSimpleDateFormatCache = new HashMap();
        }
        if (!mSimpleDateFormatCache.containsKey(string2)) {
            SimpleDateFormat simpleDateFormat2;
            simpleDateFormat = simpleDateFormat2;
            simpleDateFormat2 = new SimpleDateFormat(string2, Locale.ENGLISH);
            mSimpleDateFormatCache.put(string2, simpleDateFormat);
        } else {
            simpleDateFormat = mSimpleDateFormatCache.get(string2);
        }
        return simpleDateFormat;
    }

    public static void storeLogToSDcard() {
        if (isStoreLog) {
            StringBuffer stringBuffer;
            CharSequence charSequence = stringBuffer;
            String string2 = Logger.generateTimeStamp(Boolean.FALSE) + ".log";
            new StringBuffer().append(LogPath).append(string2);
            mLogFile = new File(charSequence.toString());
            if (!mLogFile.exists()) {
                try {
                    mLogFile.createNewFile();
                }
                catch (IOException iOException) {
                    mLogFile = null;
                    iOException.printStackTrace();
                }
            }
            charSequence = "path=" + charSequence.toString();
            Logger.WriteLogToSDcard("\u65e5\u5fd7\u8def\u5f84:", "Logger", (String)charSequence);
        }
    }

    protected static void deleteOldLog(File fileArray) {
        Date date;
        fileArray = fileArray.listFiles();
        Date date2 = date;
        date = new Date();
        if (fileArray != null) {
            for (File file : fileArray) {
                if (file.isDirectory()) continue;
                Object object = file.getName().substring(0, 8);
                object = new SimpleDateFormat(TIMESTAMP_YYYY_MM_DD).parse((String)object);
                long l2 = date2.getTime() - ((Date)object).getTime();
                if (l2 <= TIMES) continue;
                try {
                    file.delete();
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                }
            }
        }
    }

    private static void initWriteLogToSdCardThread() {
        if (mWriteLogToSdCardThread == null) {
            mWriteLogToSdCardThread = new HandlerThread("WriteLogToSdCardThread");
            mWriteLogToSdCardThread.start();
            mWriteLogToSdCardThreadHandler = new WriteLogToSdCardThreadHandler(mWriteLogToSdCardThread.getLooper());
        }
    }

    public static void stopWriteLogToSdCardThread() {
        if (mWriteLogToSdCardThread != null) {
            WriteLogToSdCardThreadHandler writeLogToSdCardThreadHandler = mWriteLogToSdCardThreadHandler;
            if (writeLogToSdCardThreadHandler != null) {
                writeLogToSdCardThreadHandler.removeCallbacksAndMessages(null);
            }
            mWriteLogToSdCardThreadHandler = null;
            if (Build.VERSION.SDK_INT >= 18) {
                mWriteLogToSdCardThread.quitSafely();
            } else {
                mWriteLogToSdCardThread.quit();
            }
            mWriteLogToSdCardThread = null;
        }
    }

    static class WriteLogToSdCardThreadHandler
    extends Handler {
        public WriteLogToSdCardThreadHandler(Looper looper) {
            super(looper);
        }

        /*
         * Loose catch block
         * WARNING - void declaration
         */
        public void handleMessage(Message message) {
            block19: {
                block16: {
                    super.handleMessage(message);
                    Object object = message.obj;
                    if (object == null || !(object instanceof String[])) break block19;
                    if (((String[])(object = (String[])object)).length < 3) {
                        return;
                    }
                    String string2 = object[0];
                    object = object[1];
                    object = Logger.generateLog(string2, (String)object, object[2]);
                    if (mLogFile != null && mLogFile.exists() && object != null) {
                        void var0_3;
                        Object object2;
                        block18: {
                            Exception exception2;
                            block17: {
                                FileOutputStream fileOutputStream;
                                message = null;
                                object2 = fileOutputStream;
                                Object object3 = object;
                                ((FileOutputStream)object2)(mLogFile, true);
                                ((OutputStream)fileOutputStream).write(((String)object3).getBytes());
                                fileOutputStream.flush();
                                ((OutputStream)fileOutputStream).close();
                                break block16;
                                catch (Exception exception2) {
                                    break block17;
                                }
                                catch (Throwable throwable) {
                                    object2 = message;
                                    break block18;
                                }
                                catch (Exception exception2) {
                                    object2 = message;
                                }
                            }
                            exception2.printStackTrace();
                            if (object2 == null) break block16;
                            try {
                                ((OutputStream)object2).close();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                            break block16;
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (object2 != null) {
                            try {
                                ((OutputStream)object2).close();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                        throw var0_3;
                    }
                }
                return;
            }
        }
    }
}

