/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.adapter.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.Bundle;
import io.dcloud.common.adapter.ui.AdaWebview;
import io.dcloud.common.adapter.util.CanvasHelper;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.util.PdrUtil;

public abstract class AndroidResources {
    public static Resources mResources;
    public static PackageInfo mApplicationInfo;
    static AssetManager sAssetMgr;
    public static String versionName;
    public static int versionCode;
    public static String packageName;
    public static boolean sIMEAlive = false;
    public static boolean splashBacking = false;
    static Bundle sMetaDatas;

    public static void initAndroidResources(Context context) {
        if (mResources != null) {
            return;
        }
        Context context2 = context;
        mResources = context2.getResources();
        DeviceInfo.sApplicationContext = context2;
        sAssetMgr = context2.getAssets();
        try {
            packageName = context2.getApplicationInfo().packageName;
            mApplicationInfo = context2.getPackageManager().getPackageInfo(packageName, 1);
            versionName = AndroidResources.mApplicationInfo.versionName;
            versionCode = AndroidResources.mApplicationInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
    }

    public static void clearData() {
        CanvasHelper.clearData();
        AdaWebview.clearData();
        mResources = null;
        sAssetMgr = null;
        mApplicationInfo = null;
    }

    public static String getMetaValue(String string2) {
        Bundle bundle;
        if (sMetaDatas == null) {
            try {
                sMetaDatas = DeviceInfo.sApplicationContext.getPackageManager().getApplicationInfo((String)AndroidResources.packageName, (int)128).metaData;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        if ((bundle = sMetaDatas) != null && !PdrUtil.isEmpty(bundle.get(string2))) {
            return String.valueOf(sMetaDatas.get(string2));
        }
        return null;
    }

    public static void setMetaValue(String string2, String string3) {
        Bundle bundle;
        if (sMetaDatas == null) {
            try {
                sMetaDatas = DeviceInfo.sApplicationContext.getPackageManager().getApplicationInfo((String)AndroidResources.packageName, (int)128).metaData;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if ((bundle = sMetaDatas) != null) {
            bundle.putString(string2, string3);
            System.out.println("meta data = " + sMetaDatas.get(string2));
        }
    }

    public static int getIdentifier(String string2, String string3) {
        int n2 = 0;
        Resources resources = mResources;
        if (resources != null) {
            String string4 = packageName;
            n2 = resources.getIdentifier(string2, string3, string4);
        }
        return n2;
    }

    public static int getIdentifierFromApk(Context context, String string2, String string3) {
        try {
            Context context2 = context;
            return context2.createPackageContext(context2.getPackageName(), 2).getResources().getIdentifier(string2, string3, context.getPackageName());
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
            return 0;
        }
    }

    public static String getString(int n2) {
        Resources resources = mResources;
        if (resources != null) {
            return resources.getString(n2);
        }
        return "";
    }
}

