/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.common.adapter.ui;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsoluteLayout;
import io.dcloud.base.R;
import io.dcloud.common.adapter.ui.AdaFrameItem;
import io.dcloud.common.adapter.ui.AdaWebview;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.PlatformUtil;
import io.dcloud.common.adapter.util.ViewOptions;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.PdrUtil;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONException;
import org.json.JSONObject;

public class PullRefreshView
extends View {
    public static final String TAG = "PullRefreshView";
    public static final byte TYPE_PULL_UP_REFRESH = 0;
    public static final byte TYPE_PULL_DOWN_REFRESH = 1;
    static int MAX_FRAME_COUNT = 9;
    static int HEIGHT = 25;
    static final byte STATE_NO_REFRESH = 0;
    static final byte STATE_ON_MOVE_ING = 1;
    static final byte STATE_ON_OVER = 2;
    static final byte STATE_ON_REFRESH_ING = 3;
    static final byte FLAG_NO_THING = -1;
    static final byte FLAG_STARTED = 0;
    static final byte FLAG_MOVEED = 1;
    static final int color_tr = 0xFF00F0;
    byte mType;
    String mContent_down;
    String mContent_over;
    String mContent_refresh;
    String mShowContent;
    String mSecInfo;
    private Rect src;
    private RectF dst;
    Bitmap mIcon;
    float mFontScale;
    int changeStateHeight;
    int maxPullHeight;
    float startX;
    float startY;
    AdaFrameItem mParent;
    AdaWebview mWebview;
    private float mWebviewScale;
    int sScreenWidth;
    int sScreenHeight;
    Paint paint;
    int index;
    private int contentLeft;
    private int contentTop;
    private int contentWidth;
    byte mState;
    boolean touch_started;
    boolean mCaptureTouchEnd;
    byte mFlag;
    int icon_x;
    int icon_y;
    int fontSize;
    int mScrollHeight;
    byte SCROLL_STATE_MIN;
    byte SCROLL_STATE_MAX;
    byte SCROLL_STATE_MIDDLE;
    byte mScrollState;
    boolean mEnableScrollMinHeight;
    boolean mEnableScrollMaxHeight;
    float lastScrollY;
    boolean mRefreshState;
    Timer mUpdateProgressBar;

    public PullRefreshView(AdaFrameItem adaFrameItem, AdaWebview adaWebview) {
        PullRefreshView pullRefreshView = this;
        PullRefreshView pullRefreshView2 = this;
        super(adaFrameItem.getContext());
        this.mType = 1;
        this.mShowContent = null;
        this.mSecInfo = null;
        this.mIcon = null;
        this.mFontScale = 1.2f;
        this.changeStateHeight = 100;
        this.maxPullHeight = 100;
        this.paint = new Paint();
        this.index = 0;
        this.contentLeft = 0;
        this.contentTop = 0;
        this.contentWidth = 0;
        this.mState = 0;
        this.touch_started = false;
        this.mCaptureTouchEnd = false;
        this.mFlag = 0;
        this.mScrollHeight = 0;
        this.SCROLL_STATE_MIN = 0;
        this.SCROLL_STATE_MAX = 1;
        this.SCROLL_STATE_MIDDLE = (byte)2;
        this.mScrollState = 0;
        this.mEnableScrollMinHeight = true;
        this.mEnableScrollMaxHeight = true;
        this.mRefreshState = false;
        this.mUpdateProgressBar = null;
        this.mParent = adaFrameItem;
        pullRefreshView2.mWebview = adaWebview;
        pullRefreshView2.mContent_down = pullRefreshView2.getResources().getString(R.string.dcloud_drop_down_refresh1);
        pullRefreshView2.mContent_over = pullRefreshView2.getResources().getString(R.string.dcloud_drop_down_refresh2);
        pullRefreshView2.mContent_refresh = pullRefreshView2.getResources().getString(R.string.dcloud_drop_down_refresh3);
        this.sScreenWidth = adaWebview.obtainApp().getInt(0);
        this.sScreenHeight = adaWebview.obtainApp().getInt(1);
        pullRefreshView.mWebviewScale = adaWebview.getScale();
        pullRefreshView.init(null);
        pullRefreshView.paint.setAntiAlias(true);
    }

    private boolean updateScrollState(byte by) {
        boolean bl = false;
        this.mScrollState = by;
        if (by == this.SCROLL_STATE_MAX) {
            PullRefreshView pullRefreshView = this;
            pullRefreshView.mScrollHeight = pullRefreshView.maxPullHeight;
            if (pullRefreshView.mEnableScrollMaxHeight) {
                bl = true;
                this.mEnableScrollMaxHeight = false;
            }
            this.mEnableScrollMinHeight = true;
        } else if (by == this.SCROLL_STATE_MIN) {
            this.mEnableScrollMaxHeight = true;
            this.mScrollHeight = 0;
            if (this.mEnableScrollMinHeight) {
                bl = true;
                this.mEnableScrollMinHeight = false;
            }
        } else if (by == this.SCROLL_STATE_MIDDLE) {
            PullRefreshView pullRefreshView = this;
            pullRefreshView.mEnableScrollMinHeight = true;
            pullRefreshView.mEnableScrollMaxHeight = true;
            bl = true;
        }
        return bl;
    }

    private void stopUpdateScreenTimer() {
        Timer timer = this.mUpdateProgressBar;
        if (timer != null) {
            timer.cancel();
            this.mUpdateProgressBar = null;
        }
    }

    private void startUpdateScreenTimer() {
        TimerTask timerTask;
        Timer timer;
        this.stopUpdateScreenTimer();
        Object object = timer;
        ((Timer)object)();
        this.mUpdateProgressBar = object;
        object = timerTask;
        timerTask = new TimerTask(){

            @Override
            public void run() {
                PullRefreshView.this.updateScreen();
            }
        };
        timer.schedule((TimerTask)object, 0L, 100L);
    }

    static void smoothScrollTo(ViewGroup viewGroup, View view, int n2, int n3, int n4) {
        TimerTask timerTask;
        Timer timer;
        Timer timer2 = timer;
        timer2();
        TimerTask timerTask2 = timerTask;
        timerTask = new TimerTask(view, viewGroup, n2, n3, timer2){
            View child;
            ViewGroup parent;
            final int TIME;
            int toX;
            int toY;
            int fromX;
            int fromY;
            int timesCount;
            int flagTimes;
            int vX;
            int vY;
            final /* synthetic */ View val$pView;
            final /* synthetic */ ViewGroup val$pParent;
            final /* synthetic */ int val$x;
            final /* synthetic */ int val$y;
            final /* synthetic */ Timer val$_timer;
            {
                2 v0 = this;
                2 v1 = this;
                this.val$pView = view;
                this.val$pParent = viewGroup;
                this.val$x = n2;
                this.val$y = n3;
                this.val$_timer = timer;
                this.child = view;
                v1.parent = viewGroup;
                v1.TIME = 500;
                this.toX = n2;
                this.toY = n3;
                v0.fromX = viewGroup.getScrollX();
                v0.fromY = v0.parent.getScrollY();
                v0.timesCount = 10;
                v0.flagTimes = 1;
                v0.vX = Math.abs(v0.toX - this.fromX) / this.timesCount;
                this.vY = Math.abs(v0.toY - this.fromY) / this.timesCount;
                if (this.vY >= 5) {
                    this.vY = 5;
                    this.timesCount = Math.abs(this.toY - this.fromY) / this.vY;
                }
                this.vX = Math.abs(this.toX - this.fromX) / this.timesCount;
            }

            @Override
            public void run() {
                2 v0 = this;
                int n2 = v0.fromX + this.vX;
                int n3 = v0.fromY + this.vY;
                if (v0.flagTimes == this.timesCount) {
                    2 v1 = this;
                    n2 = v1.toX;
                    n3 = v1.toY;
                }
                2 v2 = this;
                PullRefreshView.scrollToByMessage((View)v2.parent, n2, n3);
                if (v2.flagTimes == this.timesCount) {
                    if (this.child != null) {
                        this.parent.post(new Runnable(){

                            @Override
                            public void run() {
                                Runnable runnable = runnable.this;
                                runnable.parent.removeView(runnable.child);
                            }
                        });
                    }
                    this.val$_timer.cancel();
                }
                this.fromX = n2;
                this.fromY = n3;
                ++this.flagTimes;
            }
        };
        long l2 = n4;
        timer.schedule(timerTask2, 0L, l2);
    }

    private static void scrollToByMessage(final View view, final int n2, final int n3) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                3 v0 = this;
                int n22 = v0.n2;
                view.scrollTo(n22, v0.n3);
            }
        };
        view.post(runnable2);
    }

    protected void onDraw(Canvas canvas) {
        if (pullRefreshView3.mState != 0) {
            PullRefreshView pullRefreshView = pullRefreshView3;
            canvas.drawColor(-1907998);
            pullRefreshView.paint.setColor(-16777216);
            pullRefreshView.paint.setTextSize((float)pullRefreshView3.fontSize);
            String string2 = pullRefreshView.mShowContent;
            float f2 = pullRefreshView.contentLeft;
            float f3 = pullRefreshView.contentTop;
            Paint paint = pullRefreshView.paint;
            canvas.drawText(string2, f2, f3, paint);
            string2 = pullRefreshView3.mIcon;
            if (string2 != null) {
                Canvas canvas2 = canvas;
                PullRefreshView pullRefreshView2 = pullRefreshView3;
                PullRefreshView pullRefreshView3 = pullRefreshView2.src;
                canvas = pullRefreshView2.dst;
                Paint paint2 = pullRefreshView2.paint;
                canvas2.drawBitmap((Bitmap)string2, (Rect)pullRefreshView3, (RectF)canvas, paint2);
            }
        }
    }

    public void updateScreen() {
        if (++this.index >= MAX_FRAME_COUNT) {
            this.index = 0;
        }
        PullRefreshView pullRefreshView = this;
        int n2 = HEIGHT;
        int n3 = this.index;
        int n4 = n2 * n3;
        int n5 = n2 * (n3 + 1);
        pullRefreshView.src.set(n4, 0, n5, n2);
        pullRefreshView.postInvalidate();
    }

    public void init(String string2) {
        int n2;
        BitmapFactory.Options options;
        string2 = options;
        new BitmapFactory.Options().inScaled = false;
        string2 = BitmapFactory.decodeStream((InputStream)PlatformUtil.getResInputStream("res/dcloud_prograss_snow1.png"), null, (BitmapFactory.Options)string2);
        this.mIcon = string2;
        HEIGHT = n2 = string2.getHeight();
        int n3 = this.sScreenWidth;
        this.contentLeft = (int)((float)n3 * 0.43f);
        this.icon_x = (int)((float)n3 * 0.41f) - n2;
        int n4 = n2 = HEIGHT;
        this.src = new Rect(0, 0, n4, n4);
        int n5 = HEIGHT;
        float f2 = n5;
        float f3 = n5;
        this.dst = new RectF(0.0f, 150.0f, f2, f3);
        MAX_FRAME_COUNT = string2.getWidth() / HEIGHT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseJsonOption(JSONObject jSONObject) {
        float f2;
        int n2;
        int n3;
        if (!jSONObject.isNull("height")) {
            PullRefreshView pullRefreshView = this;
            PullRefreshView pullRefreshView2 = this;
            n3 = pullRefreshView2.mWebview.mFrameView.mViewOptions.height;
            n2 = pullRefreshView2.changeStateHeight;
            f2 = pullRefreshView2.mWebviewScale;
            n3 = PdrUtil.convertToScreenInt(JSONUtil.getString(jSONObject, "height"), n3, n2, f2);
            pullRefreshView.changeStateHeight = n3;
            pullRefreshView.maxPullHeight = n3;
        }
        if (!jSONObject.isNull("range")) {
            PullRefreshView pullRefreshView = this;
            n3 = pullRefreshView.mWebview.mFrameView.mViewOptions.height;
            n2 = pullRefreshView.changeStateHeight;
            f2 = pullRefreshView.mWebviewScale;
            this.maxPullHeight = PdrUtil.convertToScreenInt(jSONObject.getString("range"), n3, n2, f2);
        }
        if (!jSONObject.isNull("contentdown")) {
            this.changeStringInfo(JSONUtil.getString(jSONObject.getJSONObject("contentdown"), "caption"));
        }
        if (!jSONObject.isNull("contentover")) {
            this.mContent_over = JSONUtil.getString(jSONObject.getJSONObject("contentover"), "caption");
        }
        if (!jSONObject.isNull("contentrefresh")) {
            this.mContent_refresh = JSONUtil.getString(jSONObject.getJSONObject("contentrefresh"), "caption");
        }
        PullRefreshView pullRefreshView = this;
        PullRefreshView pullRefreshView3 = pullRefreshView;
        PullRefreshView pullRefreshView4 = pullRefreshView;
        int n4 = Math.max(pullRefreshView.maxPullHeight - this.changeStateHeight, 0);
        int n5 = n4;
        Paint.FontMetricsInt fontMetricsInt = DeviceInfo.sPaint.getFontMetricsInt();
        n2 = this.changeStateHeight;
        int n6 = fontMetricsInt.bottom - fontMetricsInt.top;
        this.contentTop = n5 + (n2 >> 1) + (n6 >> 1);
        n5 = HEIGHT;
        int n7 = n4 + (n2 - n5 >> 1);
        pullRefreshView4.icon_y = n7;
        RectF rectF = pullRefreshView3.dst;
        int n8 = n7;
        int n9 = n5;
        n2 = this.icon_x;
        float f3 = n2;
        float f4 = n7;
        float f5 = n2 + n5;
        f2 = n8 + n9;
        try {
            rectF.set(f3, f4, f5, f2);
            Logger.d(TAG, "height=" + this.changeStateHeight + ";range=" + this.maxPullHeight + ";contentdown=" + this.mShowContent);
            return;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public void changeStringInfo(String string2) {
        this.mShowContent = string2;
        this.fontSize = (int)(DeviceInfo.DEFAULT_FONT_SIZE * DeviceInfo.sDensity * this.mFontScale);
        this.paint.setAntiAlias(true);
        int n2 = string2.length();
        float[] fArray = new float[n2];
        this.paint.getTextWidths(string2, fArray);
        float f2 = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            f2 += fArray[i2];
        }
        this.contentWidth = (int)f2;
    }

    void setColorByParentChild(View view) {
        int n2 = 2;
        for (int i2 = 0; i2 != n2; ++i2) {
            view = (View)view.getParent();
            view.setBackgroundColor(0xFF00F0);
        }
    }

    void onPullDown_start(float f2, float f3) {
        if (!this.touch_started) {
            byte by;
            Logger.d(TAG, "onPullDown_start");
            this.startX = f2;
            this.startY = f3;
            this.lastScrollY = f3;
            if (this.getParent() == null) {
                AbsoluteLayout.LayoutParams layoutParams;
                AbsoluteLayout.LayoutParams layoutParams2 = layoutParams;
                PullRefreshView pullRefreshView = this;
                int n2 = pullRefreshView.maxPullHeight;
                ViewOptions viewOptions = pullRefreshView.mWebview.mViewOptions;
                int n3 = viewOptions.left;
                int n4 = viewOptions.top - n2;
                layoutParams = new AbsoluteLayout.LayoutParams(-1, n2, n3, n4);
                ((ViewGroup)this.mParent.obtainMainView()).addView((View)this, 0, (ViewGroup.LayoutParams)layoutParams2);
            }
            if ((by = this.mState) == 0) {
                PullRefreshView pullRefreshView = this;
                pullRefreshView.mState = 1;
                pullRefreshView.mFlag = 0;
            } else if (by == 3) {
                this.mFlag = 0;
            }
            this.touch_started = true;
        }
    }

    boolean onMove(float f2, float f3) {
        int n2;
        int n3 = (int)((f3 - this.lastScrollY) * (float)this.maxPullHeight / (float)this.mWebview.mFrameView.mViewOptions.height);
        if (Math.abs(n3) < 1) {
            if (this.mScrollHeight > 0) {
                int n4;
                n2 = n4 = 1;
            } else {
                int n5;
                float f4 = n3;
                if ((f4 > 0.5f || f4 < -0.5f) && this.mFlag == 0) {
                    this.mFlag = 1;
                }
                n2 = n5 = 0;
            }
        } else {
            this.mScrollHeight = n2 = this.mScrollHeight + n3;
            if (n2 >= this.maxPullHeight) {
                PullRefreshView pullRefreshView = this;
                n2 = pullRefreshView.updateScrollState(pullRefreshView.SCROLL_STATE_MAX) ? 1 : 0;
            } else if (n2 <= 0) {
                PullRefreshView pullRefreshView = this;
                n2 = pullRefreshView.updateScrollState(pullRefreshView.SCROLL_STATE_MIN) ? 1 : 0;
            } else {
                PullRefreshView pullRefreshView = this;
                n2 = pullRefreshView.updateScrollState(pullRefreshView.SCROLL_STATE_MIDDLE) ? 1 : 0;
            }
            byte by = this.mState;
            if (by != 3) {
                if (by == 1 && this.mScrollHeight >= this.changeStateHeight) {
                    PullRefreshView pullRefreshView = this;
                    pullRefreshView.mState = (byte)2;
                    pullRefreshView.changeStringInfo(pullRefreshView.mContent_over);
                } else if (by == 2 && this.mScrollHeight < this.changeStateHeight) {
                    PullRefreshView pullRefreshView = this;
                    pullRefreshView.mState = 1;
                    pullRefreshView.changeStringInfo(pullRefreshView.mContent_down);
                }
            }
            if (n2 != 0) {
                if (this.mFlag == 0) {
                    this.mFlag = 1;
                    Logger.d(TAG, "onMove; mFlag=FLAG_MOVEED");
                    this.startUpdateScreenTimer();
                }
                this.mParent.obtainMainView().scrollBy(0, -n3);
                this.lastScrollY = f3;
            }
        }
        return n2 != 0;
    }

    void onExecuting() {
        PullRefreshView pullRefreshView = this;
        Logger.d(TAG, "onExecuting");
        pullRefreshView.mState = (byte)3;
        pullRefreshView.mRefreshState = true;
        pullRefreshView.mFlag = (byte)-1;
        Logger.d(TAG, "onExecuting; mFlag = FLAG_NO_THING");
        pullRefreshView.changeStringInfo(pullRefreshView.mContent_refresh);
        pullRefreshView.mScrollHeight = pullRefreshView.changeStateHeight;
        int n2 = -this.changeStateHeight;
        PullRefreshView.smoothScrollTo((ViewGroup)pullRefreshView.mParent.obtainMainView(), null, 0, n2, 1);
    }

    void onPullDown_end() {
        if (this.mScrollHeight <= this.changeStateHeight) {
            PullRefreshView pullRefreshView = this;
            pullRefreshView.mState = 0;
            pullRefreshView.mScrollHeight = 0;
            pullRefreshView.mFlag = (byte)-1;
            Logger.d(TAG, "onPullDown_end; mFlag = FLAG_NO_THING");
            pullRefreshView.changeStringInfo(pullRefreshView.mContent_down);
            Timer timer = pullRefreshView.mUpdateProgressBar;
            if (timer != null) {
                timer.cancel();
            }
            PullRefreshView pullRefreshView2 = this;
            pullRefreshView2.mParent.obtainMainView().scrollTo(0, 0);
            pullRefreshView2.stopUpdateScreenTimer();
        } else {
            this.smoothScrollToStateHeight(true);
        }
        this.mRefreshState = false;
    }

    void smoothScrollToStateHeight(boolean bl) {
        if (bl) {
            PullRefreshView pullRefreshView = this;
            pullRefreshView.mScrollHeight = pullRefreshView.changeStateHeight;
            int n2 = -this.changeStateHeight;
            PullRefreshView.smoothScrollTo((ViewGroup)pullRefreshView.mParent.obtainMainView(), null, 0, n2, 1);
        } else if (this.mScrollHeight > this.changeStateHeight) {
            this.smoothScrollToStateHeight(true);
        } else {
            this.mRefreshState = false;
        }
    }
}

