/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;

public class Timeout {
    public static final Timeout NONE = new Timeout(){

        @Override
        public Timeout timeout(long l2, TimeUnit timeUnit) {
            return this;
        }

        @Override
        public Timeout deadlineNanoTime(long l2) {
            return this;
        }

        @Override
        public void throwIfReached() throws IOException {
        }
    };
    private boolean hasDeadline;
    private long deadlineNanoTime;
    private long timeoutNanos;

    static long minTimeout(long l2, long l3) {
        if (l2 == 0L) {
            return l3;
        }
        if (l3 == 0L) {
            return l2;
        }
        if (l2 < l3) {
            return l2;
        }
        return l3;
    }

    public Timeout timeout(long l2, TimeUnit timeUnit) {
        if (l2 >= 0L) {
            if (timeUnit != null) {
                this.timeoutNanos = timeUnit.toNanos(l2);
                return this;
            }
            throw new IllegalArgumentException("unit == null");
        }
        throw new IllegalArgumentException("timeout < 0: " + l2);
    }

    public long timeoutNanos() {
        return this.timeoutNanos;
    }

    public boolean hasDeadline() {
        return this.hasDeadline;
    }

    public long deadlineNanoTime() {
        if (this.hasDeadline) {
            return this.deadlineNanoTime;
        }
        throw new IllegalStateException("No deadline");
    }

    public Timeout deadlineNanoTime(long l2) {
        this.hasDeadline = true;
        this.deadlineNanoTime = l2;
        return this;
    }

    public final Timeout deadline(long l2, TimeUnit timeUnit) {
        if (l2 > 0L) {
            if (timeUnit != null) {
                return this.deadlineNanoTime(System.nanoTime() + timeUnit.toNanos(l2));
            }
            throw new IllegalArgumentException("unit == null");
        }
        throw new IllegalArgumentException("duration <= 0: " + l2);
    }

    public Timeout clearTimeout() {
        this.timeoutNanos = 0L;
        return this;
    }

    public Timeout clearDeadline() {
        this.hasDeadline = false;
        return this;
    }

    public void throwIfReached() throws IOException {
        if (!Thread.interrupted()) {
            if (this.hasDeadline && this.deadlineNanoTime - System.nanoTime() <= 0L) {
                throw new InterruptedIOException("deadline reached");
            }
            return;
        }
        Thread.currentThread().interrupt();
        throw new InterruptedIOException("interrupted");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void waitUntilNotified(Object object) throws InterruptedIOException {
        long l2;
        long l3;
        block12: {
            long l4;
            int n2;
            try {
                n2 = this.hasDeadline();
                l3 = this.timeoutNanos();
                if (n2 == 0 && l3 == 0L) {
                    object.wait();
                    return;
                }
                l4 = System.nanoTime();
                if (n2 != 0 && l3 != 0L) {
                    l3 = Math.min(l3, this.deadlineNanoTime() - l4);
                } else if (n2 != 0) {
                    l3 = this.deadlineNanoTime() - l4;
                }
                l2 = 0L;
                if (l3 <= 0L) break block12;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException("interrupted");
            }
            Object object2 = object;
            long l5 = l3;
            long l6 = l5 / 1000000L;
            n2 = (int)(l5 - l6 * 1000000L);
            object2.wait(l6, n2);
            l2 = System.nanoTime() - l4;
        }
        if (l2 < l3) {
            return;
        }
        throw new InterruptedIOException("timeout");
    }
}

