/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import dc.squareup.okio.Buffer;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.ForwardingSource;
import dc.squareup.okio.Segment;
import dc.squareup.okio.Source;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class HashingSource
extends ForwardingSource {
    private final MessageDigest messageDigest;
    private final Mac mac;

    public static HashingSource md5(Source source) {
        return new HashingSource(source, "MD5");
    }

    public static HashingSource sha1(Source source) {
        return new HashingSource(source, "SHA-1");
    }

    public static HashingSource sha256(Source source) {
        return new HashingSource(source, "SHA-256");
    }

    public static HashingSource hmacSha1(Source source, ByteString byteString) {
        return new HashingSource(source, byteString, "HmacSHA1");
    }

    public static HashingSource hmacSha256(Source source, ByteString byteString) {
        return new HashingSource(source, byteString, "HmacSHA256");
    }

    private HashingSource(Source source, String string2) {
        HashingSource hashingSource = this;
        super(source);
        try {
            hashingSource.messageDigest = MessageDigest.getInstance(string2);
            hashingSource.mac = null;
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    private HashingSource(Source source, ByteString byteString, String string2) {
        super(source);
        Mac mac = Mac.getInstance(string2);
        try {
            this.mac = mac;
            mac.init(new SecretKeySpec(byteString.toByteArray(), string2));
            this.messageDigest = null;
            return;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
    }

    @Override
    public long read(Buffer buffer, long l2) throws IOException {
        if ((l2 = super.read(buffer, l2)) != -1L) {
            long l3;
            long l4 = l3 - l2;
            Segment segment = buffer.head;
            for (l3 = (v624533).size; l3 > l4; l3 -= (long)(segment.limit - segment.pos)) {
                segment = segment.prev;
            }
            while (l3 < buffer.size) {
                int n2 = (int)((long)segment.pos + l4 - l3);
                MessageDigest messageDigest = this.messageDigest;
                if (messageDigest != null) {
                    messageDigest.update(segment.data, n2, segment.limit - n2);
                } else {
                    this.mac.update(segment.data, n2, segment.limit - n2);
                }
                segment = segment.next;
                l4 = l3 += (long)(segment.limit - segment.pos);
            }
        }
        return l2;
    }

    public final ByteString hash() {
        MessageDigest messageDigest = this.messageDigest;
        return ByteString.of(messageDigest != null ? messageDigest.digest() : this.mac.doFinal());
    }
}

