/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import android.support.annotation.Nullable;
import dc.squareup.okio.Base64;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.Util;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class ByteString
implements Serializable,
Comparable<ByteString> {
    static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final long serialVersionUID = 1L;
    public static final ByteString EMPTY = ByteString.of(new byte[0]);
    final byte[] data;
    transient int hashCode;
    transient String utf8;

    ByteString(byte[] byArray) {
        this.data = byArray;
    }

    public static ByteString of(byte ... byArray) {
        if (byArray != null) {
            return new ByteString((byte[])byArray.clone());
        }
        throw new IllegalArgumentException("data == null");
    }

    public static ByteString of(byte[] byArray, int n2, int n3) {
        if (byArray != null) {
            long l2 = n2;
            long l3 = n3;
            Util.checkOffsetAndCount(byArray.length, l2, l3);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            return new ByteString(byArray2);
        }
        throw new IllegalArgumentException("data == null");
    }

    public static ByteString of(ByteBuffer object) {
        if (object != null) {
            ByteBuffer byteBuffer = object;
            byte[] byArray = new byte[byteBuffer.remaining()];
            object = byArray;
            byteBuffer.get(byArray);
            return new ByteString((byte[])object);
        }
        throw new IllegalArgumentException("data == null");
    }

    public static ByteString encodeUtf8(String string2) {
        if (string2 != null) {
            new ByteString(string2.getBytes(Util.UTF_8)).utf8 = string2;
            return new ByteString(string2.getBytes(Util.UTF_8));
        }
        throw new IllegalArgumentException("s == null");
    }

    public static ByteString encodeString(String string2, Charset charset) {
        if (string2 != null) {
            if (charset != null) {
                return new ByteString(string2.getBytes(charset));
            }
            throw new IllegalArgumentException("charset == null");
        }
        throw new IllegalArgumentException("s == null");
    }

    private ByteString digest(String string2) {
        try {
            return ByteString.of(MessageDigest.getInstance(string2).digest(this.data));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    private ByteString hmac(String string2, ByteString byteString) {
        Mac mac = Mac.getInstance(string2);
        try {
            mac.init(new SecretKeySpec(byteString.toByteArray(), string2));
            return ByteString.of(mac.doFinal(this.data));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    @Nullable
    public static ByteString decodeBase64(String object) {
        if (object != null) {
            ByteString byteString;
            byte[] byArray = Base64.decode((String)object);
            object = byArray;
            if (byArray != null) {
                ByteString byteString2;
                byteString = byteString2;
                byteString2 = new ByteString((byte[])object);
            } else {
                byteString = null;
            }
            return byteString;
        }
        throw new IllegalArgumentException("base64 == null");
    }

    public static ByteString decodeHex(String string2) {
        if (string2 != null) {
            if (string2.length() % 2 == 0) {
                int n2 = string2.length() / 2;
                byte[] byArray = new byte[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n3 = i2 * 2;
                    byArray[i2] = (byte)((ByteString.decodeHexDigit(string2.charAt(n3)) << 4) + ByteString.decodeHexDigit(string2.charAt(n3 + 1)));
                }
                return ByteString.of(byArray);
            }
            throw new IllegalArgumentException("Unexpected hex string: " + string2);
        }
        throw new IllegalArgumentException("hex == null");
    }

    private static int decodeHexDigit(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        throw new IllegalArgumentException("Unexpected hex digit: " + c2);
    }

    public static ByteString read(InputStream inputStream, int n2) throws IOException {
        if (inputStream != null) {
            if (n2 >= 0) {
                int n3;
                byte[] byArray = new byte[n2];
                for (int i2 = 0; i2 < n2; i2 += n3) {
                    n3 = n2 - i2;
                    if ((n3 = inputStream.read(byArray, i2, n3)) != -1) {
                        continue;
                    }
                    throw new EOFException();
                }
                return new ByteString(byArray);
            }
            throw new IllegalArgumentException("byteCount < 0: " + n2);
        }
        throw new IllegalArgumentException("in == null");
    }

    static int codePointIndexToCharIndex(String string2, int n2) {
        int n3;
        int n4 = 0;
        int n5 = string2.length();
        for (int i2 = 0; i2 < n5; i2 += Character.charCount(n3)) {
            if (n4 == n2) {
                return i2;
            }
            n3 = string2.codePointAt(i2);
            if (Character.isISOControl(n3) && n3 != 10 && n3 != 13 || n3 == 65533) {
                return -1;
            }
            ++n4;
        }
        return string2.length();
    }

    private void readObject(ObjectInputStream object) throws IOException {
        ObjectInputStream objectInputStream = object;
        object = ByteString.read(objectInputStream, objectInputStream.readInt());
        Field field = ByteString.class.getDeclaredField("data");
        try {
            field.setAccessible(true);
            field.set(this, ((ByteString)object).data);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new AssertionError();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.data.length);
        objectOutputStream.write(this.data);
    }

    public String utf8() {
        String string2 = this.utf8;
        if (string2 == null) {
            String string3;
            string2 = string3;
            string3 = new String(this.data, Util.UTF_8);
            this.utf8 = string2;
        }
        return string2;
    }

    public String string(Charset charset) {
        if (charset != null) {
            return new String(this.data, charset);
        }
        throw new IllegalArgumentException("charset == null");
    }

    public String base64() {
        return Base64.encode(this.data);
    }

    public ByteString md5() {
        return this.digest("MD5");
    }

    public ByteString sha1() {
        return this.digest("SHA-1");
    }

    public ByteString sha256() {
        return this.digest("SHA-256");
    }

    public ByteString sha512() {
        return this.digest("SHA-512");
    }

    public ByteString hmacSha1(ByteString byteString) {
        return this.hmac("HmacSHA1", byteString);
    }

    public ByteString hmacSha256(ByteString byteString) {
        return this.hmac("HmacSHA256", byteString);
    }

    public ByteString hmacSha512(ByteString byteString) {
        return this.hmac("HmacSHA512", byteString);
    }

    public String base64Url() {
        return Base64.encodeUrl(this.data);
    }

    public String hex() {
        Object object = ((ByteString)object).data;
        char[] cArray = new char[((ByteString)object).data.length * 2];
        int n2 = 0;
        int n3 = ((ByteString)object).data.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object2 = object[i2];
            int n4 = n2 + 1;
            char[] cArray2 = HEX_DIGITS;
            cArray[n2] = cArray2[object2 >> 4 & 0xF];
            n2 = n4 + 1;
            cArray[n4] = HEX_DIGITS[object2 & 0xF];
        }
        return new String(cArray);
    }

    public ByteString toAsciiLowercase() {
        int n2 = 0;
        while (true) {
            byte[] byArray = ((ByteString)object).data;
            if (n2 >= ((ByteString)object).data.length) break;
            byte by = byArray[n2];
            if (by >= 65 && by <= 90) {
                byte[] byArray2 = (byte[])byArray.clone();
                Object object = byArray2;
                byArray2[n2++] = (byte)(by - -32);
                while (n2 < ((Object)object).length) {
                    Object object2 = object[n2];
                    if (object2 >= 65 && object2 <= 90) {
                        object[n2] = (byte)(object2 - -32);
                    }
                    ++n2;
                }
                return new ByteString((byte[])object);
            }
            ++n2;
        }
        return object;
    }

    public ByteString toAsciiUppercase() {
        int n2 = 0;
        while (true) {
            byte[] byArray = ((ByteString)object).data;
            if (n2 >= ((ByteString)object).data.length) break;
            byte by = byArray[n2];
            if (by >= 97 && by <= 122) {
                byte[] byArray2 = (byte[])byArray.clone();
                Object object = byArray2;
                byArray2[n2++] = (byte)(by - 32);
                while (n2 < ((Object)object).length) {
                    Object object2 = object[n2];
                    if (object2 >= 97 && object2 <= 122) {
                        object[n2] = (byte)(object2 - 32);
                    }
                    ++n2;
                }
                return new ByteString((byte[])object);
            }
            ++n2;
        }
        return object;
    }

    public ByteString substring(int n2) {
        return this.substring(n2, this.data.length);
    }

    public ByteString substring(int n2, int n3) {
        if (n2 >= 0) {
            byte[] byArray = ((ByteString)object).data;
            if (n3 <= ((ByteString)object).data.length) {
                int n4 = n3 - n2;
                if (n4 >= 0) {
                    if (n2 == 0 && n3 == byArray.length) {
                        return object;
                    }
                    Object object = new byte[n4];
                    System.arraycopy(byArray, n2, object, 0, n4);
                    return new ByteString((byte[])object);
                }
                throw new IllegalArgumentException("endIndex < beginIndex");
            }
            throw new IllegalArgumentException("endIndex > length(" + ((ByteString)object).data.length + ")");
        }
        throw new IllegalArgumentException("beginIndex < 0");
    }

    public byte getByte(int n2) {
        return this.data[n2];
    }

    public int size() {
        return this.data.length;
    }

    public byte[] toByteArray() {
        return (byte[])this.data.clone();
    }

    byte[] internalArray() {
        return this.data;
    }

    public ByteBuffer asByteBuffer() {
        return ByteBuffer.wrap(this.data).asReadOnlyBuffer();
    }

    public void write(OutputStream outputStream) throws IOException {
        if (outputStream != null) {
            outputStream.write(this.data);
            return;
        }
        throw new IllegalArgumentException("out == null");
    }

    void write(Buffer buffer) {
        Object object = ((ByteString)object).data;
        int n2 = ((ByteString)object).data.length;
        buffer.write((byte[])object, 0, n2);
    }

    public boolean rangeEquals(int n2, ByteString byteString, int n3, int n4) {
        return byteString.rangeEquals(n3, this.data, n2, n4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean rangeEquals(int n2, byte[] byArray, int n3, int n4) {
        if (n2 < 0) return false;
        Object object = ((ByteString)object).data;
        if (n2 > ((ByteString)object).data.length - n4) return false;
        if (n3 < 0) return false;
        if (n3 > byArray.length - n4) return false;
        if (!Util.arrayRangeEquals((byte[])object, n2, byArray, n3, n4)) return false;
        return true;
    }

    public final boolean startsWith(ByteString byteString) {
        int n2 = byteString.size();
        return this.rangeEquals(0, byteString, 0, n2);
    }

    public final boolean startsWith(byte[] byArray) {
        int n2 = byArray.length;
        return this.rangeEquals(0, byArray, 0, n2);
    }

    public final boolean endsWith(ByteString byteString) {
        int n2 = this.size() - byteString.size();
        int n3 = byteString.size();
        return this.rangeEquals(n2, byteString, 0, n3);
    }

    public final boolean endsWith(byte[] byArray) {
        int n2 = this.size() - byArray.length;
        int n3 = byArray.length;
        return this.rangeEquals(n2, byArray, 0, n3);
    }

    public final int indexOf(ByteString byteString) {
        return this.indexOf(byteString.internalArray(), 0);
    }

    public final int indexOf(ByteString byteString, int n2) {
        return this.indexOf(byteString.internalArray(), n2);
    }

    public final int indexOf(byte[] byArray) {
        return this.indexOf(byArray, 0);
    }

    public int indexOf(byte[] byArray, int n2) {
        int n3 = this.data.length - byArray.length;
        for (n2 = Math.max(n2, 0); n2 <= n3; ++n2) {
            int n4 = byArray.length;
            if (!Util.arrayRangeEquals(this.data, n2, byArray, 0, n4)) continue;
            return n2;
        }
        return -1;
    }

    public final int lastIndexOf(ByteString byteString) {
        ByteString byteString2 = object;
        Object object = byteString.internalArray();
        return byteString2.lastIndexOf((byte[])object, byteString2.size());
    }

    public final int lastIndexOf(ByteString byteString, int n2) {
        return this.lastIndexOf(byteString.internalArray(), n2);
    }

    public final int lastIndexOf(byte[] byArray) {
        return this.lastIndexOf(byArray, this.size());
    }

    public int lastIndexOf(byte[] byArray, int n2) {
        for (n2 = Math.min(n2, this.data.length - byArray.length); n2 >= 0; --n2) {
            int n3 = byArray.length;
            if (!Util.arrayRangeEquals(this.data, n2, byArray, 0, n3)) continue;
            return n2;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (object == object2) {
            return true;
        }
        if (!(object instanceof ByteString)) return false;
        object = (ByteString)object;
        Object object2 = ((ByteString)object2).data;
        if (((ByteString)object).size() != ((ByteString)object2).data.length) return false;
        int n2 = ((Object)object2).length;
        if (!((ByteString)object).rangeEquals(0, (byte[])object2, 0, n2)) return false;
        return true;
    }

    public int hashCode() {
        int n2 = this.hashCode;
        if (n2 == 0) {
            this.hashCode = n2 = Arrays.hashCode(this.data);
        }
        return n2;
    }

    @Override
    public int compareTo(ByteString byteString) {
        int n2 = this.size();
        int n3 = byteString.size();
        int n4 = Math.min(n2, n3);
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5;
            int n6 = this.getByte(i2) & 0xFF;
            if (n6 == (n5 = byteString.getByte(i2) & 0xFF)) {
                continue;
            }
            return n6 < n5 ? -1 : 1;
        }
        if (n2 == n3) {
            return 0;
        }
        return n2 < n3 ? -1 : 1;
    }

    public String toString() {
        if (this.data.length == 0) {
            return "[size=0]";
        }
        String string2 = this.utf8();
        int n2 = ByteString.codePointIndexToCharIndex(string2, 64);
        if (n2 == -1) {
            return this.data.length <= 64 ? "[hex=" + this.hex() + "]" : "[size=" + this.data.length + " hex=" + this.substring(0, 64).hex() + "\u2026]";
        }
        String string3 = string2;
        string2 = string3.substring(0, n2).replace("\\", "\\\\").replace("\n", "\\n").replace("\r", "\\r");
        return n2 < string3.length() ? "[size=" + this.data.length + " text=" + string2 + "\u2026]" : "[text=" + string2 + "]";
    }
}

