/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import android.support.annotation.Nullable;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.Okio;
import dc.squareup.okio.Options;
import dc.squareup.okio.PeekSource;
import dc.squareup.okio.Segment;
import dc.squareup.okio.SegmentPool;
import dc.squareup.okio.SegmentedByteString;
import dc.squareup.okio.Sink;
import dc.squareup.okio.Source;
import dc.squareup.okio.Timeout;
import dc.squareup.okio.Util;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class Buffer
implements BufferedSource,
BufferedSink,
Cloneable,
ByteChannel {
    private static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    static final int REPLACEMENT_CHARACTER = 65533;
    @Nullable
    Segment head;
    long size;

    private void readFrom(InputStream inputStream, long l2, boolean bl) throws IOException {
        if (inputStream != null) {
            while (true) {
                if (l2 <= 0L && !bl) {
                    return;
                }
                Segment segment = this.writableSegment(1);
                int n2 = (int)Math.min(l2, (long)(8192 - segment.limit));
                byte[] byArray = segment.data;
                if ((n2 = inputStream.read(byArray, segment.limit, n2)) == -1) {
                    if (segment.pos == segment.limit) {
                        this.head = segment.pop();
                        SegmentPool.recycle(segment);
                    }
                    if (bl) {
                        return;
                    }
                    throw new EOFException();
                }
                long l3 = l2;
                segment.limit += n2;
                l2 = n2;
                this.size += l2;
                l2 = l3 - l2;
            }
        }
        throw new IllegalArgumentException("in == null");
    }

    private boolean rangeEquals(Segment segment, int n2, ByteString byteString, int n3, int n4) {
        Segment segment2 = segment;
        int n5 = segment2.limit;
        byte[] byArray = segment2.data;
        while (n3 < n4) {
            if (n2 == n5) {
                segment = segment.next;
                byArray = segment.data;
                n2 = segment.pos;
                n5 = segment.limit;
            }
            if (byArray[n2] != byteString.getByte(n3)) {
                return false;
            }
            ++n2;
            ++n3;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ByteString digest(String object) {
        Segment segment;
        Buffer buffer = this;
        object = MessageDigest.getInstance((String)object);
        Segment segment2 = buffer.head;
        if (segment2 == null) return ByteString.of(((MessageDigest)object).digest());
        Buffer buffer2 = this;
        Object object2 = object;
        Segment segment3 = segment2;
        Segment segment4 = segment3;
        byte[] byArray = segment3.data;
        int n2 = segment4.pos;
        byte[] byArray2 = byArray;
        int n3 = n2;
        int n4 = segment2.limit;
        try {
            ((MessageDigest)object2).update(byArray2, n3, n4 - n2);
            segment = buffer2.head;
            while (true) {
                segment2 = segment.next;
                break;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError();
        }
        {
            if (segment2 == this.head) return ByteString.of(((MessageDigest)object).digest());
            segment = segment2;
            Object object3 = object;
            Segment segment5 = segment2;
            Segment segment6 = segment5;
            byArray = segment5.data;
            n2 = segment6.pos;
            byte[] byArray3 = byArray;
            int n5 = n2;
            int n6 = segment2.limit;
            ((MessageDigest)object3).update(byArray3, n5, n6 - n2);
            continue;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private ByteString hmac(String var1_2, ByteString var2_3) {
        var3_4 = Mac.getInstance((String)var1_2);
        var3_4.init(new SecretKeySpec(var2_3.toByteArray(), (String)var1_2));
        var1_2 = this.head;
        if (var1_2 == null) return ByteString.of(var3_4.doFinal());
        v0 = this;
        v1 = var3_4;
        v2 = var1_2;
        var2_3 = v2.data;
        var4_5 = v2.pos;
        v3 = var2_3;
        v4 = var4_5;
        v5 = var1_2.limit;
        try {
            v1.update((byte[])v3, v4, v5 - var4_5);
            v6 = v0.head;
            ** while ((var1_2 = v6.next) != this.head)
        }
        catch (InvalidKeyException var0_1) {
            throw new IllegalArgumentException(var0_1);
        }
        catch (NoSuchAlgorithmException v12) {
            throw new AssertionError();
        }
lbl-1000:
        // 1 sources

        {
            v6 = var1_2;
            v7 = var3_4;
            v8 = var1_2;
            var2_3 = v8.data;
            var4_5 = v8.pos;
            v9 = var2_3;
            v10 = var4_5;
            v11 = var1_2.limit;
            v7.update((byte[])v9, v10, v11 - var4_5);
            continue;
        }
lbl30:
        // 1 sources

        return ByteString.of(var3_4.doFinal());
    }

    public final long size() {
        return this.size;
    }

    @Override
    public Buffer buffer() {
        return this;
    }

    @Override
    public Buffer getBuffer() {
        return this;
    }

    @Override
    public OutputStream outputStream() {
        return new OutputStream(){

            @Override
            public void write(int n2) {
                Buffer.this.writeByte((byte)n2);
            }

            @Override
            public void write(byte[] byArray, int n2, int n3) {
                Buffer.this.write(byArray, n2, n3);
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }

            public String toString() {
                return Buffer.this + ".outputStream()";
            }
        };
    }

    @Override
    public Buffer emitCompleteSegments() {
        return this;
    }

    @Override
    public BufferedSink emit() {
        return this;
    }

    @Override
    public boolean exhausted() {
        return this.size == 0L;
    }

    @Override
    public void require(long l2) throws EOFException {
        if (this.size >= l2) {
            return;
        }
        throw new EOFException();
    }

    @Override
    public boolean request(long l2) {
        return this.size >= l2;
    }

    @Override
    public BufferedSource peek() {
        return Okio.buffer(new PeekSource(this));
    }

    @Override
    public InputStream inputStream() {
        return new InputStream(){

            @Override
            public int read() {
                Closeable closeable = closeable.Buffer.this;
                if (((Buffer)closeable).size > 0L) {
                    return ((Buffer)closeable).readByte() & 0xFF;
                }
                return -1;
            }

            @Override
            public int read(byte[] byArray, int n2, int n3) {
                return Buffer.this.read(byArray, n2, n3);
            }

            @Override
            public int available() {
                return (int)Math.min(Buffer.this.size, Integer.MAX_VALUE);
            }

            @Override
            public void close() {
            }

            public String toString() {
                return Buffer.this + ".inputStream()";
            }
        };
    }

    public final Buffer copyTo(OutputStream outputStream) throws IOException {
        long l2 = this.size;
        return this.copyTo(outputStream, 0L, l2);
    }

    public final Buffer copyTo(OutputStream outputStream, long l2, long l3) throws IOException {
        if (outputStream != null) {
            int n2;
            int n3;
            Util.checkOffsetAndCount(this.size, l2, l3);
            if (l3 == 0L) {
                return this;
            }
            Segment segment = this.head;
            while (l2 >= (long)((n3 = segment.limit) - (n2 = segment.pos))) {
                l2 -= (long)(n3 - n2);
                segment = segment.next;
            }
            while (l3 > 0L) {
                Segment segment2 = segment;
                int n4 = (int)((long)segment2.pos + l2);
                int n5 = (int)Math.min((long)(segment2.limit - n4), l3);
                outputStream.write(segment2.data, n4, n5);
                l3 -= (long)n5;
                l2 = 0L;
                segment = segment.next;
            }
            return this;
        }
        throw new IllegalArgumentException("out == null");
    }

    public final Buffer copyTo(Buffer buffer, long l2, long l3) {
        if (buffer != null) {
            int n2;
            int n3;
            Util.checkOffsetAndCount(this.size, l2, l3);
            if (l3 == 0L) {
                return this;
            }
            buffer.size += l3;
            Segment segment = this.head;
            while (l2 >= (long)((n3 = segment.limit) - (n2 = segment.pos))) {
                l2 -= (long)(n3 - n2);
                segment = segment.next;
            }
            while (l3 > 0L) {
                int n4;
                Segment segment2 = segment.sharedCopy();
                segment2.pos = n4 = (int)((long)segment2.pos + l2);
                segment2.limit = Math.min(n4 + (int)l3, segment2.limit);
                Segment segment3 = buffer.head;
                if (segment3 == null) {
                    segment2.prev = segment2;
                    segment2.next = segment2;
                    buffer.head = segment2;
                } else {
                    segment3.prev.push(segment2);
                }
                l3 -= (long)(segment2.limit - segment2.pos);
                l2 = 0L;
                segment = segment.next;
            }
            return this;
        }
        throw new IllegalArgumentException("out == null");
    }

    public final Buffer writeTo(OutputStream outputStream) throws IOException {
        return this.writeTo(outputStream, this.size);
    }

    public final Buffer writeTo(OutputStream outputStream, long l2) throws IOException {
        if (outputStream != null) {
            Buffer buffer = this;
            Util.checkOffsetAndCount(buffer.size, 0L, l2);
            Segment segment = buffer.head;
            while (l2 > 0L) {
                Segment segment2 = segment;
                int n2 = (int)Math.min(l2, (long)(segment.limit - segment.pos));
                byte[] byArray = segment2.data;
                outputStream.write(byArray, segment2.pos, n2);
                int n3 = segment.pos + n2;
                long l3 = l2;
                segment.pos = n3;
                l2 = n2;
                this.size -= l2;
                l2 = l3 - l2;
                if (n3 != segment.limit) continue;
                Segment segment3 = segment;
                this.head = segment = segment.pop();
                SegmentPool.recycle(segment3);
            }
            return this;
        }
        throw new IllegalArgumentException("out == null");
    }

    public final Buffer readFrom(InputStream inputStream) throws IOException {
        Buffer buffer = this;
        buffer.readFrom(inputStream, Long.MAX_VALUE, true);
        return buffer;
    }

    public final Buffer readFrom(InputStream inputStream, long l2) throws IOException {
        if (l2 >= 0L) {
            Buffer buffer = this;
            buffer.readFrom(inputStream, l2, false);
            return buffer;
        }
        throw new IllegalArgumentException("byteCount < 0: " + l2);
    }

    public final long completeSegmentByteCount() {
        long l2 = ((Buffer)((Object)segment)).size;
        if (l2 == 0L) {
            return 0L;
        }
        Segment segment = ((Buffer)((Object)segment)).head.prev;
        int n2 = segment.limit;
        if (n2 < 8192 && segment.owner) {
            l2 -= (long)(n2 - segment.pos);
        }
        return l2;
    }

    @Override
    public byte readByte() {
        long l2 = this.size;
        if (l2 != 0L) {
            Segment segment = this.head;
            int n2 = segment.pos;
            int n3 = segment.limit;
            byte[] byArray = segment.data;
            int n4 = n2 + 1;
            byte by = byArray[n2];
            this.size = l2 - 1L;
            if (n4 == n3) {
                this.head = segment.pop();
                SegmentPool.recycle(segment);
            } else {
                segment.pos = n4;
            }
            return by;
        }
        throw new IllegalStateException("size == 0");
    }

    public final byte getByte(long l2) {
        Buffer buffer = object;
        Util.checkOffsetAndCount(buffer.size, l2, 1L);
        long l3 = buffer.size;
        if (l3 - l2 > l2) {
            Object object = ((Buffer)object).head;
            while (true) {
                int n2;
                long l4;
                if (l2 < (l4 = (long)(((Segment)object).limit - (n2 = ((Segment)object).pos)))) {
                    return ((Segment)object).data[n2 + (int)l2];
                }
                l2 -= l4;
                object = ((Segment)object).next;
            }
        }
        long l5 = l2 - l3;
        Segment segment = ((Buffer)object).head.prev;
        int n3;
        while ((l3 = l5 + (long)(segment.limit - (n3 = segment.pos))) < 0L) {
            segment = segment.prev;
            l5 = l3;
        }
        return segment.data[n3 + (int)l3];
    }

    @Override
    public short readShort() {
        long l2 = this.size;
        if (l2 >= 2L) {
            Segment segment = this.head;
            int n2 = segment.limit;
            int n3 = segment.pos;
            if (n2 - n3 < 2) {
                return (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
            }
            byte[] byArray = segment.data;
            int n4 = (segment.data[n3++] & 0xFF) << 8;
            int n5 = n3 + 1;
            int n6 = n4 | byArray[n3] & 0xFF;
            this.size = l2 - 2L;
            if (n5 == n2) {
                this.head = segment.pop();
                SegmentPool.recycle(segment);
            } else {
                segment.pos = n5;
            }
            return (short)n6;
        }
        throw new IllegalStateException("size < 2: " + this.size);
    }

    @Override
    public int readInt() {
        long l2 = this.size;
        if (l2 >= 4L) {
            Segment segment = this.head;
            int n2 = segment.limit;
            int n3 = segment.pos;
            if (n2 - n3 < 4) {
                return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
            }
            byte[] byArray = segment.data;
            int n4 = (segment.data[n3++] & 0xFF) << 24 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 8;
            int n5 = n3 + 1;
            int n6 = n4 | byArray[n3] & 0xFF;
            this.size = l2 - 4L;
            if (n5 == n2) {
                this.head = segment.pop();
                SegmentPool.recycle(segment);
            } else {
                segment.pos = n5;
            }
            return n6;
        }
        throw new IllegalStateException("size < 4: " + this.size);
    }

    @Override
    public long readLong() {
        long l2 = this.size;
        if (l2 >= 8L) {
            Segment segment = this.head;
            int n2 = segment.limit;
            int n3 = segment.pos;
            if (n2 - n3 < 8) {
                return ((long)this.readInt() & 0xFFFFFFFFL) << 32 | (long)this.readInt() & 0xFFFFFFFFL;
            }
            byte[] byArray = segment.data;
            long l3 = ((long)segment.data[n3++] & 0xFFL) << 56 | ((long)byArray[n3++] & 0xFFL) << 48 | ((long)byArray[n3++] & 0xFFL) << 40 | ((long)byArray[n3++] & 0xFFL) << 32 | ((long)byArray[n3++] & 0xFFL) << 24 | ((long)byArray[n3++] & 0xFFL) << 16 | ((long)byArray[n3++] & 0xFFL) << 8;
            int n4 = n3 + 1;
            long l4 = l2;
            l2 = l3 | (long)byArray[n3] & 0xFFL;
            this.size = l4 - 8L;
            if (n4 == n2) {
                this.head = segment.pop();
                SegmentPool.recycle(segment);
            } else {
                segment.pos = n4;
            }
            return l2;
        }
        throw new IllegalStateException("size < 8: " + this.size);
    }

    @Override
    public short readShortLe() {
        return Util.reverseBytesShort(this.readShort());
    }

    @Override
    public int readIntLe() {
        return Util.reverseBytesInt(this.readInt());
    }

    @Override
    public long readLongLe() {
        return Util.reverseBytesLong(this.readLong());
    }

    @Override
    public long readDecimalLong() {
        block9: {
            if (buffer2.size == 0L) break block9;
            long l2 = 0L;
            int n2 = 0;
            boolean bl = false;
            boolean bl2 = false;
            long l3 = -922337203685477580L;
            long l4 = -7L;
            do {
                Segment segment = buffer2.head;
                byte[] byArray = segment.data;
                int n3 = segment.pos;
                int n4 = segment.limit;
                while (n3 < n4) {
                    byte by;
                    block13: {
                        block12: {
                            block10: {
                                Buffer buffer;
                                block11: {
                                    by = byArray[n3];
                                    if (by < 48 || by > 57) break block10;
                                    int n5 = 48 - by;
                                    long l5 = l2 == l3 ? 0 : (l2 < l3 ? -1 : 1);
                                    if (l5 < 0 || l5 == false && (long)n5 < l4) break block11;
                                    l2 = l2 * 10L + (long)n5;
                                    break block12;
                                }
                                Buffer buffer2 = buffer;
                                buffer2();
                                buffer2 = buffer.writeDecimalLong(l2).writeByte(by);
                                if (!bl) {
                                    buffer2.readByte();
                                }
                                throw new NumberFormatException("Number too large: " + buffer2.readUtf8());
                            }
                            if (by != 45 || n2 != 0) break block13;
                            bl = true;
                            --l4;
                        }
                        ++n3;
                        ++n2;
                        continue;
                    }
                    if (n2 != 0) {
                        bl2 = true;
                        break;
                    }
                    throw new NumberFormatException("Expected leading [0-9] or '-' character but was 0x" + Integer.toHexString(by));
                }
                if (n3 == n4) {
                    buffer2.head = segment.pop();
                    SegmentPool.recycle(segment);
                    continue;
                }
                segment.pos = n3;
            } while (!bl2 && buffer2.head != null);
            buffer2.size -= (long)n2;
            if (!bl) {
                l2 = -l2;
            }
            return l2;
        }
        throw new IllegalStateException("size == 0");
    }

    @Override
    public long readHexadecimalUnsignedLong() {
        block8: {
            if (buffer2.size == 0L) break block8;
            long l2 = 0L;
            int n2 = 0;
            boolean bl = false;
            do {
                Segment segment = buffer2.head;
                byte[] byArray = segment.data;
                int n3 = segment.pos;
                int n4 = segment.limit;
                while (n3 < n4) {
                    byte by;
                    block12: {
                        Buffer buffer;
                        int n5;
                        block10: {
                            block11: {
                                block9: {
                                    by = byArray[n3];
                                    if (by < 48 || by > 57) break block9;
                                    n5 = by - 48;
                                    break block10;
                                }
                                if (by < 97 || by > 102) break block11;
                                n5 = by - 97 + 10;
                                break block10;
                            }
                            if (by < 65 || by > 70) break block12;
                            n5 = by - 65 + 10;
                        }
                        if ((l2 & 0xF000000000000000L) == 0L) {
                            l2 = l2 << 4 | (long)n5;
                            ++n3;
                            ++n2;
                            continue;
                        }
                        Buffer buffer2 = buffer;
                        buffer2();
                        buffer2 = buffer.writeHexadecimalUnsignedLong(l2).writeByte(by);
                        throw new NumberFormatException("Number too large: " + buffer2.readUtf8());
                    }
                    if (n2 != 0) {
                        bl = true;
                        break;
                    }
                    throw new NumberFormatException("Expected leading [0-9a-fA-F] character but was 0x" + Integer.toHexString(by));
                }
                if (n3 == n4) {
                    buffer2.head = segment.pop();
                    SegmentPool.recycle(segment);
                    continue;
                }
                segment.pos = n3;
            } while (!bl && buffer2.head != null);
            buffer2.size -= (long)n2;
            return l2;
        }
        throw new IllegalStateException("size == 0");
    }

    @Override
    public ByteString readByteString() {
        return new ByteString(this.readByteArray());
    }

    @Override
    public ByteString readByteString(long l2) throws EOFException {
        return new ByteString(this.readByteArray(l2));
    }

    @Override
    public int select(Options options) {
        int n2 = this.selectPrefix(options, false);
        if (n2 == -1) {
            return -1;
        }
        try {
            this.skip(options.byteStrings[n2].size());
            return n2;
        }
        catch (EOFException eOFException) {
            throw new AssertionError();
        }
    }

    /*
     * Unable to fully structure code
     */
    int selectPrefix(Options var1_1, boolean var2_2) {
        this = this.head;
        if (this == null) {
            if (var2_2) {
                return -2;
            }
            return var1_1.indexOf(ByteString.EMPTY);
        }
        v0 = var1_1;
        v1 = this;
        var1_1 = v1.data;
        var3_3 = v1.pos;
        var4_4 = v1.limit;
        var5_5 = v0.trie;
        var6_6 = 0;
        var7_7 = -1;
        var8_8 = this;
        block0: while (true) {
            block18: {
                var9_9 = var6_6 + 1;
                var6_6 = var5_5[var6_6];
                var10_10 = var9_9 + 1;
                if ((var9_9 = var5_5[var9_9]) == -1) {
                    var9_9 = var7_7;
                }
                if (var8_8 == null) ** GOTO lbl35
                if (var6_6 >= 0) break block18;
                var7_7 = var10_10 + var6_6 * -1;
                do {
                    block19: {
                        if ((var1_1[var3_3++] & 255) != var5_5[var10_10++]) {
                            return var9_9;
                        }
                        var6_6 = var10_10 == var7_7 ? 1 : 0;
                        if (var3_3 != var4_4) continue;
                        var8_8 = var8_8.next;
                        var3_3 = var8_8.pos;
                        var1_1 = var8_8.data;
                        var4_4 = var8_8.limit;
                        if (var8_8 != this) continue;
                        if (var6_6 != 0) break block19;
lbl35:
                        // 2 sources

                        if (var2_2) {
                            return -2;
                        }
                        return var9_9;
                    }
                    var8_8 = null;
                } while (var6_6 == 0);
                var6_6 = var5_5[var10_10];
                ** GOTO lbl58
            }
            var7_7 = var1_1[var3_3++] & 255;
            var11_11 = var10_10 + var6_6;
            while (true) {
                block20: {
                    if (var10_10 == var11_11) {
                        return var9_9;
                    }
                    if (var7_7 != var5_5[var10_10]) break block20;
                    var6_6 = var5_5[var10_10 + var6_6];
                    if (var3_3 == var4_4) {
                        var8_8 = var8_8.next;
                        var3_3 = var8_8.pos;
                        var1_1 = var8_8.data;
                        var4_4 = var8_8.limit;
                        if (var8_8 == this) {
                            var8_8 = null;
                        }
                    }
lbl58:
                    // 6 sources

                    if (var6_6 >= 0) {
                        return var6_6;
                    }
                    var6_6 = -var6_6;
                    var7_7 = var9_9;
                    continue block0;
                }
                ++var10_10;
            }
            break;
        }
    }

    @Override
    public void readFully(Buffer buffer, long l2) throws EOFException {
        long l3 = this.size;
        if (l3 >= l2) {
            buffer.write(this, l2);
            return;
        }
        buffer.write(this, l3);
        throw new EOFException();
    }

    @Override
    public long readAll(Sink sink) throws IOException {
        long l2 = this.size;
        if (l2 > 0L) {
            sink.write(this, l2);
        }
        return l2;
    }

    @Override
    public String readUtf8() {
        try {
            Buffer buffer = this;
            return buffer.readString(buffer.size, Util.UTF_8);
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public String readUtf8(long l2) throws EOFException {
        return this.readString(l2, Util.UTF_8);
    }

    @Override
    public String readString(Charset charset) {
        try {
            Buffer buffer = this;
            return buffer.readString(buffer.size, charset);
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public String readString(long l2, Charset charset) throws EOFException {
        Util.checkOffsetAndCount(this.size, 0L, l2);
        if (charset != null) {
            if (l2 <= Integer.MAX_VALUE) {
                int n2;
                String string2;
                if (l2 == 0L) {
                    return "";
                }
                Segment segment = this.head;
                if ((long)segment.pos + l2 > (long)segment.limit) {
                    return new String(this.readByteArray(l2), charset);
                }
                String string3 = string2;
                Segment segment2 = segment;
                byte[] byArray = segment2.data;
                int n3 = segment2.pos;
                int n4 = (int)l2;
                string2 = new String(byArray, n3, n4, charset);
                segment.pos = n2 = (int)((long)segment.pos + l2);
                this.size -= l2;
                if (n2 == segment.limit) {
                    this.head = segment.pop();
                    SegmentPool.recycle(segment);
                }
                return string3;
            }
            throw new IllegalArgumentException("byteCount > Integer.MAX_VALUE: " + l2);
        }
        throw new IllegalArgumentException("charset == null");
    }

    @Override
    @Nullable
    public String readUtf8Line() throws EOFException {
        long l2 = this.indexOf((byte)10);
        if (l2 == -1L) {
            l2 = this.size;
            return l2 != 0L ? this.readUtf8(l2) : null;
        }
        return this.readUtf8Line(l2);
    }

    @Override
    public String readUtf8LineStrict() throws EOFException {
        return this.readUtf8LineStrict(Long.MAX_VALUE);
    }

    @Override
    public String readUtf8LineStrict(long l2) throws EOFException {
        if (l2 >= 0L) {
            Buffer buffer;
            long l3 = l2 == Long.MAX_VALUE ? Long.MAX_VALUE : l2 + 1L;
            long l4 = this.indexOf((byte)10, 0L, l3);
            if (l4 != -1L) {
                return this.readUtf8Line(l4);
            }
            if (l3 < this.size() && this.getByte(l3 - 1L) == 13 && this.getByte(l3) == 10) {
                return this.readUtf8Line(l3);
            }
            Buffer buffer2 = this;
            Buffer buffer3 = buffer;
            buffer = new Buffer();
            long l5 = buffer2.size();
            l5 = Math.min(32L, l5);
            buffer2.copyTo(buffer3, 0L, l5);
            throw new EOFException("\\n not found: limit=" + Math.min(this.size(), l2) + " content=" + buffer3.readByteString().hex() + '\u2026');
        }
        throw new IllegalArgumentException("limit < 0: " + l2);
    }

    String readUtf8Line(long l2) throws EOFException {
        long l3;
        if (l2 > 0L && this.getByte(l3 = l2 - 1L) == 13) {
            String string2 = this.readUtf8(l3);
            this.skip(2L);
            return string2;
        }
        String string3 = this.readUtf8(l2);
        this.skip(1L);
        return string3;
    }

    @Override
    public int readUtf8CodePoint() throws EOFException {
        block9: {
            block14: {
                int n2;
                int n3;
                int n4;
                int n5;
                block11: {
                    block13: {
                        block12: {
                            block10: {
                                if (this.size == 0L) break block9;
                                n5 = this.getByte(0L);
                                if ((n5 & 0x80) != 0) break block10;
                                n4 = n5 & 0x7F;
                                n3 = 1;
                                n2 = 0;
                                break block11;
                            }
                            if ((n5 & 0xE0) != 192) break block12;
                            n4 = n5 & 0x1F;
                            n3 = 2;
                            n2 = 128;
                            break block11;
                        }
                        if ((n5 & 0xF0) != 224) break block13;
                        n4 = n5 & 0xF;
                        n3 = 3;
                        n2 = 2048;
                        break block11;
                    }
                    if ((n5 & 0xF8) != 240) break block14;
                    n4 = n5 & 7;
                    n3 = 4;
                    n2 = 65536;
                }
                long l2 = n3;
                if (this.size >= l2) {
                    for (n5 = 1; n5 < n3; ++n5) {
                        long l3 = n5;
                        byte by = this.getByte(l3);
                        if ((by & 0xC0) == 128) {
                            n4 = n4 << 6 | by & 0x3F;
                            continue;
                        }
                        this.skip(l3);
                        return 65533;
                    }
                    this.skip(l2);
                    if (n4 > 0x10FFFF) {
                        return 65533;
                    }
                    if (n4 >= 55296 && n4 <= 57343) {
                        return 65533;
                    }
                    if (n4 < n2) {
                        return 65533;
                    }
                    return n4;
                }
                throw new EOFException("size < " + n3 + ": " + this.size + " (to read code point prefixed 0x" + Integer.toHexString(n5) + ")");
            }
            this.skip(1L);
            return 65533;
        }
        throw new EOFException();
    }

    @Override
    public byte[] readByteArray() {
        try {
            Buffer buffer = this;
            return buffer.readByteArray(buffer.size);
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public byte[] readByteArray(long l2) throws EOFException {
        Util.checkOffsetAndCount(this.size, 0L, l2);
        if (l2 <= Integer.MAX_VALUE) {
            byte[] byArray = new byte[(int)l2];
            this.readFully(byArray);
            return byArray;
        }
        throw new IllegalArgumentException("byteCount > Integer.MAX_VALUE: " + l2);
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray) throws EOFException {
        int n2;
        for (int i2 = 0; i2 < byArray.length; i2 += n2) {
            n2 = this.read(byArray, i2, byArray.length - i2);
            if (n2 != -1) {
                continue;
            }
            throw new EOFException();
        }
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        int n4;
        long l2 = n2;
        long l3 = n3;
        Util.checkOffsetAndCount(byArray.length, l2, l3);
        Segment segment = this.head;
        if (segment == null) {
            return -1;
        }
        Segment segment2 = segment;
        n3 = Math.min(n3, segment.limit - segment.pos);
        System.arraycopy(segment2.data, segment.pos, byArray, n2, n3);
        segment.pos = n4 = segment2.pos + n3;
        this.size -= (long)n3;
        if (n4 == segment.limit) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        }
        return n3;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n2;
        Segment segment = this.head;
        if (segment == null) {
            return -1;
        }
        Segment segment2 = segment;
        int n3 = Math.min(byteBuffer.remaining(), segment.limit - segment.pos);
        byte[] byArray = segment2.data;
        byteBuffer.put(byArray, segment2.pos, n3);
        segment.pos = n2 = segment.pos + n3;
        this.size -= (long)n3;
        if (n2 == segment.limit) {
            this.head = segment.pop();
            SegmentPool.recycle(segment);
        }
        return n3;
    }

    public final void clear() {
        try {
            Buffer buffer = this;
            buffer.skip(buffer.size);
            return;
        }
        catch (EOFException eOFException) {
            throw new AssertionError((Object)eOFException);
        }
    }

    @Override
    public void skip(long l2) throws EOFException {
        while (l2 > 0L) {
            Segment segment = this.head;
            if (segment != null) {
                int n2 = (int)Math.min(l2, (long)(segment.limit - segment.pos));
                long l3 = n2;
                this.size -= l3;
                l3 = l2 - l3;
                Segment segment2 = this.head;
                segment2.pos = n2 = segment2.pos + n2;
                if (n2 == segment2.limit) {
                    this.head = segment2.pop();
                    SegmentPool.recycle(segment2);
                }
                l2 = l3;
                continue;
            }
            throw new EOFException();
        }
    }

    @Override
    public Buffer write(ByteString byteString) {
        if (byteString != null) {
            byteString.write(this);
            return this;
        }
        throw new IllegalArgumentException("byteString == null");
    }

    @Override
    public Buffer writeUtf8(String string2) {
        String string3 = string2;
        return this.writeUtf8(string3, 0, string3.length());
    }

    @Override
    public Buffer writeUtf8(String string2, int n2, int n3) {
        if (string2 != null) {
            if (n2 >= 0) {
                if (n3 >= n2) {
                    if (n3 <= string2.length()) {
                        while (n2 < n3) {
                            int n4 = string2.charAt(n2);
                            if (n4 < 128) {
                                Segment segment = this.writableSegment(1);
                                byte[] byArray = segment.data;
                                int n5 = n4;
                                n4 = segment.limit - n2;
                                int n6 = Math.min(n3, 8192 - n4);
                                int n7 = n4 + n2++;
                                segment.data[n7] = (byte)n5;
                                while (n2 < n6) {
                                    char c2 = string2.charAt(n2);
                                    n7 = c2;
                                    if (c2 >= '\u0080') break;
                                    int n8 = n7;
                                    n7 = n2 + 1;
                                    n2 = n4 + n2;
                                    byArray[n2] = (byte)n8;
                                    n2 = n7;
                                }
                                n4 = n2 + n4;
                                int n9 = segment.limit;
                                segment.limit = n9 + (n4 -= n9);
                                this.size += (long)n4;
                                continue;
                            }
                            if (n4 < 2048) {
                                this.writeByte(n4 >> 6 | 0xC0);
                                this.writeByte(n4 & 0x3F | 0x80);
                                ++n2;
                                continue;
                            }
                            if (n4 >= 55296 && n4 <= 57343) {
                                int n10 = n2 + 1;
                                char c3 = n10 < n3 ? string2.charAt(n10) : (char)'\u0000';
                                if (n4 <= 56319 && c3 >= '\udc00' && c3 <= '\udfff') {
                                    n4 = ((n4 & 0xFFFF27FF) << 10 | c3 & 0xFFFF23FF) + 65536;
                                    this.writeByte(n4 >> 18 | 0xF0);
                                    this.writeByte(n4 >> 12 & 0x3F | 0x80);
                                    this.writeByte(n4 >> 6 & 0x3F | 0x80);
                                    this.writeByte(n4 & 0x3F | 0x80);
                                    n2 += 2;
                                    continue;
                                }
                                this.writeByte(63);
                                n2 = n10;
                                continue;
                            }
                            this.writeByte(n4 >> 12 | 0xE0);
                            this.writeByte(n4 >> 6 & 0x3F | 0x80);
                            this.writeByte(n4 & 0x3F | 0x80);
                            ++n2;
                        }
                        return this;
                    }
                    throw new IllegalArgumentException("endIndex > string.length: " + n3 + " > " + string2.length());
                }
                throw new IllegalArgumentException("endIndex < beginIndex: " + n3 + " < " + n2);
            }
            throw new IllegalArgumentException("beginIndex < 0: " + n2);
        }
        throw new IllegalArgumentException("string == null");
    }

    @Override
    public Buffer writeUtf8CodePoint(int n2) {
        block9: {
            block6: {
                block8: {
                    block7: {
                        block5: {
                            if (n2 >= 128) break block5;
                            this.writeByte(n2);
                            break block6;
                        }
                        if (n2 >= 2048) break block7;
                        this.writeByte(n2 >> 6 | 0xC0);
                        this.writeByte(n2 & 0x3F | 0x80);
                        break block6;
                    }
                    if (n2 >= 65536) break block8;
                    if (n2 >= 55296 && n2 <= 57343) {
                        this.writeByte(63);
                    } else {
                        this.writeByte(n2 >> 12 | 0xE0);
                        this.writeByte(n2 >> 6 & 0x3F | 0x80);
                        this.writeByte(n2 & 0x3F | 0x80);
                    }
                    break block6;
                }
                if (n2 > 0x10FFFF) break block9;
                this.writeByte(n2 >> 18 | 0xF0);
                this.writeByte(n2 >> 12 & 0x3F | 0x80);
                this.writeByte(n2 >> 6 & 0x3F | 0x80);
                this.writeByte(n2 & 0x3F | 0x80);
            }
            return this;
        }
        throw new IllegalArgumentException("Unexpected code point: " + Integer.toHexString(n2));
    }

    @Override
    public Buffer writeString(String string2, Charset charset) {
        String string3 = string2;
        return this.writeString(string3, 0, string3.length(), charset);
    }

    @Override
    public Buffer writeString(String string2, int n2, int n3, Charset charset) {
        if (string2 != null) {
            if (n2 >= 0) {
                if (n3 >= n2) {
                    if (n3 <= string2.length()) {
                        if (charset != null) {
                            if (charset.equals(Util.UTF_8)) {
                                return this.writeUtf8(string2, n2, n3);
                            }
                            byte[] byArray = string2.substring(n2, n3).getBytes(charset);
                            return this.write(byArray, 0, byArray.length);
                        }
                        throw new IllegalArgumentException("charset == null");
                    }
                    throw new IllegalArgumentException("endIndex > string.length: " + n3 + " > " + string2.length());
                }
                throw new IllegalArgumentException("endIndex < beginIndex: " + n3 + " < " + n2);
            }
            throw new IllegalAccessError("beginIndex < 0: " + n2);
        }
        throw new IllegalArgumentException("string == null");
    }

    @Override
    public Buffer write(byte[] byArray) {
        if (byArray != null) {
            return this.write(byArray, 0, byArray.length);
        }
        throw new IllegalArgumentException("source == null");
    }

    @Override
    public Buffer write(byte[] byArray, int n2, int n3) {
        if (byArray != null) {
            long l2 = n2;
            long l3 = n3;
            Util.checkOffsetAndCount(byArray.length, l2, l3);
            n3 = n2 + n3;
            while (n2 < n3) {
                Segment segment = this.writableSegment(1);
                Object object = segment;
                int n4 = n2;
                int n5 = n2;
                Segment segment2 = object;
                n2 = Math.min(n3 - n2, 8192 - ((Segment)object).limit);
                object = segment2.data;
                System.arraycopy(byArray, n5, object, segment2.limit, n2);
                int n6 = n4 + n2;
                segment.limit += n2;
                n2 = n6;
            }
            Buffer buffer = this;
            buffer.size += l3;
            return buffer;
        }
        throw new IllegalArgumentException("source == null");
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (byteBuffer != null) {
            int n2;
            int n3 = n2 = byteBuffer.remaining();
            while (n3 > 0) {
                Segment segment = this.writableSegment(1);
                Object object = segment;
                int n4 = n3;
                Segment segment2 = object;
                n3 = Math.min(n3, 8192 - ((Segment)object).limit);
                object = segment2.data;
                byteBuffer.get((byte[])object, segment2.limit, n3);
                int n5 = n4 - n3;
                segment.limit += n3;
                n3 = n5;
            }
            this.size += (long)n2;
            return n2;
        }
        throw new IllegalArgumentException("source == null");
    }

    @Override
    public long writeAll(Source source) throws IOException {
        if (source != null) {
            long l2;
            long l3 = 0L;
            while ((l2 = source.read(this, 8192L)) != -1L) {
                l3 += l2;
            }
            return l3;
        }
        throw new IllegalArgumentException("source == null");
    }

    @Override
    public BufferedSink write(Source source, long l2) throws IOException {
        while (l2 > 0L) {
            long l3 = source.read(this, l2);
            if (l3 != -1L) {
                l2 -= l3;
                continue;
            }
            throw new EOFException();
        }
        return this;
    }

    @Override
    public Buffer writeByte(int n2) {
        Buffer buffer = segment;
        Segment segment = buffer.writableSegment(1);
        int n3 = segment.limit;
        segment.limit = n3 + 1;
        segment.data[n3] = (byte)n2;
        ++buffer.size;
        return buffer;
    }

    @Override
    public Buffer writeShort(int n2) {
        Buffer buffer = segment;
        Segment segment = buffer.writableSegment(2);
        int n3 = n2;
        int n4 = segment.limit;
        n2 = n4 + 1;
        segment.data[n4] = (byte)(n3 >>> 8 & 0xFF);
        n4 = n2 + 1;
        segment.data[n2] = (byte)(n2 & 0xFF);
        segment.limit = n4;
        buffer.size += 2L;
        return buffer;
    }

    @Override
    public Buffer writeShortLe(int n2) {
        return this.writeShort(Util.reverseBytesShort((short)n2));
    }

    @Override
    public Buffer writeInt(int n2) {
        Buffer buffer = segment;
        Segment segment = buffer.writableSegment(4);
        byte[] byArray = segment.data;
        int n3 = n2;
        int n4 = n2;
        int n5 = n2;
        int n6 = n2;
        int n7 = segment.limit;
        n2 = n7 + 1;
        byArray[n7] = (byte)(n6 >>> 24 & 0xFF);
        n7 = n2 + 1;
        byArray[n2] = (byte)(n5 >>> 16 & 0xFF);
        n2 = n7 + 1;
        byArray[n7] = (byte)(n4 >>> 8 & 0xFF);
        n7 = n2 + 1;
        segment.data[n2] = (byte)(n3 & 0xFF);
        segment.limit = n7;
        buffer.size += 4L;
        return buffer;
    }

    @Override
    public Buffer writeIntLe(int n2) {
        return this.writeInt(Util.reverseBytesInt(n2));
    }

    @Override
    public Buffer writeLong(long l2) {
        Buffer buffer = segment;
        Segment segment = buffer.writableSegment(8);
        byte[] byArray = segment.data;
        int n2 = segment.limit;
        int n3 = n2 + 1;
        byArray[n2] = (byte)(l2 >>> 56 & 0xFFL);
        n2 = n3 + 1;
        byArray[n3] = (byte)(l2 >>> 48 & 0xFFL);
        n3 = n2 + 1;
        byArray[n2] = (byte)(l2 >>> 40 & 0xFFL);
        n2 = n3 + 1;
        byArray[n3] = (byte)(l2 >>> 32 & 0xFFL);
        n3 = n2 + 1;
        byArray[n2] = (byte)(l2 >>> 24 & 0xFFL);
        n2 = n3 + 1;
        byArray[n3] = (byte)(l2 >>> 16 & 0xFFL);
        n3 = n2 + 1;
        byArray[n2] = (byte)(l2 >>> 8 & 0xFFL);
        n2 = n3 + 1;
        segment.data[n3] = (byte)(l2 & 0xFFL);
        segment.limit = n2;
        buffer.size += 8L;
        return buffer;
    }

    @Override
    public Buffer writeLongLe(long l2) {
        return this.writeLong(Util.reverseBytesLong(l2));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Buffer writeDecimalLong(long l2) {
        int n2;
        long l3 = l2 - 0L;
        long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
        if (l4 == false) {
            return this.writeByte(48);
        }
        long l5 = l4;
        l4 = 0;
        if (l5 < 0) {
            if ((l2 = -l2) < 0L) {
                return this.writeUtf8("-9223372036854775808");
            }
            l4 = 1;
        }
        int n3 = l2 < 100000000L ? (l2 < 10000L ? (l2 < 100L ? (l2 < 10L ? 1 : 2) : (l2 < 1000L ? 3 : 4)) : (l2 < 1000000L ? (l2 < 100000L ? 5 : 6) : (l2 < 10000000L ? 7 : 8))) : (l2 < 1000000000000L ? (l2 < 10000000000L ? (l2 < 1000000000L ? 9 : 10) : (l2 < 100000000000L ? 11 : 12)) : (l2 < 1000000000000000L ? (l2 < 10000000000000L ? 13 : (l2 < 100000000000000L ? 14 : 15)) : (l2 < 100000000000000000L ? (l2 < 10000000000000000L ? 16 : 17) : (n2 = l2 < 1000000000000000000L ? 18 : 19))));
        if (l4 != false) {
            ++n2;
        }
        Segment segment = this.writableSegment(n2);
        byte[] byArray = segment.data;
        int n4 = segment.limit + n2;
        while (l2 != 0L) {
            int n5 = (int)(l2 % 10L);
            byArray[n4 += -1] = DIGITS[n5];
            l2 /= 10L;
        }
        if (l4 != false) {
            byArray[n4 + -1] = 45;
        }
        Buffer buffer = this;
        segment.limit += n2;
        buffer.size += (long)n2;
        return buffer;
    }

    @Override
    public Buffer writeHexadecimalUnsignedLong(long l2) {
        if (l2 == 0L) {
            return this.writeByte(48);
        }
        int n2 = Long.numberOfTrailingZeros(Long.highestOneBit(l2)) / 4 + 1;
        Segment segment = this.writableSegment(n2);
        byte[] byArray = segment.data;
        int n3 = segment.limit;
        for (int i2 = n3 + n2 - 1; i2 >= n3; --i2) {
            byArray[i2] = DIGITS[(int)(l2 & 0xFL)];
            l2 >>>= 4;
        }
        Buffer buffer = this;
        segment.limit += n2;
        buffer.size += (long)n2;
        return buffer;
    }

    Segment writableSegment(int n2) {
        if (n2 >= 1 && n2 <= 8192) {
            Segment segment = ((Buffer)object).head;
            if (segment == null) {
                Segment segment2;
                ((Buffer)object).head = segment2 = SegmentPool.take();
                segment2.prev = segment2;
                segment2.next = segment2;
                return segment2;
            }
            Object object = segment.prev;
            if (((Segment)object).limit + n2 > 8192 || !((Segment)object).owner) {
                object = ((Segment)object).push(SegmentPool.take());
            }
            return object;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void write(Buffer buffer, long l2) {
        if (buffer != null) {
            if (buffer != this) {
                Util.checkOffsetAndCount(buffer.size, 0L, l2);
                while (l2 > 0L) {
                    Segment segment = buffer.head;
                    if (l2 < (long)(segment.limit - segment.pos)) {
                        long l3;
                        long l4;
                        Segment segment2 = this.head;
                        segment2 = segment2 != null ? segment2.prev : null;
                        if (segment2 != null && segment2.owner && (l4 = l2 + (long)segment2.limit) - (l3 = (long)(segment2.shared ? 0 : segment2.pos)) <= 8192L) {
                            segment.writeTo(segment2, (int)l2);
                            buffer.size -= l2;
                            this.size += l2;
                            return;
                        }
                        buffer.head = segment.split((int)l2);
                    }
                    segment = buffer.head;
                    long l5 = segment.limit - segment.pos;
                    buffer.head = segment.pop();
                    Segment segment3 = this.head;
                    if (segment3 == null) {
                        Segment segment4 = this.head = segment;
                        segment4.prev = segment;
                        segment4.next = segment;
                    } else {
                        segment3.prev.push(segment).compact();
                    }
                    buffer.size -= l5;
                    this.size += l5;
                    l2 -= l5;
                }
                return;
            }
            throw new IllegalArgumentException("source == this");
        }
        throw new IllegalArgumentException("source == null");
    }

    @Override
    public long read(Buffer buffer, long l2) {
        if (buffer != null) {
            if (l2 >= 0L) {
                long l3 = this.size;
                if (l3 == 0L) {
                    return -1L;
                }
                if (l2 <= l3) {
                    l3 = l2;
                }
                buffer.write(this, l3);
                return l3;
            }
            throw new IllegalArgumentException("byteCount < 0: " + l2);
        }
        throw new IllegalArgumentException("sink == null");
    }

    @Override
    public long indexOf(byte by) {
        return this.indexOf(by, 0L, Long.MAX_VALUE);
    }

    @Override
    public long indexOf(byte by, long l2) {
        return this.indexOf(by, l2, Long.MAX_VALUE);
    }

    @Override
    public long indexOf(byte by, long l2, long l3) {
        if (l2 >= 0L && l3 >= l2) {
            long l4 = ((Buffer)object).size;
            if (l3 > l4) {
                l3 = l4;
            }
            if (l2 == l3) {
                return -1L;
            }
            Object object = ((Buffer)object).head;
            if (object == null) {
                return -1L;
            }
            if (l4 - l2 < l2) {
                while (l4 > l2) {
                    object = ((Segment)object).prev;
                    l4 -= (long)(((Segment)object).limit - ((Segment)object).pos);
                }
            } else {
                long l5;
                l4 = 0L;
                while ((l5 = l4 + (long)(((Segment)object).limit - ((Segment)object).pos)) < l2) {
                    object = ((Segment)object).next;
                    l4 = l5;
                }
            }
            while (l4 < l3) {
                Object object2 = object;
                byte[] byArray = ((Segment)object2).data;
                int n2 = (int)Math.min((long)((Segment)object2).limit, (long)((Segment)object).pos + l3 - l4);
                for (int i2 = (int)((long)((Segment)(v1027490)).pos + l2 - l4); i2 < n2; ++i2) {
                    if (byArray[i2] != by) continue;
                    return (long)(i2 - ((Segment)object).pos) + l4;
                }
                object = ((Segment)object).next;
                l2 = l4 += (long)(((Segment)object).limit - ((Segment)object).pos);
            }
            return -1L;
        }
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = ((Buffer)object).size;
        objectArray2[1] = l2;
        objectArray[2] = l3;
        throw new IllegalArgumentException(String.format("size=%s fromIndex=%s toIndex=%s", objectArray2));
    }

    @Override
    public long indexOf(ByteString byteString) throws IOException {
        return this.indexOf(byteString, 0L);
    }

    @Override
    public long indexOf(ByteString byteString, long l2) throws IOException {
        if (byteString.size() != 0) {
            if (l2 >= 0L) {
                Segment segment = this.head;
                if (segment == null) {
                    return -1L;
                }
                long l3 = this.size;
                if (l3 - l2 < l2) {
                    while (l3 > l2) {
                        segment = segment.prev;
                        l3 -= (long)(segment.limit - segment.pos);
                    }
                } else {
                    long l4;
                    l3 = 0L;
                    while ((l4 = l3 + (long)(segment.limit - segment.pos)) < l2) {
                        segment = segment.next;
                        l3 = l4;
                    }
                }
                ByteString byteString2 = byteString;
                byte by = byteString2.getByte(0);
                int n2 = byteString2.size();
                long l5 = this.size - (long)n2 + 1L;
                while (l3 < l5) {
                    Segment segment2 = segment;
                    byte[] byArray = segment2.data;
                    int n3 = (int)Math.min((long)segment2.limit, (long)segment.pos + l5 - l3);
                    for (int i2 = (int)((long)(v1027643).pos + l2 - l3); i2 < n3; ++i2) {
                        if (byArray[i2] != by || !this.rangeEquals(segment, i2 + 1, byteString, 1, n2)) continue;
                        return (long)(i2 - segment.pos) + l3;
                    }
                    segment = segment.next;
                    l2 = l3 += (long)(segment.limit - segment.pos);
                }
                return -1L;
            }
            throw new IllegalArgumentException("fromIndex < 0");
        }
        throw new IllegalArgumentException("bytes is empty");
    }

    @Override
    public long indexOfElement(ByteString byteString) {
        return this.indexOfElement(byteString, 0L);
    }

    @Override
    public long indexOfElement(ByteString object, long l2) {
        if (l2 >= 0L) {
            Segment segment = this.head;
            if (segment == null) {
                return -1L;
            }
            long l3 = this.size;
            if (l3 - l2 < l2) {
                while (l3 > l2) {
                    segment = segment.prev;
                    l3 -= (long)(segment.limit - segment.pos);
                }
            } else {
                long l4;
                l3 = 0L;
                while ((l4 = l3 + (long)(segment.limit - segment.pos)) < l2) {
                    segment = segment.next;
                    l3 = l4;
                }
            }
            if (((ByteString)object).size() == 2) {
                ByteString byteString = object;
                byte by = byteString.getByte(0);
                byte by2 = byteString.getByte(1);
                while (l3 < this.size) {
                    Segment segment2 = segment;
                    byte[] byArray = segment2.data;
                    int n2 = segment2.limit;
                    for (int i2 = (int)((long)(v1027780).pos + l2 - l3); i2 < n2; ++i2) {
                        byte by3 = byArray[i2];
                        if (by3 != by && by3 != by2) {
                            continue;
                        }
                        return (long)(i2 - segment.pos) + l3;
                    }
                    segment = segment.next;
                    l2 = l3 += (long)(segment.limit - segment.pos);
                }
            } else {
                object = ((ByteString)object).internalArray();
                while (l3 < this.size) {
                    Segment segment3 = segment;
                    byte[] byArray = segment3.data;
                    int n3 = segment3.limit;
                    for (int i3 = (int)((long)(v1027832).pos + l2 - l3); i3 < n3; ++i3) {
                        byte by = byArray[i3];
                        int n4 = ((Object)object).length;
                        for (int i4 = 0; i4 < n4; ++i4) {
                            if (by != object[i4]) continue;
                            return (long)(i3 - segment.pos) + l3;
                        }
                    }
                    segment = segment.next;
                    l2 = l3 += (long)(segment.limit - segment.pos);
                }
            }
            return -1L;
        }
        throw new IllegalArgumentException("fromIndex < 0");
    }

    @Override
    public boolean rangeEquals(long l2, ByteString byteString) {
        int n2 = byteString.size();
        return this.rangeEquals(l2, byteString, 0, n2);
    }

    @Override
    public boolean rangeEquals(long l2, ByteString byteString, int n2, int n3) {
        if (l2 >= 0L && n2 >= 0 && n3 >= 0 && this.size - l2 >= (long)n3 && byteString.size() - n2 >= n3) {
            for (int i2 = 0; i2 < n3; ++i2) {
                if (this.getByte(l2 + (long)i2) == byteString.getByte(n2 + i2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void flush() {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public Timeout timeout() {
        return Timeout.NONE;
    }

    List<Integer> segmentSizes() {
        ArrayList<Integer> arrayList;
        if (this.head == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> arrayList2 = arrayList;
        arrayList2();
        Segment segment = this.head;
        arrayList.add(segment.limit - segment.pos);
        segment = this.head.next;
        while (segment != this.head) {
            arrayList2.add(segment.limit - segment.pos);
            segment = segment.next;
        }
        return arrayList2;
    }

    public final ByteString md5() {
        return this.digest("MD5");
    }

    public final ByteString sha1() {
        return this.digest("SHA-1");
    }

    public final ByteString sha256() {
        return this.digest("SHA-256");
    }

    public final ByteString sha512() {
        return this.digest("SHA-512");
    }

    public final ByteString hmacSha1(ByteString byteString) {
        return this.hmac("HmacSHA1", byteString);
    }

    public final ByteString hmacSha256(ByteString byteString) {
        return this.hmac("HmacSHA256", byteString);
    }

    public final ByteString hmacSha512(ByteString byteString) {
        return this.hmac("HmacSHA512", byteString);
    }

    public boolean equals(Object object) {
        long l2;
        if (this == object) {
            return true;
        }
        if (!(object instanceof Buffer)) {
            return false;
        }
        object = (Buffer)object;
        long l3 = this.size;
        if (l3 != ((Buffer)object).size) {
            return false;
        }
        if (l3 == 0L) {
            return true;
        }
        Object object2 = object;
        object = this.head;
        Segment segment = ((Buffer)object2).head;
        int n2 = ((Segment)object).pos;
        int n3 = segment.pos;
        for (long i2 = 0L; i2 < this.size; i2 += l2) {
            l2 = Math.min(((Segment)object).limit - n2, segment.limit - n3);
            int n4 = 0;
            while ((long)n4 < l2) {
                if (((Segment)object).data[n2++] != segment.data[n3++]) {
                    return false;
                }
                ++n4;
            }
            if (n2 == ((Segment)object).limit) {
                object = ((Segment)object).next;
                n2 = ((Segment)object).pos;
            }
            if (n3 != segment.limit) continue;
            segment = segment.next;
            n3 = segment.pos;
        }
        return true;
    }

    public int hashCode() {
        Segment segment = this.head;
        if (segment == null) {
            return 0;
        }
        int n2 = 1;
        do {
            int n3 = segment.limit;
            for (int i2 = (v1028109).pos; i2 < n3; ++i2) {
                n2 = n2 * 31 + segment.data[i2];
            }
        } while ((segment = segment.next) != this.head);
        return n2;
    }

    public String toString() {
        return this.snapshot().toString();
    }

    public Buffer clone() {
        Buffer buffer;
        Buffer buffer2 = buffer;
        buffer = new Buffer();
        if (this.size == 0L) {
            return buffer2;
        }
        Buffer buffer3 = this;
        buffer2.head.prev = buffer2.head = buffer3.head.sharedCopy();
        buffer2.head.next = buffer2.head;
        Segment segment = buffer3.head.next;
        while (segment != this.head) {
            buffer2.head.prev.push(segment.sharedCopy());
            segment = segment.next;
        }
        buffer2.size = this.size;
        return buffer2;
    }

    public final ByteString snapshot() {
        long l2 = this.size;
        if (l2 <= Integer.MAX_VALUE) {
            return this.snapshot((int)l2);
        }
        throw new IllegalArgumentException("size > Integer.MAX_VALUE: " + this.size);
    }

    public final ByteString snapshot(int n2) {
        if (n2 == 0) {
            return ByteString.EMPTY;
        }
        return new SegmentedByteString(this, n2);
    }

    public final UnsafeCursor readUnsafe() {
        return this.readUnsafe(new UnsafeCursor());
    }

    public final UnsafeCursor readUnsafe(UnsafeCursor unsafeCursor) {
        if (unsafeCursor.buffer == null) {
            unsafeCursor.buffer = this;
            unsafeCursor.readWrite = false;
            return unsafeCursor;
        }
        throw new IllegalStateException("already attached to a buffer");
    }

    public final UnsafeCursor readAndWriteUnsafe() {
        return this.readAndWriteUnsafe(new UnsafeCursor());
    }

    public final UnsafeCursor readAndWriteUnsafe(UnsafeCursor unsafeCursor) {
        if (unsafeCursor.buffer == null) {
            unsafeCursor.buffer = this;
            unsafeCursor.readWrite = true;
            return unsafeCursor;
        }
        throw new IllegalStateException("already attached to a buffer");
    }

    public static final class UnsafeCursor
    implements Closeable {
        public Buffer buffer;
        public boolean readWrite;
        private Segment segment;
        public long offset = -1L;
        public byte[] data;
        public int start = -1;
        public int end = -1;

        public final int next() {
            long l2 = this.offset;
            if (l2 != this.buffer.size) {
                if (l2 == -1L) {
                    return this.seek(0L);
                }
                return this.seek(l2 + (long)(this.end - this.start));
            }
            throw new IllegalStateException();
        }

        public final int seek(long l2) {
            long l3 = l2 - -1L;
            long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
            if (l4 >= 0) {
                Buffer buffer = this.buffer;
                long l5 = buffer.size;
                if (l2 <= l5) {
                    if (l4 != false && l2 != l5) {
                        int n2;
                        int n3;
                        long l6;
                        Segment segment;
                        long l7;
                        long l8 = 0L;
                        Segment segment2 = buffer.head;
                        Segment segment3 = this.segment;
                        if (segment3 != null) {
                            l7 = this.offset - (long)(this.start - segment3.pos);
                            if (l7 > l2) {
                                segment = segment2;
                                l6 = l8;
                            } else {
                                segment = segment3;
                                segment3 = segment2;
                                l6 = l7;
                                l7 = l5;
                            }
                        } else {
                            segment = segment2;
                            segment3 = segment2;
                            l6 = l8;
                            l7 = l5;
                        }
                        if (l7 - l2 > l2 - l6) {
                            int n4;
                            int n5;
                            while (l2 >= l6 + (long)((n5 = segment.limit) - (n4 = segment.pos))) {
                                l6 += (long)(n5 - n4);
                                segment = segment.next;
                            }
                        } else {
                            segment = segment3;
                            l6 = l7;
                            while (l6 > l2) {
                                segment3 = segment.prev;
                                l7 = l6 - (long)(segment3.limit - segment3.pos);
                                segment = segment3;
                                l6 = l7;
                            }
                        }
                        if (this.readWrite && segment.shared) {
                            Segment segment4 = segment.unsharedCopy();
                            Buffer buffer2 = this.buffer;
                            if (buffer2.head == segment) {
                                buffer2.head = segment4;
                            }
                            segment = segment.push(segment4);
                            segment.prev.pop();
                        }
                        this.segment = segment;
                        this.offset = l2;
                        this.data = segment.data;
                        this.start = n3 = segment.pos + (int)(l2 - l6);
                        this.end = n2 = segment.limit;
                        return n2 - n3;
                    }
                    UnsafeCursor unsafeCursor = this;
                    unsafeCursor.segment = null;
                    unsafeCursor.offset = l2;
                    unsafeCursor.data = null;
                    unsafeCursor.start = -1;
                    unsafeCursor.end = -1;
                    return -1;
                }
            }
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = l2;
            objectArray[1] = this.buffer.size;
            throw new ArrayIndexOutOfBoundsException(String.format("offset=%s > size=%s", objectArray2));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final long resizeBuffer(long l2) {
            Buffer buffer = this.buffer;
            if (buffer == null) throw new IllegalStateException("not attached to a buffer");
            if (!this.readWrite) throw new IllegalStateException("resizeBuffer() only permitted for read/write buffers");
            long l3 = buffer.size;
            long l4 = l2 - l3;
            long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
            if (l5 <= 0) {
                long l6;
                if (l2 < 0L) throw new IllegalArgumentException("newSize < 0: " + l2);
                for (long i2 = l3 - l2; i2 > 0L; i2 -= l6) {
                    Buffer buffer2 = this.buffer;
                    Segment segment = buffer2.head.prev;
                    int n2 = segment.limit;
                    l6 = n2 - segment.pos;
                    if (l6 <= i2) {
                        buffer2.head = segment.pop();
                        SegmentPool.recycle(segment);
                        continue;
                    }
                    segment.limit = (int)((long)n2 - i2);
                    break;
                }
                UnsafeCursor unsafeCursor = this;
                unsafeCursor.segment = null;
                unsafeCursor.offset = l2;
                unsafeCursor.data = null;
                unsafeCursor.start = -1;
                unsafeCursor.end = -1;
            } else if (l5 > 0) {
                l5 = 1;
                long l7 = l2 - l3;
                while (l7 > 0L) {
                    int n3;
                    Segment segment = this.buffer.writableSegment(1);
                    int n4 = (int)Math.min(l7, (long)(8192 - segment.limit));
                    segment.limit = n3 = segment.limit + n4;
                    long l8 = l7 - (long)n4;
                    if (l5 != false) {
                        this.segment = segment;
                        this.offset = l3;
                        this.data = segment.data;
                        this.start = n3 - n4;
                        this.end = n3;
                        l5 = 0;
                    }
                    l7 = l8;
                }
            }
            this.buffer.size = l2;
            return l3;
        }

        public final long expandBuffer(int n2) {
            if (n2 > 0) {
                if (n2 <= 8192) {
                    Buffer buffer = this.buffer;
                    if (buffer != null) {
                        if (this.readWrite) {
                            long l2 = buffer.size;
                            Segment segment = buffer.writableSegment(n2);
                            int n3 = 8192 - segment.limit;
                            segment.limit = 8192;
                            Buffer buffer2 = this.buffer;
                            long l3 = n3;
                            UnsafeCursor unsafeCursor = this;
                            buffer2.size = l2 + l3;
                            this.segment = segment;
                            this.offset = l2;
                            unsafeCursor.data = segment.data;
                            unsafeCursor.start = 8192 - n3;
                            unsafeCursor.end = 8192;
                            return l3;
                        }
                        throw new IllegalStateException("expandBuffer() only permitted for read/write buffers");
                    }
                    throw new IllegalStateException("not attached to a buffer");
                }
                throw new IllegalArgumentException("minByteCount > Segment.SIZE: " + n2);
            }
            throw new IllegalArgumentException("minByteCount <= 0: " + n2);
        }

        @Override
        public void close() {
            if (this.buffer != null) {
                UnsafeCursor unsafeCursor = this;
                unsafeCursor.buffer = null;
                unsafeCursor.segment = null;
                unsafeCursor.offset = -1L;
                unsafeCursor.data = null;
                unsafeCursor.start = -1;
                unsafeCursor.end = -1;
                return;
            }
            throw new IllegalStateException("not attached to a buffer");
        }
    }
}

