/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.platform;

import android.support.annotation.Nullable;
import dc.squareup.okhttp3.OkHttpClient;
import dc.squareup.okhttp3.Protocol;
import dc.squareup.okhttp3.internal.platform.Android10Platform;
import dc.squareup.okhttp3.internal.platform.AndroidPlatform;
import dc.squareup.okhttp3.internal.platform.Jdk9Platform;
import dc.squareup.okhttp3.internal.platform.JdkWithJettyBootPlatform;
import dc.squareup.okhttp3.internal.tls.BasicCertificateChainCleaner;
import dc.squareup.okhttp3.internal.tls.BasicTrustRootIndex;
import dc.squareup.okhttp3.internal.tls.CertificateChainCleaner;
import dc.squareup.okhttp3.internal.tls.TrustRootIndex;
import dc.squareup.okio.Buffer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

public class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();
    public static final int INFO = 4;
    public static final int WARN = 5;
    private static final Logger logger = Logger.getLogger(OkHttpClient.class.getName());

    public static Platform get() {
        return PLATFORM;
    }

    public static List<String> alpnProtocolNames(List<Protocol> list) {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>(list.size());
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Protocol protocol = list.get(i2);
            if (protocol == Protocol.HTTP_1_0) continue;
            arrayList2.add(protocol.toString());
        }
        return arrayList2;
    }

    public static boolean isConscrytpPreferred() {
        if ("conscrypt".equals(System.getProperty("okhttp.platform"))) {
            return true;
        }
        return "Conscrypt".equals(Security.getProviders()[0].getName());
    }

    private static Platform findPlatform() {
        Platform platform = Android10Platform.buildIfSupported();
        if (platform != null) {
            return platform;
        }
        platform = AndroidPlatform.buildIfSupported();
        if (platform != null) {
            return platform;
        }
        platform = Jdk9Platform.buildIfSupported();
        if (platform != null) {
            return platform;
        }
        platform = JdkWithJettyBootPlatform.buildIfSupported();
        if (platform != null) {
            return platform;
        }
        return new Platform();
    }

    static byte[] concatLengthPrefixed(List<Protocol> list) {
        Buffer buffer;
        Buffer buffer2 = buffer;
        buffer = new Buffer();
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Protocol protocol = list.get(i2);
            if (protocol == Protocol.HTTP_1_0) continue;
            buffer2.writeByte(protocol.toString().length());
            buffer2.writeUtf8(protocol.toString());
        }
        return buffer2.readByteArray();
    }

    @Nullable
    static <T> T readFieldOrNull(Object object, Class<T> clazz, String string2) {
        for (Class<?> clazz2 = object.getClass(); clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
            block8: {
                Field field = clazz2.getDeclaredField(string2);
                field.setAccessible(true);
                Object object2 = field.get(object);
                if (object2 == null) break block8;
                if (!clazz.isInstance(object2)) break block8;
                try {
                    return clazz.cast(object2);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AssertionError();
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
            }
            return null;
        }
        if (!string2.equals("delegate") && (object = Platform.readFieldOrNull(object, Object.class, "delegate")) != null) {
            return Platform.readFieldOrNull(object, clazz, string2);
        }
        return null;
    }

    public String getPrefix() {
        return "OkHttp";
    }

    @Nullable
    protected X509TrustManager trustManager(SSLSocketFactory sSLSocketFactory) {
        block3: {
            try {
                Platform platform = Platform.readFieldOrNull(sSLSocketFactory, Class.forName("sun.security.ssl.SSLContextImpl"), "context");
                if (platform != null) break block3;
                return null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        return Platform.readFieldOrNull(platform, X509TrustManager.class, "trustManager");
    }

    public void configureTlsExtensions(SSLSocket sSLSocket, @Nullable String string2, List<Protocol> list) throws IOException {
    }

    public void afterHandshake(SSLSocket sSLSocket) {
    }

    @Nullable
    public String getSelectedProtocol(SSLSocket sSLSocket) {
        return null;
    }

    public void connectSocket(Socket socket, InetSocketAddress inetSocketAddress, int n2) throws IOException {
        socket.connect(inetSocketAddress, n2);
    }

    public void log(int n2, String string2, @Nullable Throwable throwable) {
        Level level = n2 == 5 ? Level.WARNING : Level.INFO;
        logger.log(level, string2, throwable);
    }

    public boolean isCleartextTrafficPermitted(String string2) {
        return true;
    }

    public Object getStackTraceForCloseable(String string2) {
        if (logger.isLoggable(Level.FINE)) {
            return new Throwable(string2);
        }
        return null;
    }

    public void logCloseableLeak(String string2, Object object) {
        if (object == null) {
            string2 = string2 + " To see where this was allocated, set the OkHttpClient logger level to FINE: Logger.getLogger(OkHttpClient.class.getName()).setLevel(Level.FINE);";
        }
        Platform platform = throwable;
        Throwable throwable = (Throwable)object;
        platform.log(5, string2, throwable);
    }

    public CertificateChainCleaner buildCertificateChainCleaner(X509TrustManager x509TrustManager) {
        return new BasicCertificateChainCleaner(this.buildTrustRootIndex(x509TrustManager));
    }

    public CertificateChainCleaner buildCertificateChainCleaner(SSLSocketFactory sSLSocketFactory) {
        X509TrustManager x509TrustManager = this.trustManager(sSLSocketFactory);
        if (x509TrustManager != null) {
            return this.buildCertificateChainCleaner(x509TrustManager);
        }
        throw new IllegalStateException("Unable to extract the trust manager on " + Platform.get() + ", sslSocketFactory is " + sSLSocketFactory.getClass());
    }

    public SSLContext getSSLContext() {
        if ("1.7".equals(System.getProperty("java.specification.version"))) {
            try {
                return SSLContext.getInstance("TLSv1.2");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        try {
            return SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("No TLS provider", noSuchAlgorithmException);
        }
    }

    public TrustRootIndex buildTrustRootIndex(X509TrustManager x509TrustManager) {
        return new BasicTrustRootIndex(x509TrustManager.getAcceptedIssuers());
    }

    public void configureSslSocketFactory(SSLSocketFactory sSLSocketFactory) {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

