/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.platform;

import android.annotation.SuppressLint;
import android.net.ssl.SSLSockets;
import android.support.annotation.Nullable;
import dc.squareup.okhttp3.Protocol;
import dc.squareup.okhttp3.internal.platform.AndroidPlatform;
import dc.squareup.okhttp3.internal.platform.Platform;
import java.io.IOException;
import java.util.List;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;

@SuppressLint(value={"NewApi"})
class Android10Platform
extends AndroidPlatform {
    Android10Platform(Class<?> clazz) {
        super(clazz, null, null, null, null);
    }

    private void enableSessionTickets(SSLSocket sSLSocket) {
        if (SSLSockets.isSupportedSocket((SSLSocket)sSLSocket)) {
            SSLSockets.setUseSessionTickets((SSLSocket)sSLSocket, (boolean)true);
        }
    }

    @Nullable
    public static Platform buildIfSupported() {
        block4: {
            try {
                if (AndroidPlatform.getSdkInt() < 29) break block4;
            }
            catch (ClassNotFoundException classNotFoundException) {}
            Class<?> clazz = Class.forName("com.android.org.conscrypt.SSLParametersImpl");
            return new Android10Platform(clazz);
        }
        return null;
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void configureTlsExtensions(SSLSocket sSLSocket, String string2, List<Protocol> list) throws IOException {
        try {
            SSLSocket sSLSocket2 = sSLSocket;
            this.enableSessionTickets(sSLSocket);
            SSLParameters sSLParameters = sSLSocket2.getSSLParameters();
            sSLParameters.setApplicationProtocols(Platform.alpnProtocolNames(list).toArray(new String[0]));
            sSLSocket2.setSSLParameters(sSLParameters);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("Android internal error", illegalArgumentException);
        }
    }

    @Override
    @Nullable
    public String getSelectedProtocol(SSLSocket sSLSocket) {
        String string2 = sSLSocket.getApplicationProtocol();
        if (string2 != null && !string2.isEmpty()) {
            return string2;
        }
        return null;
    }
}

