/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.http2;

import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.http2.ErrorCode;
import dc.squareup.okhttp3.internal.http2.Header;
import dc.squareup.okhttp3.internal.http2.Hpack;
import dc.squareup.okhttp3.internal.http2.Http2;
import dc.squareup.okhttp3.internal.http2.Settings;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.Source;
import dc.squareup.okio.Timeout;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

final class Http2Reader
implements Closeable {
    static final Logger logger = Logger.getLogger(Http2.class.getName());
    private final BufferedSource source;
    private final ContinuationSource continuation;
    private final boolean client;
    final Hpack.Reader hpackReader;

    Http2Reader(BufferedSource object, boolean bl) {
        Hpack.Reader reader;
        ContinuationSource continuationSource;
        closeable.source = object;
        closeable.client = bl;
        Closeable closeable = continuationSource;
        continuationSource = new ContinuationSource((BufferedSource)object);
        v1.continuation = closeable;
        object = reader;
        reader = new Hpack.Reader(4096, (Source)closeable);
        v1.hpackReader = object;
    }

    private void readHeaders(Handler handler, int n2, byte by, int n3) throws IOException {
        if (n3 != 0) {
            boolean bl = (by & 1) != 0;
            short s = (by & 8) != 0 ? (short)(((Http2Reader)((Object)list)).source.readByte() & 0xFF) : (short)0;
            if ((by & 0x20) != 0) {
                ((Http2Reader)((Object)list)).readPriority(handler, n3);
                n2 -= 5;
            }
            List<Header> list = ((Http2Reader)((Object)list)).readHeaderBlock(Http2Reader.lengthWithoutPadding(n2, by, s), s, by, n3);
            handler.headers(bl, n3, -1, list);
            return;
        }
        throw Http2.ioException("PROTOCOL_ERROR: TYPE_HEADERS streamId == 0", new Object[0]);
    }

    private List<Header> readHeaderBlock(int n2, short s, byte by, int n3) throws IOException {
        Http2Reader http2Reader = closeable;
        Closeable closeable = http2Reader.continuation;
        ((ContinuationSource)closeable).left = n2;
        ((ContinuationSource)closeable).length = n2;
        ((ContinuationSource)closeable).padding = s;
        ((ContinuationSource)closeable).flags = by;
        http2Reader.continuation.streamId = n3;
        http2Reader.hpackReader.readHeaders();
        return http2Reader.hpackReader.getAndResetHeaderList();
    }

    private void readData(Handler handler, int n2, byte by, int n3) throws IOException {
        if (n3 != 0) {
            boolean bl = (by & 1) != 0;
            if (!((by & 0x20) != 0)) {
                short s = (by & 8) != 0 ? (short)(this.source.readByte() & 0xFF) : (short)0;
                int n4 = Http2Reader.lengthWithoutPadding(n2, by, s);
                handler.data(bl, n3, this.source, n4);
                this.source.skip(s);
                return;
            }
            throw Http2.ioException("PROTOCOL_ERROR: FLAG_COMPRESSED without SETTINGS_COMPRESS_DATA", new Object[0]);
        }
        throw Http2.ioException("PROTOCOL_ERROR: TYPE_DATA streamId == 0", new Object[0]);
    }

    private void readPriority(Handler handler, int n2, byte by, int n3) throws IOException {
        if (n2 == 5) {
            if (n3 != 0) {
                super.readPriority(handler, n3);
                return;
            }
            throw Http2.ioException("TYPE_PRIORITY streamId == 0", new Object[0]);
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n2;
        throw Http2.ioException("TYPE_PRIORITY length: %d != 5", objectArray2);
    }

    private void readPriority(Handler handler, int n2) throws IOException {
        int n3 = this.source.readInt();
        boolean bl = (n3 & Integer.MIN_VALUE) != 0;
        int n4 = n3 & Integer.MAX_VALUE;
        handler.priority(n2, n4, (this.source.readByte() & 0xFF) + 1, bl);
    }

    private void readRstStream(Handler objectArray, int n2, byte by, int n3) throws IOException {
        if (n2 == 4) {
            if (n3 != 0) {
                int n4 = objectArray4.source.readInt();
                ErrorCode errorCode = ErrorCode.fromHttp2(n4);
                if (errorCode != null) {
                    objectArray.rstStream(n3, errorCode);
                    return;
                }
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = n4;
                throw Http2.ioException("TYPE_RST_STREAM unexpected error code: %d", objectArray);
            }
            throw Http2.ioException("TYPE_RST_STREAM streamId == 0", new Object[0]);
        }
        Object[] objectArray3 = new Object[1];
        Object[] objectArray4 = objectArray3;
        objectArray3[0] = n2;
        throw Http2.ioException("TYPE_RST_STREAM length: %d != 4", objectArray4);
    }

    private void readSettings(Handler handler, int n2, byte by, int n3) throws IOException {
        if (n3 == 0) {
            Object[] objectArray;
            if ((by & 1) != 0) {
                if (n2 == 0) {
                    handler.ackSettings();
                    return;
                }
                throw Http2.ioException("FRAME_SIZE_ERROR ack frame should be empty!", new Object[0]);
            }
            if (n2 % 6 == 0) {
                Settings settings;
                Settings settings2 = settings;
                settings = new Settings();
                for (n3 = 0; n3 < n2; n3 += 6) {
                    int n4 = objectArray.source.readShort() & 0xFFFF;
                    int n5 = objectArray.source.readInt();
                    switch (n4) {
                        default: {
                            break;
                        }
                        case 5: {
                            if (n5 >= 16384 && n5 <= 0xFFFFFF) break;
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = n5;
                            throw Http2.ioException("PROTOCOL_ERROR SETTINGS_MAX_FRAME_SIZE: %s", objectArray);
                        }
                        case 4: {
                            n4 = 7;
                            if (n5 >= 0) break;
                            throw Http2.ioException("PROTOCOL_ERROR SETTINGS_INITIAL_WINDOW_SIZE > 2^31 - 1", new Object[0]);
                        }
                        case 3: {
                            n4 = 4;
                            break;
                        }
                        case 2: {
                            if (n5 == 0 || n5 == 1) break;
                            throw Http2.ioException("PROTOCOL_ERROR SETTINGS_ENABLE_PUSH != 0 or 1", new Object[0]);
                        }
                    }
                    settings2.set(n4, n5);
                }
                handler.settings(false, settings2);
                return;
            }
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = n2;
            throw Http2.ioException("TYPE_SETTINGS length %% 6 != 0: %s", objectArray);
        }
        throw Http2.ioException("TYPE_SETTINGS streamId != 0", new Object[0]);
    }

    private void readPushPromise(Handler handler, int n2, byte by, int n3) throws IOException {
        if (n3 != 0) {
            short s = (by & 8) != 0 ? (short)(this.source.readByte() & 0xFF) : (short)0;
            int n4 = this.source.readInt() & Integer.MAX_VALUE;
            handler.pushPromise(n3, n4, this.readHeaderBlock(Http2Reader.lengthWithoutPadding(n2 + -4, by, s), s, by, n3));
            return;
        }
        throw Http2.ioException("PROTOCOL_ERROR: TYPE_PUSH_PROMISE streamId == 0", new Object[0]);
    }

    private void readPing(Handler handler, int n2, byte by, int n3) throws IOException {
        if (n2 == 8) {
            if (n3 == 0) {
                int n4 = objectArray2.source.readInt();
                n2 = objectArray2.source.readInt();
                by = (by & 1) != 0 ? (byte)1 : 0;
                handler.ping(by != 0, n4, n2);
                return;
            }
            throw Http2.ioException("TYPE_PING streamId != 0", new Object[0]);
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n2;
        throw Http2.ioException("TYPE_PING length != 8: %s", objectArray2);
    }

    private void readGoAway(Handler handler, int n2, byte by, int n3) throws IOException {
        Object[] objectArray;
        if (n2 >= 8) {
            if (n3 == 0) {
                by = (byte)objectArray.source.readInt();
                n3 = objectArray.source.readInt();
                n2 -= 8;
                ErrorCode errorCode = ErrorCode.fromHttp2(n3);
                if (errorCode != null) {
                    ByteString byteString = ByteString.EMPTY;
                    if (n2 > 0) {
                        byteString = objectArray.source.readByteString(n2);
                    }
                    handler.goAway(by, errorCode, byteString);
                    return;
                }
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = n3;
                throw Http2.ioException("TYPE_GOAWAY unexpected error code: %d", objectArray);
            }
            throw Http2.ioException("TYPE_GOAWAY streamId != 0", new Object[0]);
        }
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = n2;
        throw Http2.ioException("TYPE_GOAWAY length < 8: %s", objectArray);
    }

    private void readWindowUpdate(Handler handler, int n2, byte by, int n3) throws IOException {
        Object[] objectArray;
        if (n2 == 4) {
            long l2 = (long)objectArray.source.readInt() & Integer.MAX_VALUE;
            if (l2 != 0L) {
                handler.windowUpdate(n3, l2);
                return;
            }
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = l2;
            throw Http2.ioException("windowSizeIncrement was 0", objectArray);
        }
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = n2;
        throw Http2.ioException("TYPE_WINDOW_UPDATE length !=4: %s", objectArray);
    }

    static int readMedium(BufferedSource bufferedSource) throws IOException {
        return (bufferedSource.readByte() & 0xFF) << 16 | (bufferedSource.readByte() & 0xFF) << 8 | bufferedSource.readByte() & 0xFF;
    }

    static int lengthWithoutPadding(int n2, byte by, short s) throws IOException {
        if ((by & 8) != 0) {
            --n2;
        }
        if (s <= n2) {
            return (short)(n2 - s);
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = s;
        objectArray[1] = n2;
        throw Http2.ioException("PROTOCOL_ERROR padding %s > remaining length %s", objectArray2);
    }

    public void readConnectionPreface(Handler object) throws IOException {
        Object[] objectArray;
        block8: {
            block7: {
                block6: {
                    if (!objectArray.client) break block6;
                    if (!objectArray.nextFrame(true, (Handler)object)) {
                        throw Http2.ioException("Required SETTINGS preface not received", new Object[0]);
                    }
                    break block7;
                }
                objectArray = Http2.CONNECTION_PREFACE;
                object = objectArray.source.readByteString(objectArray.size());
                Object[] objectArray2 = logger;
                if (logger.isLoggable(Level.FINE)) {
                    Object[] objectArray3 = objectArray2;
                    Object[] objectArray4 = new Object[1];
                    objectArray2 = objectArray4;
                    objectArray4[0] = ((ByteString)object).hex();
                    objectArray3.fine(Util.format("<< CONNECTION %s", objectArray2));
                }
                if (!objectArray.equals(object)) break block8;
            }
            return;
        }
        Object[] objectArray5 = new Object[1];
        objectArray = objectArray5;
        objectArray5[0] = ((ByteString)object).utf8();
        throw Http2.ioException("Expected a connection header but was %s", objectArray);
    }

    public boolean nextFrame(boolean n2, Handler handler) throws IOException {
        Object[] objectArray;
        int n3;
        block15: {
            int n4;
            try {
                objectArray.source.require(9L);
                n3 = Http2Reader.readMedium(objectArray.source);
                if (n3 < 0 || n3 > 16384) break block15;
                n4 = n2;
            }
            catch (IOException iOException) {
                return false;
            }
            n2 = (byte)(objectArray.source.readByte() & 0xFF);
            if (n4 != 0 && n2 != 4) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = (byte)n2;
                throw Http2.ioException("Expected a SETTINGS frame but was %s", objectArray);
            }
            byte by = (byte)(objectArray.source.readByte() & 0xFF);
            int n5 = objectArray.source.readInt() & Integer.MAX_VALUE;
            Logger logger = Http2Reader.logger;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(Http2.frameLog(true, n5, n3, (byte)n2, by));
            }
            switch (n2) {
                default: {
                    objectArray.source.skip(n3);
                    break;
                }
                case 8: {
                    super.readWindowUpdate(handler, n3, by, n5);
                    break;
                }
                case 7: {
                    super.readGoAway(handler, n3, by, n5);
                    break;
                }
                case 6: {
                    super.readPing(handler, n3, by, n5);
                    break;
                }
                case 5: {
                    super.readPushPromise(handler, n3, by, n5);
                    break;
                }
                case 4: {
                    super.readSettings(handler, n3, by, n5);
                    break;
                }
                case 3: {
                    super.readRstStream(handler, n3, by, n5);
                    break;
                }
                case 2: {
                    super.readPriority(handler, n3, by, n5);
                    break;
                }
                case 1: {
                    super.readHeaders(handler, n3, by, n5);
                    break;
                }
                case 0: {
                    super.readData(handler, n3, by, n5);
                }
            }
            return true;
        }
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = n3;
        throw Http2.ioException("FRAME_SIZE_ERROR: %s", objectArray);
    }

    @Override
    public void close() throws IOException {
        this.source.close();
    }

    static interface Handler {
        public void data(boolean var1, int var2, BufferedSource var3, int var4) throws IOException;

        public void headers(boolean var1, int var2, int var3, List<Header> var4);

        public void rstStream(int var1, ErrorCode var2);

        public void settings(boolean var1, Settings var2);

        public void ackSettings();

        public void ping(boolean var1, int var2, int var3);

        public void goAway(int var1, ErrorCode var2, ByteString var3);

        public void windowUpdate(int var1, long var2);

        public void priority(int var1, int var2, int var3, boolean var4);

        public void pushPromise(int var1, int var2, List<Header> var3) throws IOException;

        public void alternateService(int var1, String var2, ByteString var3, String var4, int var5, long var6);
    }

    static final class ContinuationSource
    implements Source {
        private final BufferedSource source;
        int length;
        byte flags;
        int streamId;
        int left;
        short padding;

        ContinuationSource(BufferedSource bufferedSource) {
            this.source = bufferedSource;
        }

        private void readContinuationHeader() throws IOException {
            int n2;
            int by;
            ContinuationSource continuationSource = this;
            int n3 = continuationSource.streamId;
            continuationSource.left = by = Http2Reader.readMedium(continuationSource.source);
            continuationSource.length = by;
            byte by2 = (byte)(continuationSource.source.readByte() & 0xFF);
            continuationSource.flags = (byte)(continuationSource.source.readByte() & 0xFF);
            Logger n4 = logger;
            if (n4.isLoggable(Level.FINE)) {
                ContinuationSource continuationSource2 = this;
                int n5 = continuationSource2.streamId;
                int n6 = continuationSource2.length;
                byte by3 = continuationSource2.flags;
                n4.fine(Http2.frameLog(true, n5, n6, by2, by3));
            }
            this.streamId = n2 = this.source.readInt() & Integer.MAX_VALUE;
            if (by2 == 9) {
                if (n2 == n3) {
                    return;
                }
                throw Http2.ioException("TYPE_CONTINUATION streamId changed", new Object[0]);
            }
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = by2;
            throw Http2.ioException("%s != TYPE_CONTINUATION", objectArray2);
        }

        @Override
        public long read(Buffer buffer, long l2) throws IOException {
            int n2;
            while ((n2 = this.left) == 0) {
                ContinuationSource continuationSource = this;
                continuationSource.source.skip(this.padding);
                continuationSource.padding = 0;
                if ((continuationSource.flags & 4) != 0) {
                    return -1L;
                }
                this.readContinuationHeader();
            }
            long l3 = this.source.read(buffer, Math.min(l2, (long)n2));
            if (l3 == -1L) {
                return -1L;
            }
            this.left = (int)((long)this.left - l3);
            return l3;
        }

        @Override
        public Timeout timeout() {
            return this.source.timeout();
        }

        @Override
        public void close() throws IOException {
        }
    }
}

