/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.http2;

import dc.squareup.okhttp3.Headers;
import dc.squareup.okhttp3.Protocol;
import dc.squareup.okhttp3.internal.NamedRunnable;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.http2.ConnectionShutdownException;
import dc.squareup.okhttp3.internal.http2.ErrorCode;
import dc.squareup.okhttp3.internal.http2.Header;
import dc.squareup.okhttp3.internal.http2.Http2Reader;
import dc.squareup.okhttp3.internal.http2.Http2Stream;
import dc.squareup.okhttp3.internal.http2.Http2Writer;
import dc.squareup.okhttp3.internal.http2.PushObserver;
import dc.squareup.okhttp3.internal.http2.Settings;
import dc.squareup.okhttp3.internal.platform.Platform;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.Okio;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class Http2Connection
implements Closeable {
    static final int OKHTTP_CLIENT_WINDOW_SIZE = 0x1000000;
    static final int INTERVAL_PING = 1;
    static final int DEGRADED_PING = 2;
    static final int AWAIT_PING = 3;
    static final long DEGRADED_PONG_TIMEOUT_NS = 1000000000L;
    private static final ExecutorService listenerExecutor;
    static final /* synthetic */ boolean $assertionsDisabled;
    final boolean client;
    final Listener listener;
    final Map<Integer, Http2Stream> streams = new LinkedHashMap<Integer, Http2Stream>();
    final String hostname;
    int lastGoodStreamId;
    int nextStreamId;
    private boolean shutdown;
    private final ScheduledExecutorService writerExecutor;
    private final ExecutorService pushExecutor;
    final PushObserver pushObserver;
    private long intervalPingsSent = 0L;
    private long intervalPongsReceived = 0L;
    private long degradedPingsSent = 0L;
    private long degradedPongsReceived = 0L;
    private long awaitPingsSent = 0L;
    private long awaitPongsReceived = 0L;
    private long degradedPongDeadlineNs = 0L;
    long unacknowledgedBytesRead = 0L;
    long bytesLeftInWriteWindow;
    Settings okHttpSettings = new Settings();
    final Settings peerSettings;
    final Socket socket;
    final Http2Writer writer;
    final ReaderRunnable readerRunnable;
    final Set<Integer> currentPushRequests;

    Http2Connection(Builder builder) {
        Http2Reader http2Reader;
        LinkedBlockingQueue linkedBlockingQueue;
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
        boolean bl;
        Settings settings;
        Object object = settings;
        closeable.peerSettings = new Settings();
        closeable.currentPushRequests = new LinkedHashSet<Integer>();
        closeable.pushObserver = builder.pushObserver;
        closeable.client = bl = builder.client;
        closeable.listener = builder.listener;
        int n2 = bl ? 1 : 2;
        closeable.nextStreamId = n2;
        if (bl) {
            closeable.nextStreamId = n2 + 2;
        }
        if (bl) {
            closeable.okHttpSettings.set(7, 0x1000000);
        }
        Http2Connection http2Connection = closeable;
        Object object2 = builder.hostname;
        http2Connection.hostname = object2;
        Object object3 = scheduledThreadPoolExecutor;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = object2;
        http2Connection.writerExecutor = new ScheduledThreadPoolExecutor(1, Util.threadFactory(Util.format("OkHttp %s Writer", objectArray2), false));
        if (builder.pingIntervalMillis != 0) {
            IntervalPingRunnable intervalPingRunnable;
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor2 = object3;
            object3 = intervalPingRunnable;
            intervalPingRunnable = (Http2Connection)closeable.new IntervalPingRunnable();
            int n3 = builder.pingIntervalMillis;
            long l2 = n3;
            long l3 = n3;
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            scheduledThreadPoolExecutor2.scheduleAtFixedRate((Runnable)object3, l2, l3, timeUnit);
        }
        Http2Connection http2Connection2 = closeable;
        Settings settings2 = object;
        object = TimeUnit.SECONDS;
        object3 = linkedBlockingQueue;
        linkedBlockingQueue = new LinkedBlockingQueue();
        Object[] objectArray3 = new Object[1];
        objectArray2 = objectArray3;
        objectArray3[0] = object2;
        object2 = Util.threadFactory(Util.format("OkHttp %s Push Observer", objectArray2), true);
        closeable.pushExecutor = new ThreadPoolExecutor(0, 1, 60L, (TimeUnit)((Object)object), (BlockingQueue<Runnable>)object3, (ThreadFactory)object2);
        settings2.set(7, 65535);
        settings2.set(5, 16384);
        closeable.bytesLeftInWriteWindow = settings2.getInitialWindowSize();
        http2Connection2.socket = builder.socket;
        http2Connection2.writer = new Http2Writer(builder.sink, bl);
        Http2Connection http2Connection3 = closeable;
        Closeable closeable = http2Reader;
        http2Reader = new Http2Reader(builder.source, bl);
        http2Connection2.readerRunnable = http2Connection3.new ReaderRunnable((Http2Reader)closeable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Http2Stream newStream(int var1_1, List<Header> var2_2, boolean var3_3) throws IOException {
        v0 = this;
        var4_4 = var3_3 ^ true;
        var5_5 = false;
        var6_6 = v0.writer;
        synchronized (var6_6) {
            synchronized (v0) {
            }
            {
                catch (Throwable v1) {
                    throw v1;
                }
                {
                    block14: {
                        block16: {
                            block15: {
                                if (v0.nextStreamId > 0x3FFFFFFF) {
                                    this.shutdown(ErrorCode.REFUSED_STREAM);
                                }
                                if (this.shutdown) break block14;
                                v2 = var3_3;
                                var3_3 = this.nextStreamId;
                                this.nextStreamId = var3_3 + 2;
                                var7_7 = v3;
                                v3 = new Http2Stream((int)var3_3, this, var4_4, var5_5, null);
                                var5_5 = !v2 || this.bytesLeftInWriteWindow == 0L || var7_7.bytesLeftInWriteWindow == 0L;
                                if (!var7_7.isOpen()) break block15;
                                this.streams.put((int)var3_3, var7_7);
                            }
                            try {
                                // ** MonitorExit[this] (shouldn't be in output)
                                if (var1_1 != 0) ** GOTO lbl34
                            }
                            catch (Throwable v4) {}
                            {
                                throw v4;
                            }
                            {
                                block17: {
                                    this.writer.synStream(var4_4, (int)var3_3, var1_1, var2_2);
                                    break block17;
lbl34:
                                    // 1 sources

                                    if (this.client) ** GOTO lbl-1000
                                    this.writer.pushPromise(var1_1, (int)var3_3, var2_2);
                                }
                                // MONITOREXIT @DISABLED, blocks:[5, 9, 11] lbl33 : MonitorExitStatement: MONITOREXIT : var6_6
                                if (!var5_5) break block16;
                            }
                            this.writer.flush();
                        }
                        return var7_7;
lbl-1000:
                        // 1 sources

                        {
                            throw new IllegalArgumentException("client streams shouldn't have associated stream IDs");
                        }
                    }
                    throw new ConnectionShutdownException();
                }
            }
        }
    }

    private void failConnection() {
        try {
            ErrorCode errorCode = ErrorCode.PROTOCOL_ERROR;
            this.close(errorCode, errorCode);
        }
        catch (IOException iOException) {}
    }

    private synchronized void pushExecutorExecute(NamedRunnable namedRunnable) {
        if (!this.shutdown) {
            this.pushExecutor.execute(namedRunnable);
        }
    }

    static /* synthetic */ long access$208(Http2Connection http2Connection) {
        long l2 = http2Connection.intervalPingsSent;
        http2Connection.intervalPingsSent = l2 + 1L;
        return l2;
    }

    static /* synthetic */ boolean access$300(Http2Connection http2Connection) {
        return http2Connection.shutdown;
    }

    static /* synthetic */ ExecutorService access$400() {
        return listenerExecutor;
    }

    static /* synthetic */ long access$108(Http2Connection http2Connection) {
        long l2 = http2Connection.intervalPongsReceived;
        http2Connection.intervalPongsReceived = l2 + 1L;
        return l2;
    }

    static /* synthetic */ long access$608(Http2Connection http2Connection) {
        long l2 = http2Connection.degradedPongsReceived;
        http2Connection.degradedPongsReceived = l2 + 1L;
        return l2;
    }

    static /* synthetic */ long access$708(Http2Connection http2Connection) {
        long l2 = http2Connection.awaitPongsReceived;
        http2Connection.awaitPongsReceived = l2 + 1L;
        return l2;
    }

    static /* synthetic */ boolean access$302(Http2Connection http2Connection, boolean bl) {
        http2Connection.shutdown = bl;
        return bl;
    }

    static {
        SynchronousQueue<Runnable> synchronousQueue;
        $assertionsDisabled = Http2Connection.class.desiredAssertionStatus() ^ true;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        SynchronousQueue<Runnable> synchronousQueue2 = synchronousQueue;
        synchronousQueue = new SynchronousQueue<Runnable>();
        ThreadFactory threadFactory = Util.threadFactory("OkHttp Http2Connection", true);
        listenerExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, timeUnit, synchronousQueue2, threadFactory);
    }

    public Protocol getProtocol() {
        return Protocol.HTTP_2;
    }

    public synchronized int openStreamCount() {
        return this.streams.size();
    }

    synchronized Http2Stream getStream(int n2) {
        return this.streams.get(n2);
    }

    synchronized Http2Stream removeStream(int n2) {
        this.notifyAll();
        return this.streams.remove(n2);
    }

    public synchronized int maxConcurrentStreams() {
        return this.peerSettings.getMaxConcurrentStreams(Integer.MAX_VALUE);
    }

    synchronized void updateConnectionFlowControl(long l2) {
        this.unacknowledgedBytesRead = l2 = this.unacknowledgedBytesRead + l2;
        if (l2 >= (long)(this.okHttpSettings.getInitialWindowSize() / 2)) {
            Http2Connection http2Connection = this;
            long l3 = http2Connection.unacknowledgedBytesRead;
            http2Connection.writeWindowUpdateLater(0, l3);
            http2Connection.unacknowledgedBytesRead = 0L;
        }
    }

    public Http2Stream pushStream(int n2, List<Header> list, boolean bl) throws IOException {
        if (!this.client) {
            return this.newStream(n2, list, bl);
        }
        throw new IllegalStateException("Client cannot push requests.");
    }

    public Http2Stream newStream(List<Header> list, boolean bl) throws IOException {
        return this.newStream(0, list, bl);
    }

    void writeSynReply(int n2, boolean bl, List<Header> list) throws IOException {
        this.writer.synReply(bl, n2, list);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void writeData(int n2, boolean bl, Buffer buffer, long l2) throws IOException {
        if (l2 == 0L) {
            this.writer.data(bl, n2, buffer, 0);
            return;
        }
        while (l2 > 0L) {
            long l3;
            // MONITORENTER : this
            while ((l3 = this.bytesLeftInWriteWindow) <= 0L) {
                if (!this.streams.containsKey(n2)) throw new IOException("stream closed");
                this.wait();
            }
            boolean bl2 = bl;
            Http2Connection http2Connection = this;
            long l4 = l2;
            Http2Connection http2Connection2 = this;
            Http2Connection http2Connection3 = http2Connection2;
            Http2Connection http2Connection4 = http2Connection2;
            int n3 = Math.min((int)Math.min(l2, l3), this.writer.maxDataLength());
            long l5 = http2Connection2.bytesLeftInWriteWindow;
            l3 = n3;
            http2Connection4.bytesLeftInWriteWindow = l5 - l3;
            // MONITOREXIT : http2Connection3
            l3 = l4 - l3;
            Http2Writer http2Writer = http2Connection.writer;
            boolean bl3 = bl2 && l3 == 0L;
            http2Writer.data(bl3, n2, buffer, n3);
            l2 = l3;
        }
        return;
        {
            catch (Throwable throwable) {
                throw throwable;
            }
            catch (InterruptedException interruptedException) {}
            {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        }
    }

    void writeSynResetLater(final int n2, final ErrorCode errorCode) {
        ScheduledExecutorService scheduledExecutorService;
        try {
            scheduledExecutorService = this.writerExecutor;
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
        Object[] objectArray = new Object[2];
        int n3 = 0;
        objectArray[n3] = this.hostname;
        n3 = 1;
        objectArray[n3] = n2;
        scheduledExecutorService.execute(new NamedRunnable("OkHttp %s stream %d", objectArray){

            @Override
            public void execute() {
                Http2Connection http2Connection = Http2Connection.this;
                1 v1 = this;
                1 v2 = v1;
                int n22 = v1.n2;
                try {
                    http2Connection.writeSynReset(n22, v2.errorCode);
                }
                catch (IOException iOException) {
                    Http2Connection.this.failConnection();
                }
            }
        });
    }

    void writeSynReset(int n2, ErrorCode errorCode) throws IOException {
        this.writer.rstStream(n2, errorCode);
    }

    void writeWindowUpdateLater(final int n2, final long l2) {
        ScheduledExecutorService scheduledExecutorService;
        try {
            scheduledExecutorService = this.writerExecutor;
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
        Object[] objectArray = new Object[2];
        int n3 = 0;
        objectArray[n3] = this.hostname;
        n3 = 1;
        objectArray[n3] = n2;
        scheduledExecutorService.execute(new NamedRunnable("OkHttp Window Update %s stream %d", objectArray){

            @Override
            public void execute() {
                Http2Writer http2Writer = Http2Connection.this.writer;
                2 v1 = this;
                2 v2 = v1;
                int n22 = v1.n2;
                long l22 = v2.l2;
                try {
                    http2Writer.windowUpdate(n22, l22);
                }
                catch (IOException iOException) {
                    Http2Connection.this.failConnection();
                }
            }
        });
    }

    void writePing(boolean bl, int n2, int n3) {
        try {
            this.writer.ping(bl, n2, n3);
        }
        catch (IOException iOException) {
            this.failConnection();
        }
    }

    void writePingAndAwaitPong() throws InterruptedException {
        Http2Connection http2Connection = this;
        http2Connection.writePing();
        http2Connection.awaitPong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writePing() {
        Http2Connection http2Connection = this;
        synchronized (http2Connection) {
            long l2 = http2Connection.awaitPingsSent;
            http2Connection.awaitPingsSent = l2 + 1L;
            // MONITOREXIT @DISABLED, blocks:[1, 2] lbl7 : MonitorExitStatement: MONITOREXIT : v173344
            http2Connection.writePing(false, 3, 1330343787);
            return;
        }
    }

    synchronized void awaitPong() throws InterruptedException {
        while (this.awaitPongsReceived < this.awaitPingsSent) {
            this.wait();
        }
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void shutdown(ErrorCode errorCode) throws IOException {
        Http2Writer http2Writer;
        block9: {
            Http2Connection http2Connection = this;
            http2Writer = http2Connection.writer;
            // MONITORENTER : http2Writer
            if (!http2Connection.shutdown) break block9;
            Http2Writer http2Writer2 = http2Writer;
            // MONITOREXIT : this
            // MONITOREXIT : http2Writer2
            return;
        }
        Http2Writer http2Writer3 = http2Writer;
        Http2Connection http2Connection = this;
        Http2Connection http2Connection2 = http2Connection;
        http2Connection.shutdown = true;
        int n2 = http2Connection.lastGoodStreamId;
        // MONITOREXIT : http2Connection
        {
            catch (Throwable throwable) {
                // MONITOREXIT : this
                throw throwable;
            }
        }
        http2Connection2.writer.goAway(n2, errorCode, Util.EMPTY_BYTE_ARRAY);
        // MONITOREXIT : http2Writer3
    }

    @Override
    public void close() throws IOException {
        this.close(ErrorCode.NO_ERROR, ErrorCode.CANCEL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void close(ErrorCode errorCode, ErrorCode errorCode2) throws IOException {
        if (!$assertionsDisabled && Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        ErrorCode errorCode3 = errorCode;
        errorCode = null;
        try {
            this.shutdown(errorCode3);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Http2Connection http2Connection = this;
        Http2Stream[] http2StreamArray = null;
        synchronized (http2Connection) {
            block17: {
                block15: {
                    if (!http2Connection.streams.isEmpty()) {
                        Http2Connection http2Connection2 = this;
                        http2StreamArray = http2Connection2.streams.values().toArray(new Http2Stream[this.streams.size()]);
                        http2Connection2.streams.clear();
                    }
                    // ** MonitorExit[this] (shouldn't be in output)
                    if (http2StreamArray == null) break block15;
                    int n2 = http2StreamArray.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        ErrorCode errorCode4;
                        block16: {
                            try {
                                http2StreamArray[i2].close(errorCode2);
                            }
                            catch (IOException iOException) {
                                if (errorCode != null) break block16;
                            }
                            errorCode4 = errorCode;
                        }
                        errorCode = errorCode4;
                    }
                }
                try {
                    this.writer.close();
                }
                catch (IOException iOException) {
                    if (errorCode == null) break block17;
                }
                errorCode2 = errorCode;
            }
            try {
                this.socket.close();
                errorCode = errorCode2;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Http2Connection http2Connection3 = this;
            http2Connection3.writerExecutor.shutdown();
            http2Connection3.pushExecutor.shutdown();
            if (errorCode == null) {
                return;
            }
            throw errorCode;
        }
    }

    public void start() throws IOException {
        this.start(true);
    }

    void start(boolean n2) throws IOException {
        if (n2) {
            Http2Connection http2Connection = this;
            http2Connection.writer.connectionPreface();
            http2Connection.writer.settings(this.okHttpSettings);
            n2 = http2Connection.okHttpSettings.getInitialWindowSize();
            if (n2 != 65535) {
                long l2 = n2 - 65535;
                this.writer.windowUpdate(0, l2);
            }
        }
        new Thread(this.readerRunnable).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSettings(Settings settings) throws IOException {
        Http2Connection http2Connection = this;
        Http2Writer http2Writer = http2Connection.writer;
        synchronized (http2Writer) {
            synchronized (http2Connection) {
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
                {
                    block9: {
                        try {
                            if (http2Connection.shutdown) break block9;
                            Http2Connection http2Connection2 = this;
                            http2Connection2.okHttpSettings.merge(settings);
                            // ** MonitorExit[v2] (shouldn't be in output)
                            {
                                http2Connection2.writer.settings(settings);
                            }
                        }
                        catch (Throwable throwable) {}
                        {
                            throw throwable;
                        }
                        return;
                    }
                    throw new ConnectionShutdownException();
                }
            }
        }
    }

    public synchronized boolean isHealthy(long l2) {
        if (this.shutdown) {
            return false;
        }
        return this.degradedPongsReceived >= this.degradedPingsSent || l2 < this.degradedPongDeadlineNs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void sendDegradedPingLater() {
        Http2Connection http2Connection = this;
        synchronized (http2Connection) {
            long l2;
            block9: {
                l2 = this.degradedPingsSent;
                if (http2Connection.degradedPongsReceived >= l2) break block9;
                {
                    // ** MonitorExit[this] (shouldn't be in output)
                    return;
                }
            }
            Http2Connection http2Connection2 = this;
            {
                http2Connection2.degradedPingsSent = l2 + 1L;
                http2Connection2.degradedPongDeadlineNs = System.nanoTime() + 1000000000L;
                // ** MonitorExit[v2] (shouldn't be in output)
            }
            try {
                Object[] objectArray = new Object[1];
                int n2 = 0;
                objectArray[n2] = this.hostname;
                http2Connection2.writerExecutor.execute(new NamedRunnable("OkHttp %s ping", objectArray){

                    @Override
                    public void execute() {
                        Http2Connection.this.writePing(false, 2, 0);
                    }
                });
                return;
            }
            catch (RejectedExecutionException rejectedExecutionException) {}
            return;
        }
    }

    boolean pushedStream(int n2) {
        return n2 != 0 && (n2 & 1) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void pushRequestLater(final int n2, final List<Header> list) {
        Http2Connection http2Connection = this;
        synchronized (http2Connection) {
            int n3;
            Object[] objectArray;
            if (http2Connection.currentPushRequests.contains(n2)) {
                Http2Connection http2Connection2 = this;
                http2Connection2.writeSynResetLater(n2, ErrorCode.PROTOCOL_ERROR);
                // ** MonitorExit[v1] (shouldn't be in output)
                return;
            }
            Http2Connection http2Connection3 = this;
            Http2Connection http2Connection4 = http2Connection3;
            Http2Connection http2Connection5 = http2Connection3;
            http2Connection3.currentPushRequests.add(n2);
            {
                // ** MonitorExit[v4] (shouldn't be in output)
            }
            try {
                objectArray = new Object[2];
                n3 = 0;
            }
            catch (RejectedExecutionException rejectedExecutionException) {}
            objectArray[n3] = this.hostname;
            n3 = 1;
            objectArray[n3] = n2;
            http2Connection4.pushExecutorExecute(new NamedRunnable("OkHttp %s Push Request[%s]", objectArray){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void execute() {
                    4 v0 = this;
                    int n22 = v0.n2;
                    if (!Http2Connection.this.pushObserver.onRequest(n22, v0.list)) return;
                    4 v1 = this;
                    v1.Http2Connection.this.writer.rstStream(n2, ErrorCode.CANCEL);
                    Http2Connection http2Connection = v1.Http2Connection.this;
                    4 v2 = this;
                    // MONITORENTER : http2Connection
                    {
                        catch (IOException iOException) {}
                    }
                    v2.Http2Connection.this.currentPushRequests.remove(n2);
                    // MONITOREXIT : http2Connection
                    return;
                }
            });
            return;
        }
    }

    void pushHeadersLater(final int n2, final List<Header> list, final boolean bl) {
        Http2Connection http2Connection;
        try {
            http2Connection = this;
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
        Object[] objectArray = new Object[2];
        int n3 = 0;
        objectArray[n3] = this.hostname;
        n3 = 1;
        objectArray[n3] = n2;
        http2Connection.pushExecutorExecute(new NamedRunnable("OkHttp %s Push Headers[%s]", objectArray){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void execute() {
                v0 = this;
                var1_1 = v0.n2;
                var2_3 = v0.list;
                var3_4 = v0.bl;
                v1 = Http2Connection.this.pushObserver.onHeaders(var1_1, var2_3, var3_4);
                var1_1 = (int)v1;
                if (!v1) ** GOTO lbl13
                Http2Connection.this.writer.rstStream(n2, ErrorCode.CANCEL);
                {
                    catch (IOException v2) {
                        return;
                    }
lbl13:
                    // 2 sources

                    if (var1_1 != 0) ** GOTO lbl15
                    {
                        if (bl == false) return;
lbl15:
                        // 2 sources

                        var1_2 = Http2Connection.this;
                    }
                    {
                        v3 = this;
                        ** synchronized (var1_2)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            v3.Http2Connection.this.currentPushRequests.remove(n2);
                        }
                        catch (Throwable v4) {}
                        {
                            throw v4;
                        }
                        return;
                    }
                }
            }
        });
    }

    void pushDataLater(final int n2, BufferedSource bufferedSource, int n3, boolean bl) throws IOException {
        Buffer buffer;
        BufferedSource bufferedSource2 = bufferedSource;
        bufferedSource = buffer;
        buffer = new Buffer();
        long l2 = n3;
        bufferedSource2.require(l2);
        bufferedSource2.read((Buffer)bufferedSource, l2);
        if (((Buffer)bufferedSource).size() == l2) {
            NamedRunnable namedRunnable;
            NamedRunnable namedRunnable2 = namedRunnable;
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = this.hostname;
            objectArray[1] = n2;
            namedRunnable = new NamedRunnable("OkHttp %s Push Data[%s]", objectArray2, (Buffer)bufferedSource, n3, bl){
                final /* synthetic */ Buffer val$buffer;
                final /* synthetic */ int val$byteCount;
                final /* synthetic */ boolean val$inFinished;
                {
                    this.val$buffer = buffer;
                    this.val$byteCount = n3;
                    this.val$inFinished = bl;
                    super(string2, objectArray);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void execute() {
                    v0 = this;
                    var1_1 = v0.n2;
                    var2_3 = v0.val$buffer;
                    var3_4 = v0.val$byteCount;
                    var4_5 = v0.val$inFinished;
                    v1 = Http2Connection.this.pushObserver.onData(var1_1, var2_3, var3_4, var4_5);
                    {
                        catch (IOException v2) {}
                    }
                    var1_1 = (int)v1;
                    if (!v1) ** GOTO lbl13
                    Http2Connection.this.writer.rstStream(n2, ErrorCode.CANCEL);
lbl13:
                    // 2 sources

                    if (var1_1 == 0) {
                        if (this.val$inFinished == false) return;
                    }
                    var1_2 = Http2Connection.this;
                    v3 = this;
                    // MONITORENTER : var1_2
                    v3.Http2Connection.this.currentPushRequests.remove(n2);
                    // MONITOREXIT : var1_2
                    return;
                }
            };
            this.pushExecutorExecute(namedRunnable2);
            return;
        }
        throw new IOException(((Buffer)bufferedSource).size() + " != " + n3);
    }

    void pushResetLater(final int n2, final ErrorCode errorCode) {
        NamedRunnable namedRunnable;
        NamedRunnable namedRunnable2 = namedRunnable;
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.hostname;
        objectArray[1] = n2;
        namedRunnable = new NamedRunnable("OkHttp %s Push Reset[%s]", objectArray2){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                7 v0 = this;
                7 v1 = this;
                int n22 = v1.n2;
                v0.Http2Connection.this.pushObserver.onReset(n22, v1.errorCode);
                Http2Connection http2Connection = v0.Http2Connection.this;
                synchronized (http2Connection) {
                    Http2Connection.this.currentPushRequests.remove(n2);
                    return;
                }
            }
        };
        this.pushExecutorExecute(namedRunnable2);
    }

    public static abstract class Listener {
        public static final Listener REFUSE_INCOMING_STREAMS = new Listener(){

            @Override
            public void onStream(Http2Stream http2Stream) throws IOException {
                http2Stream.close(ErrorCode.REFUSED_STREAM);
            }
        };

        public abstract void onStream(Http2Stream var1) throws IOException;

        public void onSettings(Http2Connection http2Connection) {
        }
    }

    class ReaderRunnable
    extends NamedRunnable
    implements Http2Reader.Handler {
        final Http2Reader reader;

        ReaderRunnable(Http2Reader http2Reader) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[1];
            Object[] objectArray3 = objectArray2;
            objectArray2[0] = objectArray3.Http2Connection.this.hostname;
            super("OkHttp %s", objectArray3);
            objectArray3.reader = http2Reader;
        }

        /*
         * Loose catch block
         * WARNING - void declaration
         */
        @Override
        protected void execute() {
            void var3_5;
            ErrorCode errorCode;
            ErrorCode errorCode2;
            block16: {
                block14: {
                    block15: {
                        errorCode2 = ErrorCode.INTERNAL_ERROR;
                        this.reader.readConnectionPreface(this);
                        while (this.reader.nextFrame(false, this)) {
                        }
                        ReaderRunnable readerRunnable = this;
                        errorCode = ErrorCode.NO_ERROR;
                        errorCode2 = ErrorCode.CANCEL;
                        try {
                            readerRunnable.Http2Connection.this.close(errorCode, errorCode2);
                            break block14;
                        }
                        catch (IOException iOException) {}
                        catch (IOException iOException) {
                            break block15;
                        }
                        catch (Throwable throwable) {
                            errorCode = errorCode2;
                            break block16;
                        }
                        catch (IOException iOException) {
                            errorCode = errorCode2;
                        }
                    }
                    ReaderRunnable readerRunnable = this;
                    errorCode2 = ErrorCode.PROTOCOL_ERROR;
                    ErrorCode errorCode3 = errorCode2;
                    readerRunnable.Http2Connection.this.close(errorCode3, errorCode3);
                }
                Util.closeQuietly(this.reader);
                return;
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                Http2Connection.this.close(errorCode, errorCode2);
            }
            catch (IOException iOException) {}
            Util.closeQuietly(this.reader);
            throw var3_5;
        }

        @Override
        public void data(boolean bl, int n2, BufferedSource bufferedSource, int n3) throws IOException {
            if (Http2Connection.this.pushedStream(n2)) {
                Http2Connection.this.pushDataLater(n2, bufferedSource, n3, bl);
                return;
            }
            Http2Stream http2Stream = Http2Connection.this.getStream(n2);
            if (http2Stream == null) {
                ReaderRunnable readerRunnable = this;
                readerRunnable.Http2Connection.this.writeSynResetLater(n2, ErrorCode.PROTOCOL_ERROR);
                long l2 = n3;
                readerRunnable.Http2Connection.this.updateConnectionFlowControl(l2);
                bufferedSource.skip(l2);
                return;
            }
            http2Stream.receiveData(bufferedSource, n3);
            if (bl) {
                http2Stream.receiveFin();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void headers(boolean var1_2, int var2_4, int var3_5, List<Header> var4_7) {
            if (Http2Connection.this.pushedStream(var2_4)) {
                Http2Connection.this.pushHeadersLater(var2_4, (List<Header>)var4_7, var1_2);
                return;
            }
            v0 = this;
            var3_6 = v0.Http2Connection.this;
            synchronized (var3_6) {
                var5_8 = v0.Http2Connection.this.getStream(var2_4);
                if (var5_8 != null) ** GOTO lbl46
                if (!Http2Connection.access$300(Http2Connection.this)) ** GOTO lbl16
                return;
lbl16:
                // 1 sources

                v2 = var2_4;
                var5_8 = Http2Connection.this;
                if (v2 > var5_8.lastGoodStreamId) ** GOTO lbl22
                return;
lbl22:
                // 1 sources

                if (var2_4 % 2 != var5_8.nextStreamId % 2) ** GOTO lbl25
                return;
lbl25:
                // 1 sources

                v3 = var3_6;
                v4 = this;
                var4_7 = Util.toHeaders(var4_7);
                var5_8 = v5;
                v5 = new Http2Stream(var2_4, Http2Connection.this, false, var1_2, (Headers)var4_7);
                v4.Http2Connection.this.lastGoodStreamId = var2_4;
                v4.Http2Connection.this.streams.put(var2_4, (Http2Stream)var5_8);
                v6 = Http2Connection.access$400();
                var1_3 = new Object[2];
                var1_3[0] = Http2Connection.this.hostname;
                var0_1 = 1;
                var1_3[var0_1] = var2_4;
                v6.execute(new NamedRunnable("OkHttp %s stream %d", var1_3, (Http2Stream)var5_8){
                    final /* synthetic */ Http2Stream val$newStream;
                    {
                        this.val$newStream = http2Stream;
                        super(string2, objectArray);
                    }

                    @Override
                    public void execute() {
                        try {
                            Http2Connection.this.listener.onStream(this.val$newStream);
                        }
                        catch (IOException iOException) {
                            Platform.get().log(4, "Http2Connection.Listener failure for " + Http2Connection.this.hostname, iOException);
                            try {
                                this.val$newStream.close(ErrorCode.PROTOCOL_ERROR);
                            }
                            catch (IOException iOException2) {}
                        }
                    }
                });
                // ** MonitorExit[v3] (shouldn't be in output)
                return;
lbl46:
                // 1 sources

                // MONITOREXIT @DISABLED, blocks:[11, 12] lbl47 : MonitorExitStatement: MONITOREXIT : var3_6
                var5_8.receiveHeaders((List<Header>)var4_7);
                if (var1_2) {
                    var5_8.receiveFin();
                }
                return;
            }
        }

        @Override
        public void rstStream(int n2, ErrorCode errorCode) {
            if (((ReaderRunnable)((Object)http2Stream)).Http2Connection.this.pushedStream(n2)) {
                ((ReaderRunnable)((Object)http2Stream)).Http2Connection.this.pushResetLater(n2, errorCode);
                return;
            }
            Http2Stream http2Stream = ((ReaderRunnable)((Object)http2Stream)).Http2Connection.this.removeStream(n2);
            if (http2Stream != null) {
                http2Stream.receiveRstStream(errorCode);
            }
        }

        @Override
        public void settings(final boolean bl, final Settings settings) {
            ScheduledExecutorService scheduledExecutorService;
            try {
                scheduledExecutorService = Http2Connection.this.writerExecutor;
            }
            catch (RejectedExecutionException rejectedExecutionException) {}
            Object[] objectArray = new Object[1];
            objectArray[0] = Http2Connection.this.hostname;
            scheduledExecutorService.execute(new NamedRunnable("OkHttp %s ACK Settings", objectArray){

                @Override
                public void execute() {
                    2 v0 = this;
                    boolean bl2 = v0.bl;
                    ReaderRunnable.this.applyAndAckSettings(bl2, v0.settings);
                }
            });
        }

        /*
         * Exception decompiling
         */
        void applyAndAckSettings(boolean var1_1, Settings var2_3) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void ackSettings() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void ping(boolean var1_1, int var2_3, int var3_4) {
            block7: {
                if (!var1_1) break block7;
                var1_2 = Http2Connection.this;
                synchronized (var1_2) {
                    block9: {
                        block8: {
                            if (var2_3 != 1) break block8;
                            try {
                                v0 = Http2Connection.access$108(Http2Connection.this);
                                ** GOTO lbl20
                            }
                            catch (Throwable v1) {
                                break block9;
                            }
                        }
                        if (var2_3 != 2) ** GOTO lbl14
                        {
                            v0 = Http2Connection.access$608(Http2Connection.this);
                            ** GOTO lbl20
lbl14:
                            // 1 sources

                            if (var2_3 != 3) return;
                            v2 = this;
                            v3 = v2;
                            Http2Connection.access$708(v2.Http2Connection.this);
                        }
                        {
                            v3.Http2Connection.this.notifyAll();
lbl20:
                            // 3 sources

                            return;
                        }
                    }
                    throw v1;
                }
            }
            try {
                Http2Connection.access$500(Http2Connection.this).execute(new PingRunnable(true, var2_3, var3_4));
                return;
            }
            catch (RejectedExecutionException v4) {}
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void goAway(int n2, ErrorCode object, ByteString http2StreamArray) {
            ReaderRunnable readerRunnable = this;
            http2StreamArray.size();
            object = readerRunnable.Http2Connection.this;
            synchronized (object) {
                http2StreamArray = readerRunnable.Http2Connection.this.streams.values().toArray(new Http2Stream[Http2Connection.this.streams.size()]);
                Object object2 = object;
                Http2Connection.access$302(Http2Connection.this, true);
                // ** MonitorExit[v1 /* !! */ ] (shouldn't be in output)
                for (Http2Stream http2Stream : http2StreamArray) {
                    if (http2Stream.getId() <= n2 || !http2Stream.isLocallyInitiated()) continue;
                    http2Stream.receiveRstStream(ErrorCode.REFUSED_STREAM);
                    Http2Connection.this.removeStream(http2Stream.getId());
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void windowUpdate(int n2, long l2) {
            if (n2 == 0) {
                Http2Connection http2Connection = ((ReaderRunnable)((Object)http2Stream)).Http2Connection.this;
                synchronized (http2Connection) {
                    Http2Connection http2Connection2 = ((ReaderRunnable)((Object)http2Stream)).Http2Connection.this;
                    Http2Connection http2Connection3 = http2Connection2;
                    Http2Connection http2Connection4 = http2Connection2;
                    long l3 = http2Connection2.bytesLeftInWriteWindow;
                    http2Connection4.bytesLeftInWriteWindow = l3 + l2;
                    http2Connection3.notifyAll();
                    return;
                }
            }
            Http2Stream http2Stream = ((ReaderRunnable)((Object)http2Stream)).Http2Connection.this.getStream(n2);
            if (http2Stream == null) return;
            Object object = http2Stream;
            synchronized (http2Stream) {
                ((Http2Stream)object).addBytesToWriteWindow(l2);
                // ** MonitorExit[v5] (shouldn't be in output)
                return;
            }
        }

        @Override
        public void priority(int n2, int n3, int n4, boolean bl) {
        }

        @Override
        public void pushPromise(int n2, int n3, List<Header> list) {
            Http2Connection.this.pushRequestLater(n3, list);
        }

        @Override
        public void alternateService(int n2, String string2, ByteString byteString, String string3, int n3, long l2) {
        }
    }

    public static class Builder {
        Socket socket;
        String hostname;
        BufferedSource source;
        BufferedSink sink;
        Listener listener = Listener.REFUSE_INCOMING_STREAMS;
        PushObserver pushObserver = PushObserver.CANCEL;
        boolean client;
        int pingIntervalMillis;

        public Builder(boolean bl) {
            this.client = bl;
        }

        public Builder socket(Socket closeable) throws IOException {
            Builder builder = string2;
            Socket socket = closeable;
            String string2 = ((InetSocketAddress)socket.getRemoteSocketAddress()).getHostName();
            closeable = Okio.buffer(Okio.source(socket));
            BufferedSink bufferedSink = Okio.buffer(Okio.sink(socket));
            return builder.socket(socket, string2, (BufferedSource)closeable, bufferedSink);
        }

        public Builder socket(Socket socket, String string2, BufferedSource bufferedSource, BufferedSink bufferedSink) {
            this.socket = socket;
            this.hostname = string2;
            this.source = bufferedSource;
            this.sink = bufferedSink;
            return this;
        }

        public Builder listener(Listener listener) {
            this.listener = listener;
            return this;
        }

        public Builder pushObserver(PushObserver pushObserver) {
            this.pushObserver = pushObserver;
            return this;
        }

        public Builder pingIntervalMillis(int n2) {
            this.pingIntervalMillis = n2;
            return this;
        }

        public Http2Connection build() {
            return new Http2Connection(this);
        }
    }

    final class IntervalPingRunnable
    extends NamedRunnable {
        IntervalPingRunnable() {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = objectArray2.Http2Connection.this.hostname;
            super("OkHttp %s ping", objectArray2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void execute() {
            boolean bl;
            block6: {
                IntervalPingRunnable intervalPingRunnable = this;
                Http2Connection http2Connection = intervalPingRunnable.Http2Connection.this;
                // MONITORENTER : http2Connection
                if (intervalPingRunnable.Http2Connection.this.intervalPongsReceived < Http2Connection.this.intervalPingsSent) {
                    bl = true;
                    break block6;
                }
                Http2Connection.access$208(Http2Connection.this);
                bl = false;
            }
            if (bl) {
                Http2Connection.this.failConnection();
                return;
            }
            Http2Connection.this.writePing(false, 1, 0);
        }
    }

    final class PingRunnable
    extends NamedRunnable {
        final boolean reply;
        final int payload1;
        final int payload2;

        PingRunnable(boolean bl, int n2, int n3) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            Object[] objectArray3 = objectArray2;
            objectArray3[0] = objectArray3.Http2Connection.this.hostname;
            objectArray3[1] = n2;
            objectArray2[2] = n3;
            super("OkHttp %s ping %08x%08x", objectArray3);
            objectArray.reply = bl;
            objectArray.payload1 = n2;
            objectArray3.payload2 = n3;
        }

        @Override
        public void execute() {
            PingRunnable pingRunnable = this;
            boolean bl = pingRunnable.reply;
            int n2 = pingRunnable.payload1;
            int n3 = pingRunnable.payload2;
            Http2Connection.this.writePing(bl, n2, n3);
        }
    }
}

