/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.connection;

import dc.squareup.okhttp3.ConnectionSpec;
import dc.squareup.okhttp3.internal.Internal;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.UnknownServiceException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;

public final class ConnectionSpecSelector {
    private final List<ConnectionSpec> connectionSpecs;
    private int nextModeIndex = 0;
    private boolean isFallbackPossible;
    private boolean isFallback;

    public ConnectionSpecSelector(List<ConnectionSpec> list) {
        this.connectionSpecs = list;
    }

    private boolean isFallbackPossible(SSLSocket sSLSocket) {
        for (int i2 = this.nextModeIndex; i2 < this.connectionSpecs.size(); ++i2) {
            if (!this.connectionSpecs.get(i2).isCompatible(sSLSocket)) continue;
            return true;
        }
        return false;
    }

    public ConnectionSpec configureSecureSocket(SSLSocket sSLSocket) throws IOException {
        ConnectionSpec connectionSpec;
        block2: {
            ConnectionSpec connectionSpec2 = null;
            int n2 = this.connectionSpecs.size();
            for (int i2 = (v966931).nextModeIndex; i2 < n2; ++i2) {
                connectionSpec = this.connectionSpecs.get(i2);
                if (!connectionSpec.isCompatible(sSLSocket)) continue;
                this.nextModeIndex = i2 + 1;
                break block2;
            }
            connectionSpec = connectionSpec2;
        }
        if (connectionSpec != null) {
            this.isFallbackPossible = this.isFallbackPossible(sSLSocket);
            Internal.instance.apply(connectionSpec, sSLSocket, this.isFallback);
            return connectionSpec;
        }
        throw new UnknownServiceException("Unable to find acceptable protocols. isFallback=" + this.isFallback + ", modes=" + this.connectionSpecs + ", supported protocols=" + Arrays.toString(sSLSocket.getEnabledProtocols()));
    }

    public boolean connectionFailed(IOException iOException) {
        this.isFallback = true;
        if (!this.isFallbackPossible) {
            return false;
        }
        if (iOException instanceof ProtocolException) {
            return false;
        }
        if (iOException instanceof InterruptedIOException) {
            return false;
        }
        boolean bl = iOException instanceof SSLHandshakeException;
        if (bl && iOException.getCause() instanceof CertificateException) {
            return false;
        }
        if (iOException instanceof SSLPeerUnverifiedException) {
            return false;
        }
        return bl || iOException instanceof SSLProtocolException || iOException instanceof SSLException;
    }
}

