/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.cache;

import android.support.annotation.Nullable;
import dc.squareup.okhttp3.CacheControl;
import dc.squareup.okhttp3.Headers;
import dc.squareup.okhttp3.Request;
import dc.squareup.okhttp3.Response;
import dc.squareup.okhttp3.internal.Internal;
import dc.squareup.okhttp3.internal.http.HttpDate;
import dc.squareup.okhttp3.internal.http.HttpHeaders;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public final class CacheStrategy {
    @Nullable
    public final Request networkRequest;
    @Nullable
    public final Response cacheResponse;

    CacheStrategy(Request request, Response response) {
        this.networkRequest = request;
        this.cacheResponse = response;
    }

    public static boolean isCacheable(Response response, Request request) {
        switch (response.code()) {
            default: {
                break;
            }
            case 302: 
            case 307: {
                if (response.header("Expires") == null && response.cacheControl().maxAgeSeconds() == -1 && !response.cacheControl().isPublic() && !response.cacheControl().isPrivate()) break;
            }
            case 200: 
            case 203: 
            case 204: 
            case 300: 
            case 301: 
            case 308: 
            case 404: 
            case 405: 
            case 410: 
            case 414: 
            case 501: {
                return !response.cacheControl().noStore() && !request.cacheControl().noStore();
            }
        }
        return false;
    }

    public static class Factory {
        final long nowMillis;
        final Request request;
        final Response cacheResponse;
        private Date servedDate;
        private String servedDateString;
        private Date lastModified;
        private String lastModifiedString;
        private Date expires;
        private long sentRequestMillis;
        private long receivedResponseMillis;
        private String etag;
        private int ageSeconds = -1;

        public Factory(long l2, Request request, Response object) {
            this.nowMillis = l2;
            this.request = request;
            this.cacheResponse = object;
            if (object != null) {
                this.sentRequestMillis = ((Response)object).sentRequestAtMillis();
                this.receivedResponseMillis = ((Response)object).receivedResponseAtMillis();
                Headers headers = ((Response)object).headers();
                int n2 = headers.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    object = headers.name(i2);
                    String string2 = headers.value(i2);
                    if ("Date".equalsIgnoreCase((String)object)) {
                        this.servedDate = HttpDate.parse(string2);
                        this.servedDateString = string2;
                        continue;
                    }
                    if ("Expires".equalsIgnoreCase((String)object)) {
                        this.expires = HttpDate.parse(string2);
                        continue;
                    }
                    if ("Last-Modified".equalsIgnoreCase((String)object)) {
                        this.lastModified = HttpDate.parse(string2);
                        this.lastModifiedString = string2;
                        continue;
                    }
                    if ("ETag".equalsIgnoreCase((String)object)) {
                        this.etag = string2;
                        continue;
                    }
                    if (!"Age".equalsIgnoreCase((String)object)) continue;
                    this.ageSeconds = HttpHeaders.parseSeconds(string2, -1);
                }
            }
        }

        private CacheStrategy getCandidate() {
            block12: {
                block16: {
                    Object object;
                    Object object2;
                    block14: {
                        block15: {
                            block13: {
                                long l2;
                                if (this.cacheResponse == null) {
                                    return new CacheStrategy(this.request, null);
                                }
                                if (this.request.isHttps() && this.cacheResponse.handshake() == null) {
                                    return new CacheStrategy(this.request, null);
                                }
                                if (!CacheStrategy.isCacheable(this.cacheResponse, this.request)) {
                                    return new CacheStrategy(this.request, null);
                                }
                                object2 = this.request.cacheControl();
                                if (((CacheControl)object2).noCache() || Factory.hasConditions(this.request)) break block12;
                                Factory factory = this;
                                object = factory.cacheResponse.cacheControl();
                                long l3 = factory.cacheResponseAge();
                                long l4 = factory.computeFreshnessLifetime();
                                if (((CacheControl)object2).maxAgeSeconds() != -1) {
                                    l4 = Math.min(l4, TimeUnit.SECONDS.toMillis(((CacheControl)object2).maxAgeSeconds()));
                                }
                                long l5 = 0L;
                                if (((CacheControl)object2).minFreshSeconds() != -1) {
                                    l5 = TimeUnit.SECONDS.toMillis(((CacheControl)object2).minFreshSeconds());
                                }
                                long l6 = 0L;
                                if (!((CacheControl)object).mustRevalidate() && ((CacheControl)object2).maxStaleSeconds() != -1) {
                                    l6 = TimeUnit.SECONDS.toMillis(((CacheControl)object2).maxStaleSeconds());
                                }
                                if (!((CacheControl)object).noCache() && (l2 = l3 + l5) < l4 + l6) {
                                    Response.Builder builder = this.cacheResponse.newBuilder();
                                    if (l2 >= l4) {
                                        builder.addHeader("Warning", "110 HttpURLConnection \"Response is stale\"");
                                    }
                                    if (l3 > 86400000L && this.isFreshnessLifetimeHeuristic()) {
                                        builder.addHeader("Warning", "113 HttpURLConnection \"Heuristic expiration\"");
                                    }
                                    return new CacheStrategy(null, builder.build());
                                }
                                object2 = this.etag;
                                if (object2 == null) break block13;
                                object = "If-None-Match";
                                break block14;
                            }
                            if (this.lastModified == null) break block15;
                            object = "If-Modified-Since";
                            object2 = this.lastModifiedString;
                            break block14;
                        }
                        if (this.servedDate == null) break block16;
                        object = "If-Modified-Since";
                        object2 = this.servedDateString;
                    }
                    Factory factory = this;
                    Headers.Builder builder = factory.request.headers().newBuilder();
                    Internal.instance.addLenient(builder, (String)object, (String)object2);
                    object2 = factory.request.newBuilder().headers(builder.build()).build();
                    return new CacheStrategy((Request)object2, this.cacheResponse);
                }
                return new CacheStrategy(this.request, null);
            }
            return new CacheStrategy(this.request, null);
        }

        private long computeFreshnessLifetime() {
            Object object = this.cacheResponse.cacheControl();
            if (((CacheControl)object).maxAgeSeconds() != -1) {
                return TimeUnit.SECONDS.toMillis(((CacheControl)object).maxAgeSeconds());
            }
            if (this.expires != null) {
                object = this.servedDate;
                long l2 = object != null ? ((Date)object).getTime() : this.receivedResponseMillis;
                l2 = this.expires.getTime() - l2;
                if (l2 <= 0L) {
                    l2 = 0L;
                }
                return l2;
            }
            if (this.lastModified != null && this.cacheResponse.request().url().query() == null) {
                object = this.servedDate;
                long l3 = (object != null ? ((Date)object).getTime() : this.sentRequestMillis) - this.lastModified.getTime();
                return l3 > 0L ? l3 / 10L : 0L;
            }
            return 0L;
        }

        private long cacheResponseAge() {
            long l2;
            Date date = this.servedDate;
            if (date != null) {
                l2 = this.receivedResponseMillis - date.getTime();
                l2 = Math.max(0L, l2);
            } else {
                l2 = 0L;
            }
            int n2 = this.ageSeconds;
            if (n2 != -1) {
                l2 = Math.max(l2, TimeUnit.SECONDS.toMillis(n2));
            }
            long l3 = l2;
            long l4 = this.receivedResponseMillis;
            l2 = l4;
            l2 = this.nowMillis - l2;
            return l3 + (l4 - this.sentRequestMillis) + l2;
        }

        private boolean isFreshnessLifetimeHeuristic() {
            return this.cacheResponse.cacheControl().maxAgeSeconds() == -1 && this.expires == null;
        }

        private static boolean hasConditions(Request request) {
            return request.header("If-Modified-Since") != null || request.header("If-None-Match") != null;
        }

        public CacheStrategy get() {
            CacheStrategy cacheStrategy = this.getCandidate();
            if (cacheStrategy.networkRequest != null && this.request.cacheControl().onlyIfCached()) {
                return new CacheStrategy(null, null);
            }
            return cacheStrategy;
        }
    }
}

