/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal;

import android.support.annotation.Nullable;
import dc.squareup.okhttp3.Headers;
import dc.squareup.okhttp3.HttpUrl;
import dc.squareup.okhttp3.RequestBody;
import dc.squareup.okhttp3.ResponseBody;
import dc.squareup.okhttp3.internal.Internal;
import dc.squareup.okhttp3.internal.http2.Header;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.Source;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.IDN;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public final class Util {
    public static final byte[] EMPTY_BYTE_ARRAY;
    public static final String[] EMPTY_STRING_ARRAY;
    public static final ResponseBody EMPTY_RESPONSE;
    public static final RequestBody EMPTY_REQUEST;
    private static final ByteString UTF_8_BOM;
    private static final ByteString UTF_16_BE_BOM;
    private static final ByteString UTF_16_LE_BOM;
    private static final ByteString UTF_32_BE_BOM;
    private static final ByteString UTF_32_LE_BOM;
    public static final Charset UTF_8;
    public static final Charset ISO_8859_1;
    private static final Charset UTF_16_BE;
    private static final Charset UTF_16_LE;
    private static final Charset UTF_32_BE;
    private static final Charset UTF_32_LE;
    public static final TimeZone UTC;
    public static final Comparator<String> NATURAL_ORDER;
    private static final Method addSuppressedExceptionMethod;
    private static final Pattern VERIFY_AS_IP_ADDRESS;

    public static void addSuppressedIfPossible(Throwable throwable, Throwable throwable2) {
        Method method = addSuppressedExceptionMethod;
        if (method != null) {
            try {
                method.invoke((Object)throwable, throwable2);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
    }

    private Util() {
    }

    public static void checkOffsetAndCount(long l2, long l3, long l4) {
        if ((l3 | l4) >= 0L && l3 <= l2 && l2 - l3 >= l4) {
            return;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public static boolean equal(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
        }
    }

    public static void closeQuietly(Socket object) {
        block5: {
            if (object != null) {
                try {
                    ((Socket)object).close();
                }
                catch (Exception exception) {
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (AssertionError assertionError) {
                    object = assertionError;
                    if (Util.isAndroidGetsocknameError(assertionError)) break block5;
                    throw object;
                }
            }
        }
    }

    public static void closeQuietly(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (Exception exception) {
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
        }
    }

    public static boolean discard(Source source, int n2, TimeUnit timeUnit) {
        try {
            return Util.skipAll(source, n2, timeUnit);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean skipAll(Source source, int n2, TimeUnit timeUnit) throws IOException {
        Buffer buffer;
        long l2 = System.nanoTime();
        long l3 = source.timeout().hasDeadline() ? source.timeout().deadlineNanoTime() - l2 : Long.MAX_VALUE;
        source.timeout().deadlineNanoTime(l2 + Math.min(l3, timeUnit.toNanos(n2)));
        Buffer buffer2 = buffer;
        try {
            buffer = new Buffer();
            return (boolean)buffer;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (InterruptedIOException interruptedIOException) {
            n2 = 0;
            return n2 != 0;
        }
    }

    public static <T> List<T> immutableList(List<T> list) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public static <K, V> Map<K, V> immutableMap(Map<K, V> map) {
        return map.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new LinkedHashMap<K, V>(map));
    }

    public static <T> List<T> immutableList(T ... TArray) {
        return Collections.unmodifiableList(Arrays.asList((Object[])TArray.clone()));
    }

    public static ThreadFactory threadFactory(final String string2, final boolean bl) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, string2);
                thread.setDaemon(bl);
                return thread;
            }
        };
    }

    public static String[] intersect(Comparator<? super String> comparator, String[] stringArray, String[] stringArray2) {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        block0: for (String string2 : stringArray) {
            int n2 = stringArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (comparator.compare(string2, stringArray2[i2]) != 0) continue;
                arrayList2.add(string2);
                continue block0;
            }
        }
        ArrayList<String> arrayList3 = arrayList2;
        return arrayList3.toArray(new String[arrayList3.size()]);
    }

    public static boolean nonEmptyIntersection(Comparator<String> comparator, String[] stringArray, String[] stringArray2) {
        if (stringArray != null && stringArray2 != null && stringArray.length != 0 && stringArray2.length != 0) {
            for (String string2 : stringArray) {
                int n2 = stringArray2.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (comparator.compare(string2, stringArray2[i2]) != 0) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static String hostHeader(HttpUrl httpUrl, boolean bl) {
        String string2 = httpUrl.host().contains(":") ? "[" + httpUrl.host() + "]" : httpUrl.host();
        if (bl || httpUrl.port() != HttpUrl.defaultPort(httpUrl.scheme())) {
            string2 = string2 + ":" + httpUrl.port();
        }
        return string2;
    }

    public static boolean isAndroidGetsocknameError(AssertionError assertionError) {
        return ((Throwable)((Object)assertionError)).getCause() != null && ((Throwable)((Object)assertionError)).getMessage() != null && ((Throwable)((Object)assertionError)).getMessage().contains("getsockname failed");
    }

    public static int indexOf(Comparator<String> comparator, String[] stringArray, String string2) {
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (comparator.compare(stringArray[i2], string2) != 0) continue;
            return i2;
        }
        return -1;
    }

    public static String[] concat(String[] stringArray, String string2) {
        int n2 = stringArray.length + 1;
        String[] stringArray2 = new String[n2];
        String[] stringArray3 = stringArray2;
        int n3 = stringArray.length;
        System.arraycopy(stringArray, 0, stringArray3, 0, n3);
        stringArray2[n2 - 1] = string2;
        return stringArray2;
    }

    public static int skipLeadingAsciiWhitespace(String string2, int n2, int n3) {
        while (n2 < n3) {
            char c2 = string2.charAt(n2);
            if (c2 != '\t' && c2 != '\n' && c2 != '\f' && c2 != '\r' && c2 != ' ') {
                return n2;
            }
            ++n2;
        }
        return n3;
    }

    public static int skipTrailingAsciiWhitespace(String string2, int n2, int n3) {
        --n3;
        while (n3 >= n2) {
            char c2 = string2.charAt(n3);
            if (c2 != '\t' && c2 != '\n' && c2 != '\f' && c2 != '\r' && c2 != ' ') {
                return n3 + 1;
            }
            --n3;
        }
        return n2;
    }

    public static String trimSubstring(String string2, int n2, int n3) {
        String string3 = string2;
        int n4 = Util.skipLeadingAsciiWhitespace(string3, n2, n3);
        return string3.substring(n4, Util.skipTrailingAsciiWhitespace(string3, n4, n3));
    }

    public static int delimiterOffset(String string2, int n2, int n3, String string3) {
        while (n2 < n3) {
            if (string3.indexOf(string2.charAt(n2)) != -1) {
                return n2;
            }
            ++n2;
        }
        return n3;
    }

    public static int delimiterOffset(String string2, int n2, int n3, char c2) {
        while (n2 < n3) {
            if (string2.charAt(n2) == c2) {
                return n2;
            }
            ++n2;
        }
        return n3;
    }

    public static String canonicalizeHost(String string2) {
        block10: {
            if (string2.contains(":")) {
                Object object;
                if (string2.startsWith("[") && string2.endsWith("]")) {
                    String string3 = string2;
                    object = Util.decodeIpv6(string3, 1, string3.length() - 1);
                } else {
                    String string4 = string2;
                    object = Util.decodeIpv6(string4, 0, string4.length());
                }
                if (object == null) {
                    return null;
                }
                byte[] byArray = ((InetAddress)object).getAddress();
                object = byArray;
                if (byArray.length == 16) {
                    return Util.inet6AddressToAscii((byte[])object);
                }
                throw new AssertionError((Object)("Invalid IPv6 address: '" + string2 + "'"));
            }
            try {
                string2 = IDN.toASCII(string2).toLowerCase(Locale.US);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            if (!string2.isEmpty()) break block10;
            return null;
        }
        if (Util.containsInvalidHostnameAsciiCodes(string2)) {
            return null;
        }
        return string2;
    }

    private static boolean containsInvalidHostnameAsciiCodes(String string2) {
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            char c2 = string2.charAt(i2);
            if (c2 > '\u001f' && c2 < '\u007f') {
                if (" #%/:?@[\\]".indexOf(c2) == -1) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public static int indexOfControlOrNonAscii(String string2) {
        int n2 = string2.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string2.charAt(i2);
            if (c2 > '\u001f' && c2 < '\u007f') {
                continue;
            }
            return i2;
        }
        return -1;
    }

    public static boolean verifyAsIpAddress(String string2) {
        return VERIFY_AS_IP_ADDRESS.matcher(string2).matches();
    }

    public static String format(String string2, Object ... objectArray) {
        return String.format(Locale.US, string2, objectArray);
    }

    public static Charset bomAwareCharset(BufferedSource bufferedSource, Charset charset) throws IOException {
        ByteString byteString = UTF_8_BOM;
        if (bufferedSource.rangeEquals(0L, byteString)) {
            bufferedSource.skip(byteString.size());
            return UTF_8;
        }
        byteString = UTF_16_BE_BOM;
        if (bufferedSource.rangeEquals(0L, byteString)) {
            bufferedSource.skip(byteString.size());
            return UTF_16_BE;
        }
        byteString = UTF_16_LE_BOM;
        if (bufferedSource.rangeEquals(0L, byteString)) {
            bufferedSource.skip(byteString.size());
            return UTF_16_LE;
        }
        byteString = UTF_32_BE_BOM;
        if (bufferedSource.rangeEquals(0L, byteString)) {
            bufferedSource.skip(byteString.size());
            return UTF_32_BE;
        }
        byteString = UTF_32_LE_BOM;
        if (bufferedSource.rangeEquals(0L, byteString)) {
            bufferedSource.skip(byteString.size());
            return UTF_32_LE;
        }
        return charset;
    }

    public static int checkDuration(String string2, long l2, TimeUnit timeUnit) {
        long l3 = l2 - 0L;
        long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
        if (l4 >= 0) {
            if (timeUnit != null) {
                if ((l2 = timeUnit.toMillis(l2)) <= Integer.MAX_VALUE) {
                    if (l2 == 0L && l4 > 0) {
                        throw new IllegalArgumentException(string2 + " too small.");
                    }
                    return (int)l2;
                }
                throw new IllegalArgumentException(string2 + " too large.");
            }
            throw new NullPointerException("unit == null");
        }
        throw new IllegalArgumentException(string2 + " < 0");
    }

    public static AssertionError assertionError(String string2, Exception exception) {
        AssertionError assertionError;
        AssertionError assertionError2 = assertionError;
        assertionError2((Object)string2);
        try {
            ((Throwable)((Object)assertionError)).initCause(exception);
        }
        catch (IllegalStateException illegalStateException) {}
        return assertionError2;
    }

    public static int decodeHexDigit(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static InetAddress decodeIpv6(String string2, int n2, int n3) {
        int n4 = 16;
        byte[] byArray = new byte[16];
        int n5 = 0;
        int n6 = -1;
        int n7 = -1;
        while (true) {
            int n8;
            int n9;
            block17: {
                int n10;
                block13: {
                    block10: {
                        block14: {
                            block15: {
                                block16: {
                                    block11: {
                                        block12: {
                                            if (n2 >= n3) break block10;
                                            if (n5 == n4) {
                                                return null;
                                            }
                                            n9 = n2 + 2;
                                            if (n9 > n3 || !string2.regionMatches(n2, "::", 0, 2)) break block11;
                                            if (n6 != -1) {
                                                return null;
                                            }
                                            n6 = n5 + 2;
                                            if (n9 != n3) break block12;
                                            n10 = n6;
                                            break block13;
                                        }
                                        n2 = n6;
                                        break block14;
                                    }
                                    if (n5 == 0) break block15;
                                    if (!string2.regionMatches(n2, ":", 0, 1)) break block16;
                                    n9 = n2 + 1;
                                    n2 = n6;
                                    n6 = n5;
                                    break block14;
                                }
                                if (!string2.regionMatches(n2, ".", 0, 1)) return null;
                                n10 = n5 - 2;
                                if (!Util.decodeIpv4Suffix(string2, n7, n3, byArray, n10)) {
                                    return null;
                                }
                                n10 = n5 + 2;
                                break block13;
                            }
                            int n11 = n2;
                            n2 = n6;
                            n6 = n5;
                            n9 = n11;
                        }
                        n7 = n5 = 0;
                        break block17;
                    }
                    n10 = n5;
                }
                if (n10 != n4) {
                    if (n6 == -1) {
                        return null;
                    }
                    int n12 = n6;
                    int n13 = n10;
                    System.arraycopy(byArray, n6, byArray, n4 - (n10 -= n6), n10);
                    Arrays.fill(byArray, n12, n12 + (n4 - n13), (byte)0);
                }
                try {
                    return InetAddress.getByAddress(byArray);
                }
                catch (UnknownHostException unknownHostException) {
                    throw new AssertionError();
                }
            }
            for (n5 = n9; n5 < n3 && (n8 = Util.decodeHexDigit(string2.charAt(n5))) != -1; ++n5) {
                n7 = (n7 << 4) + n8;
            }
            n8 = n5 - n9;
            if (n8 == 0) return null;
            if (n8 > 4) {
                return null;
            }
            int n14 = n7;
            byArray[n6++] = (byte)(n7 >>> 8 & 0xFF);
            n7 = n6 + 1;
            byArray[n6] = (byte)(n14 & 0xFF);
            int n15 = n5;
            int n16 = n7;
            n7 = n9;
            n6 = n2;
            n5 = n16;
            n2 = n15;
        }
    }

    private static boolean decodeIpv4Suffix(String string2, int n2, int n3, byte[] byArray, int n4) {
        int n5 = n4;
        while (n2 < n3) {
            char c2;
            int n6;
            if (n5 == byArray.length) {
                return false;
            }
            if (n5 != n4 && string2.charAt(n2) != '.') {
                return false;
            }
            int n7 = n6 = 0;
            for (n6 = ++n2; n6 < n3 && (c2 = string2.charAt(n6)) >= '0' && c2 <= '9'; ++n6) {
                if (n7 == 0 && n2 != n6) {
                    return false;
                }
                if ((n7 = n7 * 10 + c2 - 48) <= 255) continue;
                return false;
            }
            if (n6 - n2 == 0) {
                return false;
            }
            n2 = n5 + 1;
            byArray[n5] = (byte)n7;
            n5 = n2;
            n2 = n6;
        }
        return n5 == n4 + 4;
    }

    private static String inet6AddressToAscii(byte[] byArray) {
        Buffer buffer;
        int n2;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        while (n5 < byArray.length) {
            for (n2 = n5; n2 < 16 && byArray[n2] == 0 && byArray[n2 + 1] == 0; n2 += 2) {
            }
            int n6 = n2 - n5;
            if (n6 <= n4 || n6 < 4) {
                n6 = n4;
                n5 = n3;
            }
            int n7 = n3 = n2 + 2;
            n4 = n6;
            n3 = n5;
            n5 = n7;
        }
        Buffer buffer2 = buffer;
        buffer = new Buffer();
        n2 = 0;
        while (n2 < byArray.length) {
            if (n2 == n3) {
                buffer2.writeByte(58);
                if ((n2 += n4) != 16) continue;
                buffer2.writeByte(58);
                continue;
            }
            if (n2 > 0) {
                buffer2.writeByte(58);
            }
            buffer2.writeHexadecimalUnsignedLong((byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF);
            n2 += 2;
        }
        return buffer2.readUtf8();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static X509TrustManager platformTrustManager() {
        TrustManagerFactory trustManagerFactory;
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Util.assertionError("No System TLS", generalSecurityException);
        }
        trustManagerFactory.init((KeyStore)null);
        Object[] objectArray = trustManagerFactory.getTrustManagers();
        if (objectArray.length != 1) throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(objectArray));
        if (!(objectArray[0] instanceof X509TrustManager)) throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(objectArray));
        return (X509TrustManager)objectArray[0];
    }

    public static Headers toHeaders(List<Header> object) {
        Headers.Builder builder;
        Object object2 = object;
        object = builder;
        builder = new Headers.Builder();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            Header header;
            Header header2 = header = (Header)iterator.next();
            String object22 = header2.name.utf8();
            Internal.instance.addLenient((Headers.Builder)object, object22, header2.value.utf8());
        }
        return ((Headers.Builder)object).build();
    }

    static {
        Object object = new byte[]{};
        EMPTY_BYTE_ARRAY = object;
        EMPTY_STRING_ARRAY = new String[0];
        EMPTY_RESPONSE = ResponseBody.create(null, object);
        EMPTY_REQUEST = RequestBody.create(null, object);
        UTF_8_BOM = ByteString.decodeHex("efbbbf");
        UTF_16_BE_BOM = ByteString.decodeHex("feff");
        UTF_16_LE_BOM = ByteString.decodeHex("fffe");
        UTF_32_BE_BOM = ByteString.decodeHex("0000ffff");
        UTF_32_LE_BOM = ByteString.decodeHex("ffff0000");
        UTF_8 = Charset.forName("UTF-8");
        ISO_8859_1 = Charset.forName("ISO-8859-1");
        UTF_16_BE = Charset.forName("UTF-16BE");
        UTF_16_LE = Charset.forName("UTF-16LE");
        UTF_32_BE = Charset.forName("UTF-32BE");
        UTF_32_LE = Charset.forName("UTF-32LE");
        UTC = TimeZone.getTimeZone("GMT");
        NATURAL_ORDER = new Comparator<String>(){

            @Override
            public int compare(String string2, String string3) {
                return string2.compareTo(string3);
            }
        };
        Class<Throwable> clazz = Throwable.class;
        Class[] classArray = new Class[1];
        try {
            classArray[0] = Throwable.class;
            object = clazz.getDeclaredMethod("addSuppressed", classArray);
        }
        catch (Exception exception) {
            object = null;
        }
        addSuppressedExceptionMethod = object;
        VERIFY_AS_IP_ADDRESS = Pattern.compile("([0-9a-fA-F]*:[0-9a-fA-F:.]*)|([\\d.]+)");
    }
}

