/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import android.support.annotation.Nullable;
import dc.squareup.okhttp3.MediaType;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.Okio;
import dc.squareup.okio.Source;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public abstract class RequestBody {
    public static RequestBody create(@Nullable MediaType mediaType, String string2) {
        Charset charset;
        Charset charset2 = Util.UTF_8;
        if (mediaType != null) {
            charset = mediaType.charset();
            if (charset == null) {
                mediaType = MediaType.parse(mediaType + "; charset=utf-8");
                charset = charset2;
            }
        } else {
            charset = charset2;
        }
        return RequestBody.create(mediaType, string2.getBytes(charset));
    }

    public static RequestBody create(final @Nullable MediaType mediaType, final ByteString byteString) {
        return new RequestBody(){

            @Override
            @Nullable
            public MediaType contentType() {
                return mediaType;
            }

            @Override
            public long contentLength() throws IOException {
                return byteString.size();
            }

            @Override
            public void writeTo(BufferedSink bufferedSink) throws IOException {
                bufferedSink.write(byteString);
            }
        };
    }

    public static RequestBody create(@Nullable MediaType mediaType, byte[] byArray) {
        return RequestBody.create(mediaType, byArray, 0, byArray.length);
    }

    public static RequestBody create(final @Nullable MediaType mediaType, final byte[] byArray, final int n2, final int n3) {
        if (byArray != null) {
            long l2 = n2;
            long l3 = n3;
            Util.checkOffsetAndCount(byArray.length, l2, l3);
            return new RequestBody(){

                @Override
                @Nullable
                public MediaType contentType() {
                    return mediaType;
                }

                @Override
                public long contentLength() {
                    return n3;
                }

                @Override
                public void writeTo(BufferedSink bufferedSink) throws IOException {
                    2 v0 = object;
                    Object object = v0.byArray;
                    int n22 = v0.n2;
                    int n32 = v0.n3;
                    bufferedSink.write((byte[])object, n22, n32);
                }
            };
        }
        throw new NullPointerException("content == null");
    }

    public static RequestBody create(final @Nullable MediaType mediaType, final File file) {
        if (file != null) {
            return new RequestBody(){

                @Override
                @Nullable
                public MediaType contentType() {
                    return mediaType;
                }

                @Override
                public long contentLength() {
                    return file.length();
                }

                @Override
                public void writeTo(BufferedSink bufferedSink) throws IOException {
                    3 v0 = object;
                    Object object = null;
                    try {
                        object = Okio.source(v0.file);
                    }
                    catch (Throwable throwable) {
                        Util.closeQuietly((Closeable)object);
                        throw throwable;
                    }
                    bufferedSink.writeAll((Source)object);
                    Util.closeQuietly((Closeable)object);
                }
            };
        }
        throw new NullPointerException("file == null");
    }

    @Nullable
    public abstract MediaType contentType();

    public long contentLength() throws IOException {
        return -1L;
    }

    public abstract void writeTo(BufferedSink var1) throws IOException;
}

