/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import android.support.annotation.Nullable;
import dc.squareup.okhttp3.CacheControl;
import dc.squareup.okhttp3.Headers;
import dc.squareup.okhttp3.HttpUrl;
import dc.squareup.okhttp3.RequestBody;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.http.HttpMethod;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class Request {
    final HttpUrl url;
    final String method;
    final Headers headers;
    @Nullable
    final RequestBody body;
    final Map<Class<?>, Object> tags;
    @Nullable
    private volatile CacheControl cacheControl;

    Request(Builder builder) {
        this.url = builder.url;
        this.method = builder.method;
        this.headers = builder.headers.build();
        this.body = builder.body;
        this.tags = Util.immutableMap(builder.tags);
    }

    public HttpUrl url() {
        return this.url;
    }

    public String method() {
        return this.method;
    }

    public Headers headers() {
        return this.headers;
    }

    @Nullable
    public String header(String string2) {
        return this.headers.get(string2);
    }

    public List<String> headers(String string2) {
        return this.headers.values(string2);
    }

    @Nullable
    public RequestBody body() {
        return this.body;
    }

    @Nullable
    public Object tag() {
        return this.tag(Object.class);
    }

    @Nullable
    public <T> T tag(Class<? extends T> clazz) {
        return clazz.cast(this.tags.get(clazz));
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public CacheControl cacheControl() {
        CacheControl cacheControl = this.cacheControl;
        if (cacheControl == null) {
            this.cacheControl = cacheControl = CacheControl.parse(this.headers);
        }
        return cacheControl;
    }

    public boolean isHttps() {
        return this.url.isHttps();
    }

    public String toString() {
        return "Request{method=" + this.method + ", url=" + this.url + ", tags=" + this.tags + '}';
    }

    public static class Builder {
        @Nullable
        HttpUrl url;
        String method;
        Headers.Builder headers;
        @Nullable
        RequestBody body;
        Map<Class<?>, Object> tags = Collections.emptyMap();

        public Builder() {
            this.method = "GET";
            this.headers = new Headers.Builder();
        }

        Builder(Request request) {
            LinkedHashMap linkedHashMap;
            this.url = request.url;
            this.method = request.method;
            this.body = request.body;
            if (request.tags.isEmpty()) {
                linkedHashMap = Collections.emptyMap();
            } else {
                LinkedHashMap linkedHashMap2;
                linkedHashMap = linkedHashMap2;
                linkedHashMap2 = new LinkedHashMap(request.tags);
            }
            this.tags = linkedHashMap;
            this.headers = request.headers.newBuilder();
        }

        public Builder url(HttpUrl httpUrl) {
            if (httpUrl != null) {
                this.url = httpUrl;
                return this;
            }
            throw new NullPointerException("url == null");
        }

        public Builder url(String string2) {
            if (string2 != null) {
                if (string2.regionMatches(true, 0, "ws:", 0, 3)) {
                    string2 = "http:" + string2.substring(3);
                } else if (string2.regionMatches(true, 0, "wss:", 0, 4)) {
                    string2 = "https:" + string2.substring(4);
                }
                return this.url(HttpUrl.get(string2));
            }
            throw new NullPointerException("url == null");
        }

        public Builder url(URL uRL) {
            if (uRL != null) {
                return this.url(HttpUrl.get(uRL.toString()));
            }
            throw new NullPointerException("url == null");
        }

        public Builder header(String string2, String string3) {
            Builder builder = this;
            builder.headers.set(string2, string3);
            return builder;
        }

        public Builder addHeader(String string2, String string3) {
            Builder builder = this;
            builder.headers.add(string2, string3);
            return builder;
        }

        public Builder removeHeader(String string2) {
            Builder builder = this;
            builder.headers.removeAll(string2);
            return builder;
        }

        public Builder headers(Headers headers) {
            this.headers = headers.newBuilder();
            return this;
        }

        public Builder cacheControl(CacheControl object) {
            if (((String)(object = ((CacheControl)object).toString())).isEmpty()) {
                return this.removeHeader("Cache-Control");
            }
            return this.header("Cache-Control", (String)object);
        }

        public Builder get() {
            return this.method("GET", null);
        }

        public Builder head() {
            return this.method("HEAD", null);
        }

        public Builder post(RequestBody requestBody) {
            return this.method("POST", requestBody);
        }

        public Builder delete(@Nullable RequestBody requestBody) {
            return this.method("DELETE", requestBody);
        }

        public Builder delete() {
            return this.delete(Util.EMPTY_REQUEST);
        }

        public Builder put(RequestBody requestBody) {
            return this.method("PUT", requestBody);
        }

        public Builder patch(RequestBody requestBody) {
            return this.method("PATCH", requestBody);
        }

        public Builder method(String string2, @Nullable RequestBody requestBody) {
            if (string2 != null) {
                if (string2.length() != 0) {
                    if (requestBody != null && !HttpMethod.permitsRequestBody(string2)) {
                        throw new IllegalArgumentException("method " + string2 + " must not have a request body.");
                    }
                    if (requestBody == null && HttpMethod.requiresRequestBody(string2)) {
                        throw new IllegalArgumentException("method " + string2 + " must have a request body.");
                    }
                    this.method = string2;
                    this.body = requestBody;
                    return this;
                }
                throw new IllegalArgumentException("method.length() == 0");
            }
            throw new NullPointerException("method == null");
        }

        public Builder tag(@Nullable Object object) {
            return this.tag(Object.class, object);
        }

        public <T> Builder tag(Class<? super T> clazz, @Nullable T t) {
            if (clazz != null) {
                if (t == null) {
                    this.tags.remove(clazz);
                } else {
                    if (this.tags.isEmpty()) {
                        LinkedHashMap linkedHashMap;
                        LinkedHashMap linkedHashMap2 = linkedHashMap;
                        linkedHashMap = new LinkedHashMap();
                        this.tags = linkedHashMap2;
                    }
                    Class<T> clazz2 = clazz;
                    this.tags.put(clazz2, clazz2.cast(t));
                }
                return this;
            }
            throw new NullPointerException("type == null");
        }

        public Request build() {
            if (this.url != null) {
                return new Request(this);
            }
            throw new IllegalStateException("url == null");
        }
    }
}

