/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import android.support.annotation.Nullable;
import dc.squareup.okhttp3.Headers;
import dc.squareup.okhttp3.MediaType;
import dc.squareup.okhttp3.RequestBody;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public final class MultipartBody
extends RequestBody {
    public static final MediaType MIXED = MediaType.get("multipart/mixed");
    public static final MediaType ALTERNATIVE = MediaType.get("multipart/alternative");
    public static final MediaType DIGEST = MediaType.get("multipart/digest");
    public static final MediaType PARALLEL = MediaType.get("multipart/parallel");
    public static final MediaType FORM = MediaType.get("multipart/form-data");
    private static final byte[] COLONSPACE = new byte[]{58, 32};
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] DASHDASH = new byte[]{45, 45};
    private final ByteString boundary;
    private final MediaType originalType;
    private final MediaType contentType;
    private final List<Part> parts;
    private long contentLength;

    MultipartBody(ByteString byteString, MediaType mediaType, List<Part> list) {
        MultipartBody multipartBody = this;
        this.contentLength = -1L;
        this.boundary = byteString;
        multipartBody.originalType = mediaType;
        multipartBody.contentType = MediaType.get(mediaType + "; boundary=" + byteString.utf8());
        this.parts = Util.immutableList(list);
    }

    private long writeOrCountBytes(@Nullable BufferedSink bufferedSink, boolean bl) throws IOException {
        long l2 = 0L;
        BufferedSink bufferedSink2 = null;
        if (bl) {
            Buffer buffer;
            bufferedSink2 = buffer;
            buffer = new Buffer();
            bufferedSink = bufferedSink2;
        } else {
            BufferedSink bufferedSink3 = bufferedSink;
            bufferedSink = bufferedSink2;
            bufferedSink2 = bufferedSink3;
        }
        int n2 = ((MultipartBody)object).parts.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            long l3;
            Object object = ((MultipartBody)object).parts.get(i2);
            Object object2 = ((Part)object).headers;
            BufferedSink bufferedSink4 = bufferedSink2;
            object = ((Part)object).body;
            bufferedSink2.write(DASHDASH);
            bufferedSink4.write(((MultipartBody)object).boundary);
            bufferedSink4.write(CRLF);
            if (object2 != null) {
                int n3 = ((Headers)object2).size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    bufferedSink2.writeUtf8(((Headers)object2).name(i3)).write(COLONSPACE).writeUtf8(((Headers)object2).value(i3)).write(CRLF);
                }
            }
            if ((object2 = ((RequestBody)object).contentType()) != null) {
                bufferedSink2.writeUtf8("Content-Type: ").writeUtf8(((MediaType)object2).toString()).write(CRLF);
            }
            if ((l3 = ((RequestBody)object).contentLength()) != -1L) {
                bufferedSink2.writeUtf8("Content-Length: ").writeDecimalLong(l3).write(CRLF);
            } else if (bl) {
                ((Buffer)bufferedSink).clear();
                return -1L;
            }
            byte[] byArray = CRLF;
            bufferedSink2.write(CRLF);
            if (bl) {
                l2 += l3;
            } else {
                ((RequestBody)object).writeTo(bufferedSink2);
            }
            bufferedSink2.write(byArray);
        }
        BufferedSink bufferedSink5 = bufferedSink2;
        MultipartBody multipartBody = object;
        Object object = DASHDASH;
        bufferedSink2.write(DASHDASH);
        bufferedSink5.write(multipartBody.boundary);
        bufferedSink5.write((byte[])object);
        bufferedSink5.write(CRLF);
        if (bl) {
            l2 += ((Buffer)bufferedSink).size();
            ((Buffer)bufferedSink).clear();
        }
        return l2;
    }

    static StringBuilder appendQuotedString(StringBuilder stringBuilder, String string2) {
        stringBuilder.append('\"');
        int n2 = string2.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string2.charAt(i2);
            if (c2 != '\n') {
                if (c2 != '\r') {
                    if (c2 != '\"') {
                        stringBuilder.append(c2);
                        continue;
                    }
                    stringBuilder.append("%22");
                    continue;
                }
                stringBuilder.append("%0D");
                continue;
            }
            stringBuilder.append("%0A");
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.append('\"');
        return stringBuilder2;
    }

    public MediaType type() {
        return this.originalType;
    }

    public String boundary() {
        return this.boundary.utf8();
    }

    public int size() {
        return this.parts.size();
    }

    public List<Part> parts() {
        return this.parts;
    }

    public Part part(int n2) {
        return this.parts.get(n2);
    }

    @Override
    public MediaType contentType() {
        return this.contentType;
    }

    @Override
    public long contentLength() throws IOException {
        long l2 = this.contentLength;
        if (l2 != -1L) {
            return l2;
        }
        this.contentLength = l2 = this.writeOrCountBytes(null, true);
        return l2;
    }

    @Override
    public void writeTo(BufferedSink bufferedSink) throws IOException {
        this.writeOrCountBytes(bufferedSink, false);
    }

    public static final class Builder {
        private final ByteString boundary;
        private MediaType type = MIXED;
        private final List<Part> parts = new ArrayList<Part>();

        public Builder() {
            this(UUID.randomUUID().toString());
        }

        public Builder(String string2) {
            this.boundary = ByteString.encodeUtf8(string2);
        }

        public Builder setType(MediaType mediaType) {
            if (mediaType != null) {
                if (mediaType.type().equals("multipart")) {
                    this.type = mediaType;
                    return this;
                }
                throw new IllegalArgumentException("multipart != " + mediaType);
            }
            throw new NullPointerException("type == null");
        }

        public Builder addPart(RequestBody requestBody) {
            return this.addPart(Part.create(requestBody));
        }

        public Builder addPart(@Nullable Headers headers, RequestBody requestBody) {
            return this.addPart(Part.create(headers, requestBody));
        }

        public Builder addFormDataPart(String string2, String string3) {
            return this.addPart(Part.createFormData(string2, string3));
        }

        public Builder addFormDataPart(String string2, @Nullable String string3, RequestBody requestBody) {
            return this.addPart(Part.createFormData(string2, string3, requestBody));
        }

        public Builder addPart(Part part) {
            if (part != null) {
                Builder builder = this;
                builder.parts.add(part);
                return builder;
            }
            throw new NullPointerException("part == null");
        }

        public MultipartBody build() {
            if (!((Builder)((Object)byteString)).parts.isEmpty()) {
                Builder builder = byteString;
                ByteString byteString = builder.boundary;
                MediaType mediaType = builder.type;
                List<Part> list = builder.parts;
                return new MultipartBody(byteString, mediaType, list);
            }
            throw new IllegalStateException("Multipart body must have at least one part.");
        }
    }

    public static final class Part {
        @Nullable
        final Headers headers;
        final RequestBody body;

        public static Part create(RequestBody requestBody) {
            return Part.create(null, requestBody);
        }

        public static Part create(@Nullable Headers headers, RequestBody requestBody) {
            if (requestBody != null) {
                if (headers != null && headers.get("Content-Type") != null) {
                    throw new IllegalArgumentException("Unexpected header: Content-Type");
                }
                if (headers != null && headers.get("Content-Length") != null) {
                    throw new IllegalArgumentException("Unexpected header: Content-Length");
                }
                return new Part(headers, requestBody);
            }
            throw new NullPointerException("body == null");
        }

        public static Part createFormData(String string2, String string3) {
            return Part.createFormData(string2, null, RequestBody.create(null, string3));
        }

        public static Part createFormData(String string2, @Nullable String string3, RequestBody requestBody) {
            if (string2 != null) {
                StringBuilder stringBuilder;
                StringBuilder stringBuilder2 = stringBuilder;
                MultipartBody.appendQuotedString(new StringBuilder("form-data; name="), string2);
                if (string3 != null) {
                    StringBuilder stringBuilder3 = stringBuilder2;
                    stringBuilder3.append("; filename=");
                    MultipartBody.appendQuotedString(stringBuilder3, string3);
                }
                return Part.create(new Headers.Builder().addUnsafeNonAscii("Content-Disposition", stringBuilder2.toString()).build(), requestBody);
            }
            throw new NullPointerException("name == null");
        }

        private Part(@Nullable Headers headers, RequestBody requestBody) {
            this.headers = headers;
            this.body = requestBody;
        }

        @Nullable
        public Headers headers() {
            return this.headers;
        }

        public RequestBody body() {
            return this.body;
        }
    }
}

