/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import android.support.annotation.Nullable;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MediaType {
    private static final String TOKEN = "([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)";
    private static final String QUOTED = "\"([^\"]*)\"";
    private static final Pattern TYPE_SUBTYPE = Pattern.compile("([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)/([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)");
    private static final Pattern PARAMETER = Pattern.compile(";\\s*(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)=(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)|\"([^\"]*)\"))?");
    private final String mediaType;
    private final String type;
    private final String subtype;
    @Nullable
    private final String charset;

    private MediaType(String string2, String string3, String string4, @Nullable String string5) {
        this.mediaType = string2;
        this.type = string3;
        this.subtype = string4;
        this.charset = string5;
    }

    public static MediaType get(String string2) {
        Object object = TYPE_SUBTYPE.matcher(string2);
        if (((Matcher)object).lookingAt()) {
            Matcher matcher = object;
            object = Locale.US;
            String string3 = matcher.group(1).toLowerCase((Locale)object);
            object = matcher.group(2).toLowerCase((Locale)object);
            String string4 = null;
            Matcher matcher2 = PARAMETER.matcher(string2);
            int n2 = matcher.end();
            while (n2 < string2.length()) {
                Matcher matcher3 = matcher2;
                matcher3.region(n2, string2.length());
                if (matcher3.lookingAt()) {
                    String string5 = matcher2.group(1);
                    if (string5 != null && string5.equalsIgnoreCase("charset")) {
                        string5 = matcher2.group(2);
                        if (string5 != null) {
                            if (string5.startsWith("'") && string5.endsWith("'") && string5.length() > 2) {
                                String string6 = string5;
                                string5 = string6.substring(1, string6.length() - 1);
                            }
                        } else {
                            string5 = matcher2.group(3);
                        }
                        if (string4 != null && !string5.equalsIgnoreCase(string4)) {
                            throw new IllegalArgumentException("Multiple charsets defined: \"" + string4 + "\" and: \"" + string5 + "\" for: \"" + string2 + '\"');
                        }
                    } else {
                        string5 = string4;
                    }
                    int n3 = matcher2.end();
                    string4 = string5;
                    n2 = n3;
                    continue;
                }
                throw new IllegalArgumentException("Parameter is not formatted correctly: \"" + string2.substring(n2) + "\" for: \"" + string2 + '\"');
            }
            return new MediaType(string2, string3, (String)object, string4);
        }
        throw new IllegalArgumentException("No subtype found for: \"" + string2 + '\"');
    }

    @Nullable
    public static MediaType parse(String string2) {
        try {
            return MediaType.get(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public String type() {
        return this.type;
    }

    public String subtype() {
        return this.subtype;
    }

    @Nullable
    public Charset charset() {
        return this.charset(null);
    }

    @Nullable
    public Charset charset(@Nullable Charset charset) {
        block3: {
            try {
                String string2 = ((MediaType)((Object)string2)).charset;
                if (string2 == null) break block3;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return charset;
            }
            charset = Charset.forName(string2);
        }
        return charset;
    }

    public String toString() {
        return this.mediaType;
    }

    public boolean equals(@Nullable Object object) {
        return object instanceof MediaType && ((MediaType)object).mediaType.equals(this.mediaType);
    }

    public int hashCode() {
        return this.mediaType.hashCode();
    }
}

