/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import android.support.annotation.Nullable;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.http.HttpDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class Headers {
    private final String[] namesAndValues;

    Headers(Builder builder) {
        List<String> list = builder.namesAndValues;
        this.namesAndValues = list.toArray(new String[list.size()]);
    }

    private Headers(String[] stringArray) {
        this.namesAndValues = stringArray;
    }

    private static String get(String[] stringArray, String string2) {
        for (int i2 = stringArray.length - 2; i2 >= 0; i2 -= 2) {
            if (!string2.equalsIgnoreCase(stringArray[i2])) continue;
            return stringArray[i2 + 1];
        }
        return null;
    }

    public static Headers of(String ... stringArray) {
        if (stringArray != null) {
            if (stringArray.length % 2 == 0) {
                int n2;
                stringArray = (String[])stringArray.clone();
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    if (stringArray[n2] != null) {
                        stringArray[n2] = stringArray[n2].trim();
                        continue;
                    }
                    throw new IllegalArgumentException("Headers cannot be null");
                }
                for (n2 = 0; n2 < stringArray.length; n2 += 2) {
                    String string2 = stringArray[n2];
                    String string3 = stringArray[n2 + 1];
                    String string4 = string2;
                    Headers.checkName(string4);
                    Headers.checkValue(string3, string4);
                }
                return new Headers(stringArray);
            }
            throw new IllegalArgumentException("Expected alternating header names and values");
        }
        throw new NullPointerException("namesAndValues == null");
    }

    public static Headers of(Map<String, String> stringArray) {
        if (stringArray != null) {
            stringArray = new String[stringArray.size() * 2];
            int n2 = 0;
            for (Map.Entry entry : stringArray.entrySet()) {
                if (entry.getKey() != null && entry.getValue() != null) {
                    Map.Entry entry2 = entry;
                    entry = ((String)entry2.getKey()).trim();
                    String string2 = ((String)entry2.getValue()).trim();
                    Map.Entry entry3 = entry;
                    Headers.checkName((String)((Object)entry3));
                    Headers.checkValue(string2, (String)((Object)entry3));
                    stringArray[n2] = entry;
                    stringArray[n2 + 1] = string2;
                    n2 += 2;
                    continue;
                }
                throw new IllegalArgumentException("Headers cannot be null");
            }
            return new Headers(stringArray);
        }
        throw new NullPointerException("headers == null");
    }

    static void checkName(String string2) {
        if (string2 != null) {
            if (!string2.isEmpty()) {
                int n2 = string2.length();
                for (int i2 = 0; i2 < n2; ++i2) {
                    char c2 = string2.charAt(i2);
                    if (c2 > ' ' && c2 < '\u007f') {
                        continue;
                    }
                    Object[] objectArray = new Object[3];
                    Object[] objectArray2 = objectArray;
                    objectArray2[0] = (int)c2;
                    objectArray[1] = i2;
                    objectArray[2] = string2;
                    throw new IllegalArgumentException(Util.format("Unexpected char %#04x at %d in header name: %s", objectArray2));
                }
                return;
            }
            throw new IllegalArgumentException("name is empty");
        }
        throw new NullPointerException("name == null");
    }

    static void checkValue(String string2, String string3) {
        if (string2 != null) {
            int n2 = string2.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string2.charAt(i2);
                if ((c2 > '\u001f' || c2 == '\t') && c2 < '\u007f') {
                    continue;
                }
                Object[] objectArray = new Object[4];
                Object[] objectArray2 = objectArray;
                objectArray2[0] = (int)c2;
                objectArray[1] = i2;
                objectArray[2] = string3;
                objectArray[3] = string2;
                throw new IllegalArgumentException(Util.format("Unexpected char %#04x at %d in %s value: %s", objectArray2));
            }
            return;
        }
        throw new NullPointerException("value for name " + string3 + " == null");
    }

    @Nullable
    public String get(String string2) {
        return Headers.get(this.namesAndValues, string2);
    }

    @Nullable
    public Date getDate(String string2) {
        return (this = ((Headers)this).get(string2)) != null ? HttpDate.parse((String)this) : null;
    }

    public int size() {
        return this.namesAndValues.length / 2;
    }

    public String name(int n2) {
        return this.namesAndValues[n2 * 2];
    }

    public String value(int n2) {
        return this.namesAndValues[n2 * 2 + 1];
    }

    public Set<String> names() {
        TreeSet<String> treeSet;
        TreeSet<String> treeSet2 = treeSet;
        treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            treeSet2.add(this.name(i2));
        }
        return Collections.unmodifiableSet(treeSet2);
    }

    public List<String> values(String string2) {
        ArrayList<String> arrayList = null;
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!string2.equalsIgnoreCase(this.name(i2))) continue;
            if (arrayList == null) {
                ArrayList<String> arrayList2;
                arrayList = arrayList2;
                arrayList2 = new ArrayList<String>(2);
            }
            arrayList.add(this.value(i2));
        }
        return arrayList != null ? Collections.unmodifiableList(arrayList) : Collections.emptyList();
    }

    public long byteCount() {
        long l2 = this.namesAndValues.length * 2;
        int n2 = this.namesAndValues.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            l2 += (long)this.namesAndValues[i2].length();
        }
        return l2;
    }

    public Builder newBuilder() {
        Builder builder = new Builder();
        Collections.addAll(builder.namesAndValues, this.namesAndValues);
        return builder;
    }

    public boolean equals(@Nullable Object object) {
        return object instanceof Headers && Arrays.equals(((Headers)object).namesAndValues, this.namesAndValues);
    }

    public int hashCode() {
        return Arrays.hashCode(this.namesAndValues);
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder2.append(this.name(i2)).append(": ").append(this.value(i2)).append("\n");
        }
        return stringBuilder2.toString();
    }

    public Map<String, List<String>> toMultimap() {
        TreeMap<String, List<String>> treeMap;
        TreeMap<String, List<String>> treeMap2 = treeMap;
        treeMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = this.name(i2);
            List list = (List)treeMap2.get(string2);
            if (list == null) {
                ArrayList arrayList;
                list = arrayList;
                arrayList = new ArrayList(2);
                treeMap2.put(string2, list);
            }
            list.add(this.value(i2));
        }
        return treeMap2;
    }

    public static final class Builder {
        final List<String> namesAndValues;

        public Builder() {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList(20);
            v1.namesAndValues = arrayList2;
        }

        Builder addLenient(String string2) {
            int n2 = string2.indexOf(":", 1);
            if (n2 != -1) {
                Builder builder = string3;
                String string3 = string2.substring(0, n2);
                return builder.addLenient(string3, string2.substring(n2 + 1));
            }
            if (string2.startsWith(":")) {
                return ((Builder)((Object)string3)).addLenient("", string2.substring(1));
            }
            return ((Builder)((Object)string3)).addLenient("", string2);
        }

        public Builder add(String string2) {
            int n2 = string2.indexOf(":");
            if (n2 != -1) {
                Builder builder = string3;
                String string3 = string2.substring(0, n2).trim();
                return builder.add(string3, string2.substring(n2 + 1));
            }
            throw new IllegalArgumentException("Unexpected header: " + string2);
        }

        public Builder add(String string2, String string3) {
            String string4 = string2;
            Headers.checkName(string4);
            Headers.checkValue(string3, string4);
            return this.addLenient(string2, string3);
        }

        public Builder addUnsafeNonAscii(String string2, String string3) {
            String string4 = string2;
            Headers.checkName(string4);
            return this.addLenient(string4, string3);
        }

        public Builder addAll(Headers headers) {
            int n2 = headers.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Headers headers2 = headers;
                String string2 = headers2.name(i2);
                this.addLenient(string2, headers2.value(i2));
            }
            return this;
        }

        public Builder add(String string2, Date date) {
            if (date != null) {
                Builder builder = this;
                builder.add(string2, HttpDate.format(date));
                return builder;
            }
            throw new NullPointerException("value for name " + string2 + " == null");
        }

        public Builder set(String string2, Date date) {
            if (date != null) {
                Builder builder = this;
                builder.set(string2, HttpDate.format(date));
                return builder;
            }
            throw new NullPointerException("value for name " + string2 + " == null");
        }

        Builder addLenient(String string2, String string3) {
            Builder builder = this;
            builder.namesAndValues.add(string2);
            builder.namesAndValues.add(string3.trim());
            return builder;
        }

        public Builder removeAll(String string2) {
            for (int i2 = 0; i2 < this.namesAndValues.size(); i2 += 2) {
                if (!string2.equalsIgnoreCase(this.namesAndValues.get(i2))) continue;
                Builder builder = this;
                builder.namesAndValues.remove(i2);
                builder.namesAndValues.remove(i2);
                i2 -= 2;
            }
            return this;
        }

        public Builder set(String string2, String string3) {
            Builder builder = this;
            Headers.checkName(string2);
            Headers.checkValue(string3, string2);
            builder.removeAll(string2);
            builder.addLenient(string2, string3);
            return builder;
        }

        public String get(String string2) {
            for (int i2 = this.namesAndValues.size() - 2; i2 >= 0; i2 -= 2) {
                if (!string2.equalsIgnoreCase(this.namesAndValues.get(i2))) continue;
                return this.namesAndValues.get(i2 + 1);
            }
            return null;
        }

        public Headers build() {
            return new Headers(this);
        }
    }
}

