/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import android.support.annotation.Nullable;
import dc.squareup.okhttp3.Headers;
import dc.squareup.okhttp3.HttpUrl;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.http.HttpDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Cookie {
    private static final Pattern YEAR_PATTERN = Pattern.compile("(\\d{2,4})[^\\d]*");
    private static final Pattern MONTH_PATTERN = Pattern.compile("(?i)(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec).*");
    private static final Pattern DAY_OF_MONTH_PATTERN = Pattern.compile("(\\d{1,2})[^\\d]*");
    private static final Pattern TIME_PATTERN = Pattern.compile("(\\d{1,2}):(\\d{1,2}):(\\d{1,2})[^\\d]*");
    private final String name;
    private final String value;
    private final long expiresAt;
    private final String domain;
    private final String path;
    private final boolean secure;
    private final boolean httpOnly;
    private final boolean persistent;
    private final boolean hostOnly;

    private Cookie(String string2, String string3, long l2, String string4, String string5, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.name = string2;
        this.value = string3;
        this.expiresAt = l2;
        this.domain = string4;
        this.path = string5;
        this.secure = bl;
        this.httpOnly = bl2;
        this.hostOnly = bl3;
        this.persistent = bl4;
    }

    Cookie(Builder builder) {
        String string2 = builder.name;
        if (string2 != null) {
            String string3 = builder.value;
            if (string3 != null) {
                String string4 = builder.domain;
                if (string4 != null) {
                    this.name = string2;
                    this.value = string3;
                    this.expiresAt = builder.expiresAt;
                    this.domain = string4;
                    this.path = builder.path;
                    this.secure = builder.secure;
                    this.httpOnly = builder.httpOnly;
                    this.persistent = builder.persistent;
                    this.hostOnly = builder.hostOnly;
                    return;
                }
                throw new NullPointerException("builder.domain == null");
            }
            throw new NullPointerException("builder.value == null");
        }
        throw new NullPointerException("builder.name == null");
    }

    private static boolean domainMatch(String string2, String string3) {
        if (string2.equals(string3)) {
            return true;
        }
        if (string2.endsWith(string3)) {
            String string4 = string2;
            if (string4.charAt(string4.length() - string3.length() - 1) == '.' && !Util.verifyAsIpAddress(string2)) {
                return true;
            }
        }
        return false;
    }

    private static boolean pathMatch(HttpUrl object, String string2) {
        if (((String)(object = ((HttpUrl)object).encodedPath())).equals(string2)) {
            return true;
        }
        if (((String)object).startsWith(string2)) {
            if (string2.endsWith("/")) {
                return true;
            }
            if (((String)object).charAt(string2.length()) == '/') {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static Cookie parse(HttpUrl httpUrl, String string2) {
        return Cookie.parse(System.currentTimeMillis(), httpUrl, string2);
    }

    /*
     * Exception decompiling
     */
    @Nullable
    static Cookie parse(long var0, HttpUrl var2_2, String var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 264->269)] java.lang.IllegalArgumentException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static long parseExpires(String string2, int n2, int n3) {
        n2 = Cookie.dateCharacterOffset(string2, n2, n3, false);
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        Matcher matcher = TIME_PATTERN.matcher(string2);
        while (n2 < n3) {
            Pattern pattern;
            int n10 = n2;
            n2 = Cookie.dateCharacterOffset(string2, n2 + 1, n3, true);
            matcher.region(n10, n2);
            if (n4 == -1 && matcher.usePattern(TIME_PATTERN).matches()) {
                Matcher matcher2 = matcher;
                n4 = Integer.parseInt(matcher2.group(1));
                n5 = Integer.parseInt(matcher2.group(2));
                n6 = Integer.parseInt(matcher2.group(3));
            } else if (n7 == -1 && matcher.usePattern(DAY_OF_MONTH_PATTERN).matches()) {
                n7 = Integer.parseInt(matcher.group(1));
            } else if (n8 == -1 && matcher.usePattern(pattern = MONTH_PATTERN).matches()) {
                String string3 = matcher.group(1).toLowerCase(Locale.US);
                n8 = pattern.pattern().indexOf(string3) / 4;
            } else if (n9 == -1 && matcher.usePattern(YEAR_PATTERN).matches()) {
                n9 = Integer.parseInt(matcher.group(1));
            }
            n2 = Cookie.dateCharacterOffset(string2, n2 + 1, n3, false);
        }
        if (n9 >= 70 && n9 <= 99) {
            n9 += 1900;
        }
        if (n9 >= 0 && n9 <= 69) {
            n9 += 2000;
        }
        if (n9 >= 1601) {
            if (n8 != -1) {
                if (n7 >= 1 && n7 <= 31) {
                    if (n4 >= 0 && n4 <= 23) {
                        if (n5 >= 0 && n5 <= 59) {
                            if (n6 >= 0 && n6 <= 59) {
                                GregorianCalendar gregorianCalendar = new GregorianCalendar(Util.UTC);
                                gregorianCalendar.setLenient(false);
                                gregorianCalendar.set(1, n9);
                                gregorianCalendar.set(2, n8 - 1);
                                gregorianCalendar.set(5, n7);
                                gregorianCalendar.set(11, n4);
                                gregorianCalendar.set(12, n5);
                                gregorianCalendar.set(13, n6);
                                gregorianCalendar.set(14, 0);
                                return gregorianCalendar.getTimeInMillis();
                            }
                            throw new IllegalArgumentException();
                        }
                        throw new IllegalArgumentException();
                    }
                    throw new IllegalArgumentException();
                }
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException();
    }

    private static int dateCharacterOffset(String string2, int n2, int n3, boolean bl) {
        while (n2 < n3) {
            char c2 = string2.charAt(n2);
            c2 = !(c2 < ' ' && c2 != '\t' || c2 >= '\u007f' || c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 == ':') ? (char)'\u0000' : '\u0001';
            if (c2 == (bl ^ '\u0001')) {
                return n2;
            }
            ++n2;
        }
        return n3;
    }

    private static long parseMaxAge(String string2) {
        try {
            long l2 = Long.parseLong(string2);
            if (l2 <= 0L) {
                l2 = Long.MIN_VALUE;
            }
            return l2;
        }
        catch (NumberFormatException numberFormatException) {
            if (string2.matches("-?\\d+")) {
                return string2.startsWith("-") ? Long.MIN_VALUE : Long.MAX_VALUE;
            }
            throw numberFormatException;
        }
    }

    private static String parseDomain(String string2) {
        if (!string2.endsWith(".")) {
            if (string2.startsWith(".")) {
                string2 = string2.substring(1);
            }
            if ((string2 = Util.canonicalizeHost(string2)) != null) {
                return string2;
            }
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException();
    }

    public static List<Cookie> parseAll(HttpUrl httpUrl, Headers object) {
        object = ((Headers)object).values("Set-Cookie");
        ArrayList<Cookie> arrayList = null;
        int n2 = object.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Cookie cookie = Cookie.parse(httpUrl, (String)object.get(i2));
            if (cookie == null) continue;
            if (arrayList == null) {
                ArrayList<Cookie> arrayList2;
                arrayList = arrayList2;
                arrayList2 = new ArrayList<Cookie>();
            }
            arrayList.add(cookie);
        }
        return arrayList != null ? Collections.unmodifiableList(arrayList) : Collections.emptyList();
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public boolean persistent() {
        return this.persistent;
    }

    public long expiresAt() {
        return this.expiresAt;
    }

    public boolean hostOnly() {
        return this.hostOnly;
    }

    public String domain() {
        return this.domain;
    }

    public String path() {
        return this.path;
    }

    public boolean httpOnly() {
        return this.httpOnly;
    }

    public boolean secure() {
        return this.secure;
    }

    public boolean matches(HttpUrl httpUrl) {
        if (!(this.hostOnly ? httpUrl.host().equals(this.domain) : Cookie.domainMatch(httpUrl.host(), this.domain))) {
            return false;
        }
        if (!Cookie.pathMatch(httpUrl, this.path)) {
            return false;
        }
        return !this.secure || httpUrl.isHttps();
    }

    public String toString() {
        return this.toString(false);
    }

    String toString(boolean bl) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder stringBuilder3 = stringBuilder2 = stringBuilder;
        stringBuilder2();
        stringBuilder3.append(this.name);
        stringBuilder3.append('=');
        stringBuilder.append(this.value);
        if (this.persistent) {
            if (this.expiresAt == Long.MIN_VALUE) {
                stringBuilder2.append("; max-age=0");
            } else {
                stringBuilder2.append("; expires=").append(HttpDate.format(new Date(this.expiresAt)));
            }
        }
        if (!this.hostOnly) {
            stringBuilder2.append("; domain=");
            if (bl) {
                stringBuilder2.append(".");
            }
            stringBuilder2.append(this.domain);
        }
        stringBuilder2.append("; path=").append(this.path);
        if (this.secure) {
            stringBuilder2.append("; secure");
        }
        if (this.httpOnly) {
            stringBuilder2.append("; httponly");
        }
        return stringBuilder2.toString();
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof Cookie)) {
            return false;
        }
        object = (Cookie)object;
        return ((Cookie)object).name.equals(this.name) && ((Cookie)object).value.equals(this.value) && ((Cookie)object).domain.equals(this.domain) && ((Cookie)object).path.equals(this.path) && ((Cookie)object).expiresAt == this.expiresAt && ((Cookie)object).secure == this.secure && ((Cookie)object).httpOnly == this.httpOnly && ((Cookie)object).persistent == this.persistent && ((Cookie)object).hostOnly == this.hostOnly;
    }

    public int hashCode() {
        long l2 = this.expiresAt;
        return ((((((((527 + this.name.hashCode()) * 31 + this.value.hashCode()) * 31 + this.domain.hashCode()) * 31 + this.path.hashCode()) * 31 + (int)(l2 ^ l2 >>> 32)) * 31 + (this.secure ^ 1)) * 31 + (this.httpOnly ^ 1)) * 31 + (this.persistent ^ 1)) * 31 + (this.hostOnly ^ 1);
    }

    public static final class Builder {
        @Nullable
        String name;
        @Nullable
        String value;
        long expiresAt = 253402300799999L;
        @Nullable
        String domain;
        String path = "/";
        boolean secure;
        boolean httpOnly;
        boolean persistent;
        boolean hostOnly;

        private Builder domain(String string2, boolean bl) {
            if (string2 != null) {
                String string3 = Util.canonicalizeHost(string2);
                if (string3 != null) {
                    this.domain = string3;
                    this.hostOnly = bl;
                    return this;
                }
                throw new IllegalArgumentException("unexpected domain: " + string2);
            }
            throw new NullPointerException("domain == null");
        }

        public Builder name(String string2) {
            if (string2 != null) {
                if (string2.trim().equals(string2)) {
                    this.name = string2;
                    return this;
                }
                throw new IllegalArgumentException("name is not trimmed");
            }
            throw new NullPointerException("name == null");
        }

        public Builder value(String string2) {
            if (string2 != null) {
                if (string2.trim().equals(string2)) {
                    this.value = string2;
                    return this;
                }
                throw new IllegalArgumentException("value is not trimmed");
            }
            throw new NullPointerException("value == null");
        }

        public Builder expiresAt(long l2) {
            if (l2 <= 0L) {
                l2 = Long.MIN_VALUE;
            }
            if (l2 > 253402300799999L) {
                l2 = 253402300799999L;
            }
            this.expiresAt = l2;
            this.persistent = true;
            return this;
        }

        public Builder domain(String string2) {
            return this.domain(string2, false);
        }

        public Builder hostOnlyDomain(String string2) {
            return this.domain(string2, true);
        }

        public Builder path(String string2) {
            if (string2.startsWith("/")) {
                this.path = string2;
                return this;
            }
            throw new IllegalArgumentException("path must start with '/'");
        }

        public Builder secure() {
            this.secure = true;
            return this;
        }

        public Builder httpOnly() {
            this.httpOnly = true;
            return this;
        }

        public Cookie build() {
            return new Cookie(this);
        }
    }
}

