/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import android.support.annotation.Nullable;
import dc.squareup.okhttp3.Address;
import dc.squareup.okhttp3.Route;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.connection.RealConnection;
import dc.squareup.okhttp3.internal.connection.RouteDatabase;
import dc.squareup.okhttp3.internal.connection.StreamAllocation;
import dc.squareup.okhttp3.internal.platform.Platform;
import java.lang.ref.Reference;
import java.net.Socket;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ConnectionPool {
    private static final Executor executor;
    static final /* synthetic */ boolean $assertionsDisabled;
    private final int maxIdleConnections;
    private final long keepAliveDurationNs;
    private final Runnable cleanupRunnable;
    private final Deque<RealConnection> connections;
    final RouteDatabase routeDatabase;
    boolean cleanupRunning;

    public ConnectionPool() {
        ConnectionPool connectionPool = object;
        Object object = TimeUnit.MINUTES;
        connectionPool(5, 5L, (TimeUnit)((Object)object));
    }

    public ConnectionPool(int n2, long l2, TimeUnit timeUnit) {
        this.cleanupRunnable = new Runnable(){

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                while (true) {
                    long l2;
                    if ((l2 = ConnectionPool.this.cleanup(System.nanoTime())) == -1L) {
                        return;
                    }
                    if (l2 <= 0L) continue;
                    1 v0 = this;
                    long l3 = l2;
                    l2 = l3 / 1000000L;
                    long l4 = l3 - l2 * 1000000L;
                    ConnectionPool connectionPool = v0.ConnectionPool.this;
                    // MONITORENTER : connectionPool
                    try {
                        v0.ConnectionPool.this.wait(l2, (int)l4);
                    }
                    catch (InterruptedException interruptedException) {}
                    // MONITOREXIT : connectionPool
                    continue;
                    break;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        };
        this.connections = new ArrayDeque<RealConnection>();
        this.routeDatabase = new RouteDatabase();
        this.maxIdleConnections = n2;
        this.keepAliveDurationNs = timeUnit.toNanos(l2);
        if (l2 > 0L) {
            return;
        }
        throw new IllegalArgumentException("keepAliveDuration <= 0: " + l2);
    }

    private int pruneAndGetAllocationCount(RealConnection realConnection, long l2) {
        List<Reference<StreamAllocation>> list = realConnection.allocations;
        int n2 = 0;
        while (n2 < list.size()) {
            StreamAllocation.StreamAllocationReference streamAllocationReference = list.get(n2);
            if (streamAllocationReference.get() != null) {
                ++n2;
                continue;
            }
            streamAllocationReference = streamAllocationReference;
            Platform.get().logCloseableLeak("A connection to " + realConnection.route().address().url() + " was leaked. Did you forget to close a response body?", streamAllocationReference.callStackTrace);
            list.remove(n2);
            realConnection.noNewStreams = true;
            if (!list.isEmpty()) continue;
            realConnection.idleAtNanos = l2 - this.keepAliveDurationNs;
            return 0;
        }
        return list.size();
    }

    static {
        SynchronousQueue<Runnable> synchronousQueue;
        $assertionsDisabled = ConnectionPool.class.desiredAssertionStatus() ^ true;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        SynchronousQueue<Runnable> synchronousQueue2 = synchronousQueue;
        synchronousQueue = new SynchronousQueue<Runnable>();
        ThreadFactory threadFactory = Util.threadFactory("OkHttp ConnectionPool", true);
        executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, timeUnit, synchronousQueue2, threadFactory);
    }

    public synchronized int idleConnectionCount() {
        int n2 = 0;
        Iterator<RealConnection> iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().allocations.isEmpty()) continue;
            ++n2;
        }
        return n2;
    }

    public synchronized int connectionCount() {
        return this.connections.size();
    }

    @Nullable
    RealConnection get(Address address, StreamAllocation streamAllocation, Route route) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        for (RealConnection realConnection : ((ConnectionPool)this).connections) {
            if (!realConnection.isEligible(address, route)) continue;
            streamAllocation.acquire(realConnection, true);
            return realConnection;
        }
        return null;
    }

    @Nullable
    Socket deduplicate(Address address, StreamAllocation streamAllocation) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        for (RealConnection realConnection : ((ConnectionPool)this).connections) {
            if (!realConnection.isEligible(address, null) || !realConnection.isMultiplexed() || realConnection == streamAllocation.connection()) continue;
            return streamAllocation.releaseAndAcquire(realConnection);
        }
        return null;
    }

    void put(RealConnection realConnection) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (!this.cleanupRunning) {
            this.cleanupRunning = true;
            executor.execute(this.cleanupRunnable);
        }
        this.connections.add(realConnection);
    }

    boolean connectionBecameIdle(RealConnection realConnection) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (!realConnection.noNewStreams && this.maxIdleConnections != 0) {
            this.notifyAll();
            return false;
        }
        this.connections.remove(realConnection);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void evictAll() {
        v0 = this;
        var1_1 = v1;
        v1 = new ArrayList<RealConnection>();
        synchronized (v0) {
            var2_2 = v0.connections.iterator();
lbl7:
            // 3 sources

            while (var2_2.hasNext()) {
                var3_3 = var2_2.next();
                ** GOTO lbl-1000
            }
            ** GOTO lbl21
lbl-1000:
            // 1 sources

            {
                if (!var3_3.allocations.isEmpty()) ** GOTO lbl7
                v3 = var2_2;
                var3_3.noNewStreams = true;
                var1_1.add(var3_3);
            }
            {
                v3.remove();
                ** GOTO lbl7
lbl21:
                // 1 sources

                // ** MonitorExit[this] (shouldn't be in output)
                this = var1_1.iterator();
            }
            while (true) {
                if (!this.hasNext()) {
                    return;
                }
                Util.closeQuietly(((RealConnection)this.next()).socket());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    long cleanup(long var1_1) {
        v0 = this;
        var3_2 = 0;
        var4_3 = 0;
        var5_4 = null;
        var6_5 = -9223372036854775808L;
        synchronized (v0) {
            block16: {
                var8_6 = v0.connections.iterator();
                while (true) {
                    if (!var8_6.hasNext()) break;
                    v1 = this;
                    var9_7 = var8_6.next();
                    if (v1.pruneAndGetAllocationCount(var9_7, var1_1) > 0) {
                        ++var3_2;
                        continue;
                    }
                    ++var4_3;
                    var10_8 = var1_1 - var9_7.idleAtNanos;
                    if (var10_8 <= var6_5) {
                        var10_8 = var6_5;
                        var9_7 = var5_4;
                    }
                    var5_4 = var9_7;
                    var6_5 = var10_8;
                    continue;
                    break;
                }
                var1_1 = this.keepAliveDurationNs;
                if (var6_5 >= var1_1) ** GOTO lbl49
                if (var4_3 > this.maxIdleConnections) ** GOTO lbl49
                if (var4_3 <= 0) break block16;
                // ** MonitorExit[this] (shouldn't be in output)
                return var1_1 - var6_5;
            }
            if (var3_2 <= 0) ** GOTO lbl45
            // ** MonitorExit[this] (shouldn't be in output)
            return var1_1;
lbl45:
            // 1 sources

            this.cleanupRunning = false;
            // ** MonitorExit[this] (shouldn't be in output)
            return -1L;
lbl49:
            // 2 sources

            v3 = var5_4;
            v4 = this;
            v5 = v4;
            v4.connections.remove(var5_4);
            // ** MonitorExit[v5] (shouldn't be in output)
            Util.closeQuietly(v3.socket());
            return 0L;
        }
    }
}

