/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import android.support.annotation.Nullable;
import dc.squareup.okhttp3.Authenticator;
import dc.squareup.okhttp3.CertificatePinner;
import dc.squareup.okhttp3.ConnectionSpec;
import dc.squareup.okhttp3.Dns;
import dc.squareup.okhttp3.HttpUrl;
import dc.squareup.okhttp3.Protocol;
import dc.squareup.okhttp3.internal.Util;
import java.net.Proxy;
import java.net.ProxySelector;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

public final class Address {
    final HttpUrl url;
    final Dns dns;
    final SocketFactory socketFactory;
    final Authenticator proxyAuthenticator;
    final List<Protocol> protocols;
    final List<ConnectionSpec> connectionSpecs;
    final ProxySelector proxySelector;
    @Nullable
    final Proxy proxy;
    @Nullable
    final SSLSocketFactory sslSocketFactory;
    @Nullable
    final HostnameVerifier hostnameVerifier;
    @Nullable
    final CertificatePinner certificatePinner;

    public Address(String string2, int n2, Dns dns, SocketFactory socketFactory, @Nullable SSLSocketFactory sSLSocketFactory, @Nullable HostnameVerifier hostnameVerifier, @Nullable CertificatePinner certificatePinner, Authenticator authenticator, @Nullable Proxy proxy, List<Protocol> list, List<ConnectionSpec> list2, ProxySelector proxySelector) {
        HttpUrl.Builder builder;
        HttpUrl.Builder builder2 = builder;
        builder = new HttpUrl.Builder();
        String string3 = sSLSocketFactory != null ? "https" : "http";
        this.url = builder2.scheme(string3).host(string2).port(n2).build();
        if (dns != null) {
            this.dns = dns;
            if (socketFactory != null) {
                this.socketFactory = socketFactory;
                if (authenticator != null) {
                    this.proxyAuthenticator = authenticator;
                    if (list != null) {
                        this.protocols = Util.immutableList(list);
                        if (list2 != null) {
                            this.connectionSpecs = Util.immutableList(list2);
                            if (proxySelector != null) {
                                Address address = this;
                                address.proxySelector = proxySelector;
                                address.proxy = proxy;
                                address.sslSocketFactory = sSLSocketFactory;
                                address.hostnameVerifier = hostnameVerifier;
                                address.certificatePinner = certificatePinner;
                                return;
                            }
                            throw new NullPointerException("proxySelector == null");
                        }
                        throw new NullPointerException("connectionSpecs == null");
                    }
                    throw new NullPointerException("protocols == null");
                }
                throw new NullPointerException("proxyAuthenticator == null");
            }
            throw new NullPointerException("socketFactory == null");
        }
        throw new NullPointerException("dns == null");
    }

    public HttpUrl url() {
        return this.url;
    }

    public Dns dns() {
        return this.dns;
    }

    public SocketFactory socketFactory() {
        return this.socketFactory;
    }

    public Authenticator proxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    public List<Protocol> protocols() {
        return this.protocols;
    }

    public List<ConnectionSpec> connectionSpecs() {
        return this.connectionSpecs;
    }

    public ProxySelector proxySelector() {
        return this.proxySelector;
    }

    @Nullable
    public Proxy proxy() {
        return this.proxy;
    }

    @Nullable
    public SSLSocketFactory sslSocketFactory() {
        return this.sslSocketFactory;
    }

    @Nullable
    public HostnameVerifier hostnameVerifier() {
        return this.hostnameVerifier;
    }

    @Nullable
    public CertificatePinner certificatePinner() {
        return this.certificatePinner;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object object) {
        if (!(object instanceof Address)) return false;
        object = (Address)object;
        if (!this.url.equals(((Address)object).url)) return false;
        if (!this.equalsNonHost((Address)object)) return false;
        return true;
    }

    public int hashCode() {
        Address address = this;
        int n2 = ((((((527 + address.url.hashCode()) * 31 + this.dns.hashCode()) * 31 + this.proxyAuthenticator.hashCode()) * 31 + this.protocols.hashCode()) * 31 + this.connectionSpecs.hashCode()) * 31 + this.proxySelector.hashCode()) * 31;
        Proxy proxy = address.proxy;
        int n3 = proxy != null ? proxy.hashCode() : 0;
        n2 = (n2 + n3) * 31;
        SSLSocketFactory sSLSocketFactory = this.sslSocketFactory;
        int n4 = sSLSocketFactory != null ? sSLSocketFactory.hashCode() : 0;
        n2 = (n2 + n4) * 31;
        HostnameVerifier hostnameVerifier = this.hostnameVerifier;
        int n5 = hostnameVerifier != null ? hostnameVerifier.hashCode() : 0;
        int n6 = (n2 + n5) * 31;
        CertificatePinner certificatePinner = this.certificatePinner;
        int n7 = certificatePinner != null ? certificatePinner.hashCode() : 0;
        return n6 + n7;
    }

    boolean equalsNonHost(Address address) {
        return this.dns.equals(address.dns) && this.proxyAuthenticator.equals(address.proxyAuthenticator) && this.protocols.equals(address.protocols) && this.connectionSpecs.equals(address.connectionSpecs) && this.proxySelector.equals(address.proxySelector) && Util.equal(this.proxy, address.proxy) && Util.equal(this.sslSocketFactory, address.sslSocketFactory) && Util.equal(this.hostnameVerifier, address.hostnameVerifier) && Util.equal(this.certificatePinner, address.certificatePinner) && this.url().port() == address.url().port();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("Address{").append(this.url.host()).append(":").append(this.url.port());
        if (this.proxy != null) {
            stringBuilder.append(", proxy=").append(this.proxy);
        } else {
            stringBuilder.append(", proxySelector=").append(this.proxySelector);
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.append("}");
        return stringBuilder2.toString();
    }
}

