/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.dcloudimageloader.core.decode;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.os.Build;
import com.nostra13.dcloudimageloader.core.assist.ImageScaleType;
import com.nostra13.dcloudimageloader.core.assist.ImageSize;
import com.nostra13.dcloudimageloader.core.assist.ViewScaleType;
import com.nostra13.dcloudimageloader.core.decode.ImageDecoder;
import com.nostra13.dcloudimageloader.core.decode.ImageDecodingInfo;
import com.nostra13.dcloudimageloader.core.download.ImageDownloader;
import com.nostra13.dcloudimageloader.utils.ImageSizeUtils;
import com.nostra13.dcloudimageloader.utils.IoUtils;
import com.nostra13.dcloudimageloader.utils.L;
import java.io.IOException;
import java.io.InputStream;

public class BaseImageDecoder
implements ImageDecoder {
    protected static final String LOG_SUBSAMPLE_IMAGE = "Subsample original image (%1$s) to %2$s (scale = %3$d) [%4$s]";
    protected static final String LOG_SCALE_IMAGE = "Scale subsampled image (%1$s) to %2$s (scale = %3$.5f) [%4$s]";
    protected static final String LOG_ROTATE_IMAGE = "Rotate image on %1$d\u00b0 [%2$s]";
    protected static final String LOG_FLIP_IMAGE = "Flip image horizontally [%s]";
    protected static final String ERROR_NO_IMAGE_STREAM = "No stream for image [%s]";
    protected static final String ERROR_CANT_DECODE_IMAGE = "Image can't be decoded [%s]";
    protected final boolean loggingEnabled;

    public BaseImageDecoder(boolean bl) {
        this.loggingEnabled = bl;
    }

    private boolean canDefineExifParams(String string2, String string3) {
        return Build.VERSION.SDK_INT >= 5 && "image/jpeg".equalsIgnoreCase(string3) && ImageDownloader.Scheme.ofUri(string2) == ImageDownloader.Scheme.FILE;
    }

    @Override
    public Bitmap decode(ImageDecodingInfo imageDecodingInfo) throws IOException {
        InputStream inputStream = objectArray2.getImageStream(imageDecodingInfo);
        ImageFileInfo imageFileInfo = objectArray2.defineImageSizeAndRotation(inputStream, imageDecodingInfo);
        BitmapFactory.Options options = objectArray2.prepareDecodingOptions(imageFileInfo.imageSize, imageDecodingInfo);
        if ((inputStream = objectArray2.decodeStream(objectArray2.resetStream(inputStream, imageDecodingInfo), options)) == null) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = imageDecodingInfo.getImageKey();
            L.e(ERROR_CANT_DECODE_IMAGE, objectArray2);
        } else {
            ExifInfo exifInfo = imageFileInfo.exif;
            int n2 = exifInfo.rotation;
            boolean bl = exifInfo.flipHorizontal;
            inputStream = objectArray2.considerExactScaleAndOrientaiton((Bitmap)inputStream, imageDecodingInfo, n2, bl);
        }
        return inputStream;
    }

    protected InputStream getImageStream(ImageDecodingInfo imageDecodingInfo) throws IOException {
        ImageDecodingInfo imageDecodingInfo2 = imageDecodingInfo;
        String string2 = imageDecodingInfo2.getImageUri();
        return imageDecodingInfo.getDownloader().getStream(string2, imageDecodingInfo2.getExtraForDownloader());
    }

    protected ImageFileInfo defineImageSizeAndRotation(InputStream inputStream, ImageDecodingInfo object) throws IOException {
        ImageSize imageSize;
        Object object2;
        BitmapFactory.Options options;
        ImageDecodingInfo imageDecodingInfo = object;
        InputStream inputStream2 = inputStream;
        inputStream = options;
        new BitmapFactory.Options().inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)inputStream2, null, (BitmapFactory.Options)inputStream);
        object = imageDecodingInfo.getImageUri();
        if (imageDecodingInfo.shouldConsiderExifParams() && ((BaseImageDecoder)object2).canDefineExifParams((String)object, ((BitmapFactory.Options)inputStream).outMimeType)) {
            object2 = ((BaseImageDecoder)object2).defineExifOrientation((String)object);
        } else {
            ExifInfo exifInfo;
            object2 = exifInfo;
            exifInfo = new ExifInfo();
        }
        object = imageSize;
        InputStream inputStream3 = inputStream;
        int n2 = ((BitmapFactory.Options)inputStream3).outWidth;
        int n3 = ((BitmapFactory.Options)inputStream3).outHeight;
        int n4 = ((ExifInfo)object2).rotation;
        imageSize = new ImageSize(n2, n3, n4);
        return new ImageFileInfo((ImageSize)object, (ExifInfo)object2);
    }

    protected ExifInfo defineExifOrientation(String string2) {
        int n2 = 0;
        boolean bl = false;
        try {
            switch (new ExifInterface(ImageDownloader.Scheme.FILE.crop(string2)).getAttributeInt("Orientation", 1)) {
                default: {
                    break;
                }
                case 7: {
                    bl = true;
                }
                case 6: {
                    n2 = 90;
                    break;
                }
                case 5: {
                    bl = true;
                }
                case 8: {
                    n2 = 270;
                    break;
                }
                case 4: {
                    bl = true;
                }
                case 3: {
                    n2 = 180;
                    break;
                }
                case 2: {
                    bl = true;
                }
                case 1: {
                    n2 = 0;
                    break;
                }
            }
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = string2;
            L.w("Can't read EXIF tags from file [%s]", objectArray2);
        }
        return new ExifInfo(n2, bl);
    }

    protected BitmapFactory.Options prepareDecodingOptions(ImageSize imageSize, ImageDecodingInfo imageDecodingInfo) {
        ImageScaleType imageScaleType = imageDecodingInfo.getImageScaleType();
        ImageSize imageSize2 = imageDecodingInfo.getTargetSize();
        int n2 = 1;
        if (imageScaleType != ImageScaleType.NONE) {
            boolean bl = imageScaleType == ImageScaleType.IN_SAMPLE_POWER_OF_2;
            n2 = ImageSizeUtils.computeImageSampleSize(imageSize, imageSize2, imageDecodingInfo.getViewScaleType(), bl);
            if (objectArray2.loggingEnabled) {
                Object[] objectArray = new Object[4];
                Object[] objectArray2 = objectArray;
                objectArray2[0] = imageSize;
                objectArray2[1] = imageSize.scaleDown(n2);
                objectArray2[2] = n2;
                objectArray[3] = imageDecodingInfo.getImageKey();
                L.d(LOG_SUBSAMPLE_IMAGE, objectArray2);
            }
        }
        imageDecodingInfo.getDecodingOptions().inSampleSize = n2;
        return imageDecodingInfo.getDecodingOptions();
    }

    protected InputStream resetStream(InputStream inputStream, ImageDecodingInfo imageDecodingInfo) throws IOException {
        try {
            inputStream.reset();
        }
        catch (IOException iOException) {
            inputStream = this.getImageStream(imageDecodingInfo);
        }
        return inputStream;
    }

    protected Bitmap decodeStream(InputStream inputStream, BitmapFactory.Options options) throws IOException {
        Bitmap bitmap;
        try {
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        }
        catch (Throwable throwable) {
            IoUtils.closeSilently(inputStream);
            throw throwable;
        }
        IoUtils.closeSilently(inputStream);
        return bitmap;
    }

    protected Bitmap considerExactScaleAndOrientaiton(Bitmap bitmap, ImageDecodingInfo imageDecodingInfo, int n2, boolean bl) {
        int n3;
        Matrix matrix;
        Matrix matrix2 = matrix;
        matrix = new Matrix();
        Object object = imageDecodingInfo.getImageScaleType();
        if (object == ImageScaleType.EXACTLY || object == ImageScaleType.EXACTLY_STRETCHED) {
            boolean bl2;
            Object[] objectArray;
            ImageSize imageSize;
            ImageScaleType imageScaleType = object;
            ImageDecodingInfo imageDecodingInfo2 = imageDecodingInfo;
            object = imageSize;
            Bitmap bitmap2 = bitmap;
            int n4 = bitmap2.getWidth();
            imageSize = new ImageSize(n4, bitmap2.getHeight(), n2);
            ImageSize imageSize2 = imageDecodingInfo2.getTargetSize();
            float f2 = ImageSizeUtils.computeImageScale((ImageSize)object, imageSize2, (ViewScaleType)(objectArray = imageDecodingInfo2.getViewScaleType()), bl2 = imageScaleType == ImageScaleType.EXACTLY_STRETCHED);
            if (Float.compare(f2, 1.0f) != 0) {
                float f3 = f2;
                matrix2.setScale(f3, f3);
                if (objectArray4.loggingEnabled) {
                    Object[] objectArray2 = new Object[4];
                    objectArray = objectArray2;
                    objectArray[0] = object;
                    objectArray[1] = ((ImageSize)object).scale(f2);
                    objectArray[2] = Float.valueOf(f2);
                    objectArray2[3] = imageDecodingInfo.getImageKey();
                    L.d(LOG_SCALE_IMAGE, objectArray);
                }
            }
        }
        if (bl) {
            matrix2.postScale(-1.0f, 1.0f);
            if (objectArray4.loggingEnabled) {
                Object[] objectArray = new Object[1];
                Object[] objectArray3 = objectArray;
                objectArray[0] = imageDecodingInfo.getImageKey();
                L.d(LOG_FLIP_IMAGE, objectArray3);
            }
        }
        if (n2 != 0) {
            matrix2.postRotate((float)n2);
            if (objectArray4.loggingEnabled) {
                Object[] objectArray = new Object[2];
                Object[] objectArray4 = objectArray;
                objectArray4[0] = n2;
                objectArray[1] = imageDecodingInfo.getImageKey();
                L.d("Rotate image on %1$d\ufffd\ufffd [%2$s]", objectArray4);
            }
        }
        Bitmap bitmap3 = bitmap;
        int n5 = bitmap3.getWidth();
        Bitmap bitmap4 = Bitmap.createBitmap((Bitmap)bitmap3, (int)0, (int)0, (int)n5, (int)(n3 = bitmap3.getHeight()), (Matrix)matrix2, (boolean)true);
        if (bitmap4 != bitmap) {
            bitmap.recycle();
        }
        return bitmap4;
    }

    protected static class ExifInfo {
        public final int rotation;
        public final boolean flipHorizontal;

        protected ExifInfo() {
            this.rotation = 0;
            this.flipHorizontal = false;
        }

        protected ExifInfo(int n2, boolean bl) {
            this.rotation = n2;
            this.flipHorizontal = bl;
        }
    }

    protected static class ImageFileInfo {
        public final ImageSize imageSize;
        public final ExifInfo exif;

        protected ImageFileInfo(ImageSize imageSize, ExifInfo exifInfo) {
            this.imageSize = imageSize;
            this.exif = exifInfo;
        }
    }
}

