/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.dcloudimageloader.core;

import com.nostra13.dcloudimageloader.core.DefaultConfigurationFactory;
import com.nostra13.dcloudimageloader.core.ImageLoaderConfiguration;
import com.nostra13.dcloudimageloader.core.LoadAndDisplayImageTask;
import com.nostra13.dcloudimageloader.core.ProcessAndDisplayImageTask;
import com.nostra13.dcloudimageloader.core.imageaware.ImageAware;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

class ImageLoaderEngine {
    final ImageLoaderConfiguration configuration;
    private Executor taskExecutor;
    private Executor taskExecutorForCachedImages;
    private ExecutorService taskDistributor;
    private final Map<Integer, String> cacheKeysForImageAwares;
    private final Map<String, ReentrantLock> uriLocks;
    private final AtomicBoolean paused;
    private final AtomicBoolean networkDenied;
    private final AtomicBoolean slowNetwork;

    ImageLoaderEngine(ImageLoaderConfiguration imageLoaderConfiguration) {
        ImageLoaderEngine imageLoaderEngine = this;
        this.cacheKeysForImageAwares = Collections.synchronizedMap(new HashMap());
        this.uriLocks = new WeakHashMap<String, ReentrantLock>();
        this.paused = new AtomicBoolean(false);
        this.networkDenied = new AtomicBoolean(false);
        this.slowNetwork = new AtomicBoolean(false);
        this.configuration = imageLoaderConfiguration;
        this.taskExecutor = imageLoaderConfiguration.taskExecutor;
        imageLoaderEngine.taskExecutorForCachedImages = imageLoaderConfiguration.taskExecutorForCachedImages;
        imageLoaderEngine.taskDistributor = Executors.newCachedThreadPool();
    }

    private void initExecutorsIfNeed() {
        if (!this.configuration.customExecutor && ((ExecutorService)this.taskExecutor).isShutdown()) {
            this.taskExecutor = this.createTaskExecutor();
        }
        if (!this.configuration.customExecutorForCachedImages && ((ExecutorService)this.taskExecutorForCachedImages).isShutdown()) {
            this.taskExecutorForCachedImages = this.createTaskExecutor();
        }
    }

    private Executor createTaskExecutor() {
        Object object = this = ((ImageLoaderEngine)this).configuration;
        int n2 = ((ImageLoaderConfiguration)object).threadPriority;
        return DefaultConfigurationFactory.createExecutor(((ImageLoaderConfiguration)this).threadPoolSize, n2, ((ImageLoaderConfiguration)object).tasksProcessingType);
    }

    void submit(final LoadAndDisplayImageTask loadAndDisplayImageTask) {
        this.taskDistributor.execute(new Runnable(){

            @Override
            public void run() {
                boolean bl = ImageLoaderEngine.this.configuration.discCache.get(loadAndDisplayImageTask.getLoadingUri()).exists();
                ImageLoaderEngine.this.initExecutorsIfNeed();
                if (bl) {
                    ImageLoaderEngine.this.taskExecutorForCachedImages.execute(loadAndDisplayImageTask);
                } else {
                    ImageLoaderEngine.this.taskExecutor.execute(loadAndDisplayImageTask);
                }
            }
        });
    }

    void submit(ProcessAndDisplayImageTask processAndDisplayImageTask) {
        ImageLoaderEngine imageLoaderEngine = this;
        imageLoaderEngine.initExecutorsIfNeed();
        imageLoaderEngine.taskExecutorForCachedImages.execute(processAndDisplayImageTask);
    }

    String getLoadingUriForView(ImageAware imageAware) {
        return this.cacheKeysForImageAwares.get(imageAware.getId());
    }

    void prepareDisplayTaskFor(ImageAware imageAware, String string2) {
        this.cacheKeysForImageAwares.put(imageAware.getId(), string2);
    }

    void cancelDisplayTaskFor(ImageAware imageAware) {
        this.cacheKeysForImageAwares.remove(imageAware.getId());
    }

    void denyNetworkDownloads(boolean bl) {
        this.networkDenied.set(bl);
    }

    void handleSlowNetwork(boolean bl) {
        this.slowNetwork.set(bl);
    }

    void pause() {
        this.paused.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume() {
        AtomicBoolean atomicBoolean = this.paused;
        ImageLoaderEngine imageLoaderEngine = this;
        synchronized (atomicBoolean) {
            imageLoaderEngine.paused.set(false);
            imageLoaderEngine.paused.notifyAll();
            return;
        }
    }

    void stop() {
        if (!this.configuration.customExecutor) {
            ((ExecutorService)this.taskExecutor).shutdownNow();
        }
        if (!this.configuration.customExecutorForCachedImages) {
            ((ExecutorService)this.taskExecutorForCachedImages).shutdownNow();
        }
        ImageLoaderEngine imageLoaderEngine = this;
        imageLoaderEngine.cacheKeysForImageAwares.clear();
        imageLoaderEngine.uriLocks.clear();
    }

    ReentrantLock getLockForUri(String string2) {
        ReentrantLock reentrantLock = this.uriLocks.get(string2);
        if (reentrantLock == null) {
            ReentrantLock reentrantLock2;
            reentrantLock = reentrantLock2;
            reentrantLock2 = new ReentrantLock();
            this.uriLocks.put(string2, reentrantLock);
        }
        return reentrantLock;
    }

    AtomicBoolean getPause() {
        return this.paused;
    }

    boolean isNetworkDenied() {
        return this.networkDenied.get();
    }

    boolean isSlowNetwork() {
        return this.slowNetwork.get();
    }
}

