/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.dcloudimageloader.core;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import com.nostra13.dcloudimageloader.core.DefaultConfigurationFactory;
import com.nostra13.dcloudimageloader.core.assist.ImageScaleType;
import com.nostra13.dcloudimageloader.core.display.BitmapDisplayer;
import com.nostra13.dcloudimageloader.core.process.BitmapProcessor;

public final class DisplayImageOptions {
    private final int imageResOnLoading;
    private final int imageResForEmptyUri;
    private final int imageResOnFail;
    private final Drawable imageOnLoading;
    private final Drawable imageForEmptyUri;
    private final Drawable imageOnFail;
    private final boolean resetViewBeforeLoading;
    private final boolean cacheInMemory;
    private final boolean cacheOnDisc;
    private final ImageScaleType imageScaleType;
    private final BitmapFactory.Options decodingOptions;
    private final int delayBeforeLoading;
    private final boolean considerExifParams;
    private final Object extraForDownloader;
    private final BitmapProcessor preProcessor;
    private final BitmapProcessor postProcessor;
    private final BitmapDisplayer displayer;
    private final Handler handler;
    private final boolean isSyncLoading;

    private DisplayImageOptions(Builder builder) {
        this.imageResOnLoading = builder.imageResOnLoading;
        this.imageResForEmptyUri = builder.imageResForEmptyUri;
        this.imageResOnFail = builder.imageResOnFail;
        this.imageOnLoading = builder.imageOnLoading;
        this.imageForEmptyUri = builder.imageForEmptyUri;
        this.imageOnFail = builder.imageOnFail;
        this.resetViewBeforeLoading = builder.resetViewBeforeLoading;
        this.cacheInMemory = builder.cacheInMemory;
        this.cacheOnDisc = builder.cacheOnDisc;
        this.imageScaleType = builder.imageScaleType;
        this.decodingOptions = builder.decodingOptions;
        this.delayBeforeLoading = builder.delayBeforeLoading;
        this.considerExifParams = builder.considerExifParams;
        this.extraForDownloader = builder.extraForDownloader;
        this.preProcessor = builder.preProcessor;
        this.postProcessor = builder.postProcessor;
        this.displayer = builder.displayer;
        this.handler = builder.handler;
        this.isSyncLoading = builder.isSyncLoading;
    }

    public static DisplayImageOptions createSimple() {
        return new Builder().build();
    }

    public boolean shouldShowImageOnLoading() {
        return this.imageOnLoading != null || this.imageResOnLoading != 0;
    }

    public boolean shouldShowImageForEmptyUri() {
        return this.imageForEmptyUri != null || this.imageResForEmptyUri != 0;
    }

    public boolean shouldShowImageOnFail() {
        return this.imageOnFail != null || this.imageResOnFail != 0;
    }

    public boolean shouldPreProcess() {
        return this.preProcessor != null;
    }

    public boolean shouldPostProcess() {
        return this.postProcessor != null;
    }

    public boolean shouldDelayBeforeLoading() {
        return this.delayBeforeLoading > 0;
    }

    public Drawable getImageOnLoading(Resources resources) {
        int n2 = this.imageResOnLoading;
        return n2 != 0 ? resources.getDrawable(n2) : this.imageOnLoading;
    }

    public Drawable getImageForEmptyUri(Resources resources) {
        int n2 = this.imageResForEmptyUri;
        return n2 != 0 ? resources.getDrawable(n2) : this.imageForEmptyUri;
    }

    public Drawable getImageOnFail(Resources resources) {
        int n2 = this.imageResOnFail;
        return n2 != 0 ? resources.getDrawable(n2) : this.imageOnFail;
    }

    public boolean isResetViewBeforeLoading() {
        return this.resetViewBeforeLoading;
    }

    public boolean isCacheInMemory() {
        return this.cacheInMemory;
    }

    public boolean isCacheOnDisc() {
        return this.cacheOnDisc;
    }

    public ImageScaleType getImageScaleType() {
        return this.imageScaleType;
    }

    public BitmapFactory.Options getDecodingOptions() {
        return this.decodingOptions;
    }

    public int getDelayBeforeLoading() {
        return this.delayBeforeLoading;
    }

    public boolean isConsiderExifParams() {
        return this.considerExifParams;
    }

    public Object getExtraForDownloader() {
        return this.extraForDownloader;
    }

    public BitmapProcessor getPreProcessor() {
        return this.preProcessor;
    }

    public BitmapProcessor getPostProcessor() {
        return this.postProcessor;
    }

    public BitmapDisplayer getDisplayer() {
        return this.displayer;
    }

    public Handler getHandler() {
        if (displayImageOptions.isSyncLoading) {
            return null;
        }
        DisplayImageOptions displayImageOptions = displayImageOptions.handler;
        if (displayImageOptions == null) {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                return new Handler();
            }
            throw new IllegalStateException("ImageLoader.displayImage(...) must be invoked from the main thread or from Looper thread");
        }
        return displayImageOptions;
    }

    boolean isSyncLoading() {
        return this.isSyncLoading;
    }

    public static class Builder {
        private int imageResOnLoading;
        private int imageResForEmptyUri;
        private int imageResOnFail;
        private Drawable imageOnLoading;
        private Drawable imageForEmptyUri;
        private Drawable imageOnFail;
        private boolean resetViewBeforeLoading;
        private boolean cacheInMemory;
        private boolean cacheOnDisc;
        private ImageScaleType imageScaleType;
        private BitmapFactory.Options decodingOptions;
        private int delayBeforeLoading;
        private boolean considerExifParams;
        private Object extraForDownloader;
        private BitmapProcessor preProcessor;
        private BitmapProcessor postProcessor;
        private BitmapDisplayer displayer;
        private Handler handler;
        private boolean isSyncLoading;

        public Builder() {
            Builder builder = this;
            builder.imageResOnLoading = 0;
            builder.imageResForEmptyUri = 0;
            builder.imageResOnFail = 0;
            builder.imageOnLoading = null;
            builder.imageForEmptyUri = null;
            builder.imageOnFail = null;
            builder.resetViewBeforeLoading = false;
            builder.cacheInMemory = false;
            builder.cacheOnDisc = false;
            builder.imageScaleType = ImageScaleType.IN_SAMPLE_POWER_OF_2;
            builder.decodingOptions = new BitmapFactory.Options();
            builder.delayBeforeLoading = 0;
            builder.considerExifParams = false;
            builder.extraForDownloader = null;
            builder.preProcessor = null;
            builder.postProcessor = null;
            builder.displayer = DefaultConfigurationFactory.createBitmapDisplayer();
            builder.handler = null;
            builder.isSyncLoading = false;
            BitmapFactory.Options options = builder.decodingOptions;
            options.inPurgeable = true;
            options.inInputShareable = true;
        }

        @Deprecated
        public Builder showStubImage(int n2) {
            this.imageResOnLoading = n2;
            return this;
        }

        public Builder showImageOnLoading(int n2) {
            this.imageResOnLoading = n2;
            return this;
        }

        public Builder showImageOnLoading(Drawable drawable2) {
            this.imageOnLoading = drawable2;
            return this;
        }

        public Builder showImageForEmptyUri(int n2) {
            this.imageResForEmptyUri = n2;
            return this;
        }

        public Builder showImageForEmptyUri(Drawable drawable2) {
            this.imageForEmptyUri = drawable2;
            return this;
        }

        public Builder showImageOnFail(int n2) {
            this.imageResOnFail = n2;
            return this;
        }

        public Builder showImageOnFail(Drawable drawable2) {
            this.imageOnFail = drawable2;
            return this;
        }

        public Builder resetViewBeforeLoading() {
            this.resetViewBeforeLoading = true;
            return this;
        }

        public Builder resetViewBeforeLoading(boolean bl) {
            this.resetViewBeforeLoading = bl;
            return this;
        }

        public Builder cacheInMemory() {
            this.cacheInMemory = true;
            return this;
        }

        public Builder cacheInMemory(boolean bl) {
            this.cacheInMemory = bl;
            return this;
        }

        public Builder cacheOnDisc() {
            this.cacheOnDisc = true;
            return this;
        }

        public Builder cacheOnDisc(boolean bl) {
            this.cacheOnDisc = bl;
            return this;
        }

        public Builder imageScaleType(ImageScaleType imageScaleType) {
            this.imageScaleType = imageScaleType;
            return this;
        }

        public Builder bitmapConfig(Bitmap.Config config) {
            if (config != null) {
                this.decodingOptions.inPreferredConfig = config;
                return this;
            }
            throw new IllegalArgumentException("bitmapConfig can't be null");
        }

        public Builder decodingOptions(BitmapFactory.Options options) {
            if (options != null) {
                this.decodingOptions = options;
                return this;
            }
            throw new IllegalArgumentException("decodingOptions can't be null");
        }

        public Builder delayBeforeLoading(int n2) {
            this.delayBeforeLoading = n2;
            return this;
        }

        public Builder extraForDownloader(Object object) {
            this.extraForDownloader = object;
            return this;
        }

        public Builder considerExifParams(boolean bl) {
            this.considerExifParams = bl;
            return this;
        }

        public Builder preProcessor(BitmapProcessor bitmapProcessor) {
            this.preProcessor = bitmapProcessor;
            return this;
        }

        public Builder postProcessor(BitmapProcessor bitmapProcessor) {
            this.postProcessor = bitmapProcessor;
            return this;
        }

        public Builder displayer(BitmapDisplayer bitmapDisplayer) {
            if (bitmapDisplayer != null) {
                this.displayer = bitmapDisplayer;
                return this;
            }
            throw new IllegalArgumentException("displayer can't be null");
        }

        Builder syncLoading(boolean bl) {
            this.isSyncLoading = bl;
            return this;
        }

        public Builder handler(Handler handler) {
            this.handler = handler;
            return this;
        }

        public Builder cloneFrom(DisplayImageOptions displayImageOptions) {
            this.imageResOnLoading = displayImageOptions.imageResOnLoading;
            this.imageResForEmptyUri = displayImageOptions.imageResForEmptyUri;
            this.imageResOnFail = displayImageOptions.imageResOnFail;
            this.imageOnLoading = displayImageOptions.imageOnLoading;
            this.imageForEmptyUri = displayImageOptions.imageForEmptyUri;
            this.imageOnFail = displayImageOptions.imageOnFail;
            this.resetViewBeforeLoading = displayImageOptions.resetViewBeforeLoading;
            this.cacheInMemory = displayImageOptions.cacheInMemory;
            this.cacheOnDisc = displayImageOptions.cacheOnDisc;
            this.imageScaleType = displayImageOptions.imageScaleType;
            this.decodingOptions = displayImageOptions.decodingOptions;
            this.delayBeforeLoading = displayImageOptions.delayBeforeLoading;
            this.considerExifParams = displayImageOptions.considerExifParams;
            this.extraForDownloader = displayImageOptions.extraForDownloader;
            this.preProcessor = displayImageOptions.preProcessor;
            this.postProcessor = displayImageOptions.postProcessor;
            this.displayer = displayImageOptions.displayer;
            this.handler = displayImageOptions.handler;
            this.isSyncLoading = displayImageOptions.isSyncLoading;
            return this;
        }

        public DisplayImageOptions build() {
            return new DisplayImageOptions(this);
        }
    }
}

