/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.dcloudimageloader.cache.memory.impl;

import android.graphics.Bitmap;
import com.nostra13.dcloudimageloader.cache.memory.LimitedMemoryCache;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class LRULimitedMemoryCache
extends LimitedMemoryCache {
    private static final int INITIAL_CAPACITY = 10;
    private static final float LOAD_FACTOR = 1.1f;
    private final Map<String, Bitmap> lruCache = Collections.synchronizedMap(new LinkedHashMap(10, 1.1f, true));

    public LRULimitedMemoryCache(int n2) {
        super(n2);
    }

    @Override
    public boolean put(String string2, Bitmap bitmap) {
        if (super.put(string2, bitmap)) {
            this.lruCache.put(string2, bitmap);
            return true;
        }
        return false;
    }

    @Override
    public Bitmap get(String string2) {
        this.lruCache.get(string2);
        return super.get(string2);
    }

    @Override
    public Bitmap remove(String string2) {
        this.lruCache.remove(string2);
        return super.remove(string2);
    }

    @Override
    public void clear() {
        LRULimitedMemoryCache lRULimitedMemoryCache = this;
        lRULimitedMemoryCache.lruCache.clear();
        super.clear();
    }

    @Override
    protected int getSize(Bitmap bitmap) {
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Bitmap removeNext() {
        LRULimitedMemoryCache lRULimitedMemoryCache = lRULimitedMemoryCache2;
        LRULimitedMemoryCache lRULimitedMemoryCache2 = null;
        Map<String, Bitmap> map = lRULimitedMemoryCache.lruCache;
        synchronized (map) {
            Iterator<Map.Entry<String, Bitmap>> iterator = lRULimitedMemoryCache.lruCache.entrySet().iterator();
            {
                if (iterator.hasNext()) {
                    Iterator<Map.Entry<String, Bitmap>> iterator2 = iterator;
                    lRULimitedMemoryCache2 = iterator2.next().getValue();
                    iterator2.remove();
                }
                return lRULimitedMemoryCache2;
            }
        }
    }

    @Override
    protected Reference<Bitmap> createReference(Bitmap bitmap) {
        return new WeakReference<Bitmap>(bitmap);
    }
}

